/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.control;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXParseException;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.model.ExportDeleteModel;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.provider.ConfigurationData;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.provider.ExportConfigDataManager;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.provider.ExportConfigDataProvider;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.ExportManager;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.configtransformer.ConfigTransformException;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.configtransformer.XmlTransformer;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.control.MigrateRbsController;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.SiteComplete;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.util.MigrateRbsUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressMonitor;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLaunchChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrepareConvertMigrationPerformer
implements Runnable {
    private static final String CONFIGURATION_SAVED = "The converted configuration is successfully saved!";
    private MigrateRbsUtil migrateRbsUtil;
    private String zipFileName;
    private ProgressMonitor pm;
    private MigrateRbsController migrateRbsController = null;
    private MigrateRbsController.FailureCause failureCausePrepConv = MigrateRbsController.FailureCause.OTHER;

    public PrepareConvertMigrationPerformer(MigrateRbsUtil migrateRbsUtil, ProgressMonitor progressMonitor, String string) {
        this.migrateRbsUtil = migrateRbsUtil;
        this.pm = progressMonitor;
        this.zipFileName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.pm == null) {
            this.migrateRbsController = this.migrateRbsUtil.getMigrateRbsController();
            this.pm = new ProgressMonitor(this.migrateRbsController.getMigrateRbsView(), this.migrateRbsController, "Progress Migrate RBS", 0, 100);
            this.pm.setWidth(600);
            this.migrateRbsController.setPm(this.pm);
        }
        try {
            this.exportAndConvertConfigurationData();
            if (this.migrateRbsController != null) {
                if (this.migrateRbsController.isLockAllBoardsCheckBoxValue()) {
                    this.migrateRbsUtil.lockAllBoards(this.migrateRbsUtil.getBbSubrackBoards());
                }
                this.migrateRbsController.checkIfCanceled();
                this.pm.reportTotalProgress(100, "Ready");
                this.pm.close();
            }
        }
        catch (Exception exception) {
            if (this.migrateRbsController != null) {
                this.migrateRbsController.setExceptionCaught(true);
                if (this.migrateRbsController.isCancelled()) {
                    MigrateRbsUtil.displayWarningMessage("No configuration file will be stored.\n", "Warning");
                    WizardLaunchChecker.wizardStopped();
                    this.migrateRbsController.getApplication().stopApplicationNoCheck();
                    return;
                }
                this.migrateRbsController.reportException(exception, "");
                WizardLaunchChecker.wizardStopped();
                this.migrateRbsController.getApplication().stopApplicationNoCheck();
            } else {
                Nal.getFactory().getLog().nalTrace(1, this.getClass(), "Failed to export configuration data!", exception);
                exception.printStackTrace();
            }
        }
        finally {
            if (this.migrateRbsController != null) {
                if (!this.migrateRbsController.isExceptionCaught()) {
                    this.migrateRbsController.setPm(null);
                    MigrateRbsUtil.displayInfoMessage(CONFIGURATION_SAVED, "Info");
                }
                this.migrateRbsController.getWnButtonPanel().nextButton.setEnabled(true);
                this.migrateRbsController.setMyMigrationPerformerThread(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportAndConvertConfigurationData() throws Exception {
        ExportConfigDataManager exportConfigDataManager = null;
        List<ConfigurationData> list = null;
        XmlTransformer xmlTransformer = null;
        Rbs rbs = this.migrateRbsUtil.getRbs();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Closeable closeable;
            ConfigurationData configurationData3;
            this.failureCausePrepConv = MigrateRbsController.FailureCause.EXPORT;
            this.checkIfCancelled();
            this.pm.reportTotalProgress(10, "Export and Convert Started");
            ArrayList<ConfigurationData> arrayList = new ArrayList<ConfigurationData>();
            String[] stringArray = rbs.getConfigurationCheckReport();
            this.checkIfCancelled();
            this.pm.reportTotalProgress(20, "Exporting of MIB Started");
            this.pm.reportProgress(5, "Exporting of MIB Started");
            ExportDeleteModel exportDeleteModel = ExportDeleteModel.getTheInstance();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string = "";
            try {
                exportDeleteModel.addObserver(this.migrateRbsUtil);
                if (this.migrateRbsController != null) {
                    exportDeleteModel.exportMOToXML(byteArrayOutputStream, string, this.migrateRbsController);
                } else {
                    exportDeleteModel.exportMOToXML(byteArrayOutputStream, string, null);
                }
                this.checkIfCancelled();
            }
            catch (MoHandlerException moHandlerException) {
                throw new Exception("\n Error in processing MOM during export of MO to Xml. \n" + moHandlerException);
            }
            catch (IOException iOException) {
                throw new Exception("\n I/O error during export of MO to Xml. \n" + iOException);
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (Exception exception) {
                throw new Exception("\n Error during export of MO to Xml. \n" + exception);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ConfigurationData configurationData2 = new ConfigurationData("mib.xml", byteArrayInputStream, ExportConfigDataProvider.TYPE_OF_CONFIG.OTHER, null);
            arrayList.add(configurationData2);
            this.checkIfCancelled();
            this.pm.reportTotalProgress(75, "Creating Exportable Mib Done");
            this.pm.reportProgress(100, "Exporting of MIB Done");
            exportConfigDataManager = new ExportConfigDataManager(rbs, MigrateRbsController.exportedFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET), MigrateRbsController.exportedFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.SITE), MigrateRbsController.exportedFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.OAM), stringArray);
            list = exportConfigDataManager.getConfigurationData();
            this.checkIfCancelled();
            this.pm.reportTotalProgress(75, "Export and conversion of Configurations");
            this.pm.reportProgress(10, "Started export and conversion of Configurations");
            int n = list.size() + 1;
            int n2 = 0;
            int n3 = 100 / n;
            String string2 = this.migrateRbsUtil.getTransportOption();
            boolean bl = string2.equals("ipV4");
            boolean bl2 = this.migrateRbsUtil.isIpSyncRefExisting();
            xmlTransformer = new XmlTransformer(true, this.migrateRbsUtil);
            for (ConfigurationData configurationData3 : list) {
                n2 += n3;
                this.failureCausePrepConv = MigrateRbsController.FailureCause.EXPORT;
                if (configurationData3.isDtdFile()) continue;
                closeable = configurationData3.getInputStream();
                object7 = configurationData3.getTypeOfConfiguration();
                String string3 = MigrateRbsController.exportedFileNameMap.get(object7);
                object6 = MigrateRbsController.xsltFileNameMap.get(object7);
                object5 = MigrateRbsController.outputFileNameMap.get(object7);
                object4 = null;
                object3 = configurationData3.getAssociatedConfigData();
                if (object3 != null && ((ConfigurationData)object3).isDtdFile()) {
                    object4 = ((ConfigurationData)object3).getInputStream();
                }
                this.failureCausePrepConv = MigrateRbsController.FailureCause.CONVERT;
                object2 = xmlTransformer.transform(string3, (InputStream)closeable, (InputStream)object4, (String)object6, (ExportConfigDataProvider.TYPE_OF_CONFIG)((Object)object7), (String)object5, bl, bl2);
                object = object2.iterator();
                while (object.hasNext()) {
                    ConfigurationData configurationData4 = (ConfigurationData)object.next();
                    arrayList.add(configurationData4);
                }
                this.checkIfCancelled();
                this.pm.reportProgress(n2, "Export and conversion of Configurations");
            }
            this.failureCausePrepConv = MigrateRbsController.FailureCause.EXPORT;
            for (ConfigurationData configurationData3 : arrayList) {
                list.add(configurationData3);
            }
            ExportManager exportManager = exportDeleteModel.getExportManager();
            configurationData3 = exportManager.getMimModel();
            closeable = new ByteArrayOutputStream();
            object7 = new ByteArrayOutputStream();
            boolean bl3 = true;
            object6 = new PrintWriter((OutputStream)closeable, bl3);
            object5 = new PrintWriter((OutputStream)object7, bl3);
            object4 = new SiteComplete(rbs, (MimModel)configurationData3, (PrintWriter)object6, (PrintWriter)object5);
            ((SiteComplete)object4).generateMoScript();
            object3 = ((ByteArrayOutputStream)object7).toByteArray();
            object2 = new ByteArrayInputStream((byte[])object3);
            object = new ConfigurationData("node_specific.mo", (InputStream)object2, ExportConfigDataProvider.TYPE_OF_CONFIG.OTHER, null);
            list.add((ConfigurationData)object);
            this.checkIfCancelled();
            this.pm.reportProgress(n2 += n3, "Export and conversion of Configurations");
            exportConfigDataManager.exportConfigurationToZip(this.zipFileName, list);
            this.checkIfCancelled();
            this.pm.reportTotalProgress(95, "Export and Conversions of Configurations Done");
            this.pm.reportProgress(100, "Export and conversion of Configurations Done");
        }
        catch (ConfigTransformException configTransformException) {
            Throwable throwable = configTransformException.getCause();
            if (throwable instanceof SAXParseException) {
                this.failureCausePrepConv = MigrateRbsController.FailureCause.OTHER;
                String string = null;
                if (xmlTransformer != null) {
                    string = xmlTransformer.getFileParsed();
                }
                SAXParseException sAXParseException = (SAXParseException)throwable;
                int n = sAXParseException.getLineNumber();
                Exception exception = new Exception("Error: XML Parsing Error\nProbable cause: Faulty input file\nAdditional information: \nInput file: " + string + "\n" + "Line number: " + n + "\n" + "Message: " + configTransformException);
                this.handleException(exception, exportConfigDataManager, list);
            } else {
                this.failureCausePrepConv = MigrateRbsController.FailureCause.CONVERT;
                this.handleException(configTransformException, exportConfigDataManager, list);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new Exception("Migrate RBS was canceled.");
        }
        catch (Exception exception) {
            this.handleException(exception, exportConfigDataManager, list);
        }
    }

    private void checkIfCancelled() throws InterruptedException {
        if (this.migrateRbsController != null) {
            this.migrateRbsController.checkIfCanceled();
        }
    }

    private void handleException(Exception exception, ExportConfigDataProvider exportConfigDataProvider, List<ConfigurationData> list) throws Exception {
        if (exportConfigDataProvider != null && list != null) {
            exportConfigDataProvider.exportConfigurationToZip(MigrateRbsController.ERROR_ZIP_FILE_NAME, list);
        }
        if (MigrateRbsController.FailureCause.EXPORT.equals((Object)this.failureCausePrepConv)) {
            throw new Exception(" \nError: Not possible to export the configuration from the RBS.\n" + exception);
        }
        if (MigrateRbsController.FailureCause.CONVERT.equals((Object)this.failureCausePrepConv)) {
            throw new Exception(" \nError: The configuration files can not be converted to DUW.\n" + exception);
        }
        if (MigrateRbsController.FailureCause.OTHER.equals((Object)this.failureCausePrepConv)) {
            throw exception;
        }
        throw new Exception(" \nError: Not possible to export the configuration from the RBS.\n" + exception);
    }
}

