/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.control.MigrateRbsController;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.control.ReportController;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemStringField;
import se.ericsson.wcdma.rbs.bem.wizard.util.BemFileFilter;

public class StoreReportController
extends JDialog
implements ActionListener {
    private ReportController reportController;
    private MigrateRbsController parentController;
    private JDialog dialog = null;
    private JButton browseButton = new JButton();
    private JButton saveButton;
    private JButton cancelButton;
    private BemStringField filePathStringField;
    private static final String SAVE_REPORT = "Save report on client";
    private static final String USER_HOME_DIRECTORY = System.getProperties().getProperty("user.home");
    private static final String CONFIG_REPORT_FILE_NAME = System.getProperties().getProperty("os.name").indexOf("Windows") > -1 ? USER_HOME_DIRECTORY + "\\Ericsson\\DUWmigration\\configreport.txt" : USER_HOME_DIRECTORY + "/Ericsson/DUWmigration/configreport.txt";
    private static final String FILE_PATH_LABEL = "File path: ";
    private static final String BROWSE_BUTTON_LABEL = "Browse...";
    private String configReportFileName = CONFIG_REPORT_FILE_NAME;

    public StoreReportController(ReportController reportController, MigrateRbsController migrateRbsController) {
        this.reportController = reportController;
        this.parentController = migrateRbsController;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setText(SAVE_REPORT);
        jTextPane.setOpaque(false);
        jPanel.add((Component)jTextPane, new GridBagConstraints(0, 0, 0, 5, 1.0, 1.0, 11, 1, new Insets(5, 15, 5, 5), 0, 0));
        this.filePathStringField = new BemStringField(FILE_PATH_LABEL, false, (Integer)30);
        this.filePathStringField.setValue(CONFIG_REPORT_FILE_NAME);
        jPanel2.add((Component)this.filePathStringField, new GridBagConstraints(0, 10, 0, 0, 1.0, 1.0, 15, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.browseButton.setText(BROWSE_BUTTON_LABEL);
        this.browseButton.addActionListener(new BrowseButtonListener(CONFIG_REPORT_FILE_NAME));
        jPanel2.add((Component)this.browseButton, new GridBagConstraints(1, 10, 0, 0, 1.0, 1.0, 15, 1, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 5, 0, 0, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.saveButton = new JButton("Save");
        this.cancelButton = new JButton("Cancel");
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(this.saveButton);
        jPanel3.add(this.cancelButton);
        this.dialog = new JDialog(JOptionPane.getFrameForComponent(this.parentController.getView()), "Migrate RBS to DUW - Save Report");
        this.dialog.getContentPane().add((Component)jPanel, "Center");
        this.dialog.setLocationRelativeTo(this.parentController.getView());
        this.dialog.setSize(900, 900);
        this.dialog.getContentPane().add((Component)jPanel3, "South");
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton) {
            this.cancelButton.removeActionListener(this);
            this.saveButton.removeActionListener(this);
            if (this.dialog != null) {
                this.closeDialog();
                this.reportController.enableSaveButton();
            }
        } else if (actionEvent.getSource() == this.saveButton) {
            try {
                this.storeReport();
                this.closeDialog();
            }
            catch (Exception exception) {
                this.parentController.reportException(exception, "");
            }
        }
    }

    private void closeDialog() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
        this.dialog = null;
    }

    public void storeReport() throws BemException {
        try {
            this.configReportFileName = this.filePathStringField.getValue();
            File file = new File(this.configReportFileName);
            if (file.exists()) {
                file.delete();
                file.createNewFile();
            } else {
                file.createNewFile();
            }
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print(this.reportController.getReport());
            printWriter.close();
        }
        catch (Exception exception) {
            throw new BemException("storeConfigReport()", (Throwable)exception);
        }
    }

    class BrowseButtonListener
    implements ActionListener {
        private String filePath = null;

        public BrowseButtonListener(String string) {
            this.filePath = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(this.filePath);
            File file = new File(this.filePath);
            jFileChooser.setSelectedFile(file);
            jFileChooser.setBackground(Color.white);
            BemFileFilter bemFileFilter = new BemFileFilter("txt", "Text Documents");
            jFileChooser.setFileFilter(bemFileFilter);
            jFileChooser.setDialogTitle("Save report");
            int n = jFileChooser.showOpenDialog(StoreReportController.this.parentController.getMigrateRbsView());
            if (n == 0) {
                StoreReportController.this.filePathStringField.setValue(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

