/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.convert.AbstractLdnConverter;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.data.Action;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.data.Attribute;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.data.Template;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.script.BemScriptUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoData {
    private final BemMo bemMo;
    private final Template template;
    private final AbstractLdnConverter moConverter;
    private final List<Attribute> filteredAttributes;
    private final List<Action> actions;
    private String ldn = null;

    public MoData(BemMo bemMo, Template template) {
        this.bemMo = bemMo;
        this.template = template;
        if (template != null) {
            this.moConverter = template.getLdnConverter();
            this.filteredAttributes = new ArrayList<Attribute>();
            List<Attribute> list = template.getFilteredAttributes();
            for (Attribute attribute : list) {
                Attribute attribute2 = attribute.clone();
                this.filteredAttributes.add(attribute2);
            }
            this.actions = template.getActions();
        } else {
            this.moConverter = null;
            this.filteredAttributes = null;
            this.actions = null;
        }
    }

    public BemMo getBemMo() {
        return this.bemMo;
    }

    public Template getTemplate() {
        return this.template;
    }

    public List<Attribute> getFilteredAttributes() {
        return this.filteredAttributes;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void read() {
        for (Attribute attribute : this.filteredAttributes) {
            attribute.readValue(this.bemMo);
        }
    }

    public void convert() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (Attribute attribute : this.filteredAttributes) {
            Action[] actionArray;
            Object object = attribute.convert();
            if (object instanceof Action) {
                this.actions.add((Action)object);
                arrayList.add(attribute);
                continue;
            }
            if (!(object instanceof Action[])) continue;
            for (Action action : actionArray = (Action[])object) {
                this.actions.add(action);
            }
            arrayList.add(attribute);
        }
        for (Attribute attribute : arrayList) {
            this.filteredAttributes.remove(attribute);
        }
    }

    public void createMoScriptForAttributes(MoHandler moHandler, BemScriptUtil bemScriptUtil) {
        Object object;
        ArrayList<NalNameValueImpl> arrayList = new ArrayList<NalNameValueImpl>();
        for (Attribute object22 : this.filteredAttributes) {
            object = object22.getFilteredAttributeName();
            Object object2 = object22.getConvertedValue();
            if (object2 == null) continue;
            NalNameValueImpl nalNameValueImpl = new NalNameValueImpl((String)object, object2);
            arrayList.add(nalNameValueImpl);
        }
        NalNameValue[] nalNameValueArray = arrayList.toArray(new NalNameValue[0]);
        Arrays.sort(nalNameValueArray, new NalNameValueComparator());
        String string = this.getLdn();
        object = moHandler.getMo(string);
        if (this.template.isMoToBeCreated()) {
            bemScriptUtil.scriptCreate((BemMo)object, nalNameValueArray);
        } else {
            bemScriptUtil.scriptSetAttributes((BemMo)object, nalNameValueArray);
        }
    }

    public void createMoScriptForActions(MoHandler moHandler, BemScriptUtil bemScriptUtil) {
        ArrayList<NalNameValueImpl> arrayList = new ArrayList<NalNameValueImpl>();
        for (Action action : this.actions) {
            NalNameValueImpl nalNameValueImpl;
            Object[] objectArray;
            String string = action.getActionName();
            Object object = action.getValue();
            if (object instanceof Object[]) {
                for (Object object2 : objectArray = (Object[])object) {
                    nalNameValueImpl = new NalNameValueImpl("test", object2);
                    arrayList.add(nalNameValueImpl);
                }
            } else {
                nalNameValueImpl = new NalNameValueImpl("test", object);
                arrayList.add(nalNameValueImpl);
            }
            objectArray = arrayList.toArray(new NalNameValue[0]);
            Arrays.sort(objectArray, new NalNameValueComparator());
            String object3 = this.getLdn();
            BemMo bemMo = moHandler.getMo(object3);
            bemScriptUtil.scriptAction(bemMo, string, (NalNameValue[])objectArray);
            arrayList.clear();
        }
    }

    private String getLdn() {
        Object object;
        if (this.ldn != null) {
            return this.ldn;
        }
        this.ldn = this.bemMo.getDN();
        if (this.moConverter != null && (object = this.moConverter.convert(this.bemMo)) != null) {
            this.ldn = object.toString();
        }
        return this.ldn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NalNameValueComparator
    implements Comparator<NalNameValue> {
        NalNameValueComparator() {
        }

        @Override
        public int compare(NalNameValue nalNameValue, NalNameValue nalNameValue2) {
            if (nalNameValue == null) {
                return 1;
            }
            if (nalNameValue2 == null) {
                return -1;
            }
            return nalNameValue.getName().compareTo(nalNameValue2.getName());
        }
    }

    static class NalNameValueImpl
    implements NalNameValue {
        private final String name;
        private final Object value;

        public NalNameValueImpl(String string, Object object) {
            this.name = string;
            this.value = object;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getNative() {
            return this;
        }

        public String toString() {
            String string = this.name + ":" + this.value.toString();
            return string;
        }
    }
}

