/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import org.xml.sax.SAXParseException;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.provider.ExportConfigDataProvider;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.control.MigrateRbsController;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.control.PrepareConvertMigrationPerformer;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.util.moscript.MoScript;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.IpOverGigabitEthernetCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.IubUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.impl.ProgressReporterLogImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.phase.Phase;
import se.ericsson.wcdma.rbs.bem.common.config.phase.PhaseOrder;
import se.ericsson.wcdma.rbs.bem.common.config.phase.UnlockAllUnitsPhase;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.InformativeText;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.OpenCIs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.RbsFactory;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.util.ConfigurationVersionRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.util.RollbackConfigurationVersionRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.BemRuntimeException;
import se.ericsson.wcdma.rbs.bem.common.exception.BemXmlException;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressMonitor;
import se.ericsson.wcdma.rbs.bem.common.io.xml.XmlFileHandler;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAal0TpVccTp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAal1TpVccTp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAal2RoutingCase;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAtmCrossConnection;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCbu;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDs0Bundle;
import se.ericsson.wcdma.rbs.bem.common.mim.MimE1PhysPathTerm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimE3PhysPathTerm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAtmLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpInterface;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSyncRef;
import se.ericsson.wcdma.rbs.bem.common.mim.MimJ1PhysPathTerm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOs155SpiTtp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsConfiguration;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsLocalCell;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwitchFabric;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwitchModule;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSynchronization;
import se.ericsson.wcdma.rbs.bem.common.mim.MimT1PhysPathTerm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTdmCrossConnection;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.BemServiceValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;
import se.ericsson.wcdma.rbs.bem.common.util.RegressionTestInDesigntestUtils;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.precontrol.HandlePlugAndPlayPreController;

public class MigrateRbsUtil
implements Observer {
    private Rbs rbs = null;
    private MoHandler moHandler = null;
    private ProgressReporter progressReporter;
    private MigrateRbsController migrateRbsController;
    private String progressMessage = "";
    private int stepProgressCounter = 0;
    private RollbackConfigurationVersionRI rollbackCvRI;
    private static final String CABINET_DTD_PATH = "/se/ericsson/wcdma/rbs/bem/wizard/wizards/cabinet/dtd/CabinetEquipment.dtd";
    private static final String OAM_DTD_PATH = "/se/ericsson/wcdma/rbs/bem/wizard/wizards/oam/dtd/OamAccess.dtd";
    private static final String SITE_DTD_PATH = "/se/ericsson/wcdma/rbs/bem/wizard/wizards/site/dtd/SiteEquipment.dtd";
    private static final String CONFIGURATION_NOT_SUPPORTED_MESSAGE = "The configuration of this RBS is not supported by this migration tool.\nThere might be a problem when using this configuration for the DUW based RBS\n\nIt is recommended to check the following parameter:";
    private static final String NOTE_PARAMETERS = "\nPlease make sure to take a note of these parameters for further troubleshooting.\n";
    private static final String OAM_CONFIGURATION_NOT_PERFORMED = "OAM configuration has not been performed on the node";
    private static final String ADDITIONAL_INFO = "Additional information: ";
    private static final String DUW_PRECONDITIONS_NOT_FULFILLED_MESSAGE = "Error:  The exported xml-files can not be used as input for configuration\nAdditional information: ";
    private static final String WRONG_CONFIG_LEVEL = "Wrong configuration level. \nThe cabinet equipment configuration must be completed before starting Migrate RBS.\n";
    public static final String NCONF_CONFIRM_DIALOG = "Confirm";
    public static final String NCONF_WARNING_DIALOG = "Warning";
    public static final String NCONF_ERROR_DIALOG = "Error";
    public static final String NCONF_INFO_DIALOG = "Info";
    private String configReport = "\n\nSettings from XML files\n";
    private static final String[] notAllowedMos = new String[]{MimAal0TpVccTp.MOTYPENAME, MimAal1TpVccTp.MOTYPENAME, MimAal2RoutingCase.MOTYPENAME, MimTdmCrossConnection.MOTYPENAME, MimAtmCrossConnection.MOTYPENAME};
    private static final String[] notSupportedMos = new String[]{MimDs0Bundle.MOTYPENAME};
    private static final String[] termTypesOnlyAllowedUnderCbuMos = new String[]{MimE1PhysPathTerm.MOTYPENAME, MimT1PhysPathTerm.MOTYPENAME, MimJ1PhysPathTerm.MOTYPENAME};

    public MigrateRbsUtil(ProgressReporter progressReporter) throws BemException, MoHandlerException {
        this.progressReporter = new ProgressReporterLogImpl("MigrateRbs", progressReporter);
        this.moHandler = new MoHandlerImpl();
        this.rbs = RbsFactory.getRbs(this.moHandler, "STEP_MIGRATE_RBS");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkPreconditionsOK(boolean bl) throws BemException {
        String string = "The configuration of this RBS is not supported by this migration tool.\nThere might be a problem when using this configuration for the DUW based RBS\n\nIt is recommended to check the following parameter:\n";
        boolean bl2 = true;
        try {
            BemMo bemMo = this.moHandler.getRoot();
            String string2 = (String)this.moHandler.getAttribute(bemMo, "productName");
            NotSupportedConfigCause notSupportedConfigCause = this.verifySupportedConfiguration(string2);
            if (string2.equals("")) {
                bl2 = false;
                if (!bl) throw new BemException(WRONG_CONFIG_LEVEL);
                string = string + "Wrong configuration level. \nThe cabinet equipment configuration must be completed before starting Migrate RBS.\n\n\n";
            } else if (notSupportedConfigCause != null) {
                bl2 = false;
                if (!bl) throw new BemException("The configuration of this RBS is not supported by this migration tool.\nThere might be a problem when using this configuration for the DUW based RBS\n\nIt is recommended to check the following parameter:\nInput file: " + notSupportedConfigCause.getInputFile() + "\n" + "Parameter: " + notSupportedConfigCause.getParameter());
                string = string + "Input file: " + notSupportedConfigCause.getInputFile() + "\n" + "Parameter:  " + notSupportedConfigCause.getParameter() + "\n\n";
            }
            NotSupportedConfigCause notSupportedConfigCause2 = this.verifyOamConfiguration();
            if (notSupportedConfigCause2 != null) {
                bl2 = false;
                if (!bl) throw new BemException("The configuration of this RBS is not supported by this migration tool.\nThere might be a problem when using this configuration for the DUW based RBS\n\nIt is recommended to check the following parameter:\nReason: " + notSupportedConfigCause2.getInputFile() + "\n" + "MO: " + notSupportedConfigCause2.getParameter());
                string = string + "Reason: " + notSupportedConfigCause2.getInputFile() + "\n" + "MO:  " + notSupportedConfigCause2.getParameter() + "\n\n";
            }
            boolean bl3 = this.rbs.isParameterSupported("IPoverGigabitEthernet_syncIpAddress");
            CustomerParameter customerParameter = null;
            if (bl3) {
                customerParameter = this.rbs.getCustomerParameterObject("IPoverGigabitEthernet_syncIpAddress");
            }
            if ((!bl3 || bl3 && customerParameter.getValue().equals("##UNDEFINED")) && !this.rbs.isParameterSupported("firstOAMatm_atmIpAddress") && !this.rbs.isParameterSupported("secondOAMatm_atmIpAddress")) {
                bl2 = false;
                if (!bl) throw new BemException("The configuration of this RBS is not supported by this migration tool.\nThere might be a problem when using this configuration for the DUW based RBS\n\nIt is recommended to check the following parameter:\nOAM configuration has not been performed on the node");
                string = string + "OAM configuration has not been performed on the node\n\n";
            }
        }
        catch (MoHandlerException moHandlerException) {
            bl2 = false;
            throw new BemException("Could not read product name from the RBS", (Throwable)moHandlerException);
        }
        if (bl2 || !bl) return bl2;
        MigrateRbsUtil.displayErrorMessage(string + NOTE_PARAMETERS, NCONF_ERROR_DIALOG);
        return bl2;
    }

    private NotSupportedConfigCause verifySupportedConfiguration(String string) throws BemException {
        NotSupportedConfigCause notSupportedConfigCause = null;
        try {
            int n = this.rbs.getMaxNumberOfSectors();
            ArrayList<String> arrayList = new ArrayList<String>();
            CustomerParameter customerParameter = null;
            String string2 = null;
            for (int i = 1; i <= n; ++i) {
                String string3 = this.getRbbName(i);
                if (!this.rbs.isParameterSupported(string3) || (string2 = (customerParameter = this.rbs.getCustomerParameterObject(string3)).getValue()) == "") continue;
                arrayList.add(string2);
            }
            Iterator iterator = arrayList.iterator();
            if (TYPE_OF_RBS.toTypeOfRbs(string).equals((Object)TYPE_OF_RBS.RBS3106)) {
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    if (string2.equals("RB1") || string2.equals("RB3") || string2.equals("RB4") || string2.equals("RB4b") || string2.equals("RB6") || string2.equals("RB7") || string2.equals("RB8") || string2.equals("RRB02B") || string2.equals("RRB03")) continue;
                    notSupportedConfigCause = new NotSupportedConfigCause("site.xml", string2);
                }
            } else if (TYPE_OF_RBS.toTypeOfRbs(string).equals((Object)TYPE_OF_RBS.RBS3206)) {
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    if (string2.equals("RB1") || string2.equals("RB3") || string2.equals("RB4") || string2.equals("RB4b") || string2.equals("RB6") || string2.equals("RB7") || string2.equals("RB8") || string2.equals("RRB02B") || string2.equals("RRB03")) continue;
                    notSupportedConfigCause = new NotSupportedConfigCause("site.xml", string2);
                }
            } else if (TYPE_OF_RBS.toTypeOfRbs(string).equals((Object)TYPE_OF_RBS.RBS3206M) || TYPE_OF_RBS.toTypeOfRbs(string).equals((Object)TYPE_OF_RBS.RBS3018) || TYPE_OF_RBS.toTypeOfRbs(string).equals((Object)TYPE_OF_RBS.RBS3116) || TYPE_OF_RBS.toTypeOfRbs(string).equals((Object)TYPE_OF_RBS.RBS3216)) {
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    if (string2.equals("RB1") || string2.equals("RB4")) continue;
                    notSupportedConfigCause = new NotSupportedConfigCause("site.xml", string2);
                }
            } else {
                notSupportedConfigCause = new NotSupportedConfigCause("cabinet.xml", string);
            }
        }
        catch (Exception exception) {
            throw new BemException("verifySupportedConfiguration()", (Throwable)exception);
        }
        return notSupportedConfigCause;
    }

    private NotSupportedConfigCause verifyOamConfiguration() throws BemException {
        NotSupportedConfigCause notSupportedConfigCause = null;
        int n = 0;
        try {
            Object object;
            BemMo[] bemMoArray;
            Object object2;
            Object object3;
            Object object4;
            BemMo[] bemMoArray2;
            BemMo bemMo = this.moHandler.getRoot();
            for (n = 0; notSupportedConfigCause == null && n < notAllowedMos.length; ++n) {
                bemMoArray2 = this.moHandler.getChildren(bemMo, 2, notAllowedMos[n], "");
                if (bemMoArray2 == null || bemMoArray2.length <= 0) continue;
                notSupportedConfigCause = new NotSupportedConfigCause("MO is not allowed.", notAllowedMos[n]);
            }
            for (n = 0; notSupportedConfigCause == null && n < notSupportedMos.length; ++n) {
                bemMoArray2 = this.moHandler.getChildren(bemMo, 10, notSupportedMos[n], "");
                if (bemMoArray2 == null || bemMoArray2.length <= 0) continue;
                notSupportedConfigCause = new NotSupportedConfigCause("MO is not supported.", notSupportedMos[n]);
            }
            for (n = 0; notSupportedConfigCause == null && n < termTypesOnlyAllowedUnderCbuMos.length; ++n) {
                bemMoArray2 = this.moHandler.getChildren(bemMo, 10, termTypesOnlyAllowedUnderCbuMos[n], "");
                if (bemMoArray2 == null || bemMoArray2.length <= 0) continue;
                for (int i = 0; notSupportedConfigCause == null && i < bemMoArray2.length; ++i) {
                    boolean bl;
                    object4 = bemMoArray2[i];
                    object3 = object4.getDN();
                    if (!((String)object3).contains(MimCbu.MOTYPENAME)) {
                        notSupportedConfigCause = new NotSupportedConfigCause("MO is just allowed as a child to ExternalTerminal that is child to CBU.", termTypesOnlyAllowedUnderCbuMos[n]);
                    }
                    if (notSupportedConfigCause != null || !(bl = ((String)(object2 = this.getTransportOption())).equals("ipV4")) || (bemMoArray2 = this.moHandler.getChildren(bemMo, 10, MimOs155SpiTtp.MOTYPENAME, "")) == null || bemMoArray2.length <= 0) continue;
                    notSupportedConfigCause = new NotSupportedConfigCause("MO is not supported.", MimOs155SpiTtp.MOTYPENAME);
                }
            }
            if (notSupportedConfigCause == null) {
                Integer n2;
                bemMoArray2 = this.moHandler.getChildren(bemMo, 6, MimOs155SpiTtp.MOTYPENAME, "");
                if (bemMoArray2.length > 1) {
                    notSupportedConfigCause = new NotSupportedConfigCause("MO is not allowed more than 1 instances in the node.", MimOs155SpiTtp.MOTYPENAME);
                } else if (bemMoArray2.length > 0 && (n2 = (Integer)bemMoArray2[0].getAttribute("muxMode")) == 0) {
                    notSupportedConfigCause = new NotSupportedConfigCause("Atribute is not allowed to be " + n2 + ".", "muxMode");
                }
            }
            if ((bemMoArray2 = this.moHandler.getChildren(bemMo, 10, MimIpInterface.MOTYPENAME, "")) != null && bemMoArray2.length > 0) {
                for (int i = 0; notSupportedConfigCause == null && i < bemMoArray2.length; ++i) {
                    object4 = bemMoArray2[i];
                    object3 = (Boolean)object4.getAttribute("rps");
                    if (!((Boolean)object3).booleanValue()) continue;
                    notSupportedConfigCause = new NotSupportedConfigCause("Parameter rps is set to true. Not supported for the migration.", MimIpInterface.MOTYPENAME);
                }
            }
            if (notSupportedConfigCause == null && (bemMoArray2 = this.moHandler.getChildren(bemMo, 10, MimIpAtmLink.MOTYPENAME, "")).length > 2) {
                notSupportedConfigCause = new NotSupportedConfigCause("MO is not allowed more than 2 instances in the node.", MimIpAtmLink.MOTYPENAME);
            }
            if (notSupportedConfigCause == null && (bemMoArray2 = this.moHandler.getChildren(bemMo, 3, MimSynchronization.MOTYPENAME, "")) != null && bemMoArray2.length > 0 && (bemMoArray = (BemMo[])bemMoArray2[0].getAttribute("syncReference")) != null) {
                for (n = 0; n < bemMoArray.length; ++n) {
                    Object object5 = object4 = bemMoArray[n] != null ? bemMoArray[n].getType() : null;
                    if (object4 == null || !((String)object4).equals(MimE3PhysPathTerm.MOTYPENAME)) continue;
                    notSupportedConfigCause = new NotSupportedConfigCause("Attribute is not allowed to be E3PhysPathTerm.", "syncReference");
                    break;
                }
            }
            if (notSupportedConfigCause == null) {
                try {
                    MoInstance moInstance = this.rbs.getMoiRefs().getIubMoi();
                    object4 = this.moHandler.getMo(moInstance.getLdn());
                    if (this.moHandler.isExisting((BemMo)object4)) {
                        object3 = (NalStruct)object4.getAttribute("userPlaneTransportOption");
                        object2 = (Boolean)object3.getMemberValue("atm");
                        Boolean bl = (Boolean)object3.getMemberValue("ipV4");
                        object = this.rbs.getMoiRefs().getIpMoi();
                        BemMo object6 = this.moHandler.getMo(((MoInstance)object).getLdn());
                        String string = (String)this.moHandler.getAttribute(object6, "nodeInterfaceName");
                        if (((Boolean)object2).booleanValue() && bl.booleanValue()) {
                            if (!"le0".equals(string)) {
                                notSupportedConfigCause = new NotSupportedConfigCause("Attribute nodeInterfaceName should be le0 for Dual Stack Iub.", MimIp.MOTYPENAME);
                            }
                        } else if (((Boolean)object2).booleanValue()) {
                            if (!"le0".equals(string)) {
                                notSupportedConfigCause = new NotSupportedConfigCause("Attribute nodeInterfaceName should be le0 for ATM Iub.", MimIp.MOTYPENAME);
                            }
                        } else if (bl.booleanValue() && !"lh0".equals(string)) {
                            notSupportedConfigCause = new NotSupportedConfigCause("Attribute nodeInterfaceName should be lh0 for IP Iub.", MimIp.MOTYPENAME);
                        }
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new BemException("Could not find field in userPlaneTransportOption", (Throwable)noSuchFieldException);
                }
            }
            if (notSupportedConfigCause == null && IubUtil.isAtmNode()) {
                boolean bl = false;
                object4 = this.rbs.getMoiRefs().getSynchronizationMoi();
                object3 = this.rbs.getMoHandler();
                object2 = object3.getMo(((MoInstance)object4).getLdn());
                Object object7 = object2.getAttribute("syncReference");
                object = (BemMo[])object7;
                for (BemMo bemMo2 : object) {
                    String string;
                    if (bemMo2 == null || !BemUtil.isLdnOfType(string = bemMo2.getDN(), MimIpSyncRef.MOTYPENAME)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    notSupportedConfigCause = new NotSupportedConfigCause("IpSyncRef is not allowed as synchronization reference for ATM Iub.", MimSynchronization.MOTYPENAME);
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("verifyOamConfiguration()", (Throwable)moHandlerException);
        }
        return notSupportedConfigCause;
    }

    public boolean checkDuwPreconditionsOK(String string, String string2) throws BemException {
        boolean bl = true;
        try {
            String string3 = this.extractFromZip(string, string2);
            this.checkDuwPreconditionRequiresDualDuw(string3);
        }
        catch (Exception exception) {
            throw new BemException("checkDuwPreconditionsOK()", (Throwable)exception);
        }
        return bl;
    }

    private void checkDuwPreconditionRequiresDualDuw(String string) throws BemException {
        if (string.contains("poolNumber=\"2\"") && !DuwUtil.hasDualDuws()) {
            throw new BemException("Error:  The exported xml-files can not be used as input for configuration\nAdditional information: The reason is that this DUW configuration requires 2 DUWs.");
        }
    }

    private String getRbbName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "radioBuildingBlock";
    }

    public void openMigrateRbsCIs(boolean bl) throws BemException {
        this.rbs.addObserver(this);
        this.stepProgressCounter = 0;
        OpenCIs.openMigrateRbsCIs(this.rbs, bl);
    }

    public static boolean displayQuestionlDialog(String string, String string2) {
        boolean bl = true;
        int n = JOptionPane.showConfirmDialog(null, string, string2, 2, 3);
        if (n == 2) {
            bl = false;
        }
        return bl;
    }

    public static boolean displayWarningDialog(String string, String string2) {
        boolean bl = true;
        int n = JOptionPane.showConfirmDialog(null, string, string2, 2, 2);
        if (n == 2) {
            bl = false;
        }
        return bl;
    }

    public static void displayErrorMessage(String string, String string2) {
        JOptionPane.showMessageDialog(null, string, string2, 0);
    }

    public static void displayWarningMessage(String string, String string2) {
        JOptionPane.showMessageDialog(null, string, string2, 2);
    }

    public static void displayInfoMessage(String string, String string2) {
        JOptionPane.showMessageDialog(null, string, string2, 1);
    }

    private BemMo getParent(BemMo bemMo, String string) {
        String string2 = null;
        BemMo bemMo2 = null;
        if (bemMo != null) {
            bemMo2 = bemMo.getParent();
            if (bemMo2 != null) {
                string2 = bemMo2.getType();
                if (string2.equals(string)) {
                    return bemMo2;
                }
                return this.getParent(bemMo2, string);
            }
            return bemMo2;
        }
        return bemMo2;
    }

    public Vector getBbSubrackBoards() throws BemException {
        Vector<BemMo> vector = new Vector<BemMo>();
        try {
            BemMo bemMo = this.moHandler.getRoot();
            BemMo[] bemMoArray = bemMo.getChildren(1, "Equipment", "");
            BemMo bemMo2 = bemMoArray[0];
            BemMo[] bemMoArray2 = bemMo2.getChildren(1, "", "");
            for (int i = 0; i < bemMoArray2.length; ++i) {
                BemMo[] bemMoArray3;
                BemMo bemMo3 = bemMoArray2[i];
                String string = bemMo3.getType();
                if (!string.equals("Subrack") || (bemMoArray3 = bemMo3.getChildren(4, "", "")) == null || bemMoArray3.length <= 0) continue;
                for (int j = 0; j < bemMoArray3.length; ++j) {
                    BemMo bemMo4 = bemMoArray3[j];
                    String string2 = bemMo4.getType();
                    if (!string2.equals("PlugInUnit")) continue;
                    BemMo bemMo5 = bemMo4;
                    BemMo[] bemMoArray4 = bemMo5.getChildren(1, "", "");
                    BemMo bemMo6 = null;
                    String string3 = null;
                    if (bemMoArray4 == null || bemMoArray4.length <= 0) continue;
                    for (int k = 0; k < bemMoArray4.length; ++k) {
                        bemMo6 = bemMoArray4[k];
                        string3 = bemMo6.getType();
                        if (!string3.equals("RaxDeviceGroup") && !string3.equals("TxDeviceGroup") && !string3.equals("RuifDeviceGroup") && !string3.equals("TuDeviceGroup") && !string3.equals(MimCbu.MOTYPENAME)) continue;
                        vector.addElement(bemMo6);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new BemException("getBbSubrackBoards()", (Throwable)exception);
        }
        return vector;
    }

    public void lockAllBoards(Vector vector) throws BemException {
        Iterator iterator = vector.iterator();
        SingleChildMoi singleChildMoi = new SingleChildMoi(new RootMoi(), MimSwitchFabric.MOTYPENAME, "1");
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(singleChildMoi, MimSwitchModule.MOTYPENAME, "1");
        MoHandler moHandler = fixedRdnMoi.getMoHandler();
        BemMo bemMo = moHandler.getMo(fixedRdnMoi.getLdn());
        try {
            Integer n = (Integer)this.moHandler.getAttribute(bemMo, "administrativeState");
            if (n != 0) {
                this.moHandler.setAttribute(bemMo, "administrativeState", 0);
            }
            while (iterator.hasNext()) {
                BemMo bemMo2 = (BemMo)iterator.next();
                BemMo bemMo3 = this.getParent(bemMo2, MimPlugInUnit.MOTYPENAME);
                if (bemMo3 == null) {
                    throw new BemException("Unable to lock board. PIU not found.");
                }
                n = (Integer)this.moHandler.getAttribute(bemMo3, "administrativeState");
                if (n == 0) continue;
                this.moHandler.setAttribute(bemMo3, "administrativeState", 0);
            }
        }
        catch (Exception exception) {
            throw new BemException("lockAllBoards()", (Throwable)exception);
        }
    }

    private static String inputStreamToString(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            stringBuffer.append(new String(byArray, 0, n));
        }
        return stringBuffer.toString();
    }

    private String extractFromZip(String string, String string2) throws BemException {
        String string3 = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(string);
            ZipEntry zipEntry = zipFile.getEntry(string2);
            if (zipEntry == null) {
                throw new BemException("Could not find zip file entry " + string2 + " in zip file " + string);
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            string3 = MigrateRbsUtil.inputStreamToString(inputStream);
        }
        catch (ZipException zipException) {
            throw new BemException(string + " is not a valid zip file", (Throwable)zipException);
        }
        catch (IOException iOException) {
            throw new BemException("extractFromZip()", (Throwable)iOException);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string3;
    }

    private void checkIfCanceled() throws InterruptedException {
        if (this.migrateRbsController != null) {
            this.migrateRbsController.checkIfCanceled();
        }
    }

    public boolean isGigabitEthernetPortPresent(String string, String string2) throws BemException {
        String string3;
        boolean bl = false;
        String string4 = this.extractFromZip(string, string2);
        int n = string4.indexOf(string3 = "gigaBitEthernetPort");
        if (n != -1) {
            bl = true;
        }
        return bl;
    }

    public String getTransportOption() throws BemException {
        CustomerParameter customerParameter = null;
        try {
            customerParameter = this.rbs.getCustomerParameterObject("IPoverGigabitEthernet_transportOption");
        }
        catch (BemException bemException) {
            throw new BemException("getTransportOption()", (Throwable)bemException);
        }
        if (customerParameter != null) {
            String string = customerParameter.getValue();
            return string;
        }
        return null;
    }

    public void setTransportOption(String string) throws BemException {
        CustomerParameter customerParameter = null;
        try {
            customerParameter = this.rbs.getCustomerParameterObject("IPoverGigabitEthernet_transportOption");
        }
        catch (BemException bemException) {
            throw new BemException("getTransportOption()", (Throwable)bemException);
        }
        customerParameter.setValue(string);
    }

    public void performCabinetConfiguration(String string, String string2) throws Exception {
        try {
            String string3 = this.extractFromZip(string, string2);
            StringReader stringReader = new StringReader(string3);
            String string4 = "Cabinet configuration file as string";
            XmlFileHandler xmlFileHandler = XmlFileHandler.getInstance();
            ServiceValue serviceValue = xmlFileHandler.startParsing(stringReader, string4, CABINET_DTD_PATH);
            String string5 = MigrateRbsUtil.getValue(serviceValue, "rbsType");
            boolean bl = false;
            String string6 = serviceValue.getValue("2radioIfType");
            bl = string6 != null && string6.equals("DUI_O") ? true : DuwUtil.isPantherHybridRbs();
            this.rbs = RbsFactory.getRbs(string5, this.moHandler, "STEP_CABINET", bl, serviceValue);
            this.rbs.addObserver(this);
            this.update(null, "Creating rollback CV");
            this.createRollbackCV();
            this.checkIfCanceled();
            this.update(null, "Opening CIs");
            OpenCIs.openCabinetCIs(this.rbs);
            this.checkIfCanceled();
            this.update(null, "Setting customer parameters");
            this.rbs.setCustomerParameters(serviceValue);
            this.checkIfCanceled();
            this.install(this.rbs);
            this.checkIfCanceled();
            BemMo bemMo = this.getRbsConfigurationMo(this.rbs);
            this.configReport = this.configReport + "\n\nCabinet configuration\n";
            this.configReport = this.configReport + "=======================\n";
            this.configReport = this.configReport + this.getInformativetText(this.rbs);
            this.checkIfCanceled();
            this.moHandler.setAttribute(bemMo, "configurationReport", this.configReport);
        }
        catch (BemXmlException bemXmlException) {
            Throwable throwable = bemXmlException.getCause();
            if (throwable instanceof SAXParseException && this.migrateRbsController != null) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                int n = sAXParseException.getLineNumber();
                throw new BemXmlException("Error: XML Parsing Error\nProbable cause: Faulty input file\nAdditional information: " + "\n" + "Input file: " + "duwCabinet.xml" + "\n" + "Line number: " + n + "\n" + "Message: " + bemXmlException);
            }
            throw new BemException("performCabinetConfiguration()", (Throwable)bemXmlException);
        }
        catch (Exception exception) {
            throw new BemException("performCabinetConfiguration()", (Throwable)exception);
        }
    }

    public static String getValue(BemServiceValue bemServiceValue, String string) {
        String string2 = null;
        Enumeration enumeration = bemServiceValue.getAllServices();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            Vector vector = bemServiceValue.getValues(string3);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                NalNameValue nalNameValue = (NalNameValue)vector.get(i);
                String string4 = nalNameValue.getName();
                if (!string.equals(string4)) continue;
                string2 = (String)nalNameValue.getValue();
                break;
            }
            if (string2 == null) continue;
            break;
        }
        return string2;
    }

    public void install(Rbs rbs) throws BemException {
        rbs.checkConsistency();
        ArrayList arrayList = rbs.getRIsToInstall();
        int n = arrayList.size();
        Phase[] phaseArray = rbs.getInstallationPhases();
        int n2 = phaseArray.length;
        int n3 = n2 / 60;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            Phase phase = phaseArray[i];
            for (int j = 0; j < n; ++j) {
                ResourceItem resourceItem = (ResourceItem)arrayList.get(j);
                if (resourceItem.getName().equals("ROLLBACK_CONFIGURATION_VERSION")) continue;
                resourceItem.install(phase.getName());
            }
            if (n4 >= n3) {
                this.update(null, "Installing phase " + phase.getName());
                n4 = 0;
                continue;
            }
            ++n4;
        }
    }

    public void performSiteConfiguration(String string, String string2) throws Exception {
        try {
            this.moHandler = new MoHandlerImpl();
            this.rbs = RbsFactory.getRbs(this.moHandler, "STEP_SITE", DuwUtil.isPantherHybridRbs());
            String string3 = this.extractFromZip(string, string2);
            StringReader stringReader = new StringReader(string3);
            String string4 = "Site configuration file as string";
            this.rbs.addObserver(this);
            this.checkIfCanceled();
            this.stepProgressCounter = 0;
            this.update(null, "Opening CIs");
            OpenCIs.openSiteCIs(this.rbs);
            this.checkIfCanceled();
            XmlFileHandler xmlFileHandler = XmlFileHandler.getInstance();
            this.checkIfCanceled();
            ServiceValue serviceValue = xmlFileHandler.startParsing(stringReader, string4, SITE_DTD_PATH);
            this.rbs.setCustomerParameters(serviceValue);
            this.checkIfCanceled();
            this.rbs.checkConsistency();
            this.checkIfCanceled();
            this.rbs.installAllCIs(false, this);
            this.checkIfCanceled();
            BemMo bemMo = this.getRbsConfigurationMo(this.rbs);
            this.configReport = (String)this.moHandler.getAttribute(bemMo, "configurationReport");
            this.configReport = this.configReport + "\n\nSite configuration\n";
            this.configReport = this.configReport + "=======================\n";
            this.configReport = this.configReport + this.getInformativetText(this.rbs);
            this.checkIfCanceled();
            this.moHandler.setAttribute(bemMo, "configurationReport", this.configReport);
        }
        catch (BemXmlException bemXmlException) {
            Throwable throwable = bemXmlException.getCause();
            if (throwable instanceof SAXParseException && this.migrateRbsController != null) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                int n = sAXParseException.getLineNumber();
                throw new BemXmlException("Error: XML Parsing Error\nProbable cause: Faulty input file\nAdditional information: " + "\n" + "Input file: " + "duwSite.xml" + "\n" + "Line number: " + n + "\n" + "Message: " + bemXmlException);
            }
            throw new BemException("performSiteConfiguration()", (Throwable)bemXmlException);
        }
        catch (Exception exception) {
            throw new BemException("performSiteConfiguration()", (Throwable)exception);
        }
    }

    private BemMo getRbsConfigurationMo(Rbs rbs) throws BemException {
        MoInstance moInstance = rbs.getNodeBFunctionMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimRbsConfiguration.MOTYPENAME, "1");
        MoHandler moHandler = rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(singleChildMoi.getLdn());
        return bemMo;
    }

    private void combineServiceValues(ServiceValue serviceValue, ServiceValue serviceValue2) {
        Vector vector = serviceValue2.getAllAttributes();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)enumeration.nextElement();
            serviceValue.addAttribute(serviceNameValue);
        }
    }

    private String getInformativetText(Rbs rbs) throws BemException {
        InformativeText informativeText = new InformativeText(rbs);
        String string = informativeText.getInformativeText();
        return string;
    }

    public void performOamConfiguration(String string, String string2, String string3) throws Exception {
        try {
            this.moHandler = new MoHandlerImpl();
            this.rbs = RbsFactory.getRbs(this.moHandler, "STEP_OAM", DuwUtil.isPantherHybridRbs());
            String string4 = this.extractFromZip(string, string3);
            StringReader stringReader = new StringReader(string4);
            String string5 = "OAM configuration file as string";
            this.rbs.addObserver(this);
            this.stepProgressCounter = 0;
            this.update(null, "Opening CIs");
            OpenCIs.openMigrateRbsCIs(this.rbs, true);
            this.checkIfCanceled();
            PhaseOrder phaseOrder = new PhaseOrder(null);
            UnlockAllUnitsPhase unlockAllUnitsPhase = new UnlockAllUnitsPhase();
            phaseOrder.insertPhase(unlockAllUnitsPhase, "ConfigurationVersionCreationPhase");
            this.rbs.setInstallationPhaseOrder(phaseOrder);
            XmlFileHandler xmlFileHandler = XmlFileHandler.getInstance();
            this.checkIfCanceled();
            ServiceValue serviceValue = xmlFileHandler.startParsing(stringReader, string5, OAM_DTD_PATH);
            xmlFileHandler = XmlFileHandler.getInstance();
            this.checkIfCanceled();
            String string6 = this.extractFromZip(string, string2);
            StringReader stringReader2 = new StringReader(string6);
            BemMo bemMo = this.getRbsConfigurationMo(this.rbs);
            String string7 = "LDN:" + bemMo + ", Attr:" + "siteConfigFile";
            ServiceValue serviceValue2 = xmlFileHandler.startParsing(stringReader2, string7, SITE_DTD_PATH);
            this.combineServiceValues(serviceValue, serviceValue2);
            this.checkIfCanceled();
            this.rbs.setCustomerParameters(serviceValue);
            if (this.migrateRbsController != null) {
                CustomerParameter customerParameter = null;
                customerParameter = this.rbs.getCustomerParameterObject("gigaBitEthernetPort");
                customerParameter.setValue(this.migrateRbsController.getGigaBitEthernetPort());
            }
            this.checkIfCanceled();
            this.rbs.checkConsistency();
            this.checkIfCanceled();
            this.uninstallStaticRoutes();
            this.checkIfCanceled();
            this.rbs.installAllCIs(false, this);
            this.checkIfCanceled();
            this.configReport = (String)this.moHandler.getAttribute(bemMo, "configurationReport");
            this.configReport = this.configReport + "\n\nOam configuration\n";
            this.configReport = this.configReport + "=======================\n";
            this.configReport = this.configReport + this.getInformativetText(this.rbs);
            this.checkIfCanceled();
            this.moHandler.setAttribute(bemMo, "configurationReport", this.configReport);
        }
        catch (BemXmlException bemXmlException) {
            Throwable throwable = bemXmlException.getCause();
            if (throwable instanceof SAXParseException && this.migrateRbsController != null) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                int n = sAXParseException.getLineNumber();
                throw new BemXmlException("Error: XML Parsing Error\nProbable cause: Faulty input file\nAdditional information: " + "\n" + "Input file: " + "duwOam.xml" + "\n" + "Line number: " + n + "\n" + "Message: " + bemXmlException);
            }
            throw new BemException("performOamConfiguration()", (Throwable)bemXmlException);
        }
        catch (Exception exception) {
            throw new BemException("performOamConfiguration()", (Throwable)exception);
        }
    }

    public void performSiteCompleteConfiguration(String string, String string2) throws Exception {
        try {
            String string3 = this.extractFromZip(string, string2);
            File file = File.createTempFile("moscript", ".mo");
            String string4 = file.getPath();
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.print(string3);
            printWriter.flush();
            printWriter.close();
            MoScript moScript = new MoScript(string4);
            moScript.execute();
            file.delete();
        }
        catch (BemException bemException) {
            Throwable throwable = bemException.getCause();
            if (throwable instanceof SAXParseException && this.migrateRbsController != null) {
                SAXParseException sAXParseException = (SAXParseException)throwable;
                int n = sAXParseException.getLineNumber();
                throw new BemXmlException("Error: XML Parsing Error\nProbable cause: Faulty input file\nAdditional information: " + "\n" + "Input file: " + "duwCabinet.xml" + "\n" + "Line number: " + n + "\n" + "Message: " + bemException);
            }
            throw new BemException("performSiteComplete()", (Throwable)bemException);
        }
        catch (Exception exception) {
            throw new BemException("performSiteComplete()", (Throwable)exception);
        }
    }

    public void restartNode(Integer n, String string) {
        try {
            BemMo bemMo = this.moHandler.getRoot();
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("restartRank", 2), Nal.getFactory().getNameValue("restartReason", n), Nal.getFactory().getNameValue("restartInfo", string)};
            this.moHandler.action(bemMo, "manualRestart", nalNameValueArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Nal.getLog().nalTrace(6, this.getClass(), exception.getMessage());
        }
    }

    public void createRollbackCV() throws BemException {
        this.rollbackCvRI = new RollbackConfigurationVersionRI(this.rbs);
        this.rollbackCvRI.install("RollbackCVCreationPhase");
    }

    public void setRollbackCVAsStartable() throws BemException {
        if (this.rollbackCvRI != null) {
            this.rollbackCvRI.install("RollbackCVSettingPhase");
        }
    }

    public boolean isRollbackCVExisting() throws BemException {
        boolean bl = this.rollbackCvRI.isRollbackCVsExisting();
        return bl;
    }

    public void createFinalCV() throws BemException {
        ConfigurationVersionRI configurationVersionRI = new ConfigurationVersionRI(this.rbs, "MigrateRbs", "", "RBS EM", "Generated by Migrate Rbs to Duw.");
        configurationVersionRI.install("ConfigurationVersionCreationPhase");
        configurationVersionRI.setCvStartable(configurationVersionRI.getCvName());
    }

    public void startBemCliPrepareConvert(String string, boolean bl, ProgressMonitor progressMonitor) throws BemException {
        this.openMigrateRbsCIs(false);
        boolean bl2 = this.checkPreconditionsOK(false);
        if (bl2) {
            PrepareConvertMigrationPerformer prepareConvertMigrationPerformer = new PrepareConvertMigrationPerformer(this, progressMonitor, string);
            prepareConvertMigrationPerformer.run();
            if (bl) {
                this.lockAllBoards(this.getBbSubrackBoards());
            }
        }
    }

    public void startBemCliConfigure(String string, String string2) throws Exception {
        Object object;
        try {
            object = this.extractFromZip(string, MigrateRbsController.exportedFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET));
            this.checkDuwPreconditionRequiresDualDuw((String)object);
        }
        catch (Exception exception) {
            throw new BemException("startBemCliConfigure(): exception while checking preconditions", (Throwable)exception);
        }
        if (!RegressionTestInDesigntestUtils.getRegressionTest()) {
            Nal.getLog().nalTrace(4, this.getClass(), this.getClass().getName() + " - Handle Plug and Play.");
            object = new PlugAndPlayInstallerListenerCLI();
            HandlePlugAndPlayPreController handlePlugAndPlayPreController = new HandlePlugAndPlayPreController((Installer)object);
            handlePlugAndPlayPreController.install();
        }
        this.performCabinetConfiguration(string, MigrateRbsController.outputFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET));
        this.performSiteConfiguration(string, MigrateRbsController.outputFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.SITE));
        this.performOamConfiguration(string, MigrateRbsController.outputFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.SITE), MigrateRbsController.outputFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.OAM));
        this.performSiteCompleteConfiguration(string, "node_specific.mo");
        if (string2.equals("TNA") || string2.equals("TNB") || string2.equals("TNC")) {
            this.rbs.setCustomerParameter("gigaBitEthernetPort", string2);
        }
        this.createFinalCV();
        this.restartNode(0, "MigrateRbs configuration: Node restarted at the end of configuration");
    }

    public void update(Observable observable, Object object) {
        String string;
        this.progressMessage = string = object.toString();
        this.progressReporter.reportProgress(this.stepProgressCounter++, this.progressMessage);
    }

    public MoHandler getMoHandler() {
        return this.moHandler;
    }

    public Rbs getRbs() {
        return this.rbs;
    }

    public String getConfigReport() {
        return this.configReport;
    }

    public void setMigrateRbsController(MigrateRbsController migrateRbsController) {
        this.migrateRbsController = migrateRbsController;
    }

    public MigrateRbsController getMigrateRbsController() {
        return this.migrateRbsController;
    }

    public boolean hasApc(String string) {
        boolean bl = false;
        String string2 = null;
        try {
            string2 = this.extractFromZip(string, MigrateRbsController.exportedFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (0 < string2.indexOf("RBS3018")) {
            bl = true;
        }
        return bl;
    }

    public boolean isIpSyncRefExisting() throws Exception {
        if (this.getRbs().getConfigItem("IpOverGigabitEthernetCI").isOpen()) {
            for (int i = 0; i < IpOverGigabitEthernetCI.getNumberOfIpSyncRef(); ++i) {
                String string = MessageFormat.format("IPoverGigabitEthernet_{0}_ntpServerIpAddress", i + 1);
                String string2 = this.getRbs().getCustomerParameter(string);
                if (string2 == null || string2.equals("") || string2.equals("##UNDEFINED")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMultiCarrier() throws BemException {
        boolean bl;
        block3: {
            bl = false;
            try {
                MoHandler moHandler = this.rbs.getMoHandler();
                BemMo[] bemMoArray = moHandler.getChildren(moHandler.getRoot(), 2, MimRbsLocalCell.MOTYPENAME, "");
                if (bemMoArray == null) break block3;
                for (int i = 0; i < bemMoArray.length; ++i) {
                    if (!bemMoArray[i].getAttribute("featureStateHsdpaMc").equals(1) && !bemMoArray[i].getAttribute("featureStateHsdpaDbMc").equals(1)) continue;
                    bl = true;
                    break;
                }
            }
            catch (MoHandlerException moHandlerException) {
                moHandlerException.printStackTrace();
                throw new BemException(moHandlerException);
            }
        }
        return bl;
    }

    public void uninstallStaticRoutes() {
        try {
            ConfigurationItem configurationItem;
            List list = null;
            if (this.rbs.isConfigurationItemSupported("IpRoutingCI") && (configurationItem = this.rbs.getConfigItem("IpRoutingCI")).isOpen()) {
                list = configurationItem.getRIsToUninstall();
                Phase[] phaseArray = this.rbs.getUninstallationPhases();
                for (int i = 0; i < phaseArray.length; ++i) {
                    String string = phaseArray[i].getName();
                    for (ResourceItem resourceItem : list) {
                        if (resourceItem == null) continue;
                        resourceItem.uninstall(string);
                    }
                }
            }
        }
        catch (Exception exception) {
            String string = "commit failed, rollback to previous configuration.";
            String string2 = "Operation failed";
            string = "Commit or Rollback failed, reverting to Cancel CV.";
            string2 = "ROLLBACK_TRANSACTION";
            Nal.getFactory().getLog().nalTraceError(this.getClass(), "uninstallStaticRoutes() " + string, exception);
            BemRuntimeException bemRuntimeException = new BemRuntimeException("Uninstalling data on node" + string + ", action=" + string2, exception);
            throw bemRuntimeException;
        }
    }

    static class PlugAndPlayInstallerListenerCLI
    implements Installer {
        private String currentProgressDescription = "Not started";

        PlugAndPlayInstallerListenerCLI() {
        }

        public void stopExecution() {
        }

        public void reportProgress(String string, String string2, int n) {
            this.currentProgressDescription = string2;
            Nal.getLog().nalTrace(4, this.getClass(), "Handle Plug and Play. name=" + string + ", description=" + string2);
        }

        public void reportProgress(String string, String string2) {
            this.currentProgressDescription = string2;
            Nal.getLog().nalTrace(4, this.getClass(), "Handle Plug and Play. name=" + string + ", description=" + string2);
        }

        public String getReportedProgress() {
            return this.currentProgressDescription;
        }

        public void reportComplete() {
        }

        public boolean isInterrupted() {
            return false;
        }

        public void extendInstallReport(StringBuffer stringBuffer) {
        }
    }

    static class NotSupportedConfigCause {
        private String inputFile;
        private String parameter;

        public NotSupportedConfigCause(String string, String string2) {
            this.inputFile = string;
            this.parameter = string2;
        }

        public String getInputFile() {
            return this.inputFile;
        }

        public String getParameter() {
            return this.parameter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE_OF_RBS {
        RBS3106,
        RBS3206,
        RBS3206M,
        RBS3018,
        RBS3116,
        RBS3216,
        NOVALUE;


        public static TYPE_OF_RBS toTypeOfRbs(String string) {
            try {
                return TYPE_OF_RBS.valueOf(string);
            }
            catch (Exception exception) {
                return NOVALUE;
            }
        }
    }
}

