/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractCableRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOpticalInterfaceLink;
import se.ericsson.wcdma.rbs.bem.common.moi.CableMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class OilRI
extends AbstractCableRI {
    private static final String name = "OIL";
    private static final String OIL_DL_DEFAULT_RDNID_1 = "-DL";
    private static final String OIL_UL_DEFAULT_RDNID_1 = "-UL";
    private String ldn;
    private final String link;
    private String rruAuxLdn;
    private final int sectorNumber;
    private RadioEquipmentProvider radioEP;
    private String conUlRefParam;
    private String conDlRefParam;
    private Integer objAConParam;
    private Integer objBConParam;
    private String objARefParam;
    private String objBRefParam;
    private BemMo objectARef;
    private BemMo objectBRef;
    private MoInstance cableMoi;

    public OilRI(Rbs rbs, int n, String string, String string2, RadioEquipmentProvider radioEquipmentProvider, String string3) {
        super(rbs, name);
        this.radioEP = radioEquipmentProvider;
        this.ldn = string2;
        this.link = string;
        this.rruAuxLdn = string3;
        this.sectorNumber = n + 1;
    }

    public OilRI(Rbs rbs, int n, String string, String string2, Integer n2, Integer n3, String string3, String string4, String string5) {
        super(rbs, name);
        this.ldn = string2;
        this.link = string;
        this.rruAuxLdn = string5;
        this.sectorNumber = n + 1;
        this.conUlRefParam = string3;
        this.conDlRefParam = string4;
        this.objAConParam = n2;
        this.objBConParam = n3;
    }

    public OilRI(Rbs rbs, int n, String string, Integer n2, Integer n3, String string2, String string3) throws BemException {
        super(rbs, name);
        this.link = string;
        this.sectorNumber = n + 1;
        this.objARefParam = string2;
        this.objBRefParam = string3;
        this.objAConParam = n2;
        this.objBConParam = n3;
        this.initialiseMoiResources(n, string);
    }

    protected void initialiseMoiResources(int n, String string) throws BemException {
        if (string.equals("Ul")) {
            this.objectARef = this.getMo(this.objARefParam);
            this.objectBRef = this.getMo(this.objBRefParam);
            String string2 = this.getInternalNumber(this.objectARef.getDN());
            this.cableMoi = new CableMoi(MimOpticalInterfaceLink.MOTYPENAME, "A", "connectedToObjectARef", this.objectARef, "objectAConnector", this.objAConParam, null, null, null, null, Integer.toString(n + 1) + "-" + string2 + OIL_UL_DEFAULT_RDNID_1);
        } else if (string.equals("Dl")) {
            this.objectARef = this.getMo(this.objARefParam);
            this.objectBRef = this.getMo(this.objBRefParam);
            String string3 = this.getInternalNumber(this.objectBRef.getDN());
            this.cableMoi = new CableMoi(MimOpticalInterfaceLink.MOTYPENAME, "B", null, null, null, null, "connectedToObjectBRef", this.objectBRef, "objectBConnector", this.objBConParam, Integer.toString(n + 1) + "-" + string3 + OIL_DL_DEFAULT_RDNID_1);
        }
        this.ldn = this.cableMoi.getLdn();
    }

    public void updateMoiResources(int n, String string, String string2, Integer n2, Integer n3, String string3) throws BemException {
        this.objAConParam = n2;
        this.objBConParam = n3;
        this.objectARef = this.getMo(string);
        this.objectBRef = this.getMo(string2);
        Integer n4 = new Integer(n);
        String string4 = n4.toString();
        if (string3.equals("Ul")) {
            String string5 = this.getInternalNumber(this.objectARef.getDN());
            this.cableMoi = new CableMoi(MimOpticalInterfaceLink.MOTYPENAME, "B", null, null, null, null, "connectedToObjectBRef", this.objectBRef, "objectBConnector", this.objBConParam, string4 + "-" + string5 + OIL_UL_DEFAULT_RDNID_1);
        } else if (string3.equals("Dl")) {
            String string6 = this.getInternalNumber(this.objectBRef.getDN());
            this.cableMoi = new CableMoi(MimOpticalInterfaceLink.MOTYPENAME, "A", "connectedToObjectARef", this.objectARef, "objectAConnector", this.objAConParam, null, null, null, null, string4 + "-" + string6 + OIL_DL_DEFAULT_RDNID_1);
        }
        this.ldn = this.cableMoi.getLdn();
    }

    private String getInternalNumber(String string) {
        int n = string.lastIndexOf("-");
        String string2 = string.substring(n + 1, string.length());
        if (string2.length() > 1) {
            return "";
        }
        return string2;
    }

    public void install(String string) throws BemException {
        if (!string.equals("AntennaSystemCableCreationPhase")) {
            return;
        }
        BemMo bemMo = this.getMo(this.rruAuxLdn);
        if (this.radioEP != null) {
            this.conUlRefParam = this.radioEP.getTerminationObject(this.sectorNumber, "UL");
            this.conDlRefParam = this.radioEP.getTerminationObject(this.sectorNumber, "DL");
            this.objAConParam = this.radioEP.getTerminationConnectors(this.sectorNumber, "UL")[0];
            this.objBConParam = this.radioEP.getTerminationConnectors(this.sectorNumber, "DL")[0];
        }
        BemMo bemMo2 = this.getMo(this.conUlRefParam);
        BemMo bemMo3 = this.getMo(this.conDlRefParam);
        if (this.objectARef == null) {
            if (this.link.equals("Dl")) {
                this.updateOil(this.ldn, bemMo3, bemMo, this.objAConParam, 4);
            } else {
                this.updateOil(this.ldn, bemMo, bemMo2, 4, this.objBConParam);
            }
        } else {
            this.updateOil(this.ldn, this.objectARef, this.objectBRef, this.objAConParam, this.objBConParam);
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("AntennaSystemCableDeletionPhase")) {
            this.deleteMoIfNotExisting(this.ldn);
        }
    }

    private void updateOil(String string, BemMo bemMo, BemMo bemMo2, int n, int n2) throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        BemMo bemMo3 = this.getMo(string);
        if (!bemMo3.isExisting()) {
            nalNameValue = Nal.getFactory().getNameValue("connectedToObjectARef", bemMo);
            vector.add(nalNameValue);
            nalNameValue = Nal.getFactory().getNameValue("connectedToObjectBRef", bemMo2);
            vector.add(nalNameValue);
            nalNameValue = Nal.getFactory().getNameValue("objectAConnector", new Integer(n));
            vector.add(nalNameValue);
            nalNameValue = Nal.getFactory().getNameValue("objectBConnector", new Integer(n2));
            vector.add(nalNameValue);
            this.createMoIfNotExisting(string, vector);
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "OIL: " + this.getLdn();
    }
}

