/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.EtbSlotParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AbstractTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AtmPortRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.FractionalRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.ImaRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class RIAndCPWrapper {
    private static int terminationIndex = 0;
    private int termIndex = 0;
    private Map etmRIs = new HashMap();
    private AtmPortRI atmPortRI = null;
    private FractionalRI fractionalRI = null;
    private ImaRI imaRI = null;
    private boolean isToBeUninstalled = false;
    private TerminationParameterList paramList = null;

    public RIAndCPWrapper(Map map, AtmPortRI atmPortRI, ImaRI imaRI, FractionalRI fractionalRI, TerminationParameterList terminationParameterList) {
        this.etmRIs = map;
        this.fractionalRI = fractionalRI;
        this.atmPortRI = atmPortRI;
        this.imaRI = imaRI;
        this.paramList = terminationParameterList;
        this.termIndex = terminationIndex++;
    }

    public TerminationParameterList getParamList() {
        return this.paramList;
    }

    public int getTermIndex() {
        return this.termIndex;
    }

    public Map getTerminationRIs() {
        return this.etmRIs;
    }

    public FractionalRI getFractionalRI() {
        return this.fractionalRI;
    }

    public AtmPortRI getAtmPortRI() {
        return this.atmPortRI;
    }

    public ImaRI getImaRI() {
        return this.imaRI;
    }

    public void setToBeUninstalled(boolean bl) {
        this.isToBeUninstalled = bl;
    }

    public boolean isToBeUninstalled() {
        return this.isToBeUninstalled;
    }

    public void updateRiReferences() {
        String string = this.paramList.getSlotParameter().getValue();
        AbstractTerminationRI abstractTerminationRI = (AbstractTerminationRI)this.etmRIs.get(string);
        this.atmPortRI.setTerminationRI(abstractTerminationRI);
        this.fractionalRI.setTerminationRI(abstractTerminationRI);
        this.imaRI.setTerminationRI(abstractTerminationRI);
    }

    public String getConfiguredLine(String string) {
        String string2 = this.paramList.getSlotParameter().getValue();
        AbstractTerminationRI abstractTerminationRI = (AbstractTerminationRI)this.etmRIs.get(string2);
        return abstractTerminationRI.getLineFromLdn(string);
    }

    public String getConfiguredPhysTermLines(String string) throws BemException {
        AbstractTerminationRI abstractTerminationRI;
        EtbSlotParameter etbSlotParameter = this.paramList.getSlotParameter();
        String string2 = etbSlotParameter.getValue();
        String string3 = null;
        if (string.equals(string2) && (abstractTerminationRI = (AbstractTerminationRI)this.etmRIs.get(string)) != null) {
            string3 = abstractTerminationRI.getLineId();
        }
        return string3;
    }

    public String[] getConfiguredPhysTermLinesForIma(String string) {
        EtbSlotParameter etbSlotParameter = this.paramList.getSlotParameter();
        String string2 = etbSlotParameter.getValue();
        String[] stringArray = null;
        if (string.equals(string2) && this.imaRI != null) {
            stringArray = this.paramList.getLineParameter().getAllLines();
        }
        return stringArray;
    }

    protected String getLdnFromLine(String string, String string2) {
        AbstractTerminationRI abstractTerminationRI;
        String string3 = null;
        String string4 = this.paramList.getSlotParameter().getValue();
        if (string != null && string2 != null && string.equals(string4) && (abstractTerminationRI = (AbstractTerminationRI)this.etmRIs.get(string4)) != null) {
            return abstractTerminationRI.getLdnFromLine(string2);
        }
        return string3;
    }

    protected String generateLdnFromSlotAndLine(String string, String string2) throws BemException {
        String string3 = null;
        String string4 = this.paramList.getSlotParameter().getValue();
        String[] stringArray = this.paramList.getLineParameter().getAllLines();
        if (string != null && string2 != null && stringArray != null && stringArray.length > 0 && string.equals(string4)) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string2.equals(stringArray[i])) continue;
                AbstractTerminationRI abstractTerminationRI = (AbstractTerminationRI)this.etmRIs.get(string4);
                return abstractTerminationRI.generateTerminationLdn(string2);
            }
        }
        return string3;
    }

    protected String generateSynchLdnFromSlotAndLine(String string, String string2) throws BemException {
        String string3 = null;
        String string4 = this.paramList.getSlotParameter().getValue();
        String[] stringArray = this.paramList.getLineParameter().getAllLines();
        if (string != null && string2 != null && stringArray != null && stringArray.length > 0 && string.equals(string4)) {
            AbstractTerminationRI abstractTerminationRI = (AbstractTerminationRI)this.etmRIs.get(string4);
            return abstractTerminationRI.generateSynchTerminationLdn(string2);
        }
        return string3;
    }

    public String getSynchTerminationMoType(String string, String string2) throws BemException {
        String string3 = "";
        AbstractTerminationRI abstractTerminationRI = (AbstractTerminationRI)this.etmRIs.get(string);
        if (abstractTerminationRI != null) {
            string3 = abstractTerminationRI.getSynchTerminationMoType();
        }
        return string3;
    }

    public String[] getSynchPorts(String string, String[] stringArray) throws BemException {
        AbstractTerminationRI abstractTerminationRI = (AbstractTerminationRI)this.etmRIs.get(string);
        String[] stringArray2 = abstractTerminationRI.getSynchTerminations(stringArray);
        return stringArray2;
    }

    public ArrayList getRIsToUninstall() {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        if (this.isToBeUninstalled()) {
            Collection collection = this.etmRIs.values();
            for (AbstractTerminationRI abstractTerminationRI : collection) {
                if (!abstractTerminationRI.isToBeUnInstalled()) continue;
                arrayList.add(abstractTerminationRI);
            }
            if (this.fractionalRI.isToBeUnInstalled()) {
                arrayList.add(this.fractionalRI);
            }
            if (this.atmPortRI.isToBeUnInstalled()) {
                arrayList.add(this.atmPortRI);
            }
            if (this.imaRI.isToBeUnInstalled()) {
                arrayList.add(this.imaRI);
            }
        }
        return arrayList;
    }
}

