/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.LocationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.AbstractCabinetBasicCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.AutoConfigRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.CbuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.DigitalSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.ExternalNodeRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.JvmRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.MediumAccessUnitRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.NodeRestartRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.PmServiceRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.ProductInfoRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.RedundantControlSystemParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.ReliableProgramUniterRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.RestartEscalationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.SwitchPlaneRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.SupportSystemAvailableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.SyncRefInfo;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ConfirmDialogParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProviderImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsData;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.SwAllocOtherRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCbu;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimFcuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGeneralProcessorUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimJvm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.ChildWithAttributeValues;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.LdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class CabinetBasicCI
extends AbstractCabinetBasicCI {
    private ArrayList allResourceItems;
    private DigitalSubrackRI digitalSubrackRI;
    private SwAllocOtherRI swAllocOtherRI;
    private NodeRestartRI nodeRestartRI;
    private RestartEscalationRI restartEscalationRI;
    private ReliableProgramUniterRI rpuRI;
    private SwitchPlaneRI spRI;
    private ExternalNodeRI[] externalNodeRIs = new ExternalNodeRI[7];
    private RedundantControlSystemParameter redundantControlSystemCustParam;
    private ConfirmDialogParameter restartCustParam;
    private boolean isOpen = false;
    private AtfProviderImpl myAtfProvider;
    private RbsData rbsData;
    protected ChildWithAttributeValues auxpiuFcuMoi;
    private MoInstance gpuMoi;
    private boolean supportSystemAvailable = false;
    protected SupportSystemAvailableRI supportSystemAvailableRI = null;
    private Object jvmRI;

    public CabinetBasicCI(Rbs rbs) {
        super(rbs);
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            throw new BemException("CabinetBasicCI.open(): Already open");
        }
        this.initializeMoiResources();
        boolean bl = true;
        this.createBasicCommonResourceItems();
        if (this.allResourceItems != null) {
            this.initialiseCustomerParameters();
            if (this.supportSystemAvailable && this.rbs.getRbsData().isRbs6000()) {
                this.createEcPortCustomerParametersCbu();
                super.createEcPortCustomerParametersExternalNode();
            }
        } else {
            throw new BemException("CabinetBasicCI.open() can not find any resource items");
        }
        this.locationProvider = (LocationProvider)this.rbs.getProvider(LocationProvider.class);
        this.isOpen = true;
        return bl;
    }

    private void createDigitalSubrackRi() throws BemException {
        if (this.digitalSubrackRI != null) {
            return;
        }
        this.rbsData = super.getRbsData();
        int n = this.rbsData.getNoOfSlots();
        String string = this.rbsData.getCabinetPosition();
        String string2 = this.rbsData.getSubrackPosition();
        HashMap hashMap = this.rbsData.getBoardPositions();
        Map map = this.rbsData.getRepertoireMap();
        this.digitalSubrackRI = new DigitalSubrackRI(this.getRbs(), n, string, string2, hashMap, super.getHubSubrackMoi(), map, this.supportSystemAvailable);
    }

    private void createSwAllocOtherRI() {
        if (this.swAllocOtherRI != null) {
            return;
        }
        this.swAllocOtherRI = new SwAllocOtherRI(this.rbs);
    }

    private void createBasicCommonResourceItems() throws BemException {
        Integer n;
        this.allResourceItems = new ArrayList();
        this.createDigitalSubrackRi();
        this.allResourceItems.add(this.digitalSubrackRI);
        this.createSwAllocOtherRI();
        this.allResourceItems.add(this.swAllocOtherRI);
        String[] stringArray = this.rbsData.getProductData();
        this.allResourceItems.add(new ProductInfoRI(super.getRbs(), stringArray[0], stringArray[1], stringArray[2], 2));
        this.allResourceItems.add(new PmServiceRI(super.getRbs(), super.getPmServiceLdn()));
        ArrayList arrayList = this.digitalSubrackRI.getSubResourceItems();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.allResourceItems.add(arrayList.get(i));
        }
        String[] stringArray2 = this.digitalSubrackRI.getBoardPosition(MimCbu.MOTYPENAME);
        int n2 = -1;
        int n3 = 0;
        ResourceItem resourceItem = null;
        if (stringArray2.length > 1 && (resourceItem = this.digitalSubrackRI.getSubResourceItem(new Integer(n2 = (n = Integer.valueOf(stringArray2[1])).intValue()))) != null && resourceItem.isInstalled()) {
            n3 = 1;
        }
        n = Integer.valueOf(stringArray2[0]);
        int n4 = n;
        this.spRI = new SwitchPlaneRI(this.rbs, n3);
        this.allResourceItems.add(this.spRI);
        this.rpuRI = new ReliableProgramUniterRI(super.getRbs(), (HubSubrackMoi)super.getHubSubrackMoi(), n2, n4, this.supportSystemAvailable);
        this.allResourceItems.add(this.rpuRI);
        this.allResourceItems.add(new MediumAccessUnitRI(super.getRbs(), super.getHubSubrackMoi(), MimCbu.MOTYPENAME, 1));
        if (stringArray2.length > 1 && resourceItem != null) {
            this.allResourceItems.add(new MediumAccessUnitRI(super.getRbs(), super.getHubSubrackMoi(), MimCbu.MOTYPENAME, n2));
        }
        this.allResourceItems.add(new AutoConfigRI(super.getRbs(), true, super.getManagedElementMoi().getLdn()));
        this.nodeRestartRI = new NodeRestartRI(this.rbs);
        this.allResourceItems.add(this.nodeRestartRI);
        this.restartEscalationRI = new RestartEscalationRI(super.getRbs(), super.getConfigurationVersionLdn());
        this.allResourceItems.add(this.restartEscalationRI);
        for (int i = 0; i < 7; ++i) {
            String string = String.valueOf(i + 1);
            this.externalNodeRIs[i] = new ExternalNodeRI(this.rbs, string);
            this.allResourceItems.add(this.externalNodeRIs[i]);
        }
        if (!this.supportSystemAvailable) {
            this.supportSystemAvailableRI = new SupportSystemAvailableRI(super.getRbs(), false);
            this.allResourceItems.add(this.supportSystemAvailableRI);
        } else {
            this.addJvmRI();
        }
    }

    private void addJvmRI() {
        SingleChildMoi singleChildMoi = new SingleChildMoi(this.rbs.getEquipmentMoi(), MimJvm.MOTYPENAME, "1");
        this.jvmRI = new JvmRI(this.rbs, singleChildMoi, null);
        this.allResourceItems.add(this.jvmRI);
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        String[] stringArray = new String[]{"redundantControlSystem", "nodeRestart"};
        super.setCustomerParametersFromSV(stringArray, serviceValue);
        if (this.supportSystemAvailable && this.rbs.getRbsData().isRbs6000()) {
            super.setEcPortCustomerParameters(serviceValue);
        }
    }

    private void initialiseCustomerParameters() throws BemException {
        Object object;
        this.redundantControlSystemCustParam = new RedundantControlSystemParameter();
        this.restartCustParam = new ConfirmDialogParameter();
        String string = "NO";
        String[] stringArray = this.digitalSubrackRI.getBoardPosition(MimCbu.MOTYPENAME);
        int n = -1;
        ResourceItem resourceItem = null;
        if (stringArray.length > 1) {
            object = Integer.valueOf(stringArray[1]);
            n = (Integer)object;
            resourceItem = this.digitalSubrackRI.getSubResourceItem(new Integer(n));
        }
        if (resourceItem != null) {
            if (resourceItem.isInstalled()) {
                object = new ParameterRestriction("Redundant control system cannot be deleted", 0);
                this.redundantControlSystemCustParam.addRestriction((ParameterRestriction)object);
                string = "YES";
            }
        } else {
            object = new EnumeratedRange(new String[]{"NO"});
            ParameterRestriction parameterRestriction = new ParameterRestriction("Redundant control system is not supported by this RBS type", (ParameterRange)object, true);
            this.redundantControlSystemCustParam.addRestriction(parameterRestriction);
        }
        this.redundantControlSystemCustParam.setDefaultValue("NO");
        this.redundantControlSystemCustParam.setLoadedValue(string);
        this.restartCustParam.setDefaultValue("NO");
        this.restartCustParam.setLoadedValue("NO");
        super.addParameter(this.redundantControlSystemCustParam);
        super.addParameter(this.restartCustParam);
        this.redundantControlSystemCustParam.addCustomerParameterListener(this);
        this.digitalSubrackRI.registerCustomerParameter(this.redundantControlSystemCustParam);
        this.spRI.registerCustomerParameter(this.redundantControlSystemCustParam);
        if (resourceItem != null) {
            resourceItem.registerCustomerParameter(this.redundantControlSystemCustParam);
        }
        this.rpuRI.registerCustomerParameter(this.redundantControlSystemCustParam);
        this.nodeRestartRI.registerCustomerParameter(this.restartCustParam);
    }

    public ArrayList getNeededRIs() {
        if (this.isOpen && (this.redundantControlSystemCustParam.isValueEqualTo("NO") || this.redundantControlSystemCustParam.getLoadedValue().equals("YES") && this.redundantControlSystemCustParam.isValueEqualTo("YES"))) {
            String[] stringArray = this.digitalSubrackRI.getBoardPosition(MimCbu.MOTYPENAME);
            if (stringArray.length > 1) {
                Integer n = Integer.valueOf(stringArray[1]);
                ResourceItem resourceItem = this.digitalSubrackRI.getSubResourceItem(n);
                this.allResourceItems.remove(resourceItem);
            }
            if (!this.getRbs().getRbsStep().equals("STEP_CABINET") && !this.redundantControlSystemCustParam.hasValueChanged()) {
                this.allResourceItems.remove(this.rpuRI);
            }
            this.allResourceItems.remove(this.spRI);
        }
        return this.allResourceItems;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    protected AtfProvider getAtfProvider() {
        return this.getAtfProvider(0);
    }

    protected AtfProvider getAtfProvider(int n) {
        if (this.myAtfProvider == null) {
            try {
                this.createDigitalSubrackRi();
            }
            catch (BemException bemException) {
                Nal.getLog().nalTrace(2, this.getClass(), "Failed creating digital subrack RI", bemException);
            }
            this.myAtfProvider = new AtfProviderImpl();
            String[] stringArray = this.digitalSubrackRI.getBoardPosition(MimCbu.MOTYPENAME);
            Integer n2 = Integer.valueOf(stringArray[0]);
            CbuRI cbuRI = (CbuRI)this.digitalSubrackRI.getSubResourceItem(n2);
            String string = cbuRI.getPiuLdn();
            String string2 = null;
            if (stringArray.length > 1) {
                Integer n3 = Integer.valueOf(stringArray[1]);
                CbuRI cbuRI2 = (CbuRI)this.digitalSubrackRI.getSubResourceItem(n3);
                string2 = cbuRI2.getPiuLdn();
            }
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_BFU", string, string2);
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_CLU", string, string2);
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_FCU", string, string2);
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_PSU", string, string2);
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_XALM", string, string2);
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_SCU", string, string2);
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_SAU", string, string2);
        }
        return this.myAtfProvider;
    }

    protected void initializeMoiResources() {
        this.auxpiuFcuMoi = new ChildWithAttributeValues(super.getEquipmentMoi(), MimAuxPlugInUnit.MOTYPENAME, "auType", new Integer(13), "2");
        this.fcuMoi = new SingleChildMoi(this.auxpiuFcuMoi, MimFcuDeviceGroup.MOTYPENAME, "1");
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(super.getHubSubrackMoi(), MimSlot.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi = new SingleChildMoi(fixedRdnMoi, MimPlugInUnit.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimCbu.MOTYPENAME, "1");
        this.gpuMoi = new SingleChildMoi(singleChildMoi2, MimGeneralProcessorUnit.MOTYPENAME, "1");
    }

    public MoInstance getGpuMoi() {
        return this.gpuMoi;
    }

    public String[] getCbuLdns() {
        String[] stringArray = new String[2];
        String[] stringArray2 = this.digitalSubrackRI.getBoardPosition(MimCbu.MOTYPENAME);
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                Integer n = Integer.valueOf(stringArray2[i]);
                ResourceItem resourceItem = this.digitalSubrackRI.getSubResourceItem(n);
                stringArray[i] = resourceItem.getLdn();
            }
        }
        return stringArray;
    }

    public String[] getSlotsWithTuSynchRef() throws BemException {
        String[] stringArray = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.digitalSubrackRI.getBoardPosition(MimCbu.MOTYPENAME);
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                Integer n = Integer.valueOf(stringArray2[i]);
                CbuRI cbuRI = (CbuRI)this.digitalSubrackRI.getSubResourceItem(n);
                if (!cbuRI.isTuSynchRef()) continue;
                arrayList.add(stringArray2[i]);
            }
        }
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public String[] getTuSynchRefLdns(String string) throws BemException {
        Integer n = Integer.valueOf(string);
        CbuRI cbuRI = (CbuRI)this.digitalSubrackRI.getSubResourceItem(n);
        if (cbuRI == null) {
            return new String[0];
        }
        return cbuRI.getTuSynchRefLdns();
    }

    public SyncRefInfo[] getTuSyncRefs(String string) throws BemException {
        ArrayList<SyncRefInfo> arrayList = new ArrayList<SyncRefInfo>();
        int n = 5;
        Object[] objectArray = this.getTuSynchRefLdns(string);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            SyncRefInfo syncRefInfo = new SyncRefInfo((String)objectArray[i], n, "CBU");
            arrayList.add(syncRefInfo);
            ++n;
        }
        return arrayList.toArray(new SyncRefInfo[0]);
    }

    public String[] getProcessorPiuLdns() throws BemException {
        String[] stringArray = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.digitalSubrackRI.getBoardPosition(MimCbu.MOTYPENAME);
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                Integer n = Integer.valueOf(stringArray2[i]);
                CbuRI cbuRI = (CbuRI)this.digitalSubrackRI.getSubResourceItem(n);
                boolean bl = cbuRI.isInstalled();
                if (!bl) continue;
                arrayList.add(cbuRI.getPiuLdn());
            }
        }
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public void setSupportSystemAvailable(boolean bl) {
        this.supportSystemAvailable = bl;
    }

    private void createEcPortCustomerParametersCbu() throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        try {
            for (int i = 1; i <= 2; ++i) {
                Object object;
                CbuRI cbuRI = (CbuRI)this.digitalSubrackRI.getSubResourceItem(new Integer(i));
                if (cbuRI == null) continue;
                String string = cbuRI.getPiuLdn();
                LdnMoi ldnMoi = new LdnMoi(string);
                SingleChildMoi singleChildMoi = new SingleChildMoi(ldnMoi, MimEcPort.MOTYPENAME, "1");
                BemMo bemMo = moHandler.getMo(singleChildMoi.getLdn());
                EcPortInfo ecPortInfo = super.createEcPortCustomerParameter("CBU");
                Enumeration enumeration = ecPortInfo.getUnitTypeParameter();
                enumeration.setLoadedValue("CBU");
                enumeration.addRestriction(this.ecPortReadOnlyRestriction);
                Enumeration enumeration2 = ecPortInfo.getUnitNumberParameter();
                enumeration2.setLoadedValue(String.valueOf(i));
                enumeration2.addRestriction(this.ecPortReadOnlyRestriction);
                Enumeration enumeration3 = ecPortInfo.getHubPositionParameter();
                if (moHandler.isExisting(bemMo)) {
                    object = (String)bemMo.getAttribute("hubPosition");
                    enumeration3.setLoadedValue(object);
                }
                object = ecPortInfo.getPortNumberParameter();
                ((CustomerParameterImpl)object).setLoadedValue("1");
                ((CustomerParameterImpl)object).addRestriction(this.ecPortReadOnlyRestriction);
                enumeration.addCustomerParameterListener(this);
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException);
        }
    }
}

