/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDeviceBoardRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGeneralProcessorUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimReliableProgramUniter;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwManagement;
import se.ericsson.wcdma.rbs.bem.common.moi.ChildWithAttributeValues;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class GpbRI
extends AbstractDeviceBoardRI {
    private static final String name = "GPB";
    public static final String WIZARD_SWALLOC_ROLE_MAIN_GPB = "RBS_GPB_Main";
    private static final String WIZARD_REPERTOIRE_GPB = "RBS_MP_Main";
    private static final String WIZARD_REPERTOIRE_GPB_REDUNDANCY = "Cello_Common_Main_FTC_Redundancy";
    private static final String WIZARD_REPERTOIRE_CELLO_FUNCTION_ADM1_RBS_SIGTRAN = "Cello_Function_Adm1_RBS_Sigtran";
    private static final String WIZARD_REPERTOIRE_SCTP_IP_MP = "Cello_SCTP_IP_MP";
    private static final String RPU_ACT_AAL5_DYNAMIC_ADM_SCTP_ADM = "act_aal5_dynamic_adm";
    private static final String RPU_SCTP_ADM = "sctp_adm";
    private static final String RPU_IPAC_IPADM = "ipac_ipadm";
    private static final String RPU_IPCP_IPADM = "ipcp_ipadm";
    private static final String RPU_EXS_EXHADM = "exs_exhadm";
    private static final String RPU_SCTP_HOST = "sctp_host";
    private static final int VALID_YEAR = 2006;
    private static final int VALID_MONTH = 10;
    private static final int VALID_DAY = 17;
    private static final int VALID_YEAR_2 = 6;
    private static final int VALID_WEEK = 42;
    private static final Integer PIU_GROUP_NUMBER = new Integer(1);
    private boolean configureGpbForIp;
    private final boolean redundantGpb;
    private boolean redundancyChanged = false;

    public GpbRI(Rbs rbs, int n, MoInstance moInstance, boolean bl) {
        super(name, rbs, n, MimGeneralProcessorUnit.MOTYPENAME, moInstance, bl);
        super.setRoleForSwAllocation(WIZARD_SWALLOC_ROLE_MAIN_GPB);
        this.redundantGpb = bl;
        super.createPiuAndBoard(true);
        super.addRepertoiresToInstall(WIZARD_REPERTOIRE_GPB);
        try {
            this.configureGpbForIp = this.checkIfIpCapableGpbBoard();
        }
        catch (BemException bemException) {
            this.configureGpbForIp = false;
        }
    }

    public void install(String string) throws BemException {
        String string2;
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("redundantControlSystem");
        if (customerParameter.hasValueChanged()) {
            this.redundancyChanged = true;
        }
        if ((string2 = customerParameter.getValue()).equals("YES")) {
            super.addRepertoiresToInstall(WIZARD_REPERTOIRE_GPB_REDUNDANCY);
        } else {
            super.addRepertoiresToUninstall(WIZARD_REPERTOIRE_GPB_REDUNDANCY);
        }
        if (string.equals("IpCapableGpbCreationPhase") && this.configureGpbForIp && !this.redundantGpb) {
            this.addRepertoriesForIPCapleGpbBoard();
            this.createRPU();
            String string3 = super.getPiuMoi().getLdn();
            if (this.isExisting(string3)) {
                BemMo bemMo = (BemMo)this.getAttribute(this.getMo(string3), "piuType");
                super.installPiuTypeIfNeeded(bemMo, false);
            }
        }
        if (string.equals("IpCapableGpbConfigurationPhase") && this.configureGpbForIp && !this.redundantGpb) {
            super.reconfigureProgramPrepare();
        }
        if (string.equals("IpCapableGpbStartPhase") && this.configureGpbForIp && !this.redundantGpb) {
            this.startImmediateActionOnProgramMos();
        }
        super.install(string);
        if (string.equals("DeviceBoardCreationPhase") && this.redundancyChanged && !this.redundantGpb) {
            super.reconfigureProgramPrepare();
            this.startImmediateActionOnProgramMos();
        }
        if (string.equals("DeviceBoardCreationPhase") && !this.redundantGpb) {
            this.createGpb();
        }
        if (string.equals("SecondTuSyncRefCreationPhase")) {
            this.setPiuGroupNumberAttribute(PIU_GROUP_NUMBER);
        }
    }

    private void addRepertoriesForIPCapleGpbBoard() throws BemException {
        super.addRepToSwAllocationIfExisting(WIZARD_REPERTOIRE_CELLO_FUNCTION_ADM1_RBS_SIGTRAN);
        super.addRepToSwAllocationIfExisting(WIZARD_REPERTOIRE_SCTP_IP_MP);
    }

    private void createRPU() throws BemException {
        RootMoi rootMoi = new RootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimSwManagement.MOTYPENAME, "1");
        String string = this.getLdn();
        BemMo bemMo = this.getMo(string);
        BemMo bemMo2 = bemMo.getParent();
        BemMo bemMo3 = bemMo2.getParent();
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue("reliableProgramLabel", RPU_ACT_AAL5_DYNAMIC_ADM_SCTP_ADM));
        vector.add(Nal.getFactory().getNameValue("admActiveSlot", bemMo3));
        ChildWithAttributeValues childWithAttributeValues = new ChildWithAttributeValues(singleChildMoi, MimReliableProgramUniter.MOTYPENAME, "reliableProgramLabel", RPU_ACT_AAL5_DYNAMIC_ADM_SCTP_ADM, RPU_ACT_AAL5_DYNAMIC_ADM_SCTP_ADM);
        super.createMoIfNotExisting(childWithAttributeValues.getLdn(), vector);
        vector = new Vector();
        vector.add(Nal.getFactory().getNameValue("reliableProgramLabel", RPU_SCTP_ADM));
        vector.add(Nal.getFactory().getNameValue("admActiveSlot", bemMo3));
        childWithAttributeValues = new ChildWithAttributeValues(singleChildMoi, MimReliableProgramUniter.MOTYPENAME, "reliableProgramLabel", RPU_SCTP_ADM, RPU_SCTP_ADM);
        super.createMoIfNotExisting(childWithAttributeValues.getLdn(), vector);
        vector = new Vector();
        vector.add(Nal.getFactory().getNameValue("reliableProgramLabel", RPU_IPAC_IPADM));
        vector.add(Nal.getFactory().getNameValue("admActiveSlot", bemMo3));
        childWithAttributeValues = new ChildWithAttributeValues(singleChildMoi, MimReliableProgramUniter.MOTYPENAME, "reliableProgramLabel", RPU_IPAC_IPADM, RPU_IPAC_IPADM);
        super.createMoIfNotExisting(childWithAttributeValues.getLdn(), vector);
        vector = new Vector();
        vector.add(Nal.getFactory().getNameValue("reliableProgramLabel", RPU_EXS_EXHADM));
        vector.add(Nal.getFactory().getNameValue("admActiveSlot", bemMo3));
        childWithAttributeValues = new ChildWithAttributeValues(singleChildMoi, MimReliableProgramUniter.MOTYPENAME, "reliableProgramLabel", RPU_EXS_EXHADM, RPU_EXS_EXHADM);
        super.createMoIfNotExisting(childWithAttributeValues.getLdn(), vector);
        vector = new Vector();
        vector.add(Nal.getFactory().getNameValue("reliableProgramLabel", RPU_SCTP_HOST));
        vector.add(Nal.getFactory().getNameValue("admActiveSlot", bemMo3));
        childWithAttributeValues = new ChildWithAttributeValues(singleChildMoi, MimReliableProgramUniter.MOTYPENAME, "reliableProgramLabel", RPU_SCTP_HOST, RPU_SCTP_HOST);
        super.createMoIfNotExisting(childWithAttributeValues.getLdn(), vector);
        vector = new Vector();
        vector.add(Nal.getFactory().getNameValue("reliableProgramLabel", RPU_IPCP_IPADM));
        vector.add(Nal.getFactory().getNameValue("admActiveSlot", bemMo3));
        childWithAttributeValues = new ChildWithAttributeValues(singleChildMoi, MimReliableProgramUniter.MOTYPENAME, "reliableProgramLabel", RPU_IPCP_IPADM, RPU_IPCP_IPADM);
        super.createMoIfNotExisting(childWithAttributeValues.getLdn(), vector);
    }

    private boolean checkIfIpCapableGpbBoard() throws BemException {
        boolean bl;
        String string;
        String string2;
        String string3 = this.getLdn();
        BemMo bemMo = this.getMo(string3);
        BemMo bemMo2 = bemMo.getParent();
        BemMo bemMo3 = bemMo2.getParent();
        boolean bl2 = false;
        try {
            NalStruct nalStruct = (NalStruct)this.getAttribute(bemMo3, "productData");
            string2 = (String)nalStruct.getMemberValue("productionDate");
            string = (String)nalStruct.getMemberValue("productRevision");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BemException(this.getName(), (Throwable)noSuchFieldException);
        }
        boolean bl3 = this.checkProductRevision(string);
        bl2 = bl3 ? ((bl = this.checkIfProductDateIsSet(string2)) ? this.checkProductionDate(string2) : true) : false;
        return bl2;
    }

    private boolean checkProductRevision(String string) {
        int n;
        if (string == null || string.equals("")) {
            return false;
        }
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1, 2);
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            return false;
        }
        return (string2.equals("R") || string2.equals("r")) && n >= 2;
    }

    private boolean checkProductionDate(String string) {
        int n;
        String string2;
        String string3;
        if (this.checkIfProductDateIsFormat1(string)) {
            int n2;
            string3 = string.substring(0, 2);
            string2 = string.substring(3, 5);
            try {
                n2 = Integer.parseInt(string3);
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return false;
            }
            if (n2 > 6 || n2 == 6 && n >= 42) {
                return true;
            }
        }
        if (this.checkIfProductDateIsFormat2(string)) {
            int n3;
            int n4;
            string3 = string.substring(0, 4);
            string2 = string.substring(4, 6);
            String string4 = string.substring(6, 8);
            try {
                n = Integer.parseInt(string3);
                n4 = Integer.parseInt(string2);
                n3 = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                return false;
            }
            if (n > 2006) {
                return true;
            }
            if (n == 2006) {
                if (n4 > 10) {
                    return true;
                }
                if (n3 > 17) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkIfProductDateIsSet(String string) {
        return string != null && !string.equals("");
    }

    private boolean checkIfProductDateIsFormat1(String string) {
        if (string.length() == 5) {
            try {
                String string2 = string.substring(0, 2);
                String string3 = string.substring(3, 5);
                Integer.parseInt(string2);
                Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                BemLog.log(7, "checkifProductDateIsFormat1()", numberFormatException);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkIfProductDateIsFormat2(String string) {
        if (string.length() == 8) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                BemLog.log(7, "checkIfProductDateIsFormat2()", numberFormatException);
                return false;
            }
            return true;
        }
        return false;
    }

    private void createGpb() throws BemException {
        String string = this.getLdn();
        this.createMoIfNotExisting(string);
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.getLdn());
    }
}

