/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CellAndCarrierDomain;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CellAndCarrierManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CustomParaName;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.NuOfTxBranchesPerCarrierListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.SectorAndCellNumber;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.SectorInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.BasebandPoolIdParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.NuOfTxBranchesParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.NumOfRxBranchesParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.SteerHsAllocationParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.UseCellParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.resource.CarrierRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.resource.NodeBFunctionRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.resource.RbsLocalCellRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.resource.SteeredHsAllocationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.HsdpaResourcesListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.HsdpaResourcesProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.SectorInitialisationRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsLocalCell;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class CellAndCarrierCI
extends AbstractConfigurationItem
implements CustomerParameterListener,
CellAndCarrierProvider {
    public static final int MAX_CELLS_WITH_SAME_HSCODERESOURCEID = 6;
    public static final String name = "CellAndCarrierCI";
    private boolean isOpen;
    protected int maxNoOfSectors;
    protected int maxNoOfCarriers;
    private ArrayList listeners = new ArrayList();
    private Vector[] uninitiateSectorVector;
    private Vector[] initiateSectorVector;
    private SectorAndCellNumber[][] sectorAndCellNumber;
    private CellAndCarrierDomainImpl[][] cellAndCarrierDomain;
    protected SectorInfo[] sectorInfo;
    protected SectorInitialisationRI[] sectorInitialisationRI;
    protected SteeredHsAllocationRI steeredHsAllocationRI;
    protected NodeBFunctionRI nodeBFunctionRI;
    protected SteerHsAllocationParameter steerHsAllocationParameter;
    protected NuOfTxBranchesParameter nuOfTxBranchesParameter;
    protected int startingSectorNumber;
    protected RadioEquipmentProvider radioEP;
    protected HsdpaResourcesProvider hsdpaResourcesProvider;
    protected SectorChangedListener sectorChangedListener;
    private int[] sumOfHsCodeResources;
    boolean needSymmetricalCheck = false;
    private ParameterRestriction steeredHsAllocationIgnoredRestriction;
    private int MAX_NO_OF_CELLS = 12;
    protected CustomParaName customerParameterNames;
    protected UseCellParameter useCellParameter;
    private int MAX_NO_OF_PSISECTORS = 2;
    private int FOUR_RXBRANCHES = 4;
    private int SIX_RXBRANCHES = 6;
    private int TWO_RXBRANCHES = 2;
    private int MAX_SINGLE_BAND_VALUE_SIZE = 1;

    public CellAndCarrierCI(Rbs rbs) {
        this(rbs, 1);
    }

    public CellAndCarrierCI(Rbs rbs, int n) {
        super(rbs);
        this.maxNoOfSectors = rbs.isPantherHybridRbs() ? rbs.getMaxNumberOfSectors() / 2 : rbs.getMaxNumberOfSectors();
        this.maxNoOfCarriers = rbs.getMaxNumberOfCarriers();
        this.startingSectorNumber = n;
        this.isOpen = false;
        this.initializeCI();
    }

    public CellAndCarrierCI(Rbs rbs, boolean bl) {
        this(rbs, 1);
        this.needSymmetricalCheck = bl;
    }

    private void initializeCI() {
        this.sectorInfo = new SectorInfo[this.maxNoOfSectors];
        this.sectorInitialisationRI = new SectorInitialisationRI[this.maxNoOfSectors];
        this.uninitiateSectorVector = new Vector[this.maxNoOfSectors];
        this.initiateSectorVector = new Vector[this.maxNoOfSectors];
        this.initiateVectorArray();
        this.setCustomerParameterPseudoNameField();
        this.sectorAndCellNumber = this.createSectorAndCellNumber(this.maxNoOfSectors, this.maxNoOfCarriers);
        this.cellAndCarrierDomain = this.createCellAndCarrierDomain();
    }

    public SectorAndCellNumber getSectorAndCellNumber(int n, int n2) {
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        int n4 = n2 - 1;
        return this.getSectorAndCellNumberByIndex(n3, n4);
    }

    public SectorAndCellNumber getSectorAndCellNumberByIndex(int n, int n2) {
        SectorAndCellNumber sectorAndCellNumber = this.sectorAndCellNumber[n][n2];
        return sectorAndCellNumber;
    }

    private void setCustomerParameterPseudoNameField() {
        this.customerParameterNames = new CustomParaName(this.rbs, this.startingSectorNumber);
    }

    protected int getMaxNumberOfCarriers() {
        return this.maxNoOfCarriers;
    }

    private void creatSectorInfo() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            this.sectorInfo[i] = new SectorInfo(this, SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber), this.radioEP);
        }
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        boolean bl = false;
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                if (serviceValue.getValue(this.sectorAndCellNumber[i][j].useCellName) != null) {
                    bl = true;
                    continue;
                }
                if (serviceValue.getValue(this.sectorAndCellNumber[i][j].cellIdentityName) != null) {
                    bl = true;
                    continue;
                }
                if (serviceValue.getValue(this.sectorAndCellNumber[i][j].cellRangeName) == null) continue;
                bl = true;
            }
        }
        if (bl) {
            bl = this.open();
        }
        return bl;
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            return this.isOpen;
        }
        this.radioEP = this.rbs.getRadioEquipmentProvider(this.getDuwSlotNumber());
        this.hsdpaResourcesProvider = (HsdpaResourcesProvider)this.rbs.getProvider(HsdpaResourcesProvider.class, this.getDuwSlotNumber());
        this.createAllRIs();
        this.creatSectorInfo();
        this.createCustomerParameters();
        this.initiateCustomerParameters();
        this.updateLoadedValues();
        this.allocateCarriers();
        this.setParameterRestriction();
        this.addParameterListeners();
        this.isOpen = true;
        return this.isOpen;
    }

    protected SectorAndCellNumber[][] createSectorAndCellNumber(int n, int n2) {
        SectorAndCellNumber[][] sectorAndCellNumberArray = new SectorAndCellNumber[this.maxNoOfSectors][this.maxNoOfCarriers];
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                sectorAndCellNumberArray[i][j] = new SectorAndCellNumber(SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber), j + 1, this.customerParameterNames);
            }
        }
        return sectorAndCellNumberArray;
    }

    private CellAndCarrierDomainImpl[][] createCellAndCarrierDomain() {
        CellAndCarrierDomainImpl[][] cellAndCarrierDomainImplArray = new CellAndCarrierDomainImpl[this.maxNoOfSectors][this.maxNoOfCarriers];
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                int n2 = j + 1;
                cellAndCarrierDomainImplArray[i][j] = new CellAndCarrierDomainImpl(n, n2);
            }
        }
        return cellAndCarrierDomainImplArray;
    }

    public boolean isSectorInitialised(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        boolean bl = false;
        try {
            bl = this.sectorInitialisationRI[n2].isInstalled();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public int getNumberOfCarriersInUse(int n) throws BemException {
        int n2 = 0;
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        for (int i = 0; i < this.maxNoOfCarriers; ++i) {
            SectorAndCellNumber sectorAndCellNumber = this.sectorAndCellNumber[n3][i];
            CarrierRI carrierRI = sectorAndCellNumber.carrierRI;
            if (!carrierRI.isInstalled()) continue;
            ++n2;
        }
        return n2;
    }

    public SectorAndCellNumber[] getAllEquippedItems() throws BemException {
        ArrayList<SectorAndCellNumber> arrayList = new ArrayList<SectorAndCellNumber>();
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            for (int j = 1; j <= this.maxNoOfCarriers; ++j) {
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n, j);
                if (!sectorAndCellNumber.useCellParameter.getValue().equals("YES")) continue;
                arrayList.add(sectorAndCellNumber);
            }
        }
        return arrayList.toArray(new SectorAndCellNumber[0]);
    }

    protected int getDuwSlotNumber() {
        if (this.rbs.isPantherHybridRbs() && this.startingSectorNumber == 7) {
            return 1;
        }
        return 0;
    }

    public int getNumberOfCellsInSector(int n) throws CustomerParameterException, BemException {
        int n2 = 0;
        if (this.sectorInfo[n].sectorIsEquipped()) {
            for (int i = 0; i < this.maxNoOfCarriers; ++i) {
                if (!this.sectorAndCellNumber[n][i].useCellParameter.getValue().equals("YES")) continue;
                ++n2;
            }
        }
        return n2;
    }

    public void createAllRIs() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                this.sectorAndCellNumber[i][j].carrierRI = new CarrierRI(this.rbs, SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber), j + 1, this.customerParameterNames);
                this.sectorAndCellNumber[i][j].rbsLocalCellRI = new RbsLocalCellRI(this.rbs, SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber), j + 1, this.customerParameterNames);
                if (!this.sectorAndCellNumber[i][j].carrierRI.isInstalled()) continue;
                this.sectorAndCellNumber[i][j].carrierRI_isInstalled = true;
            }
            this.sectorInitialisationRI[i] = new SectorInitialisationRI(this.rbs, SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber));
        }
        this.steeredHsAllocationRI = new SteeredHsAllocationRI(this.rbs);
        this.nodeBFunctionRI = new NodeBFunctionRI(this.rbs);
    }

    protected void setParameterRestriction() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            int n2 = this.radioEP.getMaxNumberOfCarriers(n);
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                if (this.sectorAndCellNumber[i][j].useCellParameter.getValue().equals("YES")) {
                    this.sectorAndCellNumber[i][j].setCellExistingRestrictionActive(false);
                } else {
                    this.sectorAndCellNumber[i][j].setCellExistingRestrictionActive(true);
                }
                if (!this.sectorInfo[i].sectorIsEquipped()) {
                    this.sectorAndCellNumber[i][j].modifyNotSupportedRestriction.setActive(false);
                    this.sectorAndCellNumber[i][j].useCellParameter.setValue("NO");
                    this.sectorAndCellNumber[i][j].setCellExistingRestrictionActive(true);
                    this.sectorAndCellNumber[i][j].notEquippedSectorRestriction.setActive(true);
                } else {
                    this.sectorAndCellNumber[i][j].notEquippedSectorRestriction.setActive(false);
                    if (this.sectorAndCellNumber[i][j].useCellParameter.getValue().equals("YES")) {
                        this.sectorAndCellNumber[i][j].cellIsNotUsedRestriction.setActive(false);
                    }
                    if (this.sectorAndCellNumber[i][j].carrierRI_isInstalled) {
                        this.sectorAndCellNumber[i][j].modifyNotSupportedRestriction.setActive(true);
                    }
                    if (!this.areCellsOffline(n) && this.radioEP.getNumberOfSupportedTxBranches(n) == 1) {
                        this.sectorAndCellNumber[i][j].notAllowedToAddCellRestriction.setActive(true);
                    } else {
                        this.sectorAndCellNumber[i][j].notAllowedToAddCellRestriction.setActive(false);
                    }
                }
                if (n2 < j + 1) continue;
                this.sectorAndCellNumber[i][j].setCarrierIsInSupportedRange(true);
            }
        }
        this.updateSteeredHsAllocationRestriction();
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        this.configurationRuleCheck();
    }

    private void checkNumberOfCells() throws CustomerParameterException, BemException {
        int[] nArray = new int[this.maxNoOfSectors];
        int n = 0;
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n2;
            if (!this.sectorInfo[i].sectorIsEquipped()) continue;
            for (n2 = 0; n2 < this.maxNoOfCarriers; ++n2) {
                if (!this.sectorAndCellNumber[i][n2].useCellParameter.getValue().equals("YES")) continue;
                int n3 = i;
                nArray[n3] = nArray[n3] + 1;
            }
            n += nArray[i];
            n2 = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            int n4 = this.radioEP.getMinNumberOfCarriers(n2);
            if (nArray[i] > 0 && nArray[i] < n4) {
                throw new CustomerParameterException("A minimum of " + n4 + " cells are allowed in Sector " + n2 + ", please configure more cells", this.sectorAndCellNumber[i][0].useCellParameter);
            }
            if (nArray[i] <= this.radioEP.getMaxNumberOfCarriers(n2)) continue;
            throw new CustomerParameterException("A maximum of " + this.radioEP.getMaxNumberOfCarriers(n2) + " cell(s) are allowed in Sector " + n2 + " according to selected Radio Building Block.\nPlease configure fewer cells.", this.sectorAndCellNumber[i][nArray[i] - 1].useCellParameter);
        }
        if (!DuwUtil.hasDuw() && n > this.MAX_NO_OF_CELLS) {
            throw new BemException("The total number of Cells = " + n + " is more than the maximum = " + this.MAX_NO_OF_CELLS);
        }
    }

    private boolean isNotSymmetrical() {
        int n;
        int n2;
        int[] nArray = new int[this.maxNoOfSectors];
        int n3 = 0;
        for (n2 = 0; n2 < this.maxNoOfSectors; ++n2) {
            if (!this.sectorInfo[n2].sectorIsEquipped()) continue;
            for (n = 0; n < this.maxNoOfCarriers; ++n) {
                if (!this.sectorAndCellNumber[n2][n].useCellParameter.getValue().equals("YES")) continue;
                int n4 = n2;
                nArray[n4] = nArray[n4] + 1;
            }
        }
        for (n2 = 0; n2 < this.maxNoOfSectors; ++n2) {
            if (nArray[n2] == 0) continue;
            n3 = nArray[n2];
            for (n = SectorUtil.getSectorNumberFromSectorIndex(n2, this.startingSectorNumber); n < this.maxNoOfSectors; ++n) {
                if (nArray[n] == 0 || nArray[n] == n3) continue;
                return true;
            }
            break;
        }
        return false;
    }

    public void checkConsistency(List list) throws CustomerParameterException, BemException {
        super.checkConsistency(list);
        this.configurationRuleCheck();
    }

    protected void configurationRuleCheck() throws CustomerParameterException, BemException {
        String string = this.rbs.getRbsStep();
        if (string.equals("STEP_SITE")) {
            this.checkNumberOfCells();
        }
        if (this.getRbs().isParameterSupported("carrierAllocationMode") && this.getRbs().getCustomerParameter("carrierAllocationMode") != null && this.getRbs().getCustomerParameter("carrierAllocationMode").equals("Flexible")) {
            this.checkCellIdUniqueForEachSector();
        } else {
            this.checkCellIdUnique();
        }
        this.checkNuOfTxBranches();
        this.checkNumOfRxBranches();
        this.checkTxDivForConfigurationGroup();
        this.checkHsCodeResourceIdRule();
        this.checkOperatingBand();
        if (this.needSymmetricalCheck && this.isNotSymmetrical()) {
            String string2 = "The number of cells in different sector is not the same,\nCell configuration is not symmetrical! ";
            throw new BemException(string2);
        }
    }

    protected void checkHsCodeResourceIdRule() throws BemException {
        this.updateNumHsCodeResources();
        int n = this.radioEP.getNumberOfDuwSlots();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            Vector[] vectorArray = new Vector[this.sumOfHsCodeResources[i]];
            for (n3 = 0; n3 < vectorArray.length; ++n3) {
                vectorArray[n3] = new Vector();
            }
            if (DuwUtil.hasDuw()) {
                for (n3 = 0; n3 < this.maxNoOfSectors; ++n3) {
                    for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                        if (!this.rbs.isPantherHybridRbs() && DuwUtil.hasDualDuws() && j % 2 != i) continue;
                        String string = this.sectorAndCellNumber[n3][j].hsCodeResourceIdParameter.getValue();
                        for (n2 = 0; n2 < this.sumOfHsCodeResources[i]; ++n2) {
                            if (Integer.parseInt(string) != n2 + 1) continue;
                            vectorArray[n2].add(string);
                            if (vectorArray[n2].size() <= 6) continue;
                            throw new CustomerParameterException("There are more than 6 same HsCodeResourceId on Value:" + string, this.sectorAndCellNumber[n3][j].hsCodeResourceIdParameter);
                        }
                    }
                }
                continue;
            }
            int[][] nArrayArray = new int[n][];
            int[] nArray = this.radioEP.getEquippedSectors(i);
            for (int j = 0; j < nArray.length; ++j) {
                n2 = nArray[j];
                nArrayArray[i] = this.radioEP.getCarriersInSector(i, n2);
                if (nArrayArray[i] == null) continue;
                for (int k = 0; k < nArrayArray[i].length; ++k) {
                    int n4 = nArrayArray[i][k];
                    SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n2, n4);
                    String string = sectorAndCellNumber.hsCodeResourceIdParameter.getValue();
                    for (int i2 = 0; i2 < this.sumOfHsCodeResources[i]; ++i2) {
                        if (Integer.parseInt(string) != i2 + 1) continue;
                        vectorArray[i2].add(string);
                        if (vectorArray[i2].size() <= 6) continue;
                        throw new CustomerParameterException("There are more than 6 same HsCodeResourceId on Value:" + string, sectorAndCellNumber.hsCodeResourceIdParameter);
                    }
                }
            }
        }
    }

    protected void checkCellIdUnique() throws CustomerParameterException {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                String string = this.sectorAndCellNumber[i][j].cellIdentityParameter.getValue();
                boolean bl = this.sectorAndCellNumber[i][j].carrerIsAllocated;
                boolean bl2 = this.sectorAndCellNumber[i][j].useCellParameter.getValue().equals("YES");
                if (!bl || !bl2) continue;
                if (vector.contains(string)) {
                    throw new CustomerParameterException(" Cell Id: " + string + " is not unique ! " + " Sector=" + SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber) + "; Cell=" + (j + 1), this.sectorAndCellNumber[i][j].cellIdentityParameter);
                }
                if (string == null || string.equals("##UNDEFINED")) continue;
                vector.add(string);
            }
        }
    }

    private void checkCellIdUniqueForEachSector() throws CustomerParameterException {
        int n;
        Vector[] vectorArray = new Vector[this.maxNoOfSectors];
        for (n = 0; n < this.maxNoOfSectors; ++n) {
            vectorArray[n] = new Vector();
        }
        for (n = 0; n < this.maxNoOfSectors; ++n) {
            for (int i = 0; i < this.maxNoOfCarriers; ++i) {
                String string = this.sectorAndCellNumber[n][i].cellIdentityParameter.getValue();
                boolean bl = this.sectorAndCellNumber[n][i].carrerIsAllocated;
                boolean bl2 = this.sectorAndCellNumber[n][i].useCellParameter.getValue().equals("YES");
                if (!bl || !bl2) continue;
                if (vectorArray[n].contains(string)) {
                    throw new CustomerParameterException(" Cell Id: " + string + " is not unique ! " + " Sector=" + SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber) + "; Cell=" + (i + 1), this.sectorAndCellNumber[n][i].cellIdentityParameter);
                }
                if (string == null || string.equals("##UNDEFINED")) continue;
                vectorArray[n].add(string);
            }
        }
    }

    protected void checkNuOfTxBranches() throws CustomerParameterException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            if (!this.sectorInfo[i].sectorIsEquipped()) continue;
            int n2 = this.radioEP.getNumberOfSupportedTxBranches(n);
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                boolean bl = this.sectorAndCellNumber[i][j].carrerIsAllocated;
                boolean bl2 = this.sectorAndCellNumber[i][j].useCellParameter.getBooleanValue();
                if (!bl || !bl2) continue;
                int n3 = this.sectorAndCellNumber[i][j].getNuOfTxBranchesPerCarrierParameter().getValueAsInt();
                if (n3 > n2) {
                    throw new CustomerParameterException("Sector=" + n + " Cell=" + (j + 1) + ". Number of Tx Branches can not be higher than value specified by radio building block.", this.sectorAndCellNumber[i][j].getNuOfTxBranchesPerCarrierParameter());
                }
                if (n3 != 1) continue;
                this.isBuildingBlockValueValid(n, j + 1);
            }
        }
    }

    protected void checkNumOfRxBranches() throws BemException {
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            if (!this.isSectorEquipped(i)) continue;
            int n4 = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            object = this.getSectorType(n4);
            n += object[0];
            n2 += object[1];
            n3 += object[2];
        }
        if (n + n2 > this.MAX_NO_OF_PSISECTORS) {
            throw new BemException("More PSI sectors(max " + this.MAX_NO_OF_PSISECTORS + " PSI sectors) in one node");
        }
        if ((n > 0 && n2 > 0 || n > 0 && n3 > 0 || n2 > 0 && n3 > 0) && !this.rbs.getCustomerParameter("carrierAllocationMode").equals("Flexible")) {
            throw new BemException("Additional PSI configuration,carrierAllocationMode must be Flexible");
        }
        if ((n >= 1 || n2 >= 1) && n3 > 0) {
            int n5;
            int n6;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            object = new ArrayList();
            for (n6 = 1; n6 <= this.maxNoOfSectors; ++n6) {
                for (n5 = 1; n5 <= this.maxNoOfCarriers; ++n5) {
                    int n7;
                    int n8 = this.getBaseBandPoolNumber(n6, n5);
                    if (n8 == -1) continue;
                    if (!object.contains(new Integer(n8))) {
                        object.add(new Integer(n8));
                        if (object.size() > 2) {
                            throw new BemException("Configurations over 3 BBP is not supported");
                        }
                    }
                    if ((n7 = this.getNumOfRxBranches(n6, n5)) == this.FOUR_RXBRANCHES || n7 == this.SIX_RXBRANCHES) {
                        if (arrayList2.contains(new Integer(n8))) continue;
                        arrayList2.add(new Integer(n8));
                        continue;
                    }
                    if (n7 != this.TWO_RXBRANCHES || arrayList.contains(new Integer(n8))) continue;
                    arrayList.add(new Integer(n8));
                }
            }
            for (n6 = 0; n6 < arrayList.size(); ++n6) {
                for (n5 = 0; n5 < arrayList2.size(); ++n5) {
                    if (((Integer)arrayList.get(n6)).intValue() != ((Integer)arrayList2.get(n5)).intValue()) continue;
                    throw new BemException("Mix of PSI and normal sector configuration in one BBP is not supported");
                }
            }
        }
    }

    private boolean isCellUsed(int n, int n2) {
        SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n, n2);
        return sectorAndCellNumber.useCellParameter.getBooleanValue();
    }

    private boolean isSectorEquipped(int n) {
        return this.sectorInfo[n].sectorIsEquipped();
    }

    private int[] getSectorType(int n) throws BemException {
        int n2;
        int n3;
        int n4;
        block11: {
            int n5;
            int n6;
            block12: {
                int[] nArray;
                n4 = 0;
                n3 = 0;
                n2 = 0;
                if (this.rbs.getRbsStep().equals("STEP_CABINET")) break block11;
                int n7 = 0;
                if (this.rbs.isPantherHybridRbs() && n >= 7) {
                    n7 = 1;
                }
                if (!BemUtil.isIntInArray(1, nArray = this.rbs.getRadioEquipmentProvider(n7).getSupportedConfiguration(n))) break block11;
                int n8 = 0;
                n6 = 0;
                n5 = 0;
                for (int i = 1; i <= this.maxNoOfCarriers; ++i) {
                    if (!this.isCellUsed(n, i)) continue;
                    int n9 = this.getNumOfRxBranches(n, i);
                    if (n9 == 0) {
                        ++n8;
                    }
                    if (n9 == this.FOUR_RXBRANCHES) {
                        ++n6;
                    }
                    if (n9 != this.SIX_RXBRANCHES) continue;
                    ++n5;
                }
                String string = MessageFormat.format("S{0}_", new Integer(n));
                String string2 = this.rbs.getCustomerParameter(string + "radioBuildingBlock");
                if (n6 > 0 && n5 > 0) {
                    throw new BemException("In one PSI sector, numOfRxBranches of all carriers should have the same one-zero value,4 or 6");
                }
                if (n8 > n6 && n5 == 0 || n8 > n5 && n6 == 0) {
                    throw new BemException("In one PSI sector, number of non-zero numOfRxBranches carriers should be equal or greater than number of zero numOfRxBranches carriers");
                }
                if (n8 + n6 > 4 && n6 > 0 || n8 + n5 > 4 && n5 > 0 || n6 > 2 || n5 > 2) {
                    throw new BemException("More PSI carriers(max 4 carriers) in one sector");
                }
                if (n5 > 1 && "RBB22_1A".equals(string2) && n5 + n8 > 3) {
                    throw new BemException("The max number of carriers for RBB22_1A with P-Coverage is 3");
                }
                if (n6 != 1 && n5 != 1) break block12;
                if ("RBB22_1A".equals(string2)) {
                    if (!this.rbs.getCustomerParameter("carrierAllocationMode").equals("Flexible")) {
                        throw new BemException("RBB22_1A can support Additional PsiCoverage, if can support legacy PSI and PSI-DC, carrierAllocationMode must be Flexible");
                    }
                }
                break block11;
            }
            if (n6 <= 1 && n5 <= 1) break block11;
            if (!this.rbs.getCustomerParameter("carrierAllocationMode").equals("Flexible")) {
                throw new BemException("If more than one PSI carrier is configured by numOfRxBranches=4 or 6,carrierAllocationMode must be Flexible");
            }
            ++n3;
        }
        return new int[]{++n4, ++n3, ++n2};
    }

    protected void checkTxDivForConfigurationGroup() throws BemException {
        String string = this.radioEP.getConfigurationGroup();
        if (this.rbs.getRbsData().isRbs6000() || string != "A6" && !this.radioEP.getCarrierAllocationMode().equals("Advanced")) {
            return;
        }
        String string2 = null;
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            String string3 = "##UNDEFINED";
            if (i == 3) {
                string2 = null;
            }
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                String string4 = this.sectorAndCellNumber[i][j].getNuOfTxBranchesPerCarrierParameter().getValue();
                boolean bl = this.sectorAndCellNumber[i][j].carrerIsAllocated;
                boolean bl2 = this.sectorAndCellNumber[i][j].useCellParameter.getValue().equals("YES");
                if (!bl || !bl2) continue;
                if (string3.equals("##UNDEFINED")) {
                    string3 = string4;
                    if (string2 == null) {
                        string2 = this.radioEP.getRbConnectorLdn(i, j);
                        continue;
                    }
                    if (string2.equals(this.radioEP.getRbConnectorLdn(i, j))) continue;
                    throw new CustomerParameterException("Can't use different base band pools when using TX diversity", this.sectorAndCellNumber[i][j].getNuOfTxBranchesPerCarrierParameter());
                }
                if (!string4.equals("2") || string != "A6") continue;
                throw new CustomerParameterException("Sector=" + SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber) + " Cell=" + (j + 1) + ". Number of TX branches can not be 2 if" + " configuration group is A6 and number of" + " carriers are more than one.", this.sectorAndCellNumber[i][j].getNuOfTxBranchesPerCarrierParameter());
            }
        }
    }

    private void isBuildingBlockValueValid(int n, int n2) throws CustomerParameterException {
        try {
            String string = MessageFormat.format("S{0}_", new Integer(n));
            String string2 = string + "radioBuildingBlock";
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
            String string3 = customerParameter.getValue();
            if (!(string3.equals("RB3") || string3.equals("RB3b") || string3.equals("RB3B") || string3.equals("RRB03") || string3.equals("RRB04"))) {
                return;
            }
            string2 = "S" + n + "_C2_" + "cellCreated";
            customerParameter = this.rbs.getCustomerParameterObject(string2);
            String string4 = customerParameter.getValue();
            if (string4.equals("YES")) {
                return;
            }
        }
        catch (BemException bemException) {
            return;
        }
        throw new CustomerParameterException("Sector=" + n + ". Number of TX branches can not be set to 1" + " if the number of carriers are incorrect.", this.sectorAndCellNumber[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)][n2].getNuOfTxBranchesPerCarrierParameter());
    }

    protected void requestUnInitiateSectorIfAddedCarriers(int n) {
        int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
        if (this.radioEP.isUniniteSectorNeeded(n2)) {
            this.requestUninitiateSector(n2, this);
            this.requestInitiateSector(n2, this);
        }
    }

    public ArrayList getNeededRIs() throws BemException {
        int n;
        int n2;
        this.checkConsistency();
        if (!this.isOpen) {
            throw new BemException("CellAndCarrierCI is not open.");
        }
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        for (n2 = 0; n2 < this.maxNoOfSectors; ++n2) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(n2, this.startingSectorNumber);
            for (n = 1; n <= this.maxNoOfCarriers; ++n) {
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n3, n);
                boolean bl = false;
                String string = sectorAndCellNumber.useCellParameter.getValue();
                if (string.equals("YES") && this.sectorInfo[n2].sectorIsEquipped() && (!sectorAndCellNumber.carrierRI.isInstalled() || sectorAndCellNumber.getNumOfRxBranchesPerCarrierParameter().hasValueChanged())) {
                    arrayList.add(sectorAndCellNumber.carrierRI);
                    bl = true;
                }
                if (string.equals("YES") && sectorAndCellNumber.useCellParameter.hasValueChanged()) {
                    this.requestInitiateSector(n3, this);
                }
                if (!bl && sectorAndCellNumber.carrierRI.isInstalled() && sectorAndCellNumber.getNuOfTxBranchesPerCarrierParameter().hasValueChanged()) {
                    arrayList.add(sectorAndCellNumber.carrierRI);
                    if (!this.isSectorInitiateRequested(n3)) {
                        this.requestInitiateSector(n3, this);
                    }
                }
                if (!string.equals("YES") || !this.sectorInfo[n2].sectorIsEquipped() || sectorAndCellNumber.rbsLocalCellRI.getRbsLocalCellMo().isExisting() && !sectorAndCellNumber.rbsLocalCellRI.checkIfCarriersRefChanged() && !sectorAndCellNumber.hsCodeResourceIdParameter.hasValueChanged()) continue;
                arrayList.add(sectorAndCellNumber.rbsLocalCellRI);
            }
        }
        for (n2 = 0; n2 < this.initiateSectorVector.length; ++n2) {
            Iterator iterator = this.initiateSectorVector[n2].iterator();
            n = SectorUtil.getSectorNumberFromSectorIndex(n2, this.startingSectorNumber);
            while (iterator.hasNext()) {
                iterator.next();
                if (!this.isSectorInUse(n)) continue;
                arrayList.add(this.sectorInitialisationRI[n2]);
            }
        }
        if (this.steerHsAllocationParameter.getValue().equals("TRUE") || this.steerHsAllocationParameter.hasValueChanged()) {
            arrayList.add(this.steeredHsAllocationRI);
        }
        return arrayList;
    }

    private void requestUnintiateSectorIfNeeded() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                String string = this.sectorAndCellNumber[i][j].useCellParameter.getValue();
                if (!string.equals("YES") || this.sectorAndCellNumber[i][j].carrierRI.isInstalled() || !this.sectorInfo[i].sectorIsEquipped()) continue;
                this.requestUnInitiateSectorIfAddedCarriers(i);
            }
        }
    }

    public List getRIsToUninstall() throws BemException {
        int n;
        int n2;
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        for (n2 = 0; n2 < this.maxNoOfSectors; ++n2) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(n2, this.startingSectorNumber);
            if (this.sectorInfo[n2].sectorToBeDeleted()) {
                this.requestUninitiateSector(n3, this);
                for (n = 0; n < this.maxNoOfCarriers; ++n) {
                    if (!this.sectorAndCellNumber[n2][n].carrierRI_isInstalled) continue;
                    arrayList.add(this.sectorAndCellNumber[n2][n].carrierRI);
                    arrayList.add(this.sectorAndCellNumber[n2][n].rbsLocalCellRI);
                }
            } else if (this.radioEP.isSectorUninstalledBeforeAddCarrier(n2)) {
                this.requestUninitiateSector(n3, this);
            }
            for (n = 1; n <= this.maxNoOfCarriers; ++n) {
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n3, n);
                if (!sectorAndCellNumber.useCellParameter.getValue().equals("YES") || !this.sectorInfo[n2].sectorIsEquipped() || !sectorAndCellNumber.carrierRI.isInstalled() || !sectorAndCellNumber.getTxBranchConfiguredParameter().hasValueChanged() && !sectorAndCellNumber.getTxBranchConfiguredParameter2().hasValueChanged()) continue;
                arrayList.add(sectorAndCellNumber.carrierRI);
                arrayList.add(sectorAndCellNumber.rbsLocalCellRI);
            }
        }
        this.requestUnintiateSectorIfNeeded();
        for (n2 = 0; n2 < this.uninitiateSectorVector.length; ++n2) {
            Iterator iterator = this.uninitiateSectorVector[n2].iterator();
            if (!iterator.hasNext()) continue;
            arrayList.add(this.sectorInitialisationRI[n2]);
            if (!this.isDeleteCellAndCarrierNeeded(n2)) continue;
            for (n = 0; n < this.maxNoOfCarriers; ++n) {
                if (!this.sectorAndCellNumber[n2][n].carrierRI_isInstalled) continue;
                arrayList.add(this.sectorAndCellNumber[n2][n].carrierRI);
                arrayList.add(this.sectorAndCellNumber[n2][n].rbsLocalCellRI);
            }
        }
        return arrayList;
    }

    private void allocateCarrierInSector(SectorInfo sectorInfo) throws BemException {
        int n;
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(sectorInfo.sectorNumber, this.startingSectorNumber);
        for (n = 0; n < this.maxNoOfCarriers; ++n) {
            if (!this.sectorAndCellNumber[n2][n].carrerIsAllocated && this.sectorAndCellNumber[n2][n].carrierRI_isInstalled) {
                this.sectorAndCellNumber[n2][n].carrerIsAllocated = true;
                ++sectorInfo.numberOfcarrierAllocated;
                if (sectorInfo.carrierAvailable()) continue;
                break;
            }
            if (this.sectorAndCellNumber[n2][n].carrerIsAllocated || this.sectorAndCellNumber[n2][n].carrierRI_isInstalled) continue;
            this.sectorAndCellNumber[n2][n].carrerIsAllocated = true;
            ++sectorInfo.numberOfcarrierAllocated;
            if (!sectorInfo.carrierAvailable()) break;
        }
        if (sectorInfo.carrierToBeDeleted()) {
            for (n = 0; n < this.maxNoOfCarriers; ++n) {
                this.sectorAndCellNumber[n2][n].deleteCarrierNotSupportedRestriction.setActive(true);
            }
        }
    }

    private void reAllocateCarrierInSector(SectorInfo sectorInfo) throws BemException {
        int n = SectorUtil.getSectorIndexFromSectorNumber(sectorInfo.sectorNumber, this.startingSectorNumber);
        if (sectorInfo.sectorToBeDeleted()) {
            for (int i = 0; i < this.maxNoOfCarriers; ++i) {
                if (!this.sectorAndCellNumber[n][i].carrierRI_isInstalled) continue;
                this.sectorAndCellNumber[n][i].unInstallCarrierRINeeded = true;
            }
        } else if (sectorInfo.sectorIsEquipped()) {
            this.allocateCarrierInSector(sectorInfo);
        }
    }

    private void allocateCarriers() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            if (!this.sectorInfo[i].sectorIsEquipped()) continue;
            this.allocateCarrierInSector(this.sectorInfo[i]);
        }
    }

    public String getName() {
        return name;
    }

    public ArrayList getInstalledRIs() throws BemException {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        if (!this.isOpen) {
            throw new BemException("CellAndCarrierCI is not open.");
        }
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            if (this.sectorInitialisationRI[i].isInstalled()) {
                arrayList.add(this.sectorInitialisationRI[i]);
            }
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                if (!this.sectorAndCellNumber[i][j].carrierRI.isInstalled()) continue;
                arrayList.add(this.sectorAndCellNumber[i][j].carrierRI);
            }
        }
        return arrayList;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isValueChanged()) {
            int n = 0;
            for (int i = 0; i < this.maxNoOfSectors; ++i) {
                for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                    if (!customerParameter.getName().equals(this.sectorAndCellNumber[i][j].useCellName)) continue;
                    n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                    if (this.sectorAndCellNumber[i][j].useCellParameter.getValue().equals("YES")) {
                        this.sectorAndCellNumber[i][j].cellIsNotUsedRestriction.setActive(false);
                        this.sectorAndCellNumber[i][j].setCellExistingRestrictionActive(false);
                        try {
                            if (!this.areCellsOffline(n) && this.radioEP.getNumberOfSupportedTxBranches(n) == 1) {
                                this.sectorAndCellNumber[i][j].notAllowedToAddCellRestriction.setActive(true);
                                continue;
                            }
                            if (!this.areCellsOffline(n) || this.radioEP.getNumberOfSupportedTxBranches(n) != 1) continue;
                            this.sectorAndCellNumber[i][j].notAllowedToAddCellRestriction.setActive(false);
                        }
                        catch (BemException bemException) {
                            System.err.println(bemException.toString());
                        }
                        continue;
                    }
                    n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                    this.sectorAndCellNumber[i][j].cellIsNotUsedRestriction.setActive(true);
                    this.sectorAndCellNumber[i][j].setCellExistingRestrictionActive(true);
                }
            }
            this.notifyAllListeners(n);
        }
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                int n2 = j + 1;
                String[] stringArray = new String[]{this.customerParameterNames.getCellIdentityName(n, n2), this.customerParameterNames.getCellRangePseudoName(n, n2), this.customerParameterNames.getUseCellPseudoName(n, n2), this.customerParameterNames.getHsCodeResourceIdPseudoName(n, n2), this.customerParameterNames.getNuOfTxBranchesPseudoName(n, n2), this.customerParameterNames.getNumOfRxBranchesPseudoName(n, n2), this.customerParameterNames.getNuOfTxBranchesPseudoName(n, n2), this.customerParameterNames.getBasebandPoolIdPseudoName(n, n2), this.customerParameterNames.getTxBranchConfiguredPseudoName(n, n2), this.customerParameterNames.getTxBranchConfigured2PseudoName(n, n2), this.customerParameterNames.getOperatingBandPseudoName(n, n2)};
                String string = serviceValue.getValue(this.customerParameterNames.getCellIdentityName(n, n2));
                String string2 = serviceValue.getValue(this.customerParameterNames.getCellRangePseudoName(n, n2));
                String string3 = serviceValue.getValue(this.customerParameterNames.getUseCellPseudoName(n, n2));
                String string4 = serviceValue.getValue(this.customerParameterNames.getHsCodeResourceIdPseudoName(n, n2));
                String string5 = serviceValue.getValue(this.customerParameterNames.getNuOfTxBranchesPseudoName(n, n2));
                String string6 = serviceValue.getValue(this.customerParameterNames.getNumOfRxBranchesPseudoName(n, n2));
                String string7 = serviceValue.getValue(this.customerParameterNames.getTxBranchConfiguredPseudoName(n, n2));
                String string8 = serviceValue.getValue(this.customerParameterNames.getTxBranchConfigured2PseudoName(n, n2));
                String string9 = serviceValue.getValue(this.customerParameterNames.getOperatingBandPseudoName(n, n2));
                if (string3 == null && string == null && string2 == null && string4 == null && string5 == null && string6 == null && string7 == null && string8 == null && string9 == null || !this.sectorInfo[i].sectorIsEquipped()) continue;
                super.setCustomerParametersFromSV(stringArray, serviceValue);
            }
        }
        this.setSingleBandValue();
        this.setSteeredHsAllocationParameterFromSV(serviceValue);
        CellAndCarrierManager.updateInteractionBetweenCarrierRIAndRbsLocalCellRI(this);
    }

    private void setSteeredHsAllocationParameterFromSV(ServiceValue serviceValue) throws BemException {
        String[] stringArray = new String[]{"steeredHsAllocation"};
        String string = serviceValue.getValue("steeredHsAllocation");
        if (string != null) {
            super.setCustomerParametersFromSV(stringArray, serviceValue);
        }
    }

    protected void checkOperatingBand() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            if (!this.sectorInfo[i].sectorIsEquipped()) continue;
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                int n2 = j + 1;
                if (!this.isCellUsed(n, n2) || this.getOperatingBandMap(i).size() == this.MAX_SINGLE_BAND_VALUE_SIZE) continue;
                throw new BemException("The operatingBand parameter must be configured with the same value for all cells in Sector  " + n);
            }
        }
    }

    protected HashMap getOperatingBandMap(int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "";
        int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
        if (this.sectorInfo[n].sectorIsEquipped()) {
            for (int i = 0; i < this.maxNoOfCarriers; ++i) {
                SectorAndCellNumber sectorAndCellNumber;
                int n3 = i + 1;
                if (!this.isCellUsed(n2, n3) || (string = (sectorAndCellNumber = this.getSectorAndCellNumber(n2, n3)).getOperatingBandParameter().getValue()).equalsIgnoreCase("##UNDEFINED")) continue;
                hashMap.put(string, String.valueOf(n));
            }
        }
        return hashMap;
    }

    public String getSingleBandCpName(int n) {
        String string = "";
        int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
        for (int i = 0; i < this.maxNoOfCarriers; ++i) {
            int n3 = i + 1;
            if (!this.isCellUsed(n2, n3)) continue;
            String string2 = MessageFormat.format("S{0}_", new Integer(n2));
            String string3 = MessageFormat.format("C{0}_", new Integer(n3));
            string = string2 + string3 + "operatingBand";
            return string;
        }
        return string;
    }

    protected void setSingleBandValue() {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            if (!this.isSingleBand(i) || !this.sectorInfo[i].sectorIsEquipped()) continue;
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                int n2 = j + 1;
                if (!this.isCellUsed(n, n2)) continue;
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n, n2);
                String string = this.getSingleBandValue(i);
                sectorAndCellNumber.getOperatingBandParameter().setValue(string);
            }
        }
    }

    public boolean isSingleBand(int n) {
        HashMap hashMap = new HashMap();
        hashMap = this.getOperatingBandMap(n);
        return hashMap.size() == this.MAX_SINGLE_BAND_VALUE_SIZE;
    }

    public String getSingleBandValue(int n) {
        int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
        String string = "";
        if (this.sectorInfo[n].sectorIsEquipped()) {
            for (int i = 0; i < this.maxNoOfCarriers; ++i) {
                int n3 = i + 1;
                if (!this.isCellUsed(n2, n3)) continue;
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n2, n3);
                string = sectorAndCellNumber.getOperatingBandParameter().getValue();
                return string;
            }
        }
        return string;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public int getMaxNoOfSectors() {
        return this.maxNoOfSectors;
    }

    public void createCustomerParameters() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            for (int j = 1; j <= this.maxNoOfCarriers; ++j) {
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n, j);
                sectorAndCellNumber.createCustomerParameters(this.getRbs(), this.radioEP);
                this.addParameter(sectorAndCellNumber.useCellParameter);
                this.addParameter(sectorAndCellNumber.cellIdentityParameter);
                this.addParameter(sectorAndCellNumber.cellRangeParameter);
                this.addParameter(sectorAndCellNumber.hsCodeResourceIdParameter);
                this.addParameter(sectorAndCellNumber.getNuOfTxBranchesPerCarrierParameter());
                this.addParameter(sectorAndCellNumber.getNumOfRxBranchesPerCarrierParameter());
                this.addParameter(sectorAndCellNumber.basebandPoolIdParameter);
                this.addParameter(sectorAndCellNumber.txBranchConfiguredParameter);
                this.addParameter(sectorAndCellNumber.txBranchConfiguredParameter2);
                this.addParameter(sectorAndCellNumber.getOperatingBandParameter());
            }
        }
        if (this.rbs.isPantherHybridRbs() && this.startingSectorNumber == 7 && this.rbs.getCustomerParameterObject("steeredHsAllocation") != null) {
            this.steerHsAllocationParameter = (SteerHsAllocationParameter)this.rbs.getCustomerParameterObject("steeredHsAllocation");
        } else {
            this.steerHsAllocationParameter = new SteerHsAllocationParameter("steeredHsAllocation");
            this.addParameter(this.steerHsAllocationParameter);
        }
        this.useCellParameter = new UseCellParameter("Create cell");
    }

    private void addParameterListeners() throws BemException {
        this.addUseCellParameterListeners(this);
        this.addNuOfTxBranchesListeners(this.sectorInitialisationRI, this.maxNoOfSectors, this.maxNoOfCarriers);
        this.steerHsAllocationParameter.addCustomerParameterListener(new SteeredHsAllocationListener());
        this.registerRadioEquipmentListener(this.radioEP);
        NumHsCodeResourcesListener numHsCodeResourcesListener = new NumHsCodeResourcesListener();
        this.hsdpaResourcesProvider.addListener(numHsCodeResourcesListener);
    }

    protected void registerRadioEquipmentListener(RadioEquipmentProvider radioEquipmentProvider) throws BemException {
        SectorChangedListener sectorChangedListener = new SectorChangedListener();
        this.addRadioEquipmentListener(sectorChangedListener);
    }

    protected void addRadioEquipmentListener(SectorChangedListener sectorChangedListener) {
        this.radioEP.addListener(sectorChangedListener);
    }

    public void addUseCellParameterListeners(CustomerParameterListener customerParameterListener) {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                this.sectorAndCellNumber[i][j].useCellParameter.addCustomerParameterListener(customerParameterListener);
            }
        }
    }

    protected void addNuOfTxBranchesListeners(SectorInitialisationRI[] sectorInitialisationRIArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                NuOfTxBranchesPerCarrierListener nuOfTxBranchesPerCarrierListener = new NuOfTxBranchesPerCarrierListener(SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber), this, sectorInitialisationRIArray[i]);
                this.sectorAndCellNumber[i][j].getNuOfTxBranchesPerCarrierParameter().addCustomerParameterListener(nuOfTxBranchesPerCarrierListener);
            }
        }
    }

    private void initiateCustomerParameters() throws BemException {
        this.setParameterDefaultValues();
        this.initiateCustomerParameterRestrictions();
    }

    private void initiateCustomerParameterRestrictions() {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                this.sectorAndCellNumber[i][j].initializeCustomerParameterRestrictions();
            }
        }
        this.initiateSteeredHsAllocationRestriction();
    }

    private void initiateSteeredHsAllocationRestriction() {
        this.steeredHsAllocationIgnoredRestriction = new ParameterRestriction("steeredHsAllocation ignored", 1);
        this.steeredHsAllocationIgnoredRestriction.setActive(false);
        this.steerHsAllocationParameter.addRestriction(this.steeredHsAllocationIgnoredRestriction);
    }

    private void setParameterDefaultValues() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            for (int j = 1; j <= this.maxNoOfCarriers; ++j) {
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n, j);
                sectorAndCellNumber.useCellParameter.setDefaultValue("NO");
                sectorAndCellNumber.cellRangeParameter.setDefaultValue(MimRbsLocalCell.DEFAULT_CELLRANGE.toString());
                sectorAndCellNumber.hsCodeResourceIdParameter.setDefaultValue(MimRbsLocalCell.DEFAULT_HSCODERESOURCEID.toString());
                sectorAndCellNumber.getNuOfTxBranchesPerCarrierParameter().setDefaultValue();
                sectorAndCellNumber.getNumOfRxBranchesPerCarrierParameter().setDefaultValue();
                sectorAndCellNumber.txBranchConfiguredParameter.setDefaultValue("S");
                sectorAndCellNumber.txBranchConfiguredParameter2.setDefaultValue("S");
                if (this.rbs.isModifyWiz()) continue;
                sectorAndCellNumber.getOperatingBandParameter().setDefaultValue();
            }
        }
        this.steerHsAllocationParameter.setDefaultValue("FALSE");
    }

    public void updateLoadedValues() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            for (int j = 1; j <= this.maxNoOfCarriers; ++j) {
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n, j);
                sectorAndCellNumber.rbsLocalCellRI.getLoadedValue();
                if (sectorAndCellNumber.carrierRI.isInstalled()) {
                    sectorAndCellNumber.carrierRI_isInstalled = true;
                    sectorAndCellNumber.carrierRI.getNodeValues();
                    continue;
                }
                sectorAndCellNumber.useCellParameter.setLoadedValue("NO");
                sectorAndCellNumber.cellIdentityParameter.setLoadedValue("##UNDEFINED");
                sectorAndCellNumber.cellRangeParameter.setLoadedValue("##UNDEFINED");
                sectorAndCellNumber.hsCodeResourceIdParameter.setLoadedValue("##UNDEFINED");
                sectorAndCellNumber.getNuOfTxBranchesPerCarrierParameter().setDefaultValue();
                sectorAndCellNumber.getNumOfRxBranchesPerCarrierParameter().setDefaultValue();
                sectorAndCellNumber.txBranchConfiguredParameter.setLoadedValue(Integer.toString(0));
                sectorAndCellNumber.txBranchConfiguredParameter2.setLoadedValue(Integer.toString(0));
            }
        }
        this.updateSteerHsAllocationLoadedValue();
        CellAndCarrierManager.updateInteractionBetweenCarrierRIAndRbsLocalCellRI(this);
    }

    private void updateSteerHsAllocationLoadedValue() throws BemException {
        if (this.steeredHsAllocationRI.isInstalled()) {
            String string = this.steeredHsAllocationRI.getSteeredHsAllocation();
            this.steerHsAllocationParameter.setLoadedValue(string);
        } else {
            this.steerHsAllocationParameter.setLoadedValue("FALSE");
        }
    }

    private void initiateVectorArray() {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            this.uninitiateSectorVector[i] = new Vector();
            this.initiateSectorVector[i] = new Vector();
        }
    }

    public void requestUninitiateSector(int n, Object object) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (!this.uninitiateSectorVector[n2].contains(object)) {
            this.uninitiateSectorVector[n2].add(object);
        }
    }

    public void cancelUninitiateSector(int n, Object object) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (this.uninitiateSectorVector[n2].contains(object)) {
            this.uninitiateSectorVector[n2].remove(object);
        }
    }

    public boolean isSectorUninitiateRequested(int n) {
        boolean bl = false;
        Vector vector = null;
        try {
            vector = this.uninitiateSectorVector[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)];
            Object e = vector.firstElement();
            if (e != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private boolean isSectorInitiateRequested(int n) {
        boolean bl = false;
        Vector vector = null;
        try {
            vector = this.initiateSectorVector[SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber)];
            Object e = vector.firstElement();
            if (e != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void requestInitiateSector(int n, Object object) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (!this.initiateSectorVector[n2].contains(object)) {
            this.initiateSectorVector[n2].add(object);
        }
    }

    public void cancelInitiateSector(int n, Object object) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (this.initiateSectorVector[n2].contains(object)) {
            this.initiateSectorVector[n2].remove(object);
        }
    }

    public void notifyAllListeners(int n) {
        Iterator iterator = this.listeners.iterator();
        if (iterator.hasNext()) {
            CellAndCarrierListener cellAndCarrierListener = (CellAndCarrierListener)iterator.next();
            cellAndCarrierListener.update(n);
        }
    }

    public void addCellAndCarrierListener(CellAndCarrierListener cellAndCarrierListener) {
        this.listeners.add(cellAndCarrierListener);
    }

    public boolean isSectorInUse(int n) {
        boolean bl = false;
        for (int i = 0; i < this.maxNoOfCarriers; ++i) {
            int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            String string = this.sectorAndCellNumber[n2][i].useCellParameter.getValue();
            if (!string.equals("YES") || !this.sectorInfo[n2].sectorIsEquipped()) continue;
            bl = true;
        }
        return bl;
    }

    public boolean areCellsOffline(int n) throws BemException {
        boolean bl = true;
        for (int i = 0; i < this.maxNoOfCarriers; ++i) {
            int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            boolean bl2 = this.sectorAndCellNumber[n2][i].carrierRI.isCellOffline();
            if (bl2) continue;
            bl = false;
        }
        return bl;
    }

    public Object getObjectForTest(int n) {
        switch (n) {
            case 0: {
                return this.rbs;
            }
            case 1: {
                return this.sectorAndCellNumber;
            }
            case 2: {
                return this.sectorInitialisationRI;
            }
            case 3: {
                return this.radioEP;
            }
            case 4: {
                return this.uninitiateSectorVector;
            }
            case 5: {
                return this.sectorInfo;
            }
            case 6: {
                return this.nodeBFunctionRI;
            }
        }
        return null;
    }

    private void updateSteeredHsAllocationRestriction() throws BemException {
        if (this.isTxbStaticallyLoadedForAllBbp()) {
            this.steeredHsAllocationIgnoredRestriction.setActive(true);
        }
        int n = this.radioEP.getNumberOfDuwSlots();
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n2 = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            block1: for (int j = 1; j <= this.maxNoOfCarriers; ++j) {
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n2, j);
                if (this.steerHsAllocationParameter.getValue().equalsIgnoreCase("TRUE")) {
                    for (int k = 1; k <= n; ++k) {
                        if (!this.isCarrierLocatedInBbp(k, n2, j)) continue;
                        if (this.hsdpaResourcesProvider.isTxbStaticallyLoaded(k - 1)) {
                            sectorAndCellNumber.setHsCodeResourceIdIgnoredRestriction(true);
                            continue block1;
                        }
                        sectorAndCellNumber.setHsCodeResourceIdIgnoredRestriction(false);
                        continue block1;
                    }
                    continue;
                }
                sectorAndCellNumber.setHsCodeResourceIdIgnoredRestriction(true);
            }
        }
    }

    private boolean isTxbStaticallyLoadedForAllBbp() throws BemException {
        boolean bl;
        block2: {
            int n;
            block1: {
                n = this.radioEP.getNumberOfDuwSlots();
                bl = true;
                if (!this.rbs.isPantherHybridRbs() || this.startingSectorNumber < 7) break block1;
                if (this.hsdpaResourcesProvider.isTxbStaticallyLoaded(1)) break block2;
                bl = false;
                break block2;
            }
            for (int i = 0; i < n; ++i) {
                if (this.hsdpaResourcesProvider.isTxbStaticallyLoaded(i)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    protected void updateNumHsCodeResources() throws BemException {
        int n = 0;
        if (this.rbs.isPantherHybridRbs() && this.startingSectorNumber == 7) {
            n = 1;
        }
        if (this.sumOfHsCodeResources == null) {
            this.sumOfHsCodeResources = new int[this.radioEP.getNumberOfDuwSlots() + n];
        }
        int n2 = this.radioEP.getNumberOfDuwSlots();
        for (int i = n; i < n2 + n; ++i) {
            String[] stringArray = this.radioEP.getSlotArrayForTxDevices(i);
            this.sumOfHsCodeResources[i] = 0;
            for (int j = 0; j < stringArray.length; ++j) {
                int n3 = Integer.parseInt(stringArray[j]);
                int n4 = i;
                this.sumOfHsCodeResources[n4] = this.sumOfHsCodeResources[n4] + this.hsdpaResourcesProvider.getSumOfHsCodeResources(n3);
            }
            ParameterRange parameterRange = this.getUpdatedParameterRange(this.sumOfHsCodeResources[i]);
            int[] nArray = this.radioEP.getEquippedSectors(i);
            for (int j = 0; j < nArray.length; ++j) {
                int n5 = nArray[j];
                int[] nArray2 = this.radioEP.getCarriersInSector(i, n5);
                if (nArray2 == null) continue;
                for (int k = 0; k < nArray2.length; ++k) {
                    int n6 = nArray2[k];
                    SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n5, n6);
                    sectorAndCellNumber.hsCodeResourceIdRangeRestriction.setRange(parameterRange, true);
                }
            }
        }
    }

    protected String[] getUpdatedSupportedValues(int n) {
        String[] stringArray = new String[n + 1];
        for (int i = 0; i <= n; ++i) {
            stringArray[i] = Integer.toString(i);
        }
        return stringArray;
    }

    protected ParameterRange getUpdatedParameterRange(int n) {
        String[] stringArray = this.getUpdatedSupportedValues(n);
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        return enumeratedRange;
    }

    private void setParameterRestrictionInSector(int n) throws BemException {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        int n3 = this.radioEP.getMaxNumberOfCarriers(n);
        for (int i = 0; i < this.maxNoOfCarriers; ++i) {
            if (n3 >= i + 1) {
                this.sectorAndCellNumber[n2][i].setCarrierIsInSupportedRange(true);
            }
            if (!this.sectorInfo[n2].sectorIsEquipped()) {
                this.sectorAndCellNumber[n2][i].modifyNotSupportedRestriction.setActive(false);
                this.sectorAndCellNumber[n2][i].useCellParameter.setValue("NO");
                this.sectorAndCellNumber[n2][i].notEquippedSectorRestriction.setActive(true);
                continue;
            }
            this.sectorAndCellNumber[n2][i].notEquippedSectorRestriction.setActive(false);
            if (this.sectorAndCellNumber[n2][i].carrierRI_isInstalled) {
                this.sectorAndCellNumber[n2][i].modifyNotSupportedRestriction.setActive(true);
            }
            if (!this.areCellsOffline(n) && this.radioEP.getNumberOfSupportedTxBranches(n) == 1) {
                this.sectorAndCellNumber[n2][i].notAllowedToAddCellRestriction.setActive(true);
                continue;
            }
            this.sectorAndCellNumber[n2][i].notAllowedToAddCellRestriction.setActive(false);
        }
    }

    protected SectorInfo[] getSectorInfo() {
        return this.sectorInfo;
    }

    public int getMaxNumberOfCarriers(int n) throws BemException {
        int n2 = this.radioEP.getMaxNumberOfCarriers(n);
        return n2;
    }

    public void handleRadioListenerUpdate(int n) {
        try {
            int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            this.sectorInfo[n2].updateSectorInfo(this.radioEP);
            this.reAllocateCarrierInSector(this.sectorInfo[n2]);
            this.setParameterRestrictionInSector(n);
        }
        catch (BemException bemException) {
            Nal.getLog().nalTrace(1, this.getClass(), "Failed to handleRadioListenerUpdate ", bemException);
        }
    }

    public int getConfiguredNumberOfRxBranches(int n) {
        int n2 = Integer.parseInt("2");
        for (int i = 1; i <= this.maxNoOfCarriers; ++i) {
            SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n, i);
            if (sectorAndCellNumber == null || sectorAndCellNumber.getNumOfRxBranchesPerCarrierParameter().getValueAsInt() <= n2) continue;
            n2 = sectorAndCellNumber.getNumOfRxBranchesPerCarrierParameter().getValueAsInt();
        }
        return n2;
    }

    public int getLoadedNumberOfRxBranches(int n) {
        int n2 = Integer.parseInt("2");
        for (int i = 1; i <= this.maxNoOfCarriers; ++i) {
            SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n, i);
            if (sectorAndCellNumber == null || sectorAndCellNumber.getNumOfRxBranchesPerCarrierParameter().getLoadedValueAsInt() <= n2) continue;
            n2 = sectorAndCellNumber.getNumOfRxBranchesPerCarrierParameter().getLoadedValueAsInt();
        }
        return n2;
    }

    public CustomerParameter[] getNumOfRxBranchesPerCarrierParameter(int n) {
        CustomerParameter[] customerParameterArray = new NumOfRxBranchesParameter[this.maxNoOfCarriers];
        for (int i = 1; i <= this.maxNoOfCarriers; ++i) {
            SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n, i);
            customerParameterArray[i - 1] = sectorAndCellNumber.getNumOfRxBranchesPerCarrierParameter();
        }
        return customerParameterArray;
    }

    public CustomerParameter[] getNumOfRxBranchesPerUsedCarrierParameter(int n) {
        CustomerParameter[] customerParameterArray = new NumOfRxBranchesParameter[this.maxNoOfCarriers];
        for (int i = 1; i <= this.maxNoOfCarriers; ++i) {
            SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n, i);
            if (!sectorAndCellNumber.useCellParameter.getBooleanValue()) continue;
            customerParameterArray[i - 1] = sectorAndCellNumber.getNumOfRxBranchesPerCarrierParameter();
        }
        return customerParameterArray;
    }

    public int getNumOfRxBranches(int n, int n2) {
        SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n, n2);
        return sectorAndCellNumber.getNumOfRxBranchesPerCarrierParameter().getValueAsInt();
    }

    public void updateBaseBandPoolIds() {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            for (int j = 1; j <= this.maxNoOfCarriers; ++j) {
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n, j);
                sectorAndCellNumber.updateBaseBandPoolId();
            }
        }
    }

    public boolean isCarrierLocatedInBbp(int n, int n2, int n3) throws BemException {
        int n4;
        int n5 = n - 1;
        int n6 = n3 - 1;
        boolean bl = !DuwUtil.hasDualDuws() || this.rbs.isPantherHybridRbs() ? n == 1 : ((n4 = this.getBaseBandPoolNumber(n2, n3)) != -1 ? n == n4 : (this.radioEP.getCarrierAllocationMode().equals("Advanced") && this.radioEP.getEquippedSectors().length > 3 ? n2 < 4 && n == 1 || n2 >= 4 && n == 2 : n6 % 2 == n5));
        return bl;
    }

    public int getBaseBandPoolNumber(int n, int n2) throws BemException {
        SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n, n2);
        BasebandPoolIdParameter basebandPoolIdParameter = sectorAndCellNumber.getBasebandPoolIdRef();
        String string = basebandPoolIdParameter.getValue();
        int n3 = -1;
        if (string != null && !string.equals("##UNDEFINED") && !string.equals("")) {
            n3 = Integer.parseInt(string);
        }
        return n3;
    }

    public boolean isDeleteCellAndCarrierNeeded(int n) {
        boolean bl = this.rbs.getPositionChangeFlag();
        if (!bl && this.radioEP instanceof RadioEquipmentProviderWithRbb) {
            RadioEquipmentProviderWithRbb radioEquipmentProviderWithRbb = (RadioEquipmentProviderWithRbb)this.radioEP;
            bl = radioEquipmentProviderWithRbb.isDeleteCellAndCarrierNeededAfterModification(n);
        }
        return bl;
    }

    public CellAndCarrierDomain[][] getAllCellAndCarrierDomain() {
        CellAndCarrierDomain[][] cellAndCarrierDomainArray = null;
        cellAndCarrierDomainArray = this.cellAndCarrierDomain;
        return cellAndCarrierDomainArray;
    }

    public CellAndCarrierDomain[] getCellAndCarrierDomainForSector(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        CellAndCarrierDomain[] cellAndCarrierDomainArray = null;
        cellAndCarrierDomainArray = this.cellAndCarrierDomain[n2];
        return cellAndCarrierDomainArray;
    }

    public class CellAndCarrierDomainImpl
    implements CellAndCarrierDomain {
        private int sectorNumber;
        private int cellNumber;

        public CellAndCarrierDomainImpl(int n, int n2) {
            this.sectorNumber = n;
            this.cellNumber = n2;
        }

        public int getSectorNumber() {
            return this.sectorNumber;
        }

        public int getCellNumber() {
            return this.cellNumber;
        }

        public void checkConsistency(int n) throws BemException {
            if (n == 1 && this.haveDeleteRequest()) {
                this.verifyThatCellsAreOffLine();
                this.verifyFlexibleConfiguration();
            }
        }

        public HashMap delete() throws BemException {
            HashMap<String, AbstractResourceItem> hashMap = new HashMap<String, AbstractResourceItem>();
            if (this.haveDeleteRequest()) {
                CellAndCarrierCI.this.requestUninitiateSector(this.sectorNumber, this);
                CellAndCarrierCI.this.requestInitiateSector(this.sectorNumber, this);
                SectorAndCellNumber sectorAndCellNumber = CellAndCarrierCI.this.getSectorAndCellNumber(this.sectorNumber, this.cellNumber);
                sectorAndCellNumber.useCellParameter.setValue("NO");
                sectorAndCellNumber.useCellParameter.removeAllRestrictions();
                hashMap.put(sectorAndCellNumber.carrierRI.getCarrierLdn(), sectorAndCellNumber.carrierRI);
                hashMap.put(sectorAndCellNumber.rbsLocalCellRI.getLdn(), sectorAndCellNumber.rbsLocalCellRI);
            }
            return hashMap;
        }

        public HashMap modify() {
            HashMap hashMap = new HashMap();
            if (this.isCarrierExisting()) {
                CellAndCarrierCI.this.requestUninitiateSector(this.sectorNumber, this);
                CellAndCarrierCI.this.requestInitiateSector(this.sectorNumber, this);
            }
            return hashMap;
        }

        private boolean isCarrierExisting() {
            boolean bl = false;
            SectorAndCellNumber sectorAndCellNumber = CellAndCarrierCI.this.getSectorAndCellNumber(this.sectorNumber, this.cellNumber);
            bl = sectorAndCellNumber.carrierRI_isInstalled;
            return bl;
        }

        private boolean haveDeleteRequest() throws BemException {
            String string;
            String string2 = "";
            if (CellAndCarrierCI.this.getRbs().isParameterSupported(PrefixUtil.getCellPrefix(this.sectorNumber, this.cellNumber, "deleteCell")) && (string = CellAndCarrierCI.this.getRbs().getCustomerParameter(PrefixUtil.getCellPrefix(this.sectorNumber, this.cellNumber, "deleteCell"))) != null && !string.equals("")) {
                string2 = string;
            }
            boolean bl = false;
            SectorAndCellNumber sectorAndCellNumber = CellAndCarrierCI.this.getSectorAndCellNumber(this.sectorNumber, this.cellNumber);
            bl = !string2.equals("") && sectorAndCellNumber.carrierRI_isInstalled;
            return bl;
        }

        private void verifyThatCellsAreOffLine() throws BemException {
            SectorAndCellNumber sectorAndCellNumber = CellAndCarrierCI.this.getSectorAndCellNumber(this.sectorNumber, this.cellNumber);
            boolean bl = sectorAndCellNumber.carrierRI.isCellOffline();
            if (!bl) {
                String string = "Not possible to delete Carrier " + this.cellNumber + " under Sector " + this.sectorNumber + ". " + " delete cells in sector must be offline.";
                throw new BemException(string);
            }
        }

        private void verifyFlexibleConfiguration() throws BemException {
            String string;
            String string2 = "Basic";
            if (CellAndCarrierCI.this.getRbs().isParameterSupported("carrierAllocationMode") && (string = CellAndCarrierCI.this.getRbs().getCustomerParameter("carrierAllocationMode")) != null && !string.equals("")) {
                string2 = string;
            }
            if (!string2.equals("Flexible")) {
                string = "Not possible to delete Carrier " + this.cellNumber + " under Sector " + this.sectorNumber + "." + " CarrierAllocationMode must be " + "Flexible" + " when delete cells in sector.";
                throw new BemException(string);
            }
        }
    }

    protected class NumHsCodeResourcesListener
    implements HsdpaResourcesListener {
        protected NumHsCodeResourcesListener() {
        }

        public void update() {
            try {
                CellAndCarrierCI.this.updateNumHsCodeResources();
            }
            catch (BemException bemException) {
                Nal.getLog().nalTrace(1, this.getClass(), "Failed to update NumHsCodeResources ", bemException);
            }
        }
    }

    protected class SteeredHsAllocationListener
    implements CustomerParameterListener {
        protected SteeredHsAllocationListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                int n = customerParameter.getAccessLevel();
                if (n == 0) {
                    return;
                }
                try {
                    CellAndCarrierCI.this.updateSteeredHsAllocationRestriction();
                }
                catch (BemException bemException) {
                    Nal.getLog().nalTrace(1, this.getClass(), "Failed to update SteeredHsAllocationRestriction ", bemException);
                }
            }
        }
    }

    public class SectorChangedListener
    implements RadioEquipmentListener {
        public void update(int n) {
            CellAndCarrierCI.this.handleRadioListenerUpdate(n);
        }
    }
}

