/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.resource.SectorInitialisationRI;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;

public class NuOfTxBranchesPerCarrierListener
implements CustomerParameterListener {
    private int sectorNumber;
    private CellAndCarrierProvider cellAndCarrierCI;
    private SectorInitialisationRI sectorInitialisationRI;

    public NuOfTxBranchesPerCarrierListener(int n, CellAndCarrierProvider cellAndCarrierProvider, SectorInitialisationRI sectorInitialisationRI) {
        this.sectorNumber = n;
        this.cellAndCarrierCI = cellAndCarrierProvider;
        this.sectorInitialisationRI = sectorInitialisationRI;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        try {
            if (customerParameter.hasValueChanged() || customerParameter.isDefault()) {
                if (parameterEvent.isValueChanged()) {
                    if (this.sectorInitialisationRI.isInstalled()) {
                        this.cellAndCarrierCI.requestUninitiateSector(this.sectorNumber, this);
                    }
                    this.cellAndCarrierCI.requestInitiateSector(this.sectorNumber, this);
                }
            } else {
                this.cellAndCarrierCI.cancelUninitiateSector(this.sectorNumber, this);
                this.cellAndCarrierCI.cancelInitiateSector(this.sectorNumber, this);
            }
        }
        catch (Exception exception) {
            Nal.getLog().nalTrace(1, this.getClass(), "Failed in NuOfTxBranchesPerCarrierListener.ParameterPropertiesChanged, source=" + customerParameter, exception);
        }
    }
}

