/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class NuOfTxBranchesParameter
extends Enumeration {
    private static final String DEFAULT_VALUE_STRING = "1";
    private static final int DEFAULT_VALUE_INT = 1;
    private static final boolean ALLOWED_RANGE = true;
    private int sectorNumber;
    private ParameterRestriction radioBuildingBlockTxDivRestriction;
    private ParameterRestriction outputPowerTxDivRestriction;
    private Rbs rbs;

    public NuOfTxBranchesParameter(String string, int n, Rbs rbs) throws BemException {
        super(string, NuOfTxBranchesParameter.createRange(2));
        CustomerParameter customerParameter;
        this.sectorNumber = n;
        this.rbs = rbs;
        EnumeratedRange enumeratedRange = new EnumeratedRange(this.rbs.getRadioEquipmentProvider().getSupportedTxDivRange(n));
        this.rbs.getRadioEquipmentProvider().getSupportedTxDivRange(n);
        String string2 = this.getRbbPseudoName();
        String string3 = this.getOutputPowerPseudoName();
        if (rbs.isParameterSupported(string2)) {
            customerParameter = rbs.getCustomerParameterObject(string2);
            this.createRbbTxDivRestriction(rbs, customerParameter, enumeratedRange);
        }
        if (rbs.isParameterSupported(string3)) {
            customerParameter = rbs.getCustomerParameterObject(string3);
            this.createOutputPowerRestriction(customerParameter, NuOfTxBranchesParameter.createRange(1));
        }
    }

    protected void setActiveRbbRestriction(ParameterRestriction parameterRestriction) throws BemException {
        parameterRestriction.setActive(true);
    }

    private void setActiveOutputPowerRestriction(String string) {
        if (string.equals("BRANCHED")) {
            this.outputPowerTxDivRestriction.setActive(false);
        } else {
            this.outputPowerTxDivRestriction.setActive(true);
        }
    }

    private void createRbbTxDivRestriction(Rbs rbs, CustomerParameter customerParameter, EnumeratedRange enumeratedRange) throws BemException {
        String string = "Current configured radio building block for sector=" + this.sectorNumber + " only supports the following number of TX branches " + enumeratedRange;
        this.radioBuildingBlockTxDivRestriction = new ParameterRestriction(string, enumeratedRange, true);
        this.radioBuildingBlockTxDivRestriction.setActive(true);
        this.addRbbListener(customerParameter);
        this.addRestriction(this.radioBuildingBlockTxDivRestriction);
    }

    protected void addRbbListener(CustomerParameter customerParameter) {
        customerParameter.addCustomerParameterListener(new RadioBuildingBlockListener());
    }

    private void createOutputPowerRestriction(CustomerParameter customerParameter, EnumeratedRange enumeratedRange) {
        String string = "Only output power set to BRANCHED can have more than one TX branch for a cell";
        this.outputPowerTxDivRestriction = new ParameterRestriction(string, enumeratedRange, true);
        String string2 = customerParameter.getValue();
        this.setActiveOutputPowerRestriction(string2);
        customerParameter.addCustomerParameterListener(new OutputPowerListener());
        this.addRestriction(this.outputPowerTxDivRestriction);
    }

    private String getRbbPseudoName() {
        String string = MessageFormat.format("S{0}_", new Integer(this.sectorNumber));
        String string2 = string + "radioBuildingBlock";
        return string2;
    }

    private String getOutputPowerPseudoName() {
        String string = MessageFormat.format("S{0}_", new Integer(this.sectorNumber));
        String string2 = string + "outputPower";
        return string2;
    }

    public int getValueAsInt() {
        String string = this.getValue();
        return Integer.parseInt(string);
    }

    private static EnumeratedRange createRange(int n) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "" + (i + 1);
        }
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        return enumeratedRange;
    }

    public void setDefaultValue() {
        super.setDefaultValue(DEFAULT_VALUE_STRING);
    }

    protected int getSectorNumber() {
        return this.sectorNumber;
    }

    protected ParameterRestriction getRadioBuildingBlockTxDivRestriction() {
        return this.radioBuildingBlockTxDivRestriction;
    }

    protected Rbs getRbs() {
        return this.rbs;
    }

    private class OutputPowerListener
    implements CustomerParameterListener {
        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            String string = customerParameter.getValue();
            NuOfTxBranchesParameter.this.setActiveOutputPowerRestriction(string);
        }
    }

    private class RadioBuildingBlockListener
    implements CustomerParameterListener {
        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            try {
                NuOfTxBranchesParameter.this.radioBuildingBlockTxDivRestriction.setRange(new EnumeratedRange(NuOfTxBranchesParameter.this.rbs.getRadioEquipmentProvider().getSupportedTxDivRange(NuOfTxBranchesParameter.this.sectorNumber)), true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

