/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPort;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPortManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.BatteryBackupRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.BfuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.help.RDNHelper;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipmentSupportFunction;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class BatteryManager {
    private static final String HW_UNIT_TYPE = "BFU";
    private Rbs rbs;
    private MoInstance equipmentMoi;
    private MoInstance equipmentSupportFunctionMoi;
    private int[] bfuPositions = new int[0];
    private IntegerRange bfuRange;
    private TreeMap bfuRIs = new TreeMap();
    private BatteryBackupRI batteryBackupRI;
    private boolean batterySupported;
    private int cabinetNumber;
    private String cabinetType;

    public BatteryManager(Rbs rbs, int[] nArray, IntegerRange integerRange, boolean bl) {
        this(rbs, nArray, integerRange, bl, 1, null);
    }

    public BatteryManager(Rbs rbs, int[] nArray, IntegerRange integerRange, boolean bl, int n, String string) {
        this.rbs = rbs;
        this.bfuRange = integerRange;
        this.bfuPositions = nArray;
        this.batterySupported = bl;
        this.cabinetNumber = n;
        this.cabinetType = string;
        this.equipmentMoi = rbs.getEquipmentMoi();
        this.equipmentSupportFunctionMoi = new SingleChildMoi(rbs.getRootMoi(), MimEquipmentSupportFunction.MOTYPENAME, "1");
    }

    public int[] getBfuPositions() {
        return this.bfuPositions;
    }

    public IntegerRange getBfuRange() throws BemException {
        if (this.rbs.getRbsStep().equals("STEP_SITE")) {
            int n = this.bfuRange.getMaxValue();
            int n2 = this.getNumberOfInstalledBfus();
            this.bfuRange = new IntegerRange(n2, n);
        }
        return this.bfuRange;
    }

    public void updateBoards(String string) throws BemException {
        for (int i = 0; i < this.bfuPositions.length; ++i) {
            BfuRI bfuRI = (BfuRI)this.bfuRIs.get(new Integer(this.bfuPositions[i]));
            if (bfuRI == null) continue;
            String string2 = bfuRI.getHubPosition();
            String string3 = this.lookupHubPos(string, string2, i + 1);
            bfuRI.setHubPosition(string3);
        }
        this.updateMoi();
    }

    private void updateMoi() throws BemException {
        if (this.batterySupported) {
            for (int i = 0; i < this.bfuPositions.length; ++i) {
                BfuRI bfuRI = (BfuRI)this.bfuRIs.get(new Integer(this.bfuPositions[i]));
                if (bfuRI == null) continue;
                bfuRI.updateMoi(this.equipmentMoi);
            }
        }
    }

    private String lookupHubPos(String string, String string2, int n) {
        ApcHubPort apcHubPort;
        String string3 = string2;
        if (string.equals(HW_UNIT_TYPE) && n > 0 && (apcHubPort = ApcHubPortManager.getInstance().getApcPortValue(this.cabinetType, HW_UNIT_TYPE, n)) != null) {
            string3 = apcHubPort.getHubPosition();
        }
        return string3;
    }

    public void createAllRIs() throws BemException {
        if (this.batterySupported) {
            this.createBatteryBackupRI(this.equipmentSupportFunctionMoi);
        }
    }

    private void createBatteryBackupRI(MoInstance moInstance) throws BemException {
        this.batteryBackupRI = new BatteryBackupRI(this.rbs, moInstance, this.cabinetNumber);
    }

    private void createBfuRIs(int n, List list) throws BemException {
        String string;
        String string2;
        Integer n2;
        BfuRI bfuRI;
        int n3;
        RDNHelper rDNHelper = RDNHelper.getInstance();
        for (n3 = 0; n3 < list.size(); ++n3) {
            bfuRI = new BfuRI(this.rbs, Integer.valueOf(list.get(n3).toString()), this.equipmentMoi);
            n2 = new Integer(this.bfuPositions[n3]);
            string2 = bfuRI.getHubPosition();
            string = this.lookupHubPos(HW_UNIT_TYPE, string2, n3 + 1);
            bfuRI.setHubPosition(string);
            this.bfuRIs.put(n2, bfuRI);
        }
        if (n > list.size()) {
            for (n3 = 0; n3 < n - list.size(); ++n3) {
                bfuRI = new BfuRI(this.rbs, rDNHelper.getPostfix(rDNHelper.getBfuRdnList()), this.equipmentMoi);
                n2 = new Integer(this.bfuPositions[list.size() + n3]);
                string2 = bfuRI.getHubPosition();
                string = this.lookupHubPos(HW_UNIT_TYPE, string2, list.size() + n3 + 1);
                bfuRI.setHubPosition(string);
                this.bfuRIs.put(n2, bfuRI);
            }
        }
    }

    public ArrayList getRIsToBeInstalled(boolean bl, int n, List list) throws BemException {
        ArrayList arrayList = new ArrayList();
        Collections.sort(list);
        if (bl && this.isBatterySupported()) {
            ArrayList arrayList2 = this.getNeededBatteryBackupRI();
            arrayList.addAll(arrayList2);
            arrayList2 = this.getNeededBfuRIs(bl, n, list);
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public ArrayList getRIsToUninstall(int n, List list) throws BemException {
        ArrayList arrayList = new ArrayList();
        Collections.sort(list);
        int n2 = list.size();
        int n3 = n2 - n;
        if (n3 > 0) {
            arrayList = this.getBfuRIsToBeUnInstalled(n3, list);
        }
        return arrayList;
    }

    private ArrayList getBfuRIsToBeUnInstalled(int n, List list) throws BemException {
        int n2;
        ArrayList<BfuRI> arrayList = new ArrayList<BfuRI>();
        this.createBfuRIs(n, list);
        Set set = this.bfuRIs.keySet();
        Object[] objectArray = set.toArray();
        for (int i = n2 = objectArray.length - 1; i > 0; --i) {
            BfuRI bfuRI = (BfuRI)this.bfuRIs.get(objectArray[i]);
            if (n <= 0 || !bfuRI.isInstalled()) continue;
            arrayList.add(bfuRI);
            --n;
        }
        return arrayList;
    }

    private ArrayList getNeededBatteryBackupRI() {
        ArrayList<BatteryBackupRI> arrayList = new ArrayList<BatteryBackupRI>();
        arrayList.add(this.batteryBackupRI);
        return arrayList;
    }

    private ArrayList getNeededBfuRIs(boolean bl, int n, List list) throws BemException {
        ArrayList<BfuRI> arrayList = new ArrayList<BfuRI>();
        TreeMap treeMap = null;
        if (bl) {
            treeMap = this.bfuRIs;
            this.createBfuRIs(n, list);
            Set set = treeMap.entrySet();
            Iterator iterator = set.iterator();
            for (int i = 0; i < n; ++i) {
                if (!iterator.hasNext()) continue;
                Map.Entry entry = iterator.next();
                BfuRI bfuRI = (BfuRI)entry.getValue();
                arrayList.add(bfuRI);
            }
        }
        return arrayList;
    }

    public boolean isBatterySupported() {
        return this.batterySupported;
    }

    public int getNumberOfBfus() {
        return this.bfuPositions.length;
    }

    public int getNumberOfInstalledBfus() throws BemException {
        int n = 0;
        Set set = this.bfuRIs.keySet();
        for (Integer n2 : set) {
            BfuRI bfuRI = (BfuRI)this.bfuRIs.get(n2);
            boolean bl = bfuRI.isInstalled();
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    public boolean isBatteryBackupInstalled() throws BemException {
        boolean bl = false;
        if (this.batterySupported) {
            bl = this.batteryBackupRI.isInstalled();
        }
        return bl;
    }

    void setBatteryBackupRi(BatteryBackupRI batteryBackupRI) {
        this.batteryBackupRI = batteryBackupRI;
    }

    void setBatterySupported(boolean bl) {
        this.batterySupported = bl;
    }

    void setBfuRi(TreeMap treeMap) throws BemException {
        this.bfuRIs.putAll(treeMap);
    }

    public Integer getBatteryType() throws BemException {
        return (Integer)this.getAttribute("batteryType");
    }

    public Integer getChargingMode() throws BemException {
        return (Integer)this.getAttribute("chargingMode");
    }

    public Integer getTestMode() throws BemException {
        return (Integer)this.getAttribute("testMode");
    }

    public Integer getMinimumStateOfHealth() throws BemException {
        return (Integer)this.getAttribute("minimumStateOfHealth");
    }

    public Integer getMinimumBackupTime() throws BemException {
        return (Integer)this.getAttribute("minimumBackupTime");
    }

    public Integer getTestStartDay() throws BemException {
        return (Integer)this.getAttribute("testStartDay");
    }

    public String getTestStartTime() throws BemException {
        return (String)this.getAttribute("testStartTime");
    }

    public String getbatteryInstallationDate() throws BemException {
        return (String)this.getAttribute("batteryInstallationDate");
    }

    public int[] getTestStartMonths() throws BemException {
        return (int[])this.getAttribute("testStartMonths");
    }

    public Boolean getSharedBattery() throws BemException {
        return (Boolean)this.getAttribute("sharedBattery");
    }

    public Integer getChargingVoltage() throws BemException {
        return (Integer)this.getAttribute("chargingVoltage");
    }

    public Integer getTempCompVoltageSlop() throws BemException {
        return (Integer)this.getAttribute("tempCompVoltageSlope");
    }

    public Integer getNominalTemp() throws BemException {
        return (Integer)this.getAttribute("nominalTemp");
    }

    public Integer getTempCompMinVoltage() throws BemException {
        return (Integer)this.getAttribute("tempCompMinVoltage");
    }

    public Integer getTempCompMaxVoltage() throws BemException {
        return (Integer)this.getAttribute("tempCompMaxVoltage");
    }

    public Integer getIncreasedChargeVoltage() throws BemException {
        return (Integer)this.getAttribute("increasedChargeVoltage");
    }

    public Integer getBoostChargeTime() throws BemException {
        return (Integer)this.getAttribute("boostChargeTime");
    }

    public Integer getBoostChargeTriggerVoltage() throws BemException {
        return (Integer)this.getAttribute("boostChargeTriggerVoltage");
    }

    public Integer getEqualizeChargeTime() throws BemException {
        return (Integer)this.getAttribute("equalizeChargeTime");
    }

    public Integer getEqualizeChargeCyclicInterval() throws BemException {
        return (Integer)this.getAttribute("equalizeChargeCyclicInterval");
    }

    public Integer getIntermittentChargeConnectVoltage() throws BemException {
        return (Integer)this.getAttribute("intermittentChargeConnectVoltage");
    }

    public Integer getIntermittentChargeConnectTime() throws BemException {
        return (Integer)this.getAttribute("intermittentChargeConnectTime");
    }

    public Integer getIntermittentChargeDisconnectTime() throws BemException {
        return (Integer)this.getAttribute("intermittentChargeDisconnectTime");
    }

    public Object getAttribute(String string) throws BemException {
        String string2 = this.batteryBackupRI.getLdn();
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(string2);
        Object object = null;
        try {
            object = moHandler.getAttribute(bemMo, string);
        }
        catch (Exception exception) {
            throw new BemException("BatteryManager.getAttribute()", "getAttribute()", string2, null, exception);
        }
        return object;
    }
}

