/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.AbsoluteTimeSynchEnabledParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.GpsOutEnabledParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateRegulationSystem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateSystem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.SmokeDetectorParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.ControlSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAlarmPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCabinet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimControlPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimFanGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimProductData;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.LdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;

public class CabinetRI
extends AbstractResourceItem {
    private static final String NAME = "Cabinet";
    private static final String[] myInstallationPhases = new String[]{"CommonCabinetCreationPhase", "CabinetParameterUpdatePhase", "CabinetParametersDeletionPhase"};
    private final String cabinetLdn;
    private final boolean useSupInsteadOfScu;
    private int cabinetNumber;

    public CabinetRI(Rbs rbs, boolean bl, int n) throws BemException {
        super(NAME, rbs, myInstallationPhases);
        MoInstance moInstance = rbs.getMoiRefs().getEquipmentMoi();
        this.cabinetLdn = new FixedRdnMoi(moInstance, MimCabinet.MOTYPENAME, String.valueOf(n)).getLdn();
        this.useSupInsteadOfScu = bl;
        this.cabinetNumber = n;
    }

    public void install(String string) throws BemException {
        ControlSystemProvider controlSystemProvider = (ControlSystemProvider)this.rbs.getProvider(ControlSystemProvider.class);
        CustomerParameter customerParameter = controlSystemProvider.getAddDuwBoardSlotCustomerParameter();
        boolean bl = this.rbs.isParameterSupported("gpsOutEnabled");
        boolean bl2 = this.rbs.isParameterSupported("absoluteTimeSynchEnabled");
        GpsOutEnabledParameter gpsOutEnabledParameter = null;
        if (bl) {
            gpsOutEnabledParameter = (GpsOutEnabledParameter)this.rbs.getCustomerParameterObject("gpsOutEnabled");
        }
        AbsoluteTimeSynchEnabledParameter absoluteTimeSynchEnabledParameter = null;
        if (bl2) {
            absoluteTimeSynchEnabledParameter = (AbsoluteTimeSynchEnabledParameter)this.rbs.getCustomerParameterObject("absoluteTimeSynchEnabled");
        }
        if (string.equals("CommonCabinetCreationPhase")) {
            if (this.useSupInsteadOfScu) {
                if (!this.rbs.getRbsStep().equals("STEP_EXPANSION")) {
                    this.deleteCabinetMo();
                } else if (customerParameter.hasValueChanged() || bl && gpsOutEnabledParameter.hasValueChanged() || bl2 && absoluteTimeSynchEnabledParameter.hasValueChanged()) {
                    this.deleteCabinetMo();
                } else {
                    BemLog.log(7, "Skip delete Cabinet.");
                }
            }
            this.installCabinetMo();
        } else if (string.equals("CabinetParameterUpdatePhase")) {
            this.updateCabinetMo();
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("CabinetParametersDeletionPhase")) {
            this.deleteCabinetMo();
        }
    }

    public String getDisplayName() {
        return "Cabinet: " + this.getLdn();
    }

    public String getLdn() {
        return this.cabinetLdn;
    }

    public boolean isInstalled() throws BemException {
        return this.isExisting(this.cabinetLdn);
    }

    public void updateLoadedValues() throws BemException {
        BemMo bemMo = super.getMo(this.cabinetLdn);
        boolean bl = super.isExisting(bemMo);
        if (bl) {
            Object object;
            IntegerParameter integerParameter;
            Integer n = Integer.valueOf(bemMo.getDN().substring(bemMo.getDN().lastIndexOf("=") + 1));
            String string = PrefixUtil.getCabinetPrefix(String.valueOf(n));
            Integer n2 = (Integer)bemMo.getAttribute("climateSystem");
            ClimateSystem climateSystem = (ClimateSystem)this.rbs.getCustomerParameterObject(string + "climateSystem");
            climateSystem.setLoadedValue(n2);
            Integer n3 = (Integer)bemMo.getAttribute("climateRegulationSystem");
            ClimateRegulationSystem climateRegulationSystem = (ClimateRegulationSystem)this.rbs.getCustomerParameterObject(string + "climateRegulationSystem");
            climateRegulationSystem.setLoadedValue(n3);
            Boolean bl2 = (Boolean)bemMo.getAttribute("smokeDetector");
            SmokeDetectorParameter smokeDetectorParameter = (SmokeDetectorParameter)this.rbs.getCustomerParameterObject(string + "smokeDetector");
            if (bl2 != null) {
                if (bl2.booleanValue()) {
                    smokeDetectorParameter.setLoadedValue("TRUE");
                } else {
                    smokeDetectorParameter.setLoadedValue("FALSE");
                }
            }
            IntegerParameter integerParameter2 = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "cabinetNumber");
            integerParameter2.setLoadedValue(n);
            String string2 = (String)bemMo.getAttribute("sharedCabinetIdentifier");
            StringParameter stringParameter = (StringParameter)this.rbs.getCustomerParameterObject(string + "sharedCabinetIdentifier");
            stringParameter.setLoadedValue(string2);
            if (n > 1) {
                integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "ecBusNumber");
                object = this.getEcBusRef(bemMo);
                if (null != object && !((String)object).equals("")) {
                    integerParameter.setLoadedValue(new Integer((String)object));
                }
            }
            integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "referredCabinetNumber");
            object = (BemMo)bemMo.getAttribute("positionRef");
            if (null != object) {
                integerParameter.setLoadedValue(object.getId());
            }
        }
    }

    private String getEcBusRef(BemMo bemMo) throws BemException {
        String string = "";
        Object[] objectArray = (Object[])super.getAttribute(bemMo, "reservedBy");
        if (objectArray != null && objectArray.length > 0 && objectArray instanceof BemMo[]) {
            BemMo[] bemMoArray = (BemMo[])objectArray;
            for (int i = objectArray.length - 1; i >= 0; --i) {
                BemMo bemMo2 = bemMoArray[i];
                if (!bemMo2.getType().equals(MimHwUnit.MOTYPENAME)) continue;
                SingleChildMoi singleChildMoi = new SingleChildMoi(new LdnMoi(bemMo2.getDN()), MimEcPort.MOTYPENAME, "1");
                String string2 = singleChildMoi.getLdn();
                BemMo bemMo3 = super.getMo(string2);
                if (bemMo3.isExisting()) {
                    BemMo bemMo4 = (BemMo)bemMo3.getAttribute("ecBusRef");
                    return bemMo4.getId();
                }
                return null;
            }
        }
        return string;
    }

    private void installCabinetMo() throws BemException {
        Object object;
        Object object2;
        Object object3;
        CustomerParameterImpl customerParameterImpl;
        Vector<Object> vector = new Vector<Object>();
        BemMo bemMo = super.getMo(this.cabinetLdn);
        boolean bl = bemMo.isExisting();
        String string = PrefixUtil.getCabinetPrefix(String.valueOf(this.cabinetNumber));
        if ("TRUE".equals(this.rbs.getCustomerParameter("supportSystemControl"))) {
            customerParameterImpl = (Enumeration)this.rbs.getCustomerParameterObject(string + "climateSystem");
            if (customerParameterImpl.hasValueChanged() || !bl) {
                object3 = Nal.getFactory().getNameValue("climateSystem", customerParameterImpl.getValueMom());
                vector.add(object3);
            }
            if (((CustomerParameterImpl)(object3 = (Enumeration)this.rbs.getCustomerParameterObject(string + "climateRegulationSystem"))).hasValueChanged() || !bl) {
                object2 = Nal.getFactory().getNameValue("climateRegulationSystem", ((CustomerParameterImpl)object3).getValueMom());
                vector.add(object2);
            }
            if (((CustomerParameterImpl)(object2 = (SmokeDetectorParameter)this.rbs.getCustomerParameterObject(string + "smokeDetector"))).hasValueChanged() || !bl) {
                object = Nal.getFactory().getNameValue("smokeDetector", ((SmokeDetectorParameter)object2).getValueMom());
                vector.add(object);
            }
        }
        if ((customerParameterImpl = (StringParameter)this.rbs.getCustomerParameterObject(string + "sharedCabinetIdentifier")).hasValueChanged() || !bl) {
            object3 = Nal.getFactory().getNameValue("sharedCabinetIdentifier", customerParameterImpl.getValue());
            vector.add(object3);
        }
        if (!bl) {
            super.create(bemMo, vector);
        } else {
            super.setAttributes(bemMo, vector);
        }
        if (this.fetchCabinetType().equals("RACK") && this.rbs.getCustomerParameterObject("supportSystemControl").getValue().equalsIgnoreCase("TRUE")) {
            object3 = "Rack";
            object2 = "20100303";
            object = MimProductData.DEFAULT_PRODUCTNUMBER;
            String string2 = MimProductData.DEFAULT_PRODUCTREVISION;
            String string3 = MimProductData.DEFAULT_SERIALNUMBER;
            this.setCabinetParameter(bemMo, (String)object3, (String)object2, (String)object, string2, string3);
        } else if (BemLanguageHelp.getEnvironment() == 1) {
            object3 = this.fetchCabinetType();
            object2 = "20100303";
            object = "BGM 136 1006/2";
            String string4 = "R2A";
            String string5 = "C823402050";
            this.setCabinetParameter(bemMo, (String)object3, (String)object2, (String)object, string4, string5);
        }
    }

    private void updateCabinetMo() throws BemException {
        Vector<Object> vector = new Vector<Object>();
        BemMo bemMo = super.getMo(this.cabinetLdn);
        String string = PrefixUtil.getCabinetPrefix(String.valueOf(this.cabinetNumber));
        IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "referredCabinetNumber");
        if (integerParameter.hasValueChanged()) {
            Object object;
            BemMo bemMo2 = this.getMo(null);
            if (!integerParameter.getValue().equals("##UNDEFINED")) {
                object = this.rbs.getMoiRefs().getEquipmentMoi();
                FixedRdnMoi fixedRdnMoi = new FixedRdnMoi((MoInstance)object, MimCabinet.MOTYPENAME, integerParameter.getValue());
                bemMo2 = this.getMo(fixedRdnMoi.getLdn());
            }
            object = Nal.getFactory().getNameValue("positionRef", bemMo2);
            vector.add(object);
        }
        if (vector.size() > 0) {
            super.setAttributes(bemMo, vector);
        }
    }

    private void setCabinetParameter(BemMo bemMo, String string, String string2, String string3, String string4, String string5) throws BemException {
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("productionDate", string2), Nal.getFactory().getNameValue("productName", string), Nal.getFactory().getNameValue("productNumber", string3), Nal.getFactory().getNameValue("productRevision", string4), Nal.getFactory().getNameValue("serialNumber", string5)};
        super.setAttribute(bemMo, "productData", (Object)Nal.getFactory().getStruct(nalNameValueArray));
    }

    private String fetchCabinetType() throws BemException {
        String string = PrefixUtil.getCabinetPrefix(String.valueOf(this.cabinetNumber));
        String string2 = this.cabinetNumber == 1 ? this.rbs.getRbsType() : this.rbs.getCustomerParameter(string + "cabinetType");
        return string2;
    }

    private void deleteCabinetMo() throws BemException {
        this.deleteChildrenCabinetMo();
        super.deleteMoIfExisting(this.cabinetLdn);
    }

    private void deleteChildrenCabinetMo() throws BemException {
        BemMo bemMo = super.getMo(this.cabinetLdn);
        if (bemMo.isExisting()) {
            BemMo[] bemMoArray = super.getChildren(bemMo, 1, MimFanGroup.MOTYPENAME, "");
            this.deleteChildrenMos(bemMoArray);
            Object[] objectArray = (Object[])super.getAttribute(bemMo, "reservedBy");
            if (objectArray != null && objectArray.length > 0 && objectArray instanceof BemMo[]) {
                BemMo[] bemMoArray2 = (BemMo[])objectArray;
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    BemMo bemMo2 = bemMoArray2[i];
                    if (bemMo2.getType().equals(MimPlugInUnit.MOTYPENAME) || bemMo2.getType().equals(MimCabinet.MOTYPENAME)) {
                        super.setAttribute(bemMo2, "positionRef", (Object)new BemMoImpl((String)null));
                        continue;
                    }
                    if (bemMo2.getType().equals(MimHwUnit.MOTYPENAME)) {
                        this.deleteHwUnitMo(bemMo2);
                        continue;
                    }
                    this.delete(bemMo2);
                }
            }
        }
    }

    private void deleteHwUnitMo(BemMo bemMo) throws BemException {
        if (bemMo.isExisting()) {
            String[] stringArray = new String[]{MimEcPort.MOTYPENAME, MimAlarmPort.MOTYPENAME, MimControlPort.MOTYPENAME};
            for (int i = 0; i < stringArray.length; ++i) {
                BemMo[] bemMoArray = super.getChildren(bemMo, 1, stringArray[i], "");
                this.deleteChildrenMos(bemMoArray);
            }
            this.delete(bemMo);
        }
    }

    private void deleteChildrenMos(BemMo[] bemMoArray) throws BemException {
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                super.delete(bemMoArray[i]);
            }
        }
    }

    public int getCabinetNumber() {
        return this.cabinetNumber;
    }
}

