/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.AutoNegotiationParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.ConfiguredSpeedDuplexParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.GigaBitEthernetAdminQualityConverter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.GigaBitEthernetAutoNegotiationConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.GigaBitEthernetConfiguredSpeedDuplexConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.GigaBitEthernetMasterModeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.GigaBitEthernetPortNoConverter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.GigaBitEthernetUseReceivedQlConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.MasterModeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.provider.GigabitEthernetSyncRef;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGigaBitEthernet;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class GigabitEthernetRI
extends AbstractResourceItem
implements GigabitEthernetSyncRef,
CustomerParameterListener {
    public static final String name = "GigabitEthernetRI";
    private static final String[] phases = new String[]{"GigabitEthernetCreationPhase", "UnlockPhase"};
    private static final String ETH_1000_MB_FULL = "ETH_1000_MB_FULL";
    private MoInstance gigabitEthernetMoi;
    private final List pseudoList = new ArrayList();
    private MoInstance exchangeTerminalIpMoi;
    private final ParameterRestriction restrictionReadOnly = new ParameterRestriction("portNo can not be changed unless MO GigaBitEthernet is deleted and created again", 0);
    protected Enumeration gigaBitEthernetPort;
    protected AutoNegotiationParameter gigaBitEthernetAutoNegotiation;
    protected MasterModeParameter gigaBitEthernetMasterMode;
    protected ConfiguredSpeedDuplexParameter gigaBitEthernetConfiguredSpeedDuplex;
    private YesNoCustomerParameter gigaBitEthernetEsmcSupport;
    private Enumeration gigaBitEthernetUseReceivedQL;
    private Enumeration gigaBitEthernetAdminQuality;
    private final ParameterRestriction useReceivedQLOptional = new ParameterRestriction("", 2);
    private final ParameterRestriction useReceivedQLIgnored = new ParameterRestriction("", 1);
    private final ParameterRestriction adminQualityOptional = new ParameterRestriction("", 2);
    private final ParameterRestriction adminQualityIgnored = new ParameterRestriction("", 1);
    private final ParameterRestriction esmcSupportOptional = new ParameterRestriction("", 2);

    public GigabitEthernetRI(Rbs rbs) {
        super(name, rbs, phases);
    }

    public List getCustomerParameterNames() {
        return this.pseudoList;
    }

    public List createCustomerParameters() {
        ArrayList<Enumeration> arrayList = new ArrayList<Enumeration>();
        this.pseudoList.add("gigaBitEthernetPort");
        Enumeration enumeration = new Enumeration("gigaBitEthernetPort", new EnumeratedRange(new String[]{"TNA", "TNB", "TNC"}));
        enumeration.setDefaultValue("TNA");
        enumeration.setValue("TNA");
        GigaBitEthernetPortNoConverter gigaBitEthernetPortNoConverter = new GigaBitEthernetPortNoConverter();
        enumeration.setMomConverter(gigaBitEthernetPortNoConverter);
        arrayList.add(enumeration);
        this.pseudoList.add("autoNegotiation");
        this.gigaBitEthernetAutoNegotiation = new AutoNegotiationParameter();
        this.gigaBitEthernetAutoNegotiation.setDefaultValue("TRUE");
        this.gigaBitEthernetAutoNegotiation.setValue(true);
        GigaBitEthernetAutoNegotiationConversion gigaBitEthernetAutoNegotiationConversion = new GigaBitEthernetAutoNegotiationConversion();
        this.gigaBitEthernetAutoNegotiation.setMomConverter(gigaBitEthernetAutoNegotiationConversion);
        arrayList.add(this.gigaBitEthernetAutoNegotiation);
        this.pseudoList.add("masterMode");
        this.gigaBitEthernetMasterMode = new MasterModeParameter();
        this.gigaBitEthernetMasterMode.setDefaultValue("TRUE");
        this.gigaBitEthernetMasterMode.setValue(true);
        GigaBitEthernetMasterModeConversion gigaBitEthernetMasterModeConversion = new GigaBitEthernetMasterModeConversion();
        this.gigaBitEthernetMasterMode.setMomConverter(gigaBitEthernetMasterModeConversion);
        arrayList.add(this.gigaBitEthernetMasterMode);
        this.pseudoList.add("configuredSpeedDuplex");
        this.gigaBitEthernetConfiguredSpeedDuplex = new ConfiguredSpeedDuplexParameter();
        this.gigaBitEthernetConfiguredSpeedDuplex.setDefaultValue(ETH_1000_MB_FULL);
        this.gigaBitEthernetConfiguredSpeedDuplex.setValue(ETH_1000_MB_FULL);
        GigaBitEthernetConfiguredSpeedDuplexConversion gigaBitEthernetConfiguredSpeedDuplexConversion = new GigaBitEthernetConfiguredSpeedDuplexConversion();
        this.gigaBitEthernetConfiguredSpeedDuplex.setMomConverter(gigaBitEthernetConfiguredSpeedDuplexConversion);
        arrayList.add(this.gigaBitEthernetConfiguredSpeedDuplex);
        YesNoCustomerParameter yesNoCustomerParameter = new YesNoCustomerParameter("gigaBitEthernetPortCreate");
        arrayList.add(yesNoCustomerParameter);
        this.gigaBitEthernetUseReceivedQL = new Enumeration("useReceivedQl", new EnumeratedRange(new String[]{"TRUE", "FALSE"}));
        this.gigaBitEthernetUseReceivedQL.setDefaultValue("FALSE");
        this.gigaBitEthernetUseReceivedQL.setValue("FALSE");
        this.gigaBitEthernetUseReceivedQL.addRestriction(this.useReceivedQLIgnored);
        GigaBitEthernetUseReceivedQlConversion gigaBitEthernetUseReceivedQlConversion = new GigaBitEthernetUseReceivedQlConversion();
        this.gigaBitEthernetUseReceivedQL.setMomConverter(gigaBitEthernetUseReceivedQlConversion);
        arrayList.add(this.gigaBitEthernetUseReceivedQL);
        this.gigaBitEthernetAdminQuality = new Enumeration("adminQuality", new EnumeratedRange(new String[]{"QL_PRC", "QL_SSU_A", "QL_SSU_B", "QL_SEC_QL_EEC", "QL_PRS", "QL_STU", "QL_ST2", "QL_TNC", "QL_ST3E", "QL_ST3_QL_EEC", "QL_SMC", "QL_UNK", "QL_SEC", "NOT_DEFINED"}));
        this.gigaBitEthernetAdminQuality.setDefaultValue("NOT_DEFINED");
        this.gigaBitEthernetAdminQuality.setValue("NOT_DEFINED");
        this.gigaBitEthernetAdminQuality.addRestriction(this.adminQualityIgnored);
        GigaBitEthernetAdminQualityConverter gigaBitEthernetAdminQualityConverter = new GigaBitEthernetAdminQualityConverter();
        this.gigaBitEthernetAdminQuality.setMomConverter(gigaBitEthernetAdminQualityConverter);
        arrayList.add(this.gigaBitEthernetAdminQuality);
        this.gigaBitEthernetEsmcSupport = new YesNoCustomerParameter("emscSupport");
        arrayList.add(this.gigaBitEthernetEsmcSupport);
        this.gigaBitEthernetEsmcSupport.addRestriction(this.esmcSupportOptional);
        this.gigaBitEthernetEsmcSupport.addCustomerParameterListener(this);
        return arrayList;
    }

    public void initiateCPWithNodeValues() throws BemException {
        BemMo bemMo = this.getMo(this.gigabitEthernetMoi.getLdn());
        boolean bl = this.isInstalled();
        if (bl) {
            Integer n = (Integer)this.getAttribute(bemMo, "portNo");
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject("gigaBitEthernetPort");
            CustomerParameterServer customerParameterServer2 = this.rbs.getCustomerParameterServerObject("gigaBitEthernetPortCreate");
            Boolean bl2 = (Boolean)this.getAttribute(bemMo, "autoNegotiation");
            CustomerParameterServer customerParameterServer3 = this.rbs.getCustomerParameterServerObject("autoNegotiation");
            Boolean bl3 = (Boolean)this.getAttribute(bemMo, "masterMode");
            CustomerParameterServer customerParameterServer4 = this.rbs.getCustomerParameterServerObject("masterMode");
            Integer n2 = (Integer)this.getAttribute(bemMo, "configuredSpeedDuplex");
            CustomerParameterServer customerParameterServer5 = this.rbs.getCustomerParameterServerObject("configuredSpeedDuplex");
            customerParameterServer.setLoadedValue(n);
            customerParameterServer2.setLoadedValue("YES");
            customerParameterServer3.setLoadedValue(bl2);
            customerParameterServer4.setLoadedValue(bl3);
            customerParameterServer5.setLoadedValue(n2);
            if (!DuwUtil.isPrimaryDuwV2()) {
                customerParameterServer.addRestriction(this.restrictionReadOnly);
                customerParameterServer2.addRestriction(this.restrictionReadOnly);
                customerParameterServer3.addRestriction(this.restrictionReadOnly);
                customerParameterServer4.addRestriction(this.restrictionReadOnly);
                customerParameterServer5.addRestriction(this.restrictionReadOnly);
            }
        }
    }

    public void setEtmBoard(MoInstance moInstance) {
        this.exchangeTerminalIpMoi = moInstance;
        this.initialiseMois();
    }

    private void initialiseMois() {
        this.gigabitEthernetMoi = new SingleChildMoi(this.exchangeTerminalIpMoi, MimGigaBitEthernet.MOTYPENAME, "1");
    }

    public void install(String string) throws BemException {
        if (string.equals("GigabitEthernetCreationPhase")) {
            this.createGigabitEthernetMO();
        } else if (string.equals("UnlockPhase")) {
            BemMo bemMo = this.getMo(this.gigabitEthernetMoi.getLdn());
            this.unlockMO(bemMo, "administrativeState");
        }
    }

    private void createGigabitEthernetMO() throws BemException {
        BemMo bemMo = this.getMo(this.gigabitEthernetMoi.getLdn());
        if (!this.isExisting(bemMo)) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            for (String string : this.pseudoList) {
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string);
                boolean bl = customerParameterServer.hasValueChanged();
                if (!bl) continue;
                String string2 = customerParameterServer.getAttributeName();
                Object object = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string2, object));
            }
            vector.add(Nal.getFactory().getNameValue("protectiveMode", Boolean.valueOf("false")));
            this.create(bemMo, vector);
        } else {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            for (String string : this.pseudoList) {
                CustomerParameterServer customerParameterServer;
                boolean bl;
                if (string.equalsIgnoreCase("gigaBitEthernetPort") || !(bl = (customerParameterServer = this.rbs.getCustomerParameterServerObject(string)).hasValueChanged())) continue;
                String string3 = customerParameterServer.getAttributeName();
                Object object = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string3, object));
            }
            this.setAttributes(bemMo, vector);
        }
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        try {
            return this.gigabitEthernetMoi.getLdn();
        }
        catch (BemException bemException) {
            return null;
        }
    }

    public MoInstance getGigabitEthernetMoi() {
        return this.gigabitEthernetMoi;
    }

    public boolean isInstalled() throws BemException {
        if (this.gigabitEthernetMoi != null) {
            return super.isInstalled();
        }
        return false;
    }

    public String getGigabitEthernetSyncRefId() {
        return BemUtil.extractRdnId(this.getLdn(), MimGigaBitEthernet.MOTYPENAME);
    }

    public String getGigabitEthernetSyncRefLdn() throws BemException {
        return this.getLdn();
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        String string;
        if (parameterEvent.isValueChanged() && (string = customerParameter.getName()).equalsIgnoreCase(this.gigaBitEthernetEsmcSupport.getName())) {
            boolean bl = "Yes".equalsIgnoreCase(this.gigaBitEthernetEsmcSupport.getValue());
            if (bl) {
                this.gigaBitEthernetUseReceivedQL.removeRestriction(this.useReceivedQLIgnored);
                this.gigaBitEthernetUseReceivedQL.addRestriction(this.useReceivedQLOptional);
                this.gigaBitEthernetAdminQuality.removeRestriction(this.adminQualityIgnored);
                this.gigaBitEthernetAdminQuality.addRestriction(this.adminQualityOptional);
            } else {
                this.gigaBitEthernetUseReceivedQL.removeRestriction(this.useReceivedQLOptional);
                this.gigaBitEthernetUseReceivedQL.addRestriction(this.useReceivedQLIgnored);
                this.gigaBitEthernetAdminQuality.removeRestriction(this.adminQualityOptional);
                this.gigaBitEthernetAdminQuality.addRestriction(this.adminQualityIgnored);
            }
        }
    }
}

