/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.iub;

import java.util.ArrayList;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VciParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.IubRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.NbapCommonProtocolStackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.NbapDedicatedProtocolStackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.atm.PhysicalTransportLayerRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.atm.TncpProtocolStackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.atm.UserDataProtocolStackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.atm.VirtualPathRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource.ip.IubOverIpRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.SubnetMaskParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAal2PathVccTp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAal2Sp;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class IubCI
extends AbstractConfigurationItem
implements EtmBoardListener {
    public static final String name = "IubCI";
    private boolean isOpen = false;
    private IubOverIpRI ipRI;
    private PhysicalTransportLayerRI physicalTransportLayerRI;
    private TncpProtocolStackRI tncpProtocolStackRI;
    private UserDataProtocolStackRI userDataProtocolStackRI;
    private VirtualPathRI virtualPathRI;
    private IubRI iubRI;
    private NbapCommonProtocolStackRI nbapCommonProtocolStackRI;
    private NbapDedicatedProtocolStackRI nbapDedicatedProtocolStackRI;
    private EtmBoardProvider etmBoardProvider;
    private EthernetProvider ethernetProvider;
    private static final String DESCR_CONTROL_PROTOCOL_STACK_ID = "U3P1000M80";
    private static final String DESCR_VIRTUAL_PATH_E1_STM1_OC3_ID = "C1P4500";

    public IubCI(Rbs rbs) {
        super(rbs);
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            throw new BemException("IubCI.open(): Already open");
        }
        this.setupProviders();
        this.createCustomerParameters();
        this.createAllResourceItems();
        this.getRbs().registerProvider(this);
        this.update();
        this.isOpen = true;
        return this.isOpen;
    }

    private void createCustomerParameters() {
        StringParameter stringParameter = new StringParameter("IubNpcTestConfiguration_a2ea", new StringRange(MimAal2Sp.MINLEN_A2EA, MimAal2Sp.MAXLEN_A2EA));
        IntegerParameter integerParameter = new IntegerParameter("IubNpcTestConfiguration_etbSlot", new IntegerRange(0, 30));
        StringParameter stringParameter2 = new StringParameter("IubNpcTestConfiguration_terminationType", new StringRange(new Integer(0), new Integer(10)));
        IntegerParameter integerParameter2 = new IntegerParameter("IubNpcTestConfiguration_externalVpi", new IntegerRange(0, 255));
        this.addParameter(stringParameter);
        this.addParameter(integerParameter);
        this.addParameter(stringParameter2);
        this.addParameter(integerParameter2);
        IntegerParameter integerParameter3 = new IntegerParameter("IpIubTestConfiguration_etxSlot", new IntegerRange(0, 30));
        IpAddressParameter ipAddressParameter = new IpAddressParameter("IpIubTestConfiguration_etIpAddress", new IpAddressRange());
        IpAddressParameter ipAddressParameter2 = new IpAddressParameter("IpIubTestConfiguration_gpbIpAddress", new IpAddressRange());
        SubnetMaskParameter subnetMaskParameter = new SubnetMaskParameter("IpIubTestConfiguration_subnetMask", new IpAddressRange());
        IpAddressParameter ipAddressParameter3 = new IpAddressParameter("IpIubTestConfiguration_defaultRouter", new IpAddressRange());
        this.addParameter(integerParameter3);
        this.addParameter(ipAddressParameter);
        this.addParameter(ipAddressParameter2);
        this.addParameter(subnetMaskParameter);
        this.addParameter(ipAddressParameter3);
    }

    private void createAllResourceItems() {
        this.ipRI = new IubOverIpRI(this.getRbs());
        this.physicalTransportLayerRI = new PhysicalTransportLayerRI(this.getRbs(), this.etmBoardProvider);
        this.virtualPathRI = new VirtualPathRI(this.getRbs(), DESCR_VIRTUAL_PATH_E1_STM1_OC3_ID);
        this.tncpProtocolStackRI = new TncpProtocolStackRI(this.getRbs(), DESCR_CONTROL_PROTOCOL_STACK_ID);
        this.userDataProtocolStackRI = new UserDataProtocolStackRI(this.getRbs());
        this.iubRI = new IubRI(this.getRbs());
        this.nbapCommonProtocolStackRI = new NbapCommonProtocolStackRI(this.getRbs(), DESCR_CONTROL_PROTOCOL_STACK_ID);
        this.nbapDedicatedProtocolStackRI = new NbapDedicatedProtocolStackRI(this.getRbs(), DESCR_CONTROL_PROTOCOL_STACK_ID);
    }

    public ArrayList getNeededRIs() throws BemException {
        String string;
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        if (!this.isOpen) {
            throw new BemException("IubCI is not open");
        }
        arrayList.add(this.iubRI);
        arrayList.add(this.nbapCommonProtocolStackRI);
        arrayList.add(this.nbapDedicatedProtocolStackRI);
        if (this.isIPConfigured()) {
            arrayList.add(this.ipRI);
        }
        if (!(string = this.getRbs().getCustomerParameter("IubNpcTestConfiguration_etbSlot")).equals("##UNDEFINED")) {
            arrayList.add(this.physicalTransportLayerRI);
            arrayList.add(this.tncpProtocolStackRI);
            arrayList.add(this.userDataProtocolStackRI);
            arrayList.add(this.virtualPathRI);
        }
        return arrayList;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        this.createDynamicCustomerParameters(serviceValue);
        String[] stringArray = this.getAllCustomerParameterNames();
        super.setCustomerParametersFromSV(stringArray, serviceValue);
        this.update();
        this.checkConsistency();
    }

    private void createDynamicCustomerParameters(ServiceValue serviceValue) throws BemException {
        Vector vector = serviceValue.getAllAttributes();
        for (int i = 0; i < vector.size(); ++i) {
            IntegerParameter integerParameter;
            ServiceNameValue serviceNameValue = (ServiceNameValue)vector.get(i);
            if (serviceNameValue.getName().indexOf("aal2PathId") != -1) {
                integerParameter = new IntegerParameter(serviceNameValue.getPseudoName(), new IntegerRange(MimAal2PathVccTp.MIN_AAL2PATHID, MimAal2PathVccTp.MAX_AAL2PATHID));
                this.addParameter(integerParameter);
                continue;
            }
            if (serviceNameValue.getName().indexOf("vci") != -1) {
                integerParameter = new VciParameter(serviceNameValue.getPseudoName());
                this.addParameter(integerParameter);
                continue;
            }
            if (serviceNameValue.getName().indexOf("userDataATMPcr") == -1) continue;
            integerParameter = new IntegerParameter(serviceNameValue.getPseudoName(), new IntegerRange(0, 30));
            this.addParameter(integerParameter);
        }
    }

    public String getName() {
        return name;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    private void setupProviders() throws BemException {
        if (this.etmBoardProvider == null) {
            this.etmBoardProvider = (EtmBoardProvider)this.getRbs().getProvider(EtmBoardProvider.class);
            if (this.etmBoardProvider != null) {
                this.etmBoardProvider.addEtmBoardListener(this);
            } else {
                throw new BemException("IubCI.setupProviders(): can not obtain EtmBoardProvider");
            }
        }
        if (this.ethernetProvider == null) {
            this.ethernetProvider = (EthernetProvider)((Object)this.getRbs().getConfigItem("EthernetSwitchCI"));
            if (this.ethernetProvider == null) {
                throw new BemException("IubCI.setupProviders(): can not obtain EthernetProvider");
            }
        }
    }

    public void update() {
        try {
            Object object;
            String string = this.getRbs().getCustomerParameter("IpIubTestConfiguration_etxSlot");
            if (string != null && !string.equals("##UNDEFINED")) {
                object = this.ethernetProvider.getEthernetInterface(string);
                this.ipRI.setEthernetInterfaceMoi((MoInstance)object);
                MoInstance moInstance = this.etmBoardProvider.getExchangeTerminalMoi(string);
                this.ipRI.setEtmBoard(moInstance);
            }
            if ((object = this.getRbs().getCustomerParameter("IubNpcTestConfiguration_externalVpi")) != null && !((String)object).equals("##UNDEFINED")) {
                this.virtualPathRI.setExternalVpi((String)object);
            }
        }
        catch (BemException bemException) {
            BemLog.log(2, this.getClass() + ".update()");
        }
    }

    private boolean isIPConfigured() {
        try {
            String string = this.getRbs().getCustomerParameter("IpIubTestConfiguration_etxSlot");
            if (!string.equals("##UNDEFINED")) {
                return true;
            }
        }
        catch (BemException bemException) {
            BemLog.log(2, this.getClass() + ".isIPConfigured()");
        }
        return false;
    }
}

