/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.iub.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExchangeTerminalIp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimInternalEthernetPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAccessHostEt;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpInterface;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.ReferencedMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class IubRI
extends AbstractResourceItem {
    public static final String name = "IubRI";
    private static final String[] phases = new String[]{"IubCreationPhase"};
    private MoInstance ipAccessHostEtMoi;
    private String etbSlot;
    private String etxSlot;
    private boolean isIp;
    private boolean isAtm;

    public IubRI(Rbs rbs) {
        super(name, rbs, phases);
    }

    private void initialiseMois() throws BemException {
        this.etxSlot = this.rbs.getCustomerParameter("IpIubTestConfiguration_etxSlot");
        this.etbSlot = this.rbs.getCustomerParameter("IubNpcTestConfiguration_etbSlot");
        if (!this.etxSlot.equals("##UNDEFINED")) {
            this.isIp = true;
            MoInstance moInstance = this.rbs.getMoiRefs().getHubSubrackMoi();
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimSlot.MOTYPENAME, this.etxSlot);
            SingleChildMoi singleChildMoi = new SingleChildMoi(fixedRdnMoi, MimPlugInUnit.MOTYPENAME, "1");
            SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimExchangeTerminalIp.MOTYPENAME, "1");
            SingleChildMoi singleChildMoi3 = new SingleChildMoi(singleChildMoi2, MimInternalEthernetPort.MOTYPENAME, "1");
            SingleChildMoi singleChildMoi4 = new SingleChildMoi(singleChildMoi3, MimIpInterface.MOTYPENAME, "1");
            MoInstance moInstance2 = this.rbs.getMoiRefs().getIpSystemMoi();
            this.ipAccessHostEtMoi = new ReferencedMoi(moInstance2, MimIpAccessHostEt.MOTYPENAME, "ipInterfaceMoRef", singleChildMoi4, "1");
        }
        if (!this.etbSlot.equals("##UNDEFINED")) {
            this.isAtm = true;
        }
    }

    public void install(String string) throws BemException {
        if (string.equals("IubCreationPhase")) {
            this.initialiseMois();
            this.installIub();
        }
    }

    private void installIub() throws BemException {
        MoInstance moInstance = this.rbs.getMoiRefs().getIubMoi();
        BemMo bemMo = this.getMo(moInstance.getLdn());
        boolean bl = this.isExisting(bemMo);
        if (!bl) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("atm", this.isAtm), Nal.getFactory().getNameValue("ipV4", !this.isAtm)};
            NalNameValue[] nalNameValueArray2 = new NalNameValue[]{Nal.getFactory().getNameValue("atm", this.isAtm), Nal.getFactory().getNameValue("ipV4", this.isIp)};
            String string = "controlPlaneTransportOption";
            Object object = Nal.getFactory().getStruct(nalNameValueArray);
            vector.add(Nal.getFactory().getNameValue(string, object));
            string = "rbsId";
            object = new Integer(1);
            vector.add(Nal.getFactory().getNameValue(string, object));
            if (this.isIp) {
                string = "userPlaneIpResourceRef";
                BemMo bemMo2 = this.getMo(this.ipAccessHostEtMoi.getLdn());
                vector.add(Nal.getFactory().getNameValue(string, bemMo2));
            }
            string = "userPlaneTransportOption";
            object = Nal.getFactory().getStruct(nalNameValueArray2);
            vector.add(Nal.getFactory().getNameValue(string, object));
            this.create(bemMo, vector);
        }
    }

    public String getLdn() {
        try {
            return this.rbs.getMoiRefs().getIubMoi().getLdn();
        }
        catch (BemException bemException) {
            return null;
        }
    }

    public String getDisplayName() {
        return name;
    }
}

