/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAiDevice;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAiDeviceSet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRruDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class IruRI
extends AbstractDbControlledAuxillaryUnitRI {
    public static final String name = "IRU";
    public static final String WIZARD_SWALLOC_ROLE_IRU = "RBS_IRU";
    public static final String WIZARD_REPERTOIRE_IRU = "RBS_IRU";
    private static final String piuTypeProductName = "IRU";
    private boolean lockSecondAiDevice = false;
    private String ldn;
    private String auxPiuLdn;
    private MoInstance auxPiuMoi;
    private MoInstance boardMoi;
    private MoHandler moHandler;
    private int slotNumber;

    public IruRI(Rbs rbs, MoInstance moInstance, int n) throws BemException {
        super("IRU", rbs, 27, "IRU", "CONTROLLER_OF_RADIO_UNIT_POSITION_" + n);
        this.setSwLoadable(true);
        this.setRoleForSwAllocation("RBS_IRU");
        this.addRepertoiresToInstall("RBS_IRU");
        this.slotNumber = n;
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimRbsSlot.MOTYPENAME, String.valueOf(n));
        this.auxPiuMoi = new SingleChildMoi(fixedRdnMoi, MimAuxPlugInUnit.MOTYPENAME, "1");
        this.boardMoi = new SingleChildMoi(this.auxPiuMoi, MimRruDeviceGroup.MOTYPENAME, "IRU");
        this.auxPiuLdn = this.auxPiuMoi.getLdn();
        this.ldn = this.boardMoi.getLdn();
        this.moHandler = rbs.getMoHandler();
        this.addRepertoiresToInstall("RBS_IRU");
    }

    public IruRI(Rbs rbs, int n) throws BemException {
        super("IRU", rbs, 27, "IRU", AtfProvider.ALL_CONTROLLERS_OF_IRU_INDEXED_BY_SECTOR[n]);
        this.setSwLoadable(true);
        this.setRoleForSwAllocation("RBS_IRU");
        this.addRepertoiresToInstall("RBS_IRU");
        MoInstance moInstance = rbs.getEquipmentMoi();
        this.auxPiuMoi = new FixedRdnMoi(moInstance, MimAuxPlugInUnit.MOTYPENAME, new Integer(n).toString());
        this.auxPiuLdn = this.auxPiuMoi.getLdn();
        this.boardMoi = new SingleChildMoi(this.auxPiuMoi, MimRruDeviceGroup.MOTYPENAME, "IRU");
        this.ldn = this.boardMoi.getLdn();
    }

    public void install(String string) throws BemException {
        super.install(string);
        if (string.equals("LockPhase") || string.equals("UnlockPhase")) {
            this.lockOrUnlockSecondAiDevice();
        }
    }

    public void setSecondAiLocked(boolean bl) {
        this.lockSecondAiDevice = bl;
    }

    private void lockOrUnlockSecondAiDevice() throws BemException {
        try {
            String string = this.ldn + "," + MimAiDeviceSet.MOTYPENAME + "=1," + MimAiDevice.MOTYPENAME + "=2";
            BemMo bemMo = this.moHandler.getMo(string);
            Integer n = (Integer)this.moHandler.getAttribute(bemMo, "administrativeState");
            if (this.lockSecondAiDevice) {
                if (n != null && n == 1) {
                    this.moHandler.setAttribute(bemMo, "administrativeState", new Integer(0));
                }
            } else if (n != null && n == 0) {
                this.moHandler.setAttribute(bemMo, "administrativeState", new Integer(1));
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string = moHandlerException.getAction();
            throw new BemException(string, this.ldn, (Throwable)moHandlerException);
        }
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getAuxPiuLdn() {
        return this.auxPiuLdn;
    }

    public String getDisplayName() {
        return "IRU:" + this.ldn;
    }
}

