/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DigitalCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FreeConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioInterfaceBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RfCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuwRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.AbstractCableSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.AbstractRadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRfCable;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;

public class RB6B
extends AbstractRadioBuildingBlock {
    public static final String name = "RB6B";
    private static final int NOT_USED = -1;
    private static final int NO_OF_CARRIERS = 4;
    private static final int NO_OF_RUS = 0;
    private static final int NO_OF_TX_BRANCHES = 2;
    private Rbs rbs;
    private List ris = new ArrayList();
    private DigitalCableRI digitalCable1 = null;
    private DigitalCableRI digitalCable2 = null;
    private DigitalCableRI digitalCable3 = null;
    private DigitalCableRI digitalCable4 = null;
    private RfCableRI rxA1RfCable = null;
    private RfCableRI rxB1RfCable = null;
    private RuwRI ruw1 = null;
    private RuwRI ruw2 = null;
    private RadioInterfaceBoard ruif1 = null;
    private RadioInterfaceBoard ruif2 = null;
    private int[][] carriersInBaseBandPool = new int[][]{{1, 2}, {3, 4}};
    private int dcElectricalDelay;
    private int rfElectricalUlDelay;
    private int rfUlAttenuation;
    List freeConnectors;
    ReservedConnectorRI[][] reservedConnectors;

    public RB6B(Rbs rbs, int n, RuwRI ruwRI, RuwRI ruwRI2, RadioInterfaceBoard radioInterfaceBoard, RadioInterfaceBoard radioInterfaceBoard2, int n2, int n3, int n4, int n5, int n6) throws BemException {
        super(name, n, 4, 0, 2, new RadioInterfaceBoard[]{radioInterfaceBoard, radioInterfaceBoard2});
        this.rbs = rbs;
        this.ruw1 = ruwRI;
        this.ruw2 = ruwRI2;
        this.ruif1 = radioInterfaceBoard;
        this.ruif2 = radioInterfaceBoard2;
        this.dcElectricalDelay = n2;
        this.rfElectricalUlDelay = n3;
        this.rfUlAttenuation = n5;
        this.createResourceItems();
    }

    public void setRadioIfConnectors(ReservedConnectorRI reservedConnectorRI, ReservedConnectorRI reservedConnectorRI2, ReservedConnectorRI reservedConnectorRI3, ReservedConnectorRI reservedConnectorRI4, ReservedConnectorRI reservedConnectorRI5, ReservedConnectorRI reservedConnectorRI6) {
        ReservedConnectorRI[][] reservedConnectorRIArrayArray = new ReservedConnectorRI[][]{{reservedConnectorRI6, reservedConnectorRI5}, {reservedConnectorRI4, reservedConnectorRI3}, {reservedConnectorRI2, reservedConnectorRI}, {reservedConnectorRI6, reservedConnectorRI5}, {reservedConnectorRI4, reservedConnectorRI3}, {reservedConnectorRI2, reservedConnectorRI}};
        this.reservedConnectors = reservedConnectorRIArrayArray;
    }

    private void createResourceItems() throws BemException {
        this.ris.add(this.ruw1);
        this.ris.add(this.ruw2);
        this.freeConnectors = new ArrayList();
        String string = this.ruw1.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string, 13, MimRfCable.MOTYPENAME, "objectAConnector"));
        String string2 = this.ruw2.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string2, 13, MimRfCable.MOTYPENAME, "objectAConnector"));
        this.digitalCable1 = new DigitalCableRI(this.rbs, this.ruif1.getLdn(), this.getDigitalCableConnectorA(1), this.ruw1.getLdn(), 1, this.dcElectricalDelay);
        this.ris.add(this.digitalCable1);
        this.digitalCable2 = new DigitalCableRI(this.rbs, this.ruif1.getLdn(), this.getDigitalCableConnectorA(2), this.ruw1.getLdn(), 2, this.dcElectricalDelay);
        this.ris.add(this.digitalCable2);
        this.digitalCable3 = new DigitalCableRI(this.rbs, this.ruif2.getLdn(), this.getDigitalCableConnectorA(1), this.ruw2.getLdn(), 1, this.dcElectricalDelay);
        this.ris.add(this.digitalCable3);
        this.digitalCable4 = new DigitalCableRI(this.rbs, this.ruif2.getLdn(), this.getDigitalCableConnectorA(2), this.ruw2.getLdn(), 2, this.dcElectricalDelay);
        this.ris.add(this.digitalCable4);
        this.rxA1RfCable = new RfCableRI(this.rbs, this.ruw1.getLdn(), 12, this.ruw2.getLdn(), 22, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxA1RfCable);
        this.rxB1RfCable = new RfCableRI(this.rbs, this.ruw2.getLdn(), 12, this.ruw1.getLdn(), 22, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxB1RfCable);
    }

    public List getResourceItems() throws BemException {
        this.ruw1.setSecondAiLocked(false);
        this.ruw2.setSecondAiLocked(false);
        return this.ris;
    }

    public List getAllocatedResources() {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        arrayList.add(this.ruw1);
        arrayList.add(this.ruw2);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1][0]);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1][1]);
        return arrayList;
    }

    private int getDigitalCableConnectorA(int n) throws BemException {
        int n2 = 0;
        int n3 = this.getSectorNo();
        int[][] nArrayArray = new int[][]{{6, 5}, {4, 3}, {2, 1}, {6, 5}, {4, 3}, {2, 1}};
        n2 = nArrayArray[n3 - 1][n - 1];
        return n2;
    }

    public Integer getTerminationConnector(String string) throws BemException {
        Integer n = null;
        if (!string.equalsIgnoreCase("A") && !string.equalsIgnoreCase("B")) {
            throw new BemException(this.getClass().getName() + " getAntFeederCableConnectorA(): Antenna branch " + string + " not supported");
        }
        n = new Integer(1);
        return n;
    }

    public String getTerminationObject(String string) throws BemException {
        String string2 = null;
        if (string.equalsIgnoreCase("A")) {
            string2 = this.ruw1.getAuxPiuLdn();
        } else if (string.equalsIgnoreCase("B")) {
            string2 = this.ruw2.getAuxPiuLdn();
        } else {
            throw new BemException(this.getClass().getName() + " getFuReference(): Antenna branch " + string + " not supported");
        }
        return string2;
    }

    protected List getFreeConnectors() {
        return this.freeConnectors;
    }

    public void updateCableCharacteristics(AbstractCableSet abstractCableSet, int n) throws BemException {
        NalNameValue[] nalNameValueArray = null;
        nalNameValueArray = abstractCableSet.getRxACableAttributes(n);
        this.rxA1RfCable.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getRxBCableAttributes(n);
        this.rxB1RfCable.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getData1CableAttributes(n);
        this.digitalCable1.setAttributes(nalNameValueArray);
        this.digitalCable3.setAttributes(nalNameValueArray);
        this.digitalCable2.setAttributes(nalNameValueArray);
        this.digitalCable4.setAttributes(nalNameValueArray);
    }

    public int minNumberOfCarriers() {
        return 4;
    }

    public int getNoOfRuws() {
        return 2;
    }

    public boolean isDualRadioInterfaceBoardNeeded() {
        return true;
    }

    public boolean isEulInTwoBaseBandPoolsSupported() {
        return true;
    }

    public int[] getCarriersInBasebandPool(int n) {
        return this.carriersInBaseBandPool[n];
    }

    public List getAtfRoleMapping() {
        ArrayList<RadioBuildingBlock.SlotToBBPools> arrayList = new ArrayList<RadioBuildingBlock.SlotToBBPools>();
        arrayList.add(new RadioBuildingBlock.SlotToBBPools(this.ruw1.getSlotNumber(), new int[]{0}));
        arrayList.add(new RadioBuildingBlock.SlotToBBPools(this.ruw2.getSlotNumber(), new int[]{1}));
        return arrayList;
    }

    public int[] getSupportedTxDivRange() {
        return new int[]{1};
    }
}

