/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.ConfigurationCableData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.AbstractRadioEquipmentCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIntJumperCable;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.moi.CableMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;

public class IntJumperCableRI
extends AbstractRadioEquipmentCableRI {
    public static final String NAME = "IntJumperCable";
    private ConfigurationCableData cableData;
    private CableMoi moi;
    private String ldn;
    private String aiuLdn;
    private String cfLdn;
    private Integer aiuConnector;
    private String cfConnector;
    private String outputPower;
    private String branch;
    private String branchForExternalOutputPower;

    public IntJumperCableRI(Rbs rbs, String string, Integer n, String string2, String string3, int n2, String string4, ConfigurationCableData configurationCableData, String string5) throws BemException {
        super(rbs, NAME, configurationCableData, string5);
        this.cableData = configurationCableData;
        this.aiuLdn = string;
        this.aiuConnector = n;
        this.cfLdn = string2;
        this.cfConnector = string3;
        MoHandler moHandler = rbs.getMoHandler();
        this.moi = new CableMoi(MimIntJumperCable.MOTYPENAME, "A_AND_B", "aiuPlugInUnitRef", moHandler.getMo(string), "aiuConnector", n, "connectionFieldRef", moHandler.getMo(string2), "connFieldConnector", string3, "" + this.getIndentity(n2, string4));
        this.ldn = this.moi.getLdn();
        this.outputPower = string5;
        this.branch = string4;
    }

    public void setBranchForExternalOutputPower() {
        if (this.outputPower.equals("EXTERNAL")) {
            this.branchForExternalOutputPower = this.branch;
        }
    }

    public void install(String string) throws BemException {
        NalNameValue[] nalNameValueArray;
        if (!string.equals("CabinetCableCreationPhase")) {
            return;
        }
        String string2 = this.getLdn();
        if (this.branchForExternalOutputPower == null) {
            nalNameValueArray = this.cableData.getDelayAndAttenuationAttributes(MimIntJumperCable.MOTYPENAME, this.outputPower);
        } else if (this.branchForExternalOutputPower.equals(MimAntennaBranchDef.BRANCH_A) || this.branchForExternalOutputPower.equals(MimAntennaBranchDef.BRANCH_B)) {
            nalNameValueArray = this.cableData.getDelayAndAttenuationAttributes(MimIntJumperCable.MOTYPENAME, this.outputPower, this.branchForExternalOutputPower);
        } else {
            throw new BemException("Illegal branch string name" + this.branchForExternalOutputPower);
        }
        if (this.isInstalled()) {
            for (int i = 0; i < nalNameValueArray.length; ++i) {
                this.setAttribute(string2, nalNameValueArray[i].getName(), nalNameValueArray[i].getValue());
            }
        } else {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            for (int i = 0; i < nalNameValueArray.length; ++i) {
                vector.add(nalNameValueArray[i]);
            }
            NalNameValue[] nalNameValueArray2 = this.getInstallationAttributes();
            for (int i = 0; i < nalNameValueArray2.length; ++i) {
                vector.add(nalNameValueArray2[i]);
            }
            this.createMoIfNotExisting(string2, vector);
        }
    }

    public String getDisplayName() {
        return "IntJumperCable:" + this.ldn;
    }

    public String getLdn() {
        return this.ldn;
    }

    public Object getConnectorA() {
        return this.aiuConnector;
    }

    public Object getConnectorB() {
        return this.cfConnector;
    }

    public NalNameValue[] getInstallationAttributes() {
        return this.moi.getAttributes();
    }

    private int getIndentity(int n, String string) {
        int n2 = 1;
        if (string.equals(MimAntennaBranchDef.BRANCH_A)) {
            n2 = 1;
        } else if (string.equals(MimAntennaBranchDef.BRANCH_B)) {
            n2 = 2;
        } else {
            throw new Error("Unknown branch: " + string);
        }
        return 2 * (n - 1) + n2;
    }

    public String toString() {
        return "IntJumperCable: aiuPlugInUnitRef " + this.aiuLdn + ", " + "aiuConnector" + " " + this.aiuConnector + ", " + "connectionFieldRef" + " " + this.cfLdn + ", " + "connFieldConnector" + " " + this.cfConnector;
    }
}

