/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.serverconfig;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.serverconfig.ServerConfigCI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimManagedElementData;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class TimeSettingRI
extends AbstractResourceItem
implements CustomerParameterListener {
    public static final String name = "TimeSetting";
    private static final String[] phases = new String[]{"TimeSettingPhase", "NtpSettingPhase"};
    private final String ldn;
    private Enumeration localTimeZoneCP;
    private YesNoCustomerParameter daylightSavingTimeCP;
    private YesNoCustomerParameter ntpServerPrimaryIpActiveCP;
    private YesNoCustomerParameter ntpServerSecondaryIpActiveCP;
    private IpAddressParameter ntpServerPrimaryIpAddressCP;
    private IpAddressParameter ntpServerSecondaryIpAddressCP;
    private final Vector allCustomerParameters = new Vector();
    private final BemMo managedElementDataMo;
    private static final int NTP_PRIMARY_ADRESS_INDEX = 0;
    private static final int NTP_PRIMARY_ACTIVE_INDEX = 1;
    private static final int NTP_SECONDARY_ADRESS_INDEX = 2;
    private static final int NTP_SECONDARY_ACTIVE_INDEX = 3;
    private final ParameterRestriction restrictionNtpActiveOptional = new ParameterRestriction("", 2);
    private final ParameterRestriction restrictionOptional = new ParameterRestriction("", 2);
    private final ParameterRestriction restrictionPrimaryOptional = new ParameterRestriction("", 2);
    private final ParameterRestriction restrictionPrimaryMandatory = new ParameterRestriction("primaryNtpServerIpAddress is mandatory because primaryNtpServiceActive is set to true.", 3);
    private final ParameterRestriction restrictionSecondaryOptional = new ParameterRestriction("", 2);
    private final ParameterRestriction restrictionSecondaryMandatory = new ParameterRestriction("secondaryNtpServerIpAddress is mandatory because secondaryNtpServiceActive is set to true.", 3);
    private final ServerConfigCI serverConfigCI;

    public TimeSettingRI(Rbs rbs, ServerConfigCI serverConfigCI) throws BemException {
        super(name, rbs, phases);
        this.serverConfigCI = serverConfigCI;
        this.ldn = this.rbs.getMoiRefs().getManagedElementDataMoi().getLdn();
        this.managedElementDataMo = super.getMo(this.ldn);
        this.setupCustomerParameters();
    }

    private void setupCustomerParameters() throws BemException {
        this.setupNtpCustomerParameters();
        this.setupLocalTimeZoneCustomerParameter();
        this.setupDaylightSavingTimeCustomerParameter();
    }

    public boolean isInstalled() {
        return true;
    }

    boolean shouldRiBeInstalled() {
        boolean bl = false;
        for (int i = 0; i < this.allCustomerParameters.size(); ++i) {
            CustomerParameter customerParameter = (CustomerParameter)this.allCustomerParameters.get(i);
            if (!customerParameter.hasValueChanged()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void install(String string) throws BemException {
        if (string.equals("TimeSettingPhase")) {
            this.installTime();
        } else if (string.equals("NtpSettingPhase")) {
            this.installNtp();
        }
    }

    private void installTime() throws BemException {
        NalNameValue nalNameValue;
        Vector<NalNameValue> vector = new Vector<NalNameValue>(0, 1);
        if (this.localTimeZoneCP.hasValueChanged()) {
            nalNameValue = Nal.getFactory().getNameValue("nodeLocalTimeZone", this.localTimeZoneCP.getValue());
            vector.add(nalNameValue);
        }
        if (this.daylightSavingTimeCP.hasValueChanged()) {
            nalNameValue = Nal.getFactory().getNameValue("daylightSavingTime", this.daylightSavingTimeCP.getBooleanObject());
            vector.add(nalNameValue);
        }
        if (vector.size() > 0) {
            super.setAttributes(this.managedElementDataMo, vector);
        }
    }

    private void installNtp() throws BemException {
        String string;
        boolean bl;
        if (this.isAnyChanged(this.ntpServerPrimaryIpActiveCP, this.ntpServerPrimaryIpAddressCP)) {
            bl = this.isNtpCreated("ntpServiceActivePrimary");
            if (bl) {
                string = this.ntpServerPrimaryIpAddressCP.getValue();
                if (string.equals("")) {
                    super.action(this.managedElementDataMo, "deleteNtpPrimary", new NalNameValue[0]);
                } else {
                    this.updateChangedNtpAttributesOnRbs("ntpServiceActivePrimary", this.ntpServerPrimaryIpActiveCP, "ntpServerAddressPrimary", this.ntpServerPrimaryIpAddressCP);
                }
            } else if (this.ntpServerPrimaryIpActiveCP.getBooleanValue()) {
                this.createNtpAttributesOnRbs("createNtpPrimary", "ntpServiceActivePrimary", this.ntpServerPrimaryIpActiveCP, "ntpServerAddressPrimary", this.ntpServerPrimaryIpAddressCP, "ntpMinPollPrimary", MimManagedElementData.DEFAULT_NTPMINPOLLPRIMARY, "ntpMaxPollPrimary", MimManagedElementData.DEFAULT_NTPMAXPOLLPRIMARY, "ntpBurstFlagPrimary", MimManagedElementData.DEFAULT_NTPBURSTFLAGPRIMARY);
            }
        }
        if (this.isAnyChanged(this.ntpServerSecondaryIpActiveCP, this.ntpServerSecondaryIpAddressCP)) {
            bl = this.isNtpCreated("ntpServiceActiveSecondary");
            if (bl) {
                string = this.ntpServerSecondaryIpAddressCP.getValue();
                if (string.equals("")) {
                    super.action(this.managedElementDataMo, "deleteNtpSecondary", new NalNameValue[0]);
                } else {
                    this.updateChangedNtpAttributesOnRbs("ntpServiceActiveSecondary", this.ntpServerSecondaryIpActiveCP, "ntpServerAddressSecondary", this.ntpServerSecondaryIpAddressCP);
                }
            } else if (this.ntpServerSecondaryIpActiveCP.getBooleanValue()) {
                this.createNtpAttributesOnRbs("createNtpSecondary", "ntpServiceActiveSecondary", this.ntpServerSecondaryIpActiveCP, "ntpServerAddressSecondary", this.ntpServerSecondaryIpAddressCP, "ntpMinPollSecondary", MimManagedElementData.DEFAULT_NTPMINPOLLSECONDARY, "ntpMaxPollSecondary", MimManagedElementData.DEFAULT_NTPMAXPOLLSECONDARY, "ntpBurstFlagSecondary", MimManagedElementData.DEFAULT_NTPBURSTFLAGSECONDARY);
            }
        }
    }

    private boolean isAnyChanged(CustomerParameter customerParameter, CustomerParameter customerParameter2) {
        boolean bl = false;
        if (customerParameter.hasValueChanged() || customerParameter2.hasValueChanged()) {
            bl = true;
        }
        return bl;
    }

    private void createNtpAttributesOnRbs(String string, String string2, CustomerParameter customerParameter, String string3, CustomerParameter customerParameter2, String string4, Integer n, String string5, Integer n2, String string6, Boolean bl) throws BemException {
        NalNameValue[] nalNameValueArray = new NalNameValue[5];
        nalNameValueArray[0] = Nal.getFactory().getNameValue(string3, customerParameter2.getValue());
        nalNameValueArray[1] = Nal.getFactory().getNameValue(string4, n);
        nalNameValueArray[2] = Nal.getFactory().getNameValue(string5, n2);
        nalNameValueArray[3] = Nal.getFactory().getNameValue(string6, bl);
        String string7 = customerParameter.getValue();
        String string8 = this.translateYesNoToBoolean(string7);
        Boolean bl2 = Boolean.valueOf(string8);
        nalNameValueArray[4] = Nal.getFactory().getNameValue(string2, bl2);
        super.action(this.managedElementDataMo, string, nalNameValueArray);
    }

    private void updateChangedNtpAttributesOnRbs(String string, CustomerParameter customerParameter, String string2, CustomerParameter customerParameter2) throws BemException {
        Object object;
        Vector<Object> vector = new Vector<Object>(0, 1);
        if (customerParameter.hasValueChanged()) {
            object = customerParameter.getValue();
            String string3 = this.translateYesNoToBoolean((String)object);
            Boolean bl = Boolean.valueOf(string3);
            NalNameValue nalNameValue = Nal.getFactory().getNameValue(string, bl);
            vector.add(nalNameValue);
        }
        if (customerParameter2.hasValueChanged()) {
            object = Nal.getFactory().getNameValue(string2, customerParameter2.getValue());
            vector.add(object);
        }
        super.setAttributes(this.managedElementDataMo, vector);
    }

    private boolean isNtpCreated(String string) throws BemException {
        boolean bl = false;
        Object object = null;
        try {
            object = super.getAttribute(this.managedElementDataMo, string);
            this.setAttribute(this.managedElementDataMo, string, object);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return name;
    }

    private void setupLocalTimeZoneCustomerParameter() throws BemException {
        String[] stringArray = new String[]{"", "GMT", "UTC", "ECT", "EET", "ART", "EAT", "MET", "NET", "PLT", "IST", "BST", "VST", "CTT", "JST", "EST", "AET", "SST", "NST", "CAT", "AGT", "BET", "CNT", "PRT", "IET", "ACT", "PNT", "MSG", "PST", "AST", "HST", "MIT"};
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        this.localTimeZoneCP = new Enumeration("localTimeZone", enumeratedRange);
        String string = null;
        string = (String)super.getAttribute(this.managedElementDataMo, "nodeLocalTimeZone");
        this.localTimeZoneCP.setLoadedValue(string);
        if (string.equals("")) {
            this.localTimeZoneCP.setValue("UTC");
        }
        this.serverConfigCI.addParameter(this.localTimeZoneCP);
        this.allCustomerParameters.add(this.localTimeZoneCP);
        this.localTimeZoneCP.addRestriction(this.restrictionOptional);
    }

    private void setupDaylightSavingTimeCustomerParameter() throws BemException {
        this.daylightSavingTimeCP = new YesNoCustomerParameter("daylightSavingTime");
        Boolean bl = null;
        String string = "";
        bl = (Boolean)super.getAttribute(this.managedElementDataMo, "daylightSavingTime");
        if (bl != null) {
            string = bl.toString();
        }
        this.daylightSavingTimeCP.setLoadedValue(string);
        this.serverConfigCI.addParameter(this.daylightSavingTimeCP);
        this.allCustomerParameters.add(this.daylightSavingTimeCP);
        this.daylightSavingTimeCP.addRestriction(this.restrictionOptional);
    }

    private void createNtpCustomerParameters(NalNameValue[] nalNameValueArray) {
        this.ntpServerPrimaryIpActiveCP = new YesNoCustomerParameter("primaryNtpServiceActive");
        this.ntpServerPrimaryIpAddressCP = new IpAddressParameter("primaryNtpServerIpAddress", new IpAddressRange());
        String string = this.translateBooleanToYesNo(nalNameValueArray[1].getValue().toString());
        this.ntpServerPrimaryIpActiveCP.setLoadedValue(string);
        this.ntpServerPrimaryIpAddressCP.setLoadedValue(nalNameValueArray[0].getValue());
        String string2 = this.ntpServerPrimaryIpActiveCP.getValue();
        boolean bl = string2.equalsIgnoreCase("YES");
        this.setRestrictionsForPrimaryActive(bl);
        this.ntpServerPrimaryIpAddressCP.addRestriction(this.restrictionPrimaryOptional);
        this.ntpServerPrimaryIpAddressCP.addRestriction(this.restrictionPrimaryMandatory);
        this.ntpServerPrimaryIpActiveCP.addRestriction(this.restrictionNtpActiveOptional);
        this.ntpServerSecondaryIpActiveCP = new YesNoCustomerParameter("secondaryNtpServiceActive");
        this.ntpServerSecondaryIpAddressCP = new IpAddressParameter("secondaryNtpServerIpAddress", new IpAddressRange());
        String string3 = this.translateBooleanToYesNo(nalNameValueArray[3].getValue().toString());
        this.ntpServerSecondaryIpActiveCP.setLoadedValue(string3);
        this.ntpServerSecondaryIpAddressCP.setLoadedValue(nalNameValueArray[2].getValue());
        String string4 = this.ntpServerSecondaryIpActiveCP.getValue();
        boolean bl2 = string4.equalsIgnoreCase("YES");
        this.setRestrictionsForSecondaryActive(bl2);
        this.ntpServerSecondaryIpAddressCP.addRestriction(this.restrictionSecondaryOptional);
        this.ntpServerSecondaryIpAddressCP.addRestriction(this.restrictionSecondaryMandatory);
        this.ntpServerSecondaryIpActiveCP.addRestriction(this.restrictionNtpActiveOptional);
        this.ntpServerPrimaryIpActiveCP.addCustomerParameterListener(this);
        this.ntpServerSecondaryIpActiveCP.addCustomerParameterListener(this);
        this.serverConfigCI.addParameter(this.ntpServerPrimaryIpActiveCP);
        this.serverConfigCI.addParameter(this.ntpServerPrimaryIpAddressCP);
        this.serverConfigCI.addParameter(this.ntpServerSecondaryIpActiveCP);
        this.serverConfigCI.addParameter(this.ntpServerSecondaryIpAddressCP);
        this.allCustomerParameters.add(this.ntpServerPrimaryIpActiveCP);
        this.allCustomerParameters.add(this.ntpServerPrimaryIpAddressCP);
        this.allCustomerParameters.add(this.ntpServerSecondaryIpActiveCP);
        this.allCustomerParameters.add(this.ntpServerSecondaryIpAddressCP);
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isValueChanged()) {
            String string = customerParameter.getName();
            if (string.equalsIgnoreCase(this.ntpServerPrimaryIpActiveCP.getName())) {
                String string2 = this.ntpServerPrimaryIpActiveCP.getValue();
                boolean bl = string2.equalsIgnoreCase("YES");
                this.setRestrictionsForPrimaryActive(bl);
            } else if (string.equalsIgnoreCase(this.ntpServerSecondaryIpActiveCP.getName())) {
                String string3 = this.ntpServerSecondaryIpActiveCP.getValue();
                boolean bl = string3.equalsIgnoreCase("YES");
                this.setRestrictionsForSecondaryActive(bl);
            }
        }
    }

    private void setRestrictionsForPrimaryActive(boolean bl) {
        if (bl) {
            this.restrictionPrimaryOptional.setActive(false);
            this.restrictionPrimaryMandatory.setActive(true);
        } else {
            this.restrictionPrimaryOptional.setActive(true);
            this.restrictionPrimaryMandatory.setActive(false);
        }
    }

    private void setRestrictionsForSecondaryActive(boolean bl) {
        if (bl) {
            this.restrictionSecondaryOptional.setActive(false);
            this.restrictionSecondaryMandatory.setActive(true);
        } else {
            this.restrictionSecondaryOptional.setActive(true);
            this.restrictionSecondaryMandatory.setActive(false);
        }
    }

    private NalNameValue[] getNtpValuesFromRbs() {
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("ntpServerAddressPrimary", MimManagedElementData.DEFAULT_NTPSERVERADDRESSPRIMARY), Nal.getFactory().getNameValue("ntpServiceActivePrimary", MimManagedElementData.DEFAULT_NTPSERVICEACTIVEPRIMARY), Nal.getFactory().getNameValue("ntpServerAddressSecondary", MimManagedElementData.DEFAULT_NTPSERVERADDRESSSECONDARY), Nal.getFactory().getNameValue("ntpServiceActiveSecondary", MimManagedElementData.DEFAULT_NTPSERVICEACTIVESECONDARY)};
        try {
            String[] stringArray = new String[nalNameValueArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = nalNameValueArray[i].getName();
            }
            Object[] objectArray = super.getAttributes(this.managedElementDataMo, stringArray);
            for (int i = 0; i < nalNameValueArray.length; ++i) {
                String string = nalNameValueArray[i].getName();
                nalNameValueArray[i] = Nal.getFactory().getNameValue(string, objectArray[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nalNameValueArray;
    }

    private void setupNtpCustomerParameters() {
        NalNameValue[] nalNameValueArray = this.getNtpValuesFromRbs();
        this.createNtpCustomerParameters(nalNameValueArray);
    }

    private String translateBooleanToYesNo(String string) {
        String string2 = string;
        string2 = string.equalsIgnoreCase("true") ? "YES" : "NO";
        return string2;
    }

    private String translateYesNoToBoolean(String string) {
        String string2 = string;
        string2 = string.equalsIgnoreCase("yes") ? "true" : "false";
        return string2;
    }
}

