/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm;

import java.text.MessageFormat;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;

public class AlmDeviceRI
extends AbstractResourceItem {
    public static final String name = "XALM_DEVICE";
    private static final String[] myInstallationPhases = new String[]{"ExternalAlarmCreationPhase"};
    private final String ldn;
    private final String prefix;
    private static final String[] pseudos = new String[]{"alarmSlogan", "normallyOpen", "severity", "probableCause"};
    private static final String[] attributeNames = new String[]{"alarmSlogan", "normallyOpen", "perceivedSeverity", "probableCause"};
    private final Vector savedAttributes = new Vector();
    private String alarmSlogan;
    private Boolean normallyOpen;
    private Integer severity;
    private Integer probableCause;
    private String savedAlarmSlogan;
    private Boolean savedNormallyOpen;
    private Integer savedSeverity;
    private Integer savedProbableCause;
    private final String auType;

    public AlmDeviceRI(Rbs rbs, String string, String string2) {
        super(name, rbs, myInstallationPhases);
        this.ldn = string;
        BemMo bemMo = this.getMo(string);
        String string3 = bemMo.getId();
        this.auType = string2;
        String string4 = PrefixUtil.getFirstCabinetPrefix() + string2 + "ExternalAlarm" + "{0}_";
        this.prefix = MessageFormat.format(string4, string3);
    }

    public AlmDeviceRI(Rbs rbs, String string, String string2, String string3, String string4) {
        super(name, rbs, myInstallationPhases);
        this.ldn = string;
        BemMo bemMo = this.getMo(string);
        String string5 = bemMo.getId();
        this.auType = string2;
        String string6 = "";
        if (string2.equalsIgnoreCase("Rruw")) {
            string6 = PrefixUtil.getFirstCabinetPrefix();
        } else if (string2.equalsIgnoreCase("Iru")) {
            string6 = PrefixUtil.getCabinetPrefix(String.valueOf(0));
        }
        String string7 = string6 + string2 + "ExternalAlarm" + "{0}_";
        String string8 = MessageFormat.format(string7, string5);
        this.prefix = string8 + string3 + "_" + string4 + "_";
    }

    public void setLoadedValues() throws BemException {
        BemMo bemMo = this.getMo(this.ldn);
        for (int i = 0; i < pseudos.length; ++i) {
            String string = this.prefix + pseudos[i];
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string);
            Object object = this.getAttribute(bemMo, attributeNames[i]);
            customerParameterServer.setLoadedValue(object);
        }
    }

    public void install(String string) throws BemException {
        block5: {
            try {
                Object object;
                if (!myInstallationPhases[0].equals(string)) break block5;
                Vector vector = new Vector();
                if (this.savedAttributes.size() == 0) {
                    object = this.rbs.getCustomerParameterServerObject(this.prefix + "alarmSlogan");
                    this.alarmSlogan = (String)object.getValueMom();
                    object = this.rbs.getCustomerParameterServerObject(this.prefix + "normallyOpen");
                    this.normallyOpen = (Boolean)object.getValueMom();
                    object = this.rbs.getCustomerParameterServerObject(this.prefix + "severity");
                    this.severity = (Integer)object.getValueMom();
                    object = this.rbs.getCustomerParameterServerObject(this.prefix + "probableCause");
                    this.probableCause = Integer.valueOf((String)object.getValueMom());
                    vector.add(Nal.getFactory().getNameValue("alarmSlogan", this.alarmSlogan));
                    vector.add(Nal.getFactory().getNameValue("normallyOpen", this.normallyOpen));
                    vector.add(Nal.getFactory().getNameValue("perceivedSeverity", this.severity));
                    vector.add(Nal.getFactory().getNameValue("probableCause", this.probableCause));
                } else {
                    vector = this.savedAttributes;
                    this.alarmSlogan = this.savedAlarmSlogan;
                    this.normallyOpen = this.savedNormallyOpen;
                    this.severity = this.savedSeverity;
                    this.probableCause = this.savedProbableCause;
                }
                if (!this.isExisting(this.ldn)) break block5;
                this.verifyAttributes();
                object = this.getMo(this.ldn);
                Vector vector2 = this.getLoadedValues();
                if (vector2 == null) break block5;
                for (int i = 0; i < vector2.size(); ++i) {
                    if (vector2.elementAt(i).toString().endsWith(vector.elementAt(i).toString())) continue;
                    this.setAlmDeviceAttributes((BemMo)object, vector, this.ldn);
                    break;
                }
            }
            catch (Exception exception) {
                String string2 = "Installing of AlmDevice and setting its attributes";
                String string3 = exception.toString();
                throw new BemException(string2, "AlmDeviceRI.install()", "ldn=" + this.ldn, string3, exception);
            }
        }
    }

    public boolean isInstalled(String string) throws BemException {
        boolean bl = true;
        BemMoImpl bemMoImpl = new BemMoImpl(string);
        if (this.isExisting(bemMoImpl)) {
            String string2 = "administrativeState";
            Integer n = (Integer)this.getAttribute(bemMoImpl, string2);
            if (n == 0) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public void saveAttributes() throws BemException {
        if (this.isExisting(this.ldn)) {
            BemMo bemMo = this.getMo(this.ldn);
            String string = "alarmSlogan";
            String string2 = (String)this.getAttribute(bemMo, string);
            this.savedAttributes.add(Nal.getFactory().getNameValue(string, string2));
            string = "normallyOpen";
            Boolean bl = (Boolean)this.getAttribute(bemMo, string);
            this.savedAttributes.add(Nal.getFactory().getNameValue(string, bl));
            string = "perceivedSeverity";
            Integer n = (Integer)this.getAttribute(bemMo, string);
            this.savedAttributes.add(Nal.getFactory().getNameValue(string, n));
            string = "probableCause";
            Integer n2 = (Integer)this.getAttribute(bemMo, string);
            this.savedAttributes.add(Nal.getFactory().getNameValue(string, n2));
            this.savedAlarmSlogan = string2;
            this.savedNormallyOpen = bl;
            this.savedSeverity = n;
            this.savedProbableCause = n2;
        }
    }

    private void setAlmDeviceAttributes(BemMo bemMo, Vector vector, String string) throws BemException {
        if (vector != null && !vector.isEmpty()) {
            this.lockDevice(string);
            this.setAttributes(bemMo, vector);
            this.unlockDevice(string);
        }
    }

    private void lockDevice(String string) throws BemException {
        String string2;
        Integer n;
        BemMoImpl bemMoImpl = new BemMoImpl(string);
        boolean bl = this.isExisting(bemMoImpl);
        if (bl && (n = (Integer)this.getAttribute(bemMoImpl, string2 = "administrativeState")) == 1) {
            this.setAttribute(new BemMoImpl(string), string2, (Object)new Integer(0));
        }
    }

    private void unlockDevice(String string) throws BemException {
        String string2;
        Integer n;
        BemMoImpl bemMoImpl = new BemMoImpl(string);
        boolean bl = this.isExisting(bemMoImpl);
        if (bl && (n = (Integer)this.getAttribute(bemMoImpl, string2 = "administrativeState")) == 0) {
            this.setAttribute(bemMoImpl, string2, (Object)new Integer(1));
        }
    }

    private Vector getLoadedValues() throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        BemMo bemMo = this.getMo(this.ldn);
        if (this.isExisting(this.ldn)) {
            Object object = this.getAttribute(bemMo, "alarmSlogan");
            vector.add(Nal.getFactory().getNameValue("alarmSlogan", object));
            object = this.getAttribute(bemMo, "normallyOpen");
            vector.add(Nal.getFactory().getNameValue("normallyOpen", object));
            object = this.getAttribute(bemMo, "perceivedSeverity");
            vector.add(Nal.getFactory().getNameValue("perceivedSeverity", object));
            object = this.getAttribute(bemMo, "probableCause");
            vector.add(Nal.getFactory().getNameValue("probableCause", object));
        }
        return vector;
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "XALM_DEVICE: " + this.getLdn();
    }

    private void verifyAttributes() throws BemException {
        if (this.alarmSlogan == null) {
            throw new BemException("AlmDeviceRI.verifyAttributes() alarmSlogan is null for\n" + this.getDisplayName());
        }
        if (this.normallyOpen == null) {
            throw new BemException("AlmDeviceRI.verifyAttributes() normallyOpen is null for\n" + this.getDisplayName());
        }
        if (!this.normallyOpen.toString().equalsIgnoreCase("true") && !this.normallyOpen.toString().equalsIgnoreCase("false")) {
            throw new BemException("AlmDeviceRI.verifyAttributes() normallyOpen is not in range\n" + this.getDisplayName());
        }
        if (this.probableCause == null) {
            throw new BemException("AlmDeviceRI.verifyAttributes() probableCause is null for\n" + this.getDisplayName());
        }
        try {
            new Integer(this.probableCause.toString());
        }
        catch (Exception exception) {
            throw new BemException("AlmDeviceRI.verifyAttributes() probableCause can not be formatted to int.\nValue=" + this.probableCause + "\n" + this.getDisplayName());
        }
        if (this.severity.toString() == null) {
            throw new BemException("AlmDeviceRI.verifyAttributes() severity is null for\n" + this.getDisplayName());
        }
    }

    public String getAuType() {
        return this.auType;
    }
}

