/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm;

import java.text.MessageFormat;
import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.AlmDeviceRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.NormallyOpenConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.OutDeviceRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.SeverityConversion;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAlmDevice;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAlmDeviceSet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOutDevice;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOutDeviceSet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRruDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSector;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SectorAntennaMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class GenericAlarmManager {
    private static final String AUTO_CREATED_RDNID_1 = "1";
    private final Rbs rbs;
    private final String autype;
    private ArrayList almDeviceRIs = null;
    private ArrayList savedAlmDeviceRIs = null;
    private ArrayList outDeviceRIs = null;
    private boolean configuredAlarm = false;
    private MoInstance deviceGroupMoi;
    private MoInstance almDeviceSetMoi;
    private MoInstance outDeviceSetMoi;
    private MoInstance[] almDeviceMois;
    private MoInstance[] outDeviceMois;
    private final int MAX_NO_ALMDEVICES;
    private final int MAX_NO_OUTDEVICES;
    private static final String NOT_CONFIGURED_FOR_USE = "Port is not configured for use";
    private int sectorNumber;
    private int id;
    private StringParameter[] alarmSloganParam;
    private StringParameter[] equipmentParam;
    private IntegerParameter[] portIdParam;
    private IntegerParameter[] portIdOutParam;
    private YesNoCustomerParameter[] normallyOpenParam;
    private YesNoCustomerParameter[] normallyOpenOutParam;
    private Enumeration[] sectorNumberParam;
    private Enumeration[] rruwPositionInSectorParam;
    private Enumeration[] severityParam;
    private Enumeration[] externalAlarmUnitParam;
    private Enumeration[] externalAlarmUnitOutParam;
    private Enumeration[] probableCauseParam;
    private ParameterRestriction[] configurePortRestrictionAlmDevice;
    private ParameterRestriction[] configurePortRestrictionOutDevice;
    private ParameterRestriction portIdRange;
    private static final String[] almDevicePseudos = new String[]{"sectorNumber", "rruwPositionInSector", "alarmSlogan", "probableCause", "normallyOpen", "severity", "portId", "externalAlarmUnit"};
    private static final String[] outDevicePseudos = new String[]{"normallyOpen", "equipmentName", "portId", "externalAlarmUnit"};

    public GenericAlarmManager(Rbs rbs, MoInstance moInstance, String string, int n, int n2) {
        this.rbs = rbs;
        this.deviceGroupMoi = moInstance;
        this.MAX_NO_ALMDEVICES = n;
        this.MAX_NO_OUTDEVICES = n2;
        this.autype = string;
        try {
            this.initMoiResources();
        }
        catch (BemException bemException) {
            bemException.printStackTrace();
        }
        this.initPortRestrictionAlmDevice();
        this.initPortRestrictionOutDevice();
    }

    public GenericAlarmManager(Rbs rbs, MoInstance moInstance, String string, int n, int n2, int n3, int n4) {
        this.rbs = rbs;
        this.deviceGroupMoi = moInstance;
        this.MAX_NO_ALMDEVICES = n;
        this.MAX_NO_OUTDEVICES = n2;
        this.sectorNumber = n3;
        this.id = n4;
        this.autype = string;
        try {
            this.initMoiResources();
        }
        catch (BemException bemException) {
            bemException.printStackTrace();
        }
        this.initPortRestrictionAlmDevice();
        this.initPortRestrictionOutDevice();
    }

    protected void initMoiResources() throws BemException {
        int n;
        if (this.deviceGroupMoi == null) {
            FixedRdnMoi fixedRdnMoi;
            String string = String.valueOf(this.sectorNumber);
            MoInstance moInstance = this.rbs.getEquipmentMoi();
            MoInstance moInstance2 = this.rbs.getNodeBFunctionMoi();
            FixedRdnMoi fixedRdnMoi2 = new FixedRdnMoi(moInstance2, MimSector.MOTYPENAME, string);
            SectorAntennaMoi sectorAntennaMoi = null;
            int n2 = 0;
            if (this.rbs.isPantherHybridRbs() && this.sectorNumber > 6) {
                n2 = 1;
            }
            RadioEquipmentProvider radioEquipmentProvider = this.rbs.getRadioEquipmentProvider(n2);
            if (this.autype.equalsIgnoreCase("IRU")) {
                fixedRdnMoi = new FixedRdnMoi(moInstance, MimAuxPlugInUnit.MOTYPENAME, "IRU-" + this.sectorNumber + "-" + AUTO_CREATED_RDNID_1);
                this.deviceGroupMoi = new SingleChildMoi(fixedRdnMoi, MimRruDeviceGroup.MOTYPENAME, "IRU");
            } else {
                sectorAntennaMoi = this.sectorNumber > 0 && radioEquipmentProvider.getNumberOfSupportedRxBranches(this.sectorNumber) > 2 && this.id > 1 ? new SectorAntennaMoi(moInstance, fixedRdnMoi2, this.sectorNumber, 2) : new SectorAntennaMoi(moInstance, fixedRdnMoi2, this.sectorNumber, 1);
                fixedRdnMoi = new FixedRdnMoi(sectorAntennaMoi, MimAuxPlugInUnit.MOTYPENAME, "RRUW-" + this.id);
                this.deviceGroupMoi = new SingleChildMoi(fixedRdnMoi, MimRruDeviceGroup.MOTYPENAME, AUTO_CREATED_RDNID_1);
            }
        }
        this.almDeviceSetMoi = new SingleChildMoi(this.deviceGroupMoi, MimAlmDeviceSet.MOTYPENAME, AUTO_CREATED_RDNID_1);
        this.outDeviceSetMoi = new SingleChildMoi(this.deviceGroupMoi, MimOutDeviceSet.MOTYPENAME, AUTO_CREATED_RDNID_1);
        this.almDeviceMois = new MoInstance[this.MAX_NO_ALMDEVICES];
        this.outDeviceMois = new MoInstance[this.MAX_NO_OUTDEVICES];
        for (n = 0; n < this.MAX_NO_ALMDEVICES; ++n) {
            int n3 = n + 1;
            this.almDeviceMois[n] = new FixedRdnMoi(this.almDeviceSetMoi, MimAlmDevice.MOTYPENAME, "" + n3);
        }
        for (n = 0; n < this.MAX_NO_OUTDEVICES; ++n) {
            int n4 = n + 1;
            this.outDeviceMois[n] = new FixedRdnMoi(this.outDeviceSetMoi, MimOutDevice.MOTYPENAME, "" + n4);
        }
    }

    private void initPortRestrictionAlmDevice() {
        this.configurePortRestrictionAlmDevice = new ParameterRestriction[this.MAX_NO_ALMDEVICES];
        for (int i = 0; i < this.MAX_NO_ALMDEVICES; ++i) {
            this.configurePortRestrictionAlmDevice[i] = new ParameterRestriction(NOT_CONFIGURED_FOR_USE, 1);
        }
    }

    private void initPortRestrictionOutDevice() {
        this.configurePortRestrictionOutDevice = new ParameterRestriction[this.MAX_NO_OUTDEVICES];
        for (int i = 0; i < this.MAX_NO_OUTDEVICES; ++i) {
            this.configurePortRestrictionOutDevice[i] = new ParameterRestriction(NOT_CONFIGURED_FOR_USE, 1);
        }
    }

    public void createAlmdeviceRIs(ServiceValue serviceValue) throws BemException {
        ArrayList<AlmDeviceRI> arrayList = new ArrayList<AlmDeviceRI>();
        String string = this.getAutype();
        for (int i = 0; i < this.MAX_NO_ALMDEVICES; ++i) {
            int n = i + 1;
            String string2 = PrefixUtil.getFirstCabinetPrefix() + string + MessageFormat.format("ExternalAlarm{0}_", new Integer(n));
            String string3 = string2 + "alarmSlogan";
            String string4 = serviceValue.getValue(string3);
            string3 = string2 + "normallyOpen";
            String string5 = serviceValue.getValue(string3);
            string3 = string2 + "severity";
            String string6 = serviceValue.getValue(string3);
            string3 = string2 + "probableCause";
            String string7 = serviceValue.getValue(string3);
            if (!(string4 != null && string4.length() != 0 || string7 != null && string7.length() != 0 || string5 != null && string5.length() != 0) && (string6 == null || string6.length() == 0)) continue;
            String string8 = this.almDeviceMois[i].getLdn();
            AlmDeviceRI almDeviceRI = new AlmDeviceRI(this.rbs, string8, string);
            if (almDeviceRI.isExisting(string8)) {
                almDeviceRI.setLoadedValues();
            }
            arrayList.add(almDeviceRI);
        }
        this.almDeviceRIs = arrayList;
    }

    public void createAlmdeviceRIs() throws BemException {
        ArrayList<AlmDeviceRI> arrayList = new ArrayList<AlmDeviceRI>();
        String string = this.getAutype();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        for (int i = 0; i < this.MAX_NO_ALMDEVICES; ++i) {
            AlmDeviceRI almDeviceRI;
            String string5 = this.almDeviceMois[i].getLdn();
            if (string.equalsIgnoreCase("Rruw")) {
                string2 = this.getSectorNumber();
                string3 = this.getInternalRruwNumber();
                string4 = this.getPortIdRruw();
                almDeviceRI = new AlmDeviceRI(this.rbs, string5, string, string2, string3);
            } else if (string.equalsIgnoreCase("Iru")) {
                string2 = this.getSectorNumberForIru();
                almDeviceRI = new AlmDeviceRI(this.rbs, string5, string, string2, String.valueOf(this.id));
                string4 = this.getPortId(string5);
            } else {
                almDeviceRI = new AlmDeviceRI(this.rbs, string5, string);
                string4 = this.getPortId(string5);
            }
            if (almDeviceRI.isExisting(string5)) {
                String string6 = almDeviceRI.getAuType();
                if (!string.equalsIgnoreCase("Xalm")) {
                    this.externalAlarmUnitParam[i].setLoadedValue(string6);
                }
                if (string.equalsIgnoreCase("rruw")) {
                    if (this.sectorNumberParam != null && this.sectorNumberParam[i] != null) {
                        this.sectorNumberParam[i].setLoadedValue(string2);
                    }
                    if (this.rruwPositionInSectorParam != null && this.rruwPositionInSectorParam[i] != null) {
                        this.rruwPositionInSectorParam[i].setLoadedValue(string3);
                    }
                }
                if (this.portIdParam != null && this.portIdParam[i] != null) {
                    this.portIdParam[i].setLoadedValue(string4);
                }
                almDeviceRI.setLoadedValues();
                if (!this.rbs.getRbsStep().equals("STEP_CABINET")) {
                    this.configurePortRestrictionAlmDevice[i].setActive(false);
                }
            }
            arrayList.add(almDeviceRI);
        }
        this.almDeviceRIs = arrayList;
    }

    public void createOutDeviceRIs() throws BemException {
        ArrayList<OutDeviceRI> arrayList = new ArrayList<OutDeviceRI>();
        String string = this.getAutype();
        for (int i = 0; i < this.MAX_NO_OUTDEVICES; ++i) {
            String string2 = this.outDeviceMois[i].getLdn();
            OutDeviceRI outDeviceRI = new OutDeviceRI(this.rbs, string2, string);
            if (outDeviceRI.isExisting(string2)) {
                if (!string.equalsIgnoreCase("Xalm")) {
                    this.externalAlarmUnitOutParam[i].setLoadedValue(string);
                }
                String string3 = this.getPortId(string2);
                if (this.portIdOutParam != null && this.portIdOutParam[i] != null) {
                    this.portIdOutParam[i].setLoadedValue(string3);
                }
                outDeviceRI.setLoadedValues();
                if (!this.rbs.getRbsStep().equals("STEP_CABINET")) {
                    this.configurePortRestrictionOutDevice[i].setActive(false);
                }
            }
            arrayList.add(outDeviceRI);
        }
        this.outDeviceRIs = arrayList;
    }

    public void createOutdeviceRIs(ServiceValue serviceValue) throws BemException {
        ArrayList<OutDeviceRI> arrayList = new ArrayList<OutDeviceRI>();
        for (int i = 0; i < this.MAX_NO_OUTDEVICES; ++i) {
            int n = i + 1;
            String string = PrefixUtil.getFirstCabinetPrefix() + this.getAutype() + MessageFormat.format("ControlPort{0}_", new Integer(n));
            String string2 = string + "equipmentName";
            String string3 = serviceValue.getValue(string2);
            string2 = string + "normallyOpen";
            String string4 = serviceValue.getValue(string2);
            if ((string3 == null || string3.length() == 0) && (string4 == null || string4.length() == 0)) continue;
            String string5 = this.outDeviceMois[i].getLdn();
            OutDeviceRI outDeviceRI = new OutDeviceRI(this.rbs, string5, this.getAutype());
            if (outDeviceRI.isExisting(string5)) {
                outDeviceRI.setLoadedValues();
            }
            arrayList.add(outDeviceRI);
        }
        this.outDeviceRIs = arrayList;
    }

    private String getInternalRruwNumber() throws BemException {
        String string = this.deviceGroupMoi.getLdn();
        int n = string.lastIndexOf("-");
        int n2 = string.lastIndexOf(",");
        String string2 = string.substring(n + 1, n2);
        return string2;
    }

    public String getSectorNumber() throws BemException {
        String string = this.deviceGroupMoi.getLdn();
        int n = string.lastIndexOf(MimAuxPlugInUnit.MOTYPENAME);
        String string2 = string.substring(0, n - 1);
        int n2 = string2.lastIndexOf("=");
        n = string2.lastIndexOf("-");
        String string3 = string.substring(n2 + 1, n);
        return string3;
    }

    public String getSectorNumberForIru() throws BemException {
        String string = this.deviceGroupMoi.getLdn();
        int n = string.indexOf("IRU");
        int n2 = string.lastIndexOf(",");
        String string2 = string.substring(n, n2);
        n = string2.indexOf("-");
        n2 = string2.lastIndexOf("-");
        String string3 = string2.substring(n + 1, n2);
        return string3;
    }

    private String getPortIdRruw() throws BemException {
        String string = this.deviceGroupMoi.getLdn();
        int n = string.indexOf("-");
        int n2 = string.indexOf("-") - 1;
        String string2 = string.substring(n2 + 1, n);
        return string2;
    }

    private String getPortId(String string) throws BemException {
        return BemUtil.getRdn(string);
    }

    public String getDeviceGroupLdn() throws BemException {
        return this.deviceGroupMoi.getLdn();
    }

    public MoInstance getDeviceGroupMoi() {
        return this.deviceGroupMoi;
    }

    public ArrayList getOutDeviceCustomerParameters(ServiceValue serviceValue) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = new String[outDevicePseudos.length];
        for (int i = 0; i < this.MAX_NO_OUTDEVICES; ++i) {
            int n = i + 1;
            String string = PrefixUtil.getFirstCabinetPrefix() + this.getAutype() + MessageFormat.format("ControlPort{0}_", new Integer(n));
            for (int j = 0; j < outDevicePseudos.length; ++j) {
                stringArray[j] = string + outDevicePseudos[j];
                if (serviceValue.getValue(stringArray[j]) == null) continue;
                this.configurePortRestrictionOutDevice[i].setActive(false);
            }
            arrayList.add(stringArray);
            stringArray = new String[outDevicePseudos.length];
        }
        return arrayList;
    }

    public ArrayList getNeededRIs() {
        int n;
        int n2;
        ArrayList arrayList = new ArrayList();
        if (this.almDeviceRIs != null) {
            for (n2 = 0; n2 < this.almDeviceRIs.size(); ++n2) {
                for (n = 0; n < this.MAX_NO_ALMDEVICES; ++n) {
                    if (this.configurePortRestrictionAlmDevice[n].isActive() || this.almDeviceRIs.get(n2) == null || arrayList.contains(this.almDeviceRIs.get(n2))) continue;
                    arrayList.add(this.almDeviceRIs.get(n2));
                }
            }
        }
        if (this.savedAlmDeviceRIs != null) {
            for (n2 = 0; n2 < this.savedAlmDeviceRIs.size(); ++n2) {
                if (this.savedAlmDeviceRIs.get(n2) == null || arrayList.contains(this.savedAlmDeviceRIs.get(n2))) continue;
                arrayList.add(this.savedAlmDeviceRIs.get(n2));
            }
        }
        if (this.outDeviceRIs != null) {
            for (n2 = 0; n2 < this.outDeviceRIs.size(); ++n2) {
                for (n = 0; n < this.MAX_NO_OUTDEVICES; ++n) {
                    if (this.configurePortRestrictionOutDevice[n].isActive() || this.outDeviceRIs.get(n2) == null || arrayList.contains(this.outDeviceRIs.get(n2))) continue;
                    arrayList.add(this.outDeviceRIs.get(n2));
                }
            }
        }
        return arrayList;
    }

    public ArrayList getCustomerParameters() throws BemException {
        int n;
        this.alarmSloganParam = new StringParameter[this.MAX_NO_ALMDEVICES];
        this.normallyOpenParam = new YesNoCustomerParameter[this.MAX_NO_ALMDEVICES];
        this.severityParam = new Enumeration[this.MAX_NO_ALMDEVICES];
        this.externalAlarmUnitParam = new Enumeration[this.MAX_NO_ALMDEVICES];
        this.probableCauseParam = new Enumeration[this.MAX_NO_ALMDEVICES];
        this.portIdParam = new IntegerParameter[this.MAX_NO_ALMDEVICES];
        this.equipmentParam = new StringParameter[this.MAX_NO_OUTDEVICES];
        this.normallyOpenOutParam = new YesNoCustomerParameter[this.MAX_NO_OUTDEVICES];
        this.portIdOutParam = new IntegerParameter[this.MAX_NO_OUTDEVICES];
        this.externalAlarmUnitOutParam = new Enumeration[this.MAX_NO_OUTDEVICES];
        int[] nArray = new int[this.MAX_NO_ALMDEVICES];
        ArrayList<CustomerParameterImpl> arrayList = new ArrayList<CustomerParameterImpl>();
        for (int i = 0; i < nArray.length; ++i) {
            n = i + 1;
            String string = PrefixUtil.getFirstCabinetPrefix() + this.getAutype() + MessageFormat.format("ExternalAlarm{0}_", new Integer(n));
            arrayList.add(this.getAlarmSlogan(string, i));
            arrayList.add(this.getNormallyOpen(string, i));
            arrayList.add(this.getServerity(string, i));
            arrayList.add(this.getProbableCause(string, i));
            arrayList.add(this.getPortIdSlogan(string, i));
            arrayList.add(this.getExternalAlarmUnit(string, i));
        }
        int[] nArray2 = new int[this.MAX_NO_OUTDEVICES];
        for (n = 0; n < nArray2.length; ++n) {
            int n2 = n + 1;
            String string = PrefixUtil.getFirstCabinetPrefix() + this.getAutype() + MessageFormat.format("ControlPort{0}_", new Integer(n2));
            arrayList.add(this.getEquipmentName(string, n));
            arrayList.add(this.getNormallyOutOpen(string, n));
            arrayList.add(this.getPortIdOutSlogan(string, n));
            arrayList.add(this.getExternalAlarmOutUnit(string, n));
        }
        return arrayList;
    }

    public ArrayList getCustomerParametersForRruw() throws BemException {
        this.externalAlarmUnitParam = new Enumeration[this.MAX_NO_ALMDEVICES];
        this.sectorNumberParam = new Enumeration[this.MAX_NO_ALMDEVICES];
        this.rruwPositionInSectorParam = new Enumeration[this.MAX_NO_ALMDEVICES];
        this.alarmSloganParam = new StringParameter[this.MAX_NO_ALMDEVICES];
        this.normallyOpenParam = new YesNoCustomerParameter[this.MAX_NO_ALMDEVICES];
        this.severityParam = new Enumeration[this.MAX_NO_ALMDEVICES];
        this.probableCauseParam = new Enumeration[this.MAX_NO_ALMDEVICES];
        this.portIdParam = new IntegerParameter[this.MAX_NO_ALMDEVICES];
        this.equipmentParam = new StringParameter[this.MAX_NO_OUTDEVICES];
        int[] nArray = new int[this.MAX_NO_ALMDEVICES];
        ArrayList<CustomerParameterImpl> arrayList = new ArrayList<CustomerParameterImpl>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = i + 1;
            String string = PrefixUtil.getFirstCabinetPrefix() + this.getAutype() + MessageFormat.format("ExternalAlarm{0}_", new Integer(n));
            int n2 = 0;
            if (this.rbs.isPantherHybridRbs() && this.sectorNumber > 6) {
                n2 = 1;
            }
            RadioEquipmentProvider radioEquipmentProvider = this.rbs.getRadioEquipmentProvider(n2);
            string = this.sectorNumber > 0 && radioEquipmentProvider.getNumberOfSupportedRxBranches(this.sectorNumber) > 2 && this.id > 1 ? string + String.valueOf(this.sectorNumber) + "_" + this.id + "_" : string + String.valueOf(this.sectorNumber) + "_" + this.id + "_";
            arrayList.add(this.getExternalAlarmUnitParam(string, i));
            arrayList.add(this.getSectorNumberParam(string, i));
            arrayList.add(this.getRruwPositionInSectorParam(string, i));
            arrayList.add(this.getAlarmSlogan(string, i));
            arrayList.add(this.getNormallyOpen(string, i));
            arrayList.add(this.getServerity(string, i));
            arrayList.add(this.getProbableCause(string, i));
            arrayList.add(this.getPortIdSlogan(string, i));
        }
        return arrayList;
    }

    public ArrayList getCustomerParametersForIru() throws BemException {
        this.externalAlarmUnitParam = new Enumeration[this.MAX_NO_ALMDEVICES];
        this.sectorNumberParam = new Enumeration[this.MAX_NO_ALMDEVICES];
        this.alarmSloganParam = new StringParameter[this.MAX_NO_ALMDEVICES];
        this.normallyOpenParam = new YesNoCustomerParameter[this.MAX_NO_ALMDEVICES];
        this.severityParam = new Enumeration[this.MAX_NO_ALMDEVICES];
        this.probableCauseParam = new Enumeration[this.MAX_NO_ALMDEVICES];
        this.portIdParam = new IntegerParameter[this.MAX_NO_ALMDEVICES];
        this.equipmentParam = new StringParameter[this.MAX_NO_OUTDEVICES];
        int[] nArray = new int[this.MAX_NO_ALMDEVICES];
        ArrayList<CustomerParameterImpl> arrayList = new ArrayList<CustomerParameterImpl>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = i + 1;
            String string = PrefixUtil.getCabinetPrefix(String.valueOf(0)) + this.autype + MessageFormat.format("ExternalAlarm{0}_", new Integer(n)) + String.valueOf(this.sectorNumber) + "_" + this.id + "_";
            arrayList.add(this.getExternalAlarmUnitParam(string, i));
            arrayList.add(this.getSectorNumberParam(string, i));
            arrayList.add(this.getAlarmSlogan(string, i));
            arrayList.add(this.getNormallyOpen(string, i));
            arrayList.add(this.getServerity(string, i));
            arrayList.add(this.getProbableCause(string, i));
            arrayList.add(this.getPortIdSlogan(string, i));
        }
        return arrayList;
    }

    protected Enumeration getExternalAlarmUnitParam(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "externalAlarmUnit";
        String[] stringArray = new String[]{"", "Rruw", "Iru"};
        this.externalAlarmUnitParam[n] = new Enumeration(string2, stringArray);
        this.externalAlarmUnitParam[n].setDefaultValue("");
        this.externalAlarmUnitParam[n].addRestriction(this.configurePortRestrictionAlmDevice[n]);
        return this.externalAlarmUnitParam[n];
    }

    protected Enumeration getSectorNumberParam(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "sectorNumber";
        String[] stringArray = this.getSectorNumberRange(this.rbs.getMaxNumberOfSectors());
        this.sectorNumberParam[n] = new Enumeration(string2, stringArray);
        this.sectorNumberParam[n].setDefaultValue("");
        this.sectorNumberParam[n].addRestriction(this.configurePortRestrictionAlmDevice[n]);
        return this.sectorNumberParam[n];
    }

    private String[] getSectorNumberRange(int n) {
        String[] stringArray = new String[n + 1];
        stringArray[0] = "";
        for (int i = 1; i <= n; ++i) {
            Integer n2 = new Integer(i);
            stringArray[i] = n2.toString();
        }
        return stringArray;
    }

    protected Enumeration getRruwPositionInSectorParam(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "rruwPositionInSector";
        String[] stringArray = new String[]{"", AUTO_CREATED_RDNID_1, "2"};
        this.rruwPositionInSectorParam[n] = new Enumeration(string2, stringArray);
        this.rruwPositionInSectorParam[n].setDefaultValue("");
        this.rruwPositionInSectorParam[n].addRestriction(this.configurePortRestrictionAlmDevice[n]);
        return this.rruwPositionInSectorParam[n];
    }

    protected StringParameter getAlarmSlogan(String string, int n) {
        String string2 = "";
        string2 = string + "alarmSlogan";
        StringRange stringRange = new StringRange(MimAlmDevice.MINLEN_ALARMSLOGAN, MimAlmDevice.MAXLEN_ALARMSLOGAN);
        this.alarmSloganParam[n] = new StringParameter(string2, stringRange);
        this.alarmSloganParam[n].setDefaultValue("");
        this.alarmSloganParam[n].addRestriction(this.configurePortRestrictionAlmDevice[n]);
        return this.alarmSloganParam[n];
    }

    protected IntegerParameter getPortIdSlogan(String string, int n) {
        String string2 = "";
        string2 = string + "portId";
        IntegerRange integerRange = new IntegerRange(1, this.MAX_NO_ALMDEVICES);
        this.portIdParam[n] = new IntegerParameter(string2, integerRange);
        this.portIdParam[n].setDefaultValue("");
        this.portIdParam[n].addRestriction(this.configurePortRestrictionAlmDevice[n]);
        this.portIdRange = new ParameterRestriction("Port Id out of range", integerRange, true);
        this.portIdParam[n].addRestriction(this.portIdRange);
        return this.portIdParam[n];
    }

    protected IntegerParameter getPortIdOutSlogan(String string, int n) {
        String string2 = "";
        string2 = string + "portId";
        IntegerRange integerRange = new IntegerRange(0, 100);
        this.portIdOutParam[n] = new IntegerParameter(string2, integerRange);
        this.portIdOutParam[n].setDefaultValue("");
        this.portIdOutParam[n].addRestriction(this.configurePortRestrictionOutDevice[n]);
        return this.portIdOutParam[n];
    }

    protected YesNoCustomerParameter getNormallyOpen(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "normallyOpen";
        this.normallyOpenParam[n] = new YesNoCustomerParameter(string2);
        this.normallyOpenParam[n].setDefaultValue("YES");
        this.normallyOpenParam[n].addRestriction(this.configurePortRestrictionAlmDevice[n]);
        NormallyOpenConversion normallyOpenConversion = new NormallyOpenConversion();
        this.normallyOpenParam[n].setMomConverter(normallyOpenConversion);
        return this.normallyOpenParam[n];
    }

    protected Enumeration getServerity(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "severity";
        String[] stringArray = new String[]{"Critical", "Major", "Minor", "Warning"};
        this.severityParam[n] = new Enumeration(string2, stringArray);
        this.severityParam[n].setDefaultValue("Minor");
        this.severityParam[n].addRestriction(this.configurePortRestrictionAlmDevice[n]);
        SeverityConversion severityConversion = new SeverityConversion();
        this.severityParam[n].setMomConverter(severityConversion);
        return this.severityParam[n];
    }

    private Enumeration getExternalAlarmUnit(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "externalAlarmUnit";
        String[] stringArray = new String[]{"Sau", "Scu", "Sup", "Rruw", "Iru"};
        this.externalAlarmUnitParam[n] = new Enumeration(string2, stringArray);
        this.externalAlarmUnitParam[n].addRestriction(this.configurePortRestrictionAlmDevice[n]);
        return this.externalAlarmUnitParam[n];
    }

    private Enumeration getExternalAlarmOutUnit(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "externalAlarmUnit";
        String[] stringArray = new String[]{"Sau", "Scu", "Sup", "Rruw", "Iru"};
        this.externalAlarmUnitOutParam[n] = new Enumeration(string2, stringArray);
        this.externalAlarmUnitOutParam[n].addRestriction(this.configurePortRestrictionOutDevice[n]);
        return this.externalAlarmUnitOutParam[n];
    }

    protected Enumeration getProbableCause(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "probableCause";
        int[] nArray = new AllowedProbableCause().getAllowedValueArray();
        EnumeratedRange enumeratedRange = new EnumeratedRange(nArray);
        this.probableCauseParam[n] = new Enumeration(string2, enumeratedRange);
        this.probableCauseParam[n].setDefaultValue(MimAlmDevice.DEFAULT_PROBABLECAUSE.toString());
        this.probableCauseParam[n].addRestriction(this.configurePortRestrictionAlmDevice[n]);
        return this.probableCauseParam[n];
    }

    protected StringParameter getEquipmentName(String string, int n) {
        String string2 = "";
        string2 = string + "equipmentName";
        StringRange stringRange = new StringRange(MimOutDevice.MINLEN_EQUIPMENTNAME, MimOutDevice.MAXLEN_EQUIPMENTNAME);
        this.equipmentParam[n] = new StringParameter(string2, stringRange);
        this.equipmentParam[n].setDefaultValue(MimOutDevice.DEFAULT_EQUIPMENTNAME);
        this.equipmentParam[n].addRestriction(this.configurePortRestrictionOutDevice[n]);
        return this.equipmentParam[n];
    }

    protected YesNoCustomerParameter getNormallyOutOpen(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "normallyOpen";
        this.normallyOpenOutParam[n] = new YesNoCustomerParameter(string2);
        this.normallyOpenOutParam[n].setDefaultValue("YES");
        NormallyOpenConversion normallyOpenConversion = new NormallyOpenConversion();
        this.normallyOpenOutParam[n].setMomConverter(normallyOpenConversion);
        this.normallyOpenOutParam[n].addRestriction(this.configurePortRestrictionOutDevice[n]);
        return this.normallyOpenOutParam[n];
    }

    public int getMAX_NO_ALMDEVICES() {
        return this.MAX_NO_ALMDEVICES;
    }

    public int getMAX_NO_OUTDEVICES() {
        return this.MAX_NO_OUTDEVICES;
    }

    public void setDeviceGroupMoi(MoInstance moInstance) {
        this.deviceGroupMoi = moInstance;
    }

    public ArrayList getAlmDeviceCustomerParameters(ServiceValue serviceValue) throws BemException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = this.getAutype();
        String[] stringArray = new String[almDevicePseudos.length];
        for (int i = 0; i < this.MAX_NO_ALMDEVICES; ++i) {
            int n = i + 1;
            String string2 = PrefixUtil.getFirstCabinetPrefix() + string + MessageFormat.format("ExternalAlarm{0}_", new Integer(n));
            if (string.equalsIgnoreCase("Rruw")) {
                String string3 = this.getSectorNumber();
                String string4 = this.getInternalRruwNumber();
                string2 = string2 + string3 + "_" + string4 + "_";
                for (int j = 0; j < almDevicePseudos.length; ++j) {
                    stringArray[j] = string2 + almDevicePseudos[j];
                    if (serviceValue.getValue(stringArray[j]) == null || this.rbs.getRbsStep().equals("STEP_CABINET")) continue;
                    this.configurePortRestrictionAlmDevice[i].setActive(false);
                    this.setConfiguredAlarm(true);
                }
            } else if (string.equalsIgnoreCase("Iru")) {
                stringArray = new String[almDevicePseudos.length - 1];
                string2 = PrefixUtil.getCabinetPrefix(String.valueOf(0)) + string + MessageFormat.format("ExternalAlarm{0}_", new Integer(n));
                string2 = string2 + String.valueOf(this.sectorNumber) + "_" + this.id + "_";
                int n2 = 0;
                for (int j = 0; j < almDevicePseudos.length; ++j) {
                    if (almDevicePseudos[j].equalsIgnoreCase("rruwPositionInSector")) continue;
                    stringArray[n2] = string2 + almDevicePseudos[j];
                    if (serviceValue.getValue(stringArray[n2++]) == null || this.rbs.getRbsStep().equals("STEP_CABINET")) continue;
                    this.configurePortRestrictionAlmDevice[i].setActive(false);
                    this.setConfiguredAlarm(true);
                }
            } else {
                for (int j = 0; j < almDevicePseudos.length; ++j) {
                    stringArray[j] = string2 + almDevicePseudos[j];
                    if (serviceValue.getValue(stringArray[j]) == null) continue;
                    this.configurePortRestrictionAlmDevice[i].setActive(false);
                }
            }
            arrayList.add(stringArray);
            stringArray = new String[almDevicePseudos.length];
        }
        return arrayList;
    }

    public String getAutype() {
        return this.autype;
    }

    public ArrayList getMoiResources() {
        int n;
        ArrayList<MoInstance> arrayList = new ArrayList<MoInstance>();
        arrayList.add(this.deviceGroupMoi);
        arrayList.add(this.almDeviceSetMoi);
        arrayList.add(this.outDeviceSetMoi);
        if (this.almDeviceMois != null) {
            for (n = 0; n < this.MAX_NO_ALMDEVICES; ++n) {
                arrayList.add(this.almDeviceMois[n]);
            }
        }
        if (this.outDeviceMois != null) {
            for (n = 0; n < this.MAX_NO_OUTDEVICES; ++n) {
                arrayList.add(this.outDeviceMois[n]);
            }
        }
        return arrayList;
    }

    public boolean configureAlarmForRruw() {
        return this.configuredAlarm;
    }

    public boolean configureAlarmForIru() {
        return this.configuredAlarm;
    }

    public void setConfiguredAlarm(boolean bl) {
        this.configuredAlarm = bl;
        if (bl) {
            for (int i = 0; i < this.MAX_NO_ALMDEVICES; ++i) {
                if (this.portIdParam[i].getValue().equals("")) continue;
                this.configurePortRestrictionAlmDevice[i].setActive(false);
            }
        } else {
            for (int i = 0; i < this.MAX_NO_ALMDEVICES; ++i) {
                this.configurePortRestrictionAlmDevice[i].setActive(true);
            }
        }
    }

    public void saveAttributes() throws BemException {
        for (int i = 0; i < this.almDeviceRIs.size(); ++i) {
            AlmDeviceRI almDeviceRI = (AlmDeviceRI)this.almDeviceRIs.get(i);
            almDeviceRI.saveAttributes();
            this.configuredAlarm = true;
            for (int j = 0; j < this.MAX_NO_ALMDEVICES; ++j) {
                this.configurePortRestrictionAlmDevice[j].setActive(false);
            }
        }
    }

    private static class AllowedProbableCause {
        private AllowedProbableCause() {
        }

        public int[] getAllowedValueArray() {
            int[] nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 127, 128, 129, 130, 131, 132, 133, 151, 152, 153, 154, 155, 156, 301, 302, 303, 305, 306, 307, 308, 310, 311, 313, 315, 316, 317, 321, 322, 323, 324, 325, 326, 327, 330, 332, 333, 334, 336, 339, 340, 342, 343, 344, 345, 346, 347, 348, 350, 351, 353, 354, 356, 357, 501, 502, 503, 504, 505, 506, 507, 508, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 525, 526, 527, 528, 529, 530, 531, 532, 533, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 548, 549, 550, 551, 552, 561, 562, 563, 564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574};
            return nArray;
        }
    }
}

