/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.custparam;

import java.util.StringTokenizer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;

public class IpAddressRange
implements ParameterRange {
    public String getDescription() {
        return "IP Address range" + this.toString();
    }

    public boolean equals(ParameterRange parameterRange) {
        return parameterRange instanceof IpAddressRange;
    }

    public boolean isValueInRange(Object object) {
        String string = (String)object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        if (stringTokenizer.countTokens() != 7) {
            return false;
        }
        if (this.isValidIpPart(stringTokenizer.nextToken())) {
            stringTokenizer.nextToken();
            if (this.isValidIpPart(stringTokenizer.nextToken())) {
                stringTokenizer.nextToken();
                if (this.isValidIpPart(stringTokenizer.nextToken())) {
                    stringTokenizer.nextToken();
                    if (this.isValidIpPart(stringTokenizer.nextToken())) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isValidIpPart(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n >= 0 && n <= 255 && string.length() <= 3;
    }

    public ParameterRange copyAndRetainRange(ParameterRange parameterRange) {
        return new IpAddressRange();
    }

    public ParameterRange copyAndRemove(ParameterRange parameterRange) {
        return new IpAddressRange();
    }

    public String toString() {
        return "[0.0.0.0 - 255.255.255.255]";
    }

    public String convertIpToBinary(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        StringBuffer stringBuffer = new StringBuffer(0);
        if (stringTokenizer.countTokens() != 7) {
            return null;
        }
        int n = 0;
        while (true) {
            String string2 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string2);
            stringBuffer.append(this.intToBinary(n2));
            if (n >= 3) {
                return stringBuffer.toString();
            }
            stringTokenizer.nextToken();
            stringBuffer.append(".");
            ++n;
        }
    }

    private String intToBinary(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 128;
        while (true) {
            if (n >= n2) {
                stringBuffer.append("1");
                n -= n2;
            } else {
                stringBuffer.append("0");
            }
            if (n2 == 1) {
                return stringBuffer.toString();
            }
            n2 /= 2;
        }
    }
}

