/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractSwHandlingRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDpProgram;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcBus;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimManagedElementData;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimProgram;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimXpProgram;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.LdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalObject;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public abstract class AbstractDeviceBoardRI
extends AbstractSwHandlingRI
implements ResourceItem {
    public static final boolean WAIT_FOR_AUTO_CONFIGURATION = true;
    public static final boolean DONT_WAIT_FOR_AUTO_CONFIGURATION = false;
    private static final NalLog log = Nal.getLog();
    private static final String[] myInstallationPhases = new String[]{"DeviceBoardCreationPhase", "DeviceBoardRestartPhase", "UnlockAllUnitsPhase", "DeviceBoardDeletionPhase", "LockPhase", "BasicCVCleanupPhase"};
    protected int slotNo = 0;
    private boolean createPiu = false;
    protected final MoInstance slotMoi;
    protected final MoInstance piuMoi;
    protected MoInstance boardMoi;
    private final String boardType;
    protected boolean restartBoard = false;
    private boolean unlockBoard = false;
    private boolean isDeleted = false;
    private boolean waitForAutoConfiguration = true;

    public AbstractDeviceBoardRI(String string, Rbs rbs, int n, String string2, String string3) {
        this(string, rbs, n, string2, new LdnMoi(string3), false);
    }

    public AbstractDeviceBoardRI(String string, Rbs rbs, int n, String string2, String string3, boolean bl) {
        this(string, rbs, n, string2, new LdnMoi(string3), bl);
    }

    public AbstractDeviceBoardRI(String string, Rbs rbs, int n, String string2, MoInstance moInstance, boolean bl) {
        super(string, rbs, myInstallationPhases);
        this.slotNo = n;
        this.boardType = string2;
        this.waitForAutoConfiguration = bl;
        this.slotMoi = new FixedRdnMoi(moInstance, MimSlot.MOTYPENAME, String.valueOf(n));
        this.piuMoi = new SingleChildMoi(this.slotMoi, MimPlugInUnit.MOTYPENAME, "1");
        this.boardMoi = new SingleChildMoi(this.piuMoi, string2, "1");
    }

    protected void setBoardMoi(MoInstance moInstance) {
        this.boardMoi = moInstance;
    }

    public MoInstance getBoardMoi() {
        return this.boardMoi;
    }

    public MoInstance getPiuMoi() {
        return this.piuMoi;
    }

    protected void addSlotToSwAllocation() throws BemException {
        BemMo bemMo = this.getSwAllocationMOForRole(this.getRoleForSwAllocation());
        BemMo bemMo2 = this.getMo(this.piuMoi.getLdn());
        BemMo bemMo3 = this.getParent(bemMo2);
        this.verifyPiu(bemMo2);
        BemMo bemMo4 = this.checkIfSlotAlreadyInUse(bemMo3);
        boolean bl = false;
        if (bemMo4 != null) {
            bl = true;
            if (!((Object)bemMo).equals(bemMo4) && this.moveSlotAllowed) {
                this.deleteSlotIfConnected(bemMo4, bemMo3);
                bl = false;
            }
        }
        if (!bl) {
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("aSlot", bemMo3)};
            this.action(bemMo, "addSlot", nalNameValueArray);
        }
    }

    protected void removeSlotFromSwAllocation() throws BemException {
        BemMo bemMo = this.getSwAllocationMOForRole(this.getRoleForSwAllocation());
        BemMo bemMo2 = this.getMo(this.piuMoi.getLdn());
        BemMo bemMo3 = this.getParent(bemMo2);
        this.verifyPiu(bemMo2);
        boolean bl = this.checkIfSlotIsAlreadyConnected(bemMo, bemMo3);
        if (bl) {
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("aSlot", bemMo3)};
            this.action(bemMo, "deleteSlot", nalNameValueArray);
        }
    }

    private void verifyPiu(BemMo bemMo) throws BemException {
        String string = bemMo.getType();
        if (!string.equals(MimPlugInUnit.MOTYPENAME)) {
            throw new BemException("BoardConfigBase: MO is not an Piu Board MO:" + bemMo.getDN());
        }
    }

    private void createPiuMoIfNotExist(BemMo bemMo) throws BemException {
        String string = this.piuMoi.getLdn();
        BemMo bemMo2 = this.getMo(string);
        if (!this.isExisting(bemMo2)) {
            this.restartBoard = true;
            this.unlockBoard = true;
            Vector<NalNameValue> vector = new Vector<NalNameValue>(0);
            NalNameValue nalNameValue = Nal.getFactory().getNameValue("piuType", bemMo);
            vector.add(nalNameValue);
            NalNameValue nalNameValue2 = Nal.getFactory().getNameValue("administrativeState", new Integer(0));
            vector.add(nalNameValue2);
            this.createMoIfNotExisting(string, vector);
        }
    }

    protected void setPiuGroupNumberAttribute(Integer n) throws BemException {
        this.setAttribute(this.piuMoi.getLdn(), "piuGroupNumber", (Object)n);
    }

    protected void setAllowedSequentialRestarts(Integer n) throws BemException {
        this.setAttribute(this.piuMoi.getLdn(), "allowedSeqRestarts", (Object)n);
    }

    protected void createPiuIfNotExisting() throws BemException {
        try {
            BemMo bemMo = super.getPiuType();
            this.createPiuMoIfNotExist(bemMo);
        }
        catch (RuntimeException runtimeException) {
            String string = "AbstractDeviceBoard.create()";
            String string2 = runtimeException.toString();
            throw new BemException(string, "createPiuIfNotExisting()", this.piuMoi.getLdn(), string2, runtimeException);
        }
    }

    public void install(String string) throws BemException {
        if (string.equals("DeviceBoardCreationPhase")) {
            this.waitForAutoConfigurationStatusToBecomeIdle();
            this.createDeviceBoard();
        } else if (string.equals("DeviceBoardWaitingForPnpPhase")) {
            this.waitForAutoConfigurationStatusToBecomeIdle();
            this.waitForAutoConfigurationOfPlugInUnit();
        } else if (string.equals("DeviceBoardRestartPhase")) {
            this.restartDeviceBoard();
        } else if (string.equals("UnlockAllUnitsPhase")) {
            this.unlockDeviceBoard();
        } else if (string.equals("UnlockPhase") && this.unlockBoard) {
            this.unlockDeviceBoard();
        }
    }

    protected void createDeviceBoard() throws BemException {
        super.createSwAllocationIfNotExisting();
        super.updateSwAllocation();
        this.addSlotToSwAllocation();
        if (this.createPiu) {
            if (this.isSlotProductDataEmpty()) {
                log.nalTrace(6, this.getClass(), "ProductData not found, Pre configuration of " + this.piuMoi.getLdn());
                this.createPiuManually();
                this.waitForAutoConfiguration = false;
            } else {
                this.unlockBoard = true;
            }
        }
    }

    private void createPiuManually() throws BemException {
        if (!this.isDeleted) {
            super.installPiuTypes();
        }
        this.createPiuIfNotExisting();
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("LockPhase")) {
            super.lock("administrativeState");
        }
        if (string.equals("DeviceBoardDeletionPhase")) {
            this.removeSlotFromSwAllocation();
            this.deletePrograms();
            this.deletePiuAndBoard();
        }
    }

    protected void installEcPort(String string) throws BemException {
        if (this.rbs.isParameterSupported("supportSystemControl") && this.rbs.getRbsData().isRbs6000()) {
            EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
            EcPortInfo[] ecPortInfoArray = ecPortCustomerParameterProvider.getEcPortCustomerParameters(string, String.valueOf(this.slotNo));
            Vector<Object> vector = new Vector<Object>();
            this.addEcBusRef(vector);
            for (int i = 0; i < ecPortInfoArray.length; ++i) {
                NalObject nalObject;
                Object object;
                EcPortInfo ecPortInfo = ecPortInfoArray[i];
                Enumeration enumeration = ecPortInfo.getHubPositionParameter();
                Enumeration enumeration2 = ecPortInfo.getPortNumberParameter();
                Enumeration enumeration3 = ecPortInfo.getCascadingOrderParameter();
                if (enumeration.hasValueChanged() || enumeration3.hasValueChanged()) {
                    object = Nal.getFactory().getNameValue("hubPosition", this.getHubPositionValueMom(this.slotNo, enumeration));
                    nalObject = Nal.getFactory().getNameValue("cascadingOrder", enumeration3.getValueMom());
                    vector.add(nalObject);
                    vector.add(object);
                }
                object = new SingleChildMoi(this.piuMoi, MimEcPort.MOTYPENAME, enumeration2.getValue());
                nalObject = super.getMo(this.piuMoi.getLdn());
                if (!super.isExisting((BemMo)nalObject)) continue;
                String string2 = ((MoInstance)object).getLdn();
                BemMo bemMo = super.getMo(string2);
                if (super.isExisting(bemMo)) {
                    super.setAttributes(bemMo, vector);
                    continue;
                }
                super.createMoIfNotExisting(string2, vector);
            }
        }
    }

    private void addEcBusRef(Vector vector) throws BemException {
        MoInstance moInstance = this.rbs.getMoiRefs().getEquipmentMoi();
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimEcBus.MOTYPENAME, "1");
        String string = fixedRdnMoi.getLdn();
        BemMo bemMo = this.rbs.getMoHandler().getMo(string);
        vector.add(Nal.getFactory().getNameValue("ecBusRef", bemMo));
    }

    private String getHubPositionValueMom(int n, CustomerParameterServer customerParameterServer) throws BemException {
        String string = null;
        string = DuwUtil.isDualDuwAndPrimaryIsV2() && RbsInfo.RBS_6601W.NAME.equals(this.rbs.getRbsType()) && n == 1 ? "X" : (String)customerParameterServer.getValueMom();
        return string;
    }

    private boolean isSlotProductDataEmpty() throws BemException {
        boolean bl = true;
        try {
            NalStruct nalStruct;
            BemMo bemMo = this.getMo(this.piuMoi.getLdn());
            BemMo bemMo2 = this.getParent(bemMo);
            try {
                nalStruct = (NalStruct)bemMo2.getAttribute("productData");
            }
            catch (NalCmException nalCmException) {
                throw new BemException("AbstractDeviceBoard.isSlotProductDataEmpty()", "getAttribute()", bemMo2.getDN(), nalCmException.toString(), nalCmException);
            }
            String string = (String)nalStruct.getMemberValue("productNumber");
            String string2 = (String)nalStruct.getMemberValue("productRevision");
            if (string != null && !string.equals("") && string2 != null && !string2.equals("")) {
                bl = false;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BemException(AbstractDeviceBoardRI.class + " isSlotProductDataEmpty()", (Throwable)noSuchFieldException);
        }
        return bl;
    }

    protected void deletePrograms() throws BemException {
        String string = this.getLdn();
        BemMo bemMo = this.getMo(string);
        BemMo bemMo2 = bemMo.getParent();
        try {
            if (!bemMo2.isExisting()) {
                return;
            }
            BemMo[] bemMoArray = this.getChildren(bemMo2, 10, "", "");
            if (bemMoArray != null) {
                for (int i = 0; i < bemMoArray.length; ++i) {
                    BemMo bemMo3 = bemMoArray[i];
                    String string2 = bemMo3.getType();
                    if (!string2.equals(MimDpProgram.MOTYPENAME) && !string2.equals(MimXpProgram.MOTYPENAME) && !string2.equals(MimProgram.MOTYPENAME)) continue;
                    this.delete(bemMo3);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            String string3 = "AbstractDeviceBoard.uninstall()";
            String string4 = runtimeException.toString();
            throw new BemException(string3, "deletePrograms()", string, string4, runtimeException);
        }
    }

    protected final void deletePiuAndBoard() throws BemException {
        String string = this.getLdn();
        BemMo bemMo = this.getMo(string);
        BemMo bemMo2 = bemMo.getParent();
        String string2 = bemMo2.getDN();
        this.isDeleted = true;
        try {
            this.deleteMoIfExisting(string);
            this.deleteMoIfExisting(string2);
        }
        catch (RuntimeException runtimeException) {
            String string3 = "AbstractDeviceBoard.delete()";
            String string4 = runtimeException.toString();
            throw new BemException(string3, "deletePiuAndBoardMoIfExisting()", string, string4, runtimeException);
        }
    }

    protected void restartDeviceBoard() throws BemException {
        if (this.restartBoard) {
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("restartRank", new Integer(1)), Nal.getFactory().getNameValue("restartReason", new Integer(30)), Nal.getFactory().getNameValue("restartInfo", "Activating PnP by restarting board")};
            String string = this.piuMoi.getLdn();
            BemMo bemMo = this.getMo(string);
            if (this.getLdn().indexOf("," + MimPlugInUnit.MOTYPENAME) != -1) {
                this.action(bemMo, "manualRestart", nalNameValueArray);
            }
        }
    }

    protected void unlockDeviceBoard() throws BemException {
        this.unlock("administrativeState");
    }

    protected void createPiuAndBoard(boolean bl) {
        this.createPiu = bl;
    }

    public String getDisplayName() {
        String string = String.valueOf(this.slotNo) + ":" + this.getName();
        return string;
    }

    public String getLdn() {
        String string = "";
        try {
            string = this.boardMoi.getLdn();
        }
        catch (BemException bemException) {
            // empty catch block
        }
        return string;
    }

    public String getPiuLdn() {
        String string = "";
        try {
            string = this.piuMoi.getLdn();
        }
        catch (BemException bemException) {
            // empty catch block
        }
        return string;
    }

    public String getBoardType() {
        return this.boardType;
    }

    protected void reconfigureProgramPrepare() throws BemException {
        BemMo bemMo = this.getMo(this.getPiuLdn());
        NalNameValue[] nalNameValueArray = new NalNameValue[]{};
        this.action(bemMo, "reconfigureProgramPrepare", nalNameValueArray);
    }

    protected void removeDisabledPrograms() throws BemException {
        BemMo bemMo = this.getMo(this.getPiuLdn());
        NalNameValue[] nalNameValueArray = new NalNameValue[]{};
        this.action(bemMo, "removeDisabledPrograms", nalNameValueArray);
    }

    private void waitForAutoConfigurationStatusToBecomeIdle() throws BemException {
        Integer n;
        log.nalTrace(6, this.getClass(), "Waiting for autoConfigurationStatus to become IDLE.");
        MoInstance moInstance = this.getRbs().getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimManagedElementData.MOTYPENAME, "1");
        BemMo bemMo = super.getMo(singleChildMoi.getLdn());
        long l = System.currentTimeMillis() + 600000L;
        while ((n = (Integer)bemMo.getAttribute("autoConfigurationStatus")) != 0) {
            if (super.isInterrupted()) {
                log.nalTrace(2, this.getClass(), "Waiting for autoConfigurationStatus, interupted by user.");
                break;
            }
            if (l < System.currentTimeMillis()) {
                Nal.getLog().nalTrace(1, this.getClass(), "Waiting for autoConfigurationStatus, auto-configuration is still in progress after having waited for 10 minutes.");
                throw new BemException("SYSTEM BUSY, PLUG AND PLAY IN PROGRESS");
            }
            this.delay_ms(5000);
        }
    }

    private void waitForAutoConfigurationOfPlugInUnit() throws BemException {
        String string;
        block9: {
            boolean bl;
            long l;
            BemMo bemMo;
            block8: {
                string = "Waiting for Auto-configuration: " + this.piuMoi.getLdn();
                bemMo = this.getMo(this.piuMoi.getLdn());
                if (!this.waitForAutoConfiguration) {
                    log.nalTrace(6, this.getClass(), "Not " + string);
                    return;
                }
                l = System.currentTimeMillis() + 120000L;
                boolean bl2 = this.shouldExtendTimeout();
                if (bl2) {
                    l += 240000L;
                }
                do {
                    log.nalTrace(6, this.getClass(), string + " wait until created");
                    bl = this.isExisting(bemMo);
                    if (bl) break block8;
                    if (l < System.currentTimeMillis()) {
                        log.nalTrace(2, this.getClass(), string + " Timed out before Existing!");
                        if (bl2) {
                            String string2 = "Autoconfiguration of PlugInUnit failed slotLdn=" + this.slotMoi.getLdn();
                            throw new BemException(this.getClass() + string2);
                        }
                        log.nalTrace(6, this.getClass(), "Attempting manual creation of " + this.piuMoi.getLdn());
                        this.createPiuManually();
                        return;
                    }
                    this.delay_ms(500);
                } while (!this.isInterrupted());
                log.nalTrace(2, this.getClass(), string + " Interupted by user before Existing!");
                return;
            }
            log.nalTrace(6, this.getClass(), string + " is now Existing");
            do {
                log.nalTrace(6, this.getClass(), string + " wait until enabled");
                bl = this.isPiuEnabled(bemMo);
                if (bl) break block9;
                boolean bl3 = this.isExisting(bemMo);
                if (!bl3) {
                    String string3 = "Autoconfiguration of PlugInUnit failed and the transaction must have been rolled back";
                    log.nalTrace(2, this.getClass(), string + " ceased to exist, " + string3);
                    throw new BemException(string3);
                }
                if (l < System.currentTimeMillis()) {
                    log.nalTrace(2, this.getClass(), string + " Timed out before enabled!");
                    return;
                }
                this.delay_ms(500);
            } while (!this.isInterrupted());
            log.nalTrace(2, this.getClass(), string + " Interupted by user before enabled!");
            return;
        }
        log.nalTrace(6, this.getClass(), string + " is now Enabled, Completed");
    }

    private boolean isPiuEnabled(BemMo bemMo) {
        boolean bl = false;
        try {
            Integer n = (Integer)bemMo.getAttribute("operationalState");
            if (n == 1) {
                bl = true;
            }
        }
        catch (NalCmException nalCmException) {
            bl = false;
        }
        return bl;
    }

    private boolean shouldExtendTimeout() throws BemException {
        boolean bl = false;
        BemMo bemMo = this.getMo(this.rbs.getMoiRefs().getCurrentUPMoi().getLdn());
        Integer n = (Integer)bemMo.getAttribute("progressHeader");
        log.nalTrace(6, this.getClass(), "shouldExtendTimeout() progressHeaderValue=" + n);
        if (n != 0) {
            bl = true;
        }
        return bl;
    }

    public int getSlotNo() {
        return this.slotNo;
    }

    protected void startImmediateActionOnProgramMos() throws BemException {
        String string = this.getPiuLdn();
        if (string == null || string.equals("")) {
            return;
        }
        BemMo bemMo = this.getMo(string);
        BemMo[] bemMoArray = this.getChildren(bemMo, 1, MimProgram.MOTYPENAME, "");
        for (int i = 0; i < bemMoArray.length; ++i) {
            NalNameValue[] nalNameValueArray = new NalNameValue[]{};
            Integer n = (Integer)bemMoArray[i].getAttribute("operationalState");
            if (n != 0) continue;
            this.action(bemMoArray[i], "startImmediate", nalNameValueArray);
        }
    }
}

