/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterViewer;
import se.ericsson.wcdma.rbs.bem.common.gui.ErrorDialog;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressReporterCore;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractController;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractView;
import se.ericsson.wcdma.support.gui.guilib.infra.ErrorDialogController;

public class EasyPopUp {
    private static final String NCONF_INFO_DIALOG = "Information";
    private static final String NCONF_WARNING_DIALOG = "Warning";
    private static final String NCONF_ERROR_DIALOG = "Error";
    private static final String NCONF_CONFIRM_DIALOG = "Confirm";
    private final AbstractController parentController;

    public EasyPopUp(AbstractController abstractController) {
        this.parentController = abstractController;
    }

    public void displayInfoMessage(String string) {
        String string2 = this.getDialogueTitle(NCONF_INFO_DIALOG);
        JOptionPane.showMessageDialog(this.getParentView(), string, string2, 1);
    }

    public void displayWarningMessage(String string) {
        String string2 = this.getDialogueTitle(NCONF_WARNING_DIALOG);
        JOptionPane.showMessageDialog(this.getParentView(), string, string2, 2);
    }

    public boolean displayWarningMessageWithYesNoConfirm(String string) {
        boolean bl = true;
        String string2 = this.getDialogueTitle(NCONF_WARNING_DIALOG);
        int n = JOptionPane.showOptionDialog(this.getParentView(), string, string2, 0, 2, null, new String[]{"Yes", "No"}, "No");
        if (n == 1) {
            bl = false;
        }
        return bl;
    }

    public void displayDetailedWarningOkDialog(String string, String string2) {
        JOptionPane jOptionPane = new JOptionPane(string, 2);
        JTextArea jTextArea = new JTextArea(string2, 10, 50);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jOptionPane.add(jScrollPane);
        String string3 = this.getDialogueTitle(NCONF_CONFIRM_DIALOG);
        JDialog jDialog = jOptionPane.createDialog(this.getParentView(), string3);
        jDialog.setVisible(true);
    }

    public void displayErrorMessage(String string) {
        String string2 = this.getDialogueTitle(NCONF_ERROR_DIALOG);
        JOptionPane.showMessageDialog(this.getParentView(), string, string2, 0);
    }

    public void oldDisplayError(BemException bemException) {
        ErrorDialogController.startDialogue(this.parentController, bemException);
    }

    public void displayError(Throwable throwable) {
        ExceptionProperties exceptionProperties = ExceptionProperties.getProperties(throwable);
        this.displayError(exceptionProperties);
    }

    public void displayError(ExceptionProperties exceptionProperties) {
        String string;
        String string2 = exceptionProperties.getProperty("Wiz page title");
        if (string2 == null) {
            string = this.getPageSubTitle();
            exceptionProperties.setUnlessEmpty("Wiz page title", string);
        }
        this.fixCustomerParameterViewName(exceptionProperties);
        string = exceptionProperties.getPopUpMessge();
        String string3 = exceptionProperties.getPopUpDetails();
        Nal.getLog().nalTraceError(this.getClass(), string3);
        ErrorDialog errorDialog = ErrorDialog.create(this.getParentView(), string, string3);
        errorDialog.setModal(true);
        errorDialog.setEnabled(true);
        errorDialog.setFocusable(true);
        errorDialog.setVisible(true);
    }

    private void fixCustomerParameterViewName(ExceptionProperties exceptionProperties) {
        if (!(this.getParentView() instanceof CustomerParameterViewer)) {
            return;
        }
        for (Throwable throwable = exceptionProperties.getException(); throwable != null; throwable = throwable.getCause()) {
            if (!(throwable instanceof CustomerParameterException)) continue;
            CustomerParameterException customerParameterException = (CustomerParameterException)throwable;
            CustomerParameter customerParameter = customerParameterException.getParameter();
            String string = this.getGuiNameForCustomerParameter(customerParameter);
            customerParameterException.setUnlessEmpty("CustomerParameter name", string);
            customerParameterException.setUnlessEmpty("CustomerParameter view name", string);
        }
    }

    private String getGuiNameForCustomerParameter(CustomerParameter customerParameter) {
        if (!(this.getParentView() instanceof CustomerParameterViewer)) {
            return null;
        }
        CustomerParameterViewer customerParameterViewer = (CustomerParameterViewer)((Object)this.getParentView());
        String string = customerParameter.getName();
        String string2 = customerParameterViewer.getGuiNameForCustomerParameter(string);
        return string2;
    }

    private void setFocusOnCustomerParameterComponent(CustomerParameter customerParameter) {
        if (this.getParentView() instanceof CustomerParameterViewer) {
            CustomerParameterViewer customerParameterViewer = (CustomerParameterViewer)((Object)this.getParentView());
            String string = customerParameter.getName();
            customerParameterViewer.setFocusOnCustomerParameterComponent(string);
        }
    }

    public void displayCustomerParameterWarning(CustomerParameterException customerParameterException) {
        CustomerParameter customerParameter = customerParameterException.getParameter();
        String string = this.getGuiNameForCustomerParameter(customerParameter);
        String string2 = string != null ? string : customerParameter.getName();
        this.displayWarningMessage("Invalid user input:\n\n        Label       :  " + string2 + "\n\n        Problem  :  " + customerParameterException.getReason() + "\n\nPlease correct the problem before proceeding.");
        this.setFocusOnCustomerParameterComponent(customerParameter);
    }

    public boolean displayConfirmDialog(String string) {
        boolean bl = true;
        String string2 = this.getDialogueTitle(NCONF_CONFIRM_DIALOG);
        int n = JOptionPane.showConfirmDialog(this.getParentView(), string, string2, 0);
        if (n == 1) {
            bl = false;
        }
        return bl;
    }

    public boolean displayConfirmOkCancelDialog(String string) {
        boolean bl = true;
        String string2 = this.getDialogueTitle(NCONF_CONFIRM_DIALOG);
        int n = JOptionPane.showConfirmDialog(this.getParentView(), string, string2, 2);
        if (n == 2) {
            bl = false;
        }
        return bl;
    }

    public void reportProgress(String string, String string2, int n) {
        if (this.parentController instanceof ProgressReporterCore) {
            ProgressReporterCore progressReporterCore = (ProgressReporterCore)((Object)this.parentController);
            progressReporterCore.reportProgress(string, string2, n);
        }
    }

    String getPageSubTitle() {
        String string = "";
        if (this.parentController != null) {
            try {
                string = this.parentController.getPageSubTitle();
                if (string == null) {
                    string = "";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private String getDialogueTitle(String string) {
        String string2 = null;
        string2 = this.parentController.getPageSubTitle();
        string2 = string2 == null ? "" : string2.trim();
        String string3 = string2.equals("") ? string : (string.equals("") ? string2 : string2 + ": " + string);
        return string3;
    }

    private AbstractView getParentView() {
        return this.parentController == null ? null : this.parentController.getView();
    }

    public static interface Parent {
        public EasyPopUp getEasyPopUp();

        public String getPageSubTitle();
    }
}

