/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.control;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemComponentCustomizer;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemGuiComponents;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;

public abstract class GuiLogic {
    private final BemGuiComponents guiComponents = new BemGuiComponents();
    private String errorMessage = "";
    private Vector serviceAttribs = null;
    private Vector allGuiComponents = null;

    protected String getVectorValue(String string, Vector vector) {
        String string2 = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            NalNameValue nalNameValue = (NalNameValue)enumeration.nextElement();
            String string3 = nalNameValue.getName();
            if (string3.compareTo(string) != 0) continue;
            string2 = (String)nalNameValue.getValue();
            break;
        }
        return string2;
    }

    public abstract boolean updateModel(String var1) throws WizardException;

    public BemGuiComponents getGuiComponents() {
        return this.guiComponents;
    }

    public boolean importFromService(ServiceValue serviceValue, String string) throws WizardException, BemException {
        this.updateComponentsFromService(serviceValue, string);
        Vector vector = serviceValue.getValues(string);
        boolean bl = this.checkSyntax("XML", vector);
        return bl;
    }

    private void updateComponentsFromService(ServiceValue serviceValue, String string) throws WizardException {
        this.serviceAttribs = serviceValue.getValues(string);
        this.allGuiComponents = this.guiComponents.getAllComponents();
        Iterator iterator = this.allGuiComponents.iterator();
        while (iterator.hasNext()) {
            boolean bl = true;
            BemComponentCustomizer bemComponentCustomizer = (BemComponentCustomizer)iterator.next();
            String string2 = bemComponentCustomizer.getPseudoName();
            if (string2 == null) continue;
            String string3 = this.getVectorValue(string2, this.serviceAttribs);
            if (string3 != null) {
                bl = bemComponentCustomizer.setObjectValue("XML", string3);
            }
            if (bl) continue;
            this.errorMessage = this.errorMessage + this.buildErrorMessage("XML", bemComponentCustomizer, this.serviceAttribs);
        }
        if (!this.errorMessage.equals("")) {
            this.informOperator("XML", this.errorMessage);
        }
    }

    private void informOperator(String string, String string2) throws WizardException {
        if ("GUI".equals(string)) {
            this.displayErrorMessage(string2);
        } else if ("XML".equals(string)) {
            throw new WizardException(string2);
        }
    }

    private String getRange(BemComponentCustomizer bemComponentCustomizer) {
        StringBuffer stringBuffer = new StringBuffer("\n\tRange: [");
        Object object = bemComponentCustomizer.getMaxValue();
        Object object2 = bemComponentCustomizer.getMinValue();
        Object object3 = bemComponentCustomizer.getStepValue();
        if (object != null && object2 != null) {
            boolean bl = object2.getClass().isArray();
            boolean bl2 = object.getClass().isArray();
            if (bl && bl2) {
                Object[] objectArray = (Object[])object2;
                Object[] objectArray2 = (Object[])object;
                if (objectArray.length == objectArray2.length) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuffer.append(objectArray[i].toString()).append("..").append(objectArray2[i].toString()).append("]");
                    }
                }
            } else if (!bl && !bl2) {
                if (object3 != null) {
                    stringBuffer.append(object2.toString()).append(",").append(object3.toString()).append(",").append("..,").append(object.toString()).append("]");
                } else {
                    stringBuffer.append(object2.toString()).append("..").append(object.toString()).append("]");
                }
            }
        } else {
            String string = bemComponentCustomizer.getRange();
            if (string != null) {
                stringBuffer.append(string).append("]");
            }
        }
        return stringBuffer.toString();
    }

    private String buildErrorMessage(String string, BemComponentCustomizer bemComponentCustomizer, Vector vector) {
        String string2 = "";
        boolean bl = bemComponentCustomizer.isMandatory();
        String string3 = this.getRange(bemComponentCustomizer);
        if ("XML".equals(string)) {
            String string4 = bemComponentCustomizer.getPseudoName();
            String string5 = this.getVectorValue(string4, vector);
            string2 = bl ? "Required parameter not filled in or filled in with a faulty value.\n\tParameter = " + string4 + ", value = " + string5 + " " + string3 + "\n\n\t" : "Faulty value for parameter = " + string4 + ", value = " + string5 + " " + string3 + "\n\n\t";
        } else if ("GUI".equals(string)) {
            string2 = bl ? "Mandatory field not filled in or filled in with a faulty value." + string3 + "\nPlease fill in a valid value!\n" : "Incorrect input, the entered value is out of range." + string3 + "\nPlease fill in a valid value!\n";
        }
        return string2;
    }

    private void displayErrorMessage(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    public boolean checkSyntax(String string, Vector vector) throws WizardException {
        boolean bl = true;
        String string2 = "Error";
        Vector vector2 = this.guiComponents.getAllComponents();
        if (vector2 != null) {
            if (vector2.size() != 0) {
                for (BemComponentCustomizer bemComponentCustomizer : vector2) {
                    if (bemComponentCustomizer.isEmpty(string)) {
                        if (!bemComponentCustomizer.isMandatory()) continue;
                        bemComponentCustomizer.setFocus();
                        string2 = this.buildErrorMessage(string, bemComponentCustomizer, vector);
                        bl = false;
                    } else {
                        if (bemComponentCustomizer.isCorrectSyntax(string)) continue;
                        bemComponentCustomizer.setFocus();
                        string2 = this.buildErrorMessage(string, bemComponentCustomizer, vector);
                        bl = false;
                    }
                    break;
                }
            }
        } else {
            System.out.println(">>>>> Error ! No components created in Logicfor this GUI.");
        }
        if (!bl) {
            this.informOperator(string, string2);
        }
        return bl;
    }
}

