/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.precontrol;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.OneLeggedRpuLabels;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimProgram;
import se.ericsson.wcdma.rbs.bem.common.mim.MimReliableProgramUniter;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRepertoire;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwAllocation;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwManagement;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;

public abstract class AbstractDuwPlugAndPlayPreController
implements SubInstaller {
    protected String name = "";
    protected int totalReports = 0;
    protected String description = "";
    protected Installer installer = null;
    private MoHandler moHandler = new MoHandlerImpl();
    private static final String ERROR_NO_SWALLOCATIONS = "No SwAllocation MOs found on the node. Check that an Upgrade Package has been installed.";
    private MoInstance managedElementMoi;
    private MoInstance swManagementMoi;
    private MoInstance swAllocationRoleDuw;

    public AbstractDuwPlugAndPlayPreController(Installer installer) {
        this.installer = installer;
        this.managedElementMoi = new RootMoi();
        this.swManagementMoi = new SingleChildMoi(this.managedElementMoi, MimSwManagement.MOTYPENAME, "1");
        this.swAllocationRoleDuw = new FixedRdnMoi(this.swManagementMoi, MimSwAllocation.MOTYPENAME, DuwUtil.getWizardSwAllocationRoleDuw());
    }

    public String getTheDescription() {
        return this.description;
    }

    public String getTheName() {
        return this.name;
    }

    public int getTotalNoOfProgressReports() {
        return this.totalReports;
    }

    public abstract boolean install() throws BemException;

    protected void createInterPiuLinkCable() throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = DuwUtil.getPrimaryDuwSlotLdn();
        BemMoImpl bemMoImpl = new BemMoImpl(string);
        nalNameValue = Nal.getFactory().getNameValue("primaryPiuSlot", bemMoImpl);
        vector.add(nalNameValue);
        String string2 = DuwUtil.getSecondaryDuwSlotLdn();
        BemMoImpl bemMoImpl2 = new BemMoImpl(string2);
        nalNameValue = Nal.getFactory().getNameValue("secondaryPiuSlot", bemMoImpl2);
        vector.add(nalNameValue);
        this.createMoIfNotExisting(DuwUtil.getInterPiuLinkLdn(), vector);
    }

    protected void unlockInterPiuLinkCable() throws BemException {
        BemMo bemMo = this.getMo(DuwUtil.getInterPiuLinkLdn());
        boolean bl = this.isExisting(bemMo);
        if (!bl) {
            return;
        }
        Integer n = (Integer)this.getAttribute(bemMo, "administrativeState");
        if (n != null && n == 0) {
            this.setAttribute(bemMo, "administrativeState", 1);
        }
    }

    protected final BemMo getMo(String string) {
        BemMo bemMo = null;
        BemLog.log(7, this.name + " getMo()");
        bemMo = this.moHandler.getMo(string);
        return bemMo;
    }

    protected final BemMo getRoot() throws BemException {
        BemMo bemMo = null;
        BemLog.log(7, this.name + " getRoot()");
        try {
            bemMo = this.moHandler.getRoot();
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            throw bemException;
        }
        return bemMo;
    }

    protected Object action(BemMo bemMo, String string) throws BemException {
        return this.action(bemMo, string, new NalNameValue[0]);
    }

    private Object action(BemMo bemMo, String string, NalNameValue[] nalNameValueArray) throws BemException {
        Object object = null;
        try {
            BemLog.log(7, this.name + " action() " + string);
            object = this.moHandler.action(bemMo, string, nalNameValueArray);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "action");
            bemException.setProperty("Failing MoOp", string);
            bemException.setProperty("Failing MoOp    - Params", nalNameValueArray);
            throw bemException;
        }
        return object;
    }

    protected final BemMo[] getChildren(BemMo bemMo, int n, String string, String string2) throws BemException {
        BemMo[] bemMoArray = null;
        try {
            BemLog.log(7, this.name + " getChildren()");
            bemMoArray = this.moHandler.getChildren(bemMo, n, string, string2);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "getChildren()");
            throw bemException;
        }
        return bemMoArray;
    }

    protected final Object getAttribute(BemMo bemMo, String string) throws BemException {
        Object object = null;
        try {
            BemLog.log(7, this.name + " getAttribute()");
            object = this.moHandler.getAttribute(bemMo, string);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "getAttribute()");
            throw bemException;
        }
        return object;
    }

    private final void createMoIfNotExisting(String string, Vector vector) throws BemException {
        try {
            BemLog.log(7, this.name + " createMoIfNotExisting()");
            this.moHandler.createMoIfNotExisting(string, vector);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ManagedObject", string);
            bemException.setProperty("Failing Method", "createMoIfNotExisting()");
            throw bemException;
        }
    }

    private final boolean isExisting(BemMo bemMo) throws BemException {
        boolean bl = true;
        try {
            BemLog.log(7, this.name + " isExisting()");
            bl = this.moHandler.isExisting(bemMo);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "isExisting()");
            throw bemException;
        }
        return bl;
    }

    protected final void setAttribute(BemMo bemMo, String string, Object object) throws BemException {
        try {
            BemLog.log(7, this.name + " setAttribute()");
            this.moHandler.setAttribute(bemMo, string, object);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "setAttribute()");
            throw bemException;
        }
    }

    private void setAttributes(BemMo bemMo, Vector vector) throws BemException {
        try {
            BemLog.log(7, this.name + " setAttributes()");
            this.moHandler.setAttributes(bemMo, vector);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "setAttributes()");
            throw bemException;
        }
    }

    protected void unlock(String string, String string2) throws BemException {
        String string3 = string;
        BemMo bemMo = null;
        try {
            Integer n;
            bemMo = this.getMo(string3);
            if (this.isExisting(bemMo) && (n = (Integer)this.moHandler.getAttribute(bemMo, string2)) != null && n == 0) {
                BemLog.log(7, this.name + " unlock()");
                this.moHandler.setAttribute(bemMo, string2, 1);
            }
        }
        catch (Exception exception) {
            BemException bemException = new BemException(exception);
            bemException.setProperty("ManagedObject", bemMo);
            bemException.setProperty("Failing Method", "unlock()");
            throw bemException;
        }
    }

    protected void waitForAutoConfiguration() throws BemException {
        String string;
        block5: {
            boolean bl;
            long l;
            BemMo bemMo;
            block4: {
                string = "Waiting for Auto-configuration: " + DuwUtil.getSecondaryDuwPiuLdn();
                bemMo = this.getMo(DuwUtil.getSecondaryDuwPiuLdn());
                l = System.currentTimeMillis() + 120000L;
                do {
                    Nal.getLog().nalTrace(6, this.getClass(), string + " wait until created");
                    bl = this.isExisting(bemMo);
                    if (bl) break block4;
                    this.delay_ms(500);
                } while (!this.isInterrupted());
                Nal.getLog().nalTrace(2, this.getClass(), string + " Interupted by user before Existing!");
                return;
            }
            Nal.getLog().nalTrace(6, this.getClass(), string + " is now Existing");
            do {
                Nal.getLog().nalTrace(6, this.getClass(), string + " wait until enabled");
                bl = this.isPiuEnabled(bemMo);
                if (bl) break block5;
                boolean bl2 = this.isExisting(bemMo);
                if (!bl2) {
                    String string2 = "Autoconfiguration of PlugInUnit failed and the transaction must have been rolled back";
                    Nal.getLog().nalTrace(2, this.getClass(), string + " ceased to exist, " + string2);
                    throw new BemException(string2);
                }
                if (l < System.currentTimeMillis()) {
                    Nal.getLog().nalTrace(2, this.getClass(), string + " Timed out before enabled!");
                    return;
                }
                this.delay_ms(500);
            } while (!this.isInterrupted());
            Nal.getLog().nalTrace(2, this.getClass(), string + " Interupted by user before enabled!");
            return;
        }
        Nal.getLog().nalTrace(6, this.getClass(), string + " is now Enabled, Completed");
    }

    private boolean isPiuEnabled(BemMo bemMo) {
        boolean bl = false;
        try {
            Integer n = (Integer)this.getAttribute(bemMo, "operationalState");
            if (n == 1) {
                bl = true;
            }
        }
        catch (BemException bemException) {
            bl = false;
        }
        return bl;
    }

    protected void delay_ms(int n) {
        try {
            NalFactory nalFactory = Nal.getFactory();
            nalFactory.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    protected boolean isInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            Nal.getLog().nalTrace(6, this.getClass(), "interupted by user");
            return true;
        }
        return false;
    }

    protected void setslotsOnRPUMOs() throws BemException {
        BemLog.log(7, "ReliableProgramUniterDual DUW passive slot ldn: " + DuwUtil.getSecondaryDuwSlotLdn());
        this.setParameters(DuwUtil.getSecondaryDuwSlotLdn());
        BemMo bemMo = this.getMo(this.swManagementMoi.getLdn());
        BemMo[] bemMoArray = this.getChildren(bemMo, 1, MimReliableProgramUniter.MOTYPENAME, "");
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue("normalisation", 2));
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo2 = bemMoArray[i];
                this.setAttributes(bemMo2, vector);
            }
        }
    }

    protected void setParameters(String string) throws BemException {
        BemMo bemMo = this.getMo(DuwUtil.getSecondaryDuwSlotLdn());
        BemMo bemMo2 = this.getMo(this.swManagementMoi.getLdn());
        BemMo[] bemMoArray = this.getChildren(bemMo2, 1, MimReliableProgramUniter.MOTYPENAME, "");
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo3 = bemMoArray[i];
                boolean bl = this.isPassiveSlotSet(bemMo3, string);
                if (bl) continue;
                if (OneLeggedRpuLabels.isOneLegged(bemMo3)) {
                    BemLog.log(7, "OneLegged=yes, ReliableProgramUniter rpu " + bemMo3.getLastRDN() + " Skip Setting passiveSlotLdn: " + bemMo.getDN());
                    continue;
                }
                this.setAttribute(bemMo3, "admPassiveSlot", bemMo);
                BemLog.log(7, "ReliableProgramUniter rpu " + bemMo3.getLastRDN() + " Setting passiveSlotLdn: " + bemMo.getDN());
            }
        }
    }

    private boolean isPassiveSlotSet(BemMo bemMo, String string) throws BemException {
        String string2;
        boolean bl = false;
        BemMo bemMo2 = (BemMo)this.getAttribute(bemMo, "admPassiveSlot");
        if (bemMo2 != null && (string2 = bemMo2.getDN()) != null && string2.equals(string)) {
            bl = true;
        }
        return bl;
    }

    protected void addSecondDuwSlotToSwAllocation() throws BemException {
        BemMo bemMo = this.getMo(this.swAllocationRoleDuw.getLdn());
        BemMo bemMo2 = this.getMo(DuwUtil.getSecondaryDuwSlotLdn());
        BemMo bemMo3 = this.checkIfSlotAlreadyInUse(bemMo2);
        boolean bl = false;
        if (bemMo3 != null) {
            bl = true;
        }
        if (!bl) {
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("aSlot", bemMo2)};
            this.action(bemMo, "addSlot", nalNameValueArray);
        }
    }

    private BemMo checkIfSlotAlreadyInUse(BemMo bemMo) throws BemException {
        BemMo bemMo2 = null;
        BemMo bemMo3 = this.getMo(BemLdn.LDN_SWMANAGEMENT);
        BemMo[] bemMoArray = this.getChildren(bemMo3, 1, MimSwAllocation.MOTYPENAME, "");
        if (bemMoArray == null || bemMoArray.length == 0) {
            throw new BemException(ERROR_NO_SWALLOCATIONS);
        }
        BemMo bemMo4 = null;
        for (int i = 0; i < bemMoArray.length; ++i) {
            bemMo4 = bemMoArray[i];
            boolean bl = this.checkIfSlotIsAlreadyConnected(bemMo4, bemMo);
            if (!bl) continue;
            bemMo2 = bemMo4;
            break;
        }
        return bemMo2;
    }

    private boolean checkIfSlotIsAlreadyConnected(BemMo bemMo, BemMo bemMo2) throws BemException {
        BemMo[] bemMoArray = null;
        boolean bl = false;
        try {
            if (bemMo.isExisting()) {
                bemMoArray = (BemMo[])this.getAttribute(bemMo, "slotList");
            }
        }
        catch (NalCmException nalCmException) {
            throw new BemException("Get slotList", bemMo.getDN(), (Throwable)nalCmException);
        }
        if (bemMoArray != null && bemMoArray.length != 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                String string;
                BemMo bemMo3 = bemMoArray[i];
                String string2 = bemMo3.getDN();
                if (!string2.equals(string = bemMo2.getDN())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected void startImmediateActionOnProgramMosPrimaryDuw() throws BemException {
        String string = DuwUtil.getPrimaryDuwPiuLdn();
        if (string == null || string.equals("")) {
            return;
        }
        BemMo bemMo = this.getMo(string);
        BemMo[] bemMoArray = this.getChildren(bemMo, 1, MimProgram.MOTYPENAME, "");
        for (int i = 0; i < bemMoArray.length; ++i) {
            NalNameValue[] nalNameValueArray = new NalNameValue[]{};
            Integer n = (Integer)bemMoArray[i].getAttribute("operationalState");
            if (n != 0) continue;
            this.action(bemMoArray[i], "startImmediate", nalNameValueArray);
        }
    }

    protected void reconfigureProgramPreparePrimaryDuw() throws BemException {
        String string = DuwUtil.getPrimaryDuwPiuLdn();
        BemMo bemMo = this.getMo(string);
        NalNameValue[] nalNameValueArray = new NalNameValue[]{};
        this.action(bemMo, "reconfigureProgramPrepare", nalNameValueArray);
    }

    protected void addRedundancyRepToSwAllocationIfExisting() throws BemException {
        String string = this.swAllocationRoleDuw.getLdn();
        String string2 = DuwUtil.getWizardRepertoireRedundancy();
        try {
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.swManagementMoi, MimRepertoire.MOTYPENAME, string2);
            BemMo bemMo = this.getMo(fixedRdnMoi.getLdn());
            BemMo bemMo2 = this.getMo(string);
            boolean bl = this.checkIfRedRepertoireIsAlreadyConnected();
            if (!bl) {
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("aRepertoire", bemMo)};
                this.action(bemMo2, "addRepertoire", nalNameValueArray);
            }
        }
        catch (RuntimeException runtimeException) {
            String string3 = "Adding Repertoire to the SwAllocation MO";
            String string4 = runtimeException.toString();
            throw new BemException(string3, "addRepToSwAllocationIfExisting()", string, string4, runtimeException);
        }
    }

    protected boolean checkIfRedRepertoireIsAlreadyConnected() throws BemException {
        String string = this.swAllocationRoleDuw.getLdn();
        String string2 = DuwUtil.getWizardRepertoireRedundancy();
        BemMo bemMo = this.getMo(string);
        boolean bl = false;
        BemMo[] bemMoArray = null;
        bemMoArray = (BemMo[])this.getAttribute(bemMo, "repertoireList");
        if (bemMoArray != null && bemMoArray.length != 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo2 = bemMoArray[i];
                String string3 = (String)bemMo2.getAttribute("name");
                if (!string2.equals(string3)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected void setPiuGroupNumberAttribute(Integer n) throws BemException {
        this.setPiuGroupNumberDUW(this.getMo(DuwUtil.getPrimaryDuwPiuLdn()), n);
        this.setPiuGroupNumberDUW(this.getMo(DuwUtil.getSecondaryDuwPiuLdn()), n);
    }

    private void setPiuGroupNumberDUW(BemMo bemMo, Integer n) throws BemException {
        if (this.isExisting(bemMo)) {
            this.setAttribute(bemMo, "piuGroupNumber", n);
        }
    }
}

