/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.util;

import java.io.File;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.common.util.GitHelper;

public class NpcUtils {
    private static final String DEFAULT_DESIGN_ENV_FILE_PATH;
    public static String DESIGN_ENV_FILE_PATH;
    private static final String DEFAULT_DESIGN_ENV_CABINET_FILE_NAME = "IubNpcCabinet.xml";
    public static String DESIGN_ENV_CABINET_FILE_NAME;
    private static final String DEFAULT_DESIGN_ENV_SITE_FILE_NAME = "IubNpcSiteEquipment.xml";
    public static String DESIGN_ENV_SITE_FILE_NAME;
    private static final String DEFAULT_DESIGN_ENV_IUB_FILE_NAME = "IubNpcTestConfiguration.xml";
    public static String DESIGN_ENV_IUB_FILE_NAME;
    public static String TARGET_ENV_FILE_PATH;
    private static String UNIX_ENV_FILE_PATH;
    public static final String TARGET_ENV_CABINET_FILE_NAME = "CabinetConfiguration.xml";
    public static final String TARGET_ENV_SITE_FILE_NAME = "SiteEquipmentConfiguration.xml";
    public static final String TARGET_ENV_IUB_FILE_NAME = "IubConfiguration.xml";
    private static File cabinetInputFile;
    private static File siteInputFile;
    private static File iubInputFile;
    public static boolean toBeConfiguredForNpc;

    public static boolean areNpcXmlFilesExisting() {
        boolean bl = false;
        int n = BemLanguageHelp.getEnvironment();
        if (n == 1) {
            cabinetInputFile = new File(DESIGN_ENV_FILE_PATH + DESIGN_ENV_CABINET_FILE_NAME);
            siteInputFile = new File(DESIGN_ENV_FILE_PATH + DESIGN_ENV_SITE_FILE_NAME);
            iubInputFile = new File(DESIGN_ENV_FILE_PATH + DESIGN_ENV_IUB_FILE_NAME);
        } else {
            String string = System.getProperty("file.separator");
            if (string.equals("/")) {
                TARGET_ENV_FILE_PATH = System.getProperty("user.home") + string + UNIX_ENV_FILE_PATH + string;
            }
            cabinetInputFile = new File(TARGET_ENV_FILE_PATH + TARGET_ENV_CABINET_FILE_NAME);
            siteInputFile = new File(TARGET_ENV_FILE_PATH + TARGET_ENV_SITE_FILE_NAME);
            iubInputFile = new File(TARGET_ENV_FILE_PATH + TARGET_ENV_IUB_FILE_NAME);
        }
        if (cabinetInputFile.exists() && siteInputFile.exists() && iubInputFile.exists()) {
            bl = true;
        }
        return bl;
    }

    public static void setNpcConfiguration(boolean bl) {
        toBeConfiguredForNpc = bl;
    }

    public static boolean getNpcConfiguration() {
        return toBeConfiguredForNpc;
    }

    public static String getInputFilePathName(String string) {
        if (string.equalsIgnoreCase("CABINET")) {
            return cabinetInputFile.getPath();
        }
        if (string.equalsIgnoreCase("SITE")) {
            return siteInputFile.getPath();
        }
        return iubInputFile.getPath();
    }

    public static void setDesigntestXmlDirectory(String string) {
        DESIGN_ENV_FILE_PATH = string;
    }

    public static void setDefaultDesigntestXmlSettings() {
        NpcUtils.setNpcConfiguration(false);
        DESIGN_ENV_FILE_PATH = DEFAULT_DESIGN_ENV_FILE_PATH;
        DESIGN_ENV_CABINET_FILE_NAME = DEFAULT_DESIGN_ENV_CABINET_FILE_NAME;
        DESIGN_ENV_SITE_FILE_NAME = DEFAULT_DESIGN_ENV_SITE_FILE_NAME;
        DESIGN_ENV_IUB_FILE_NAME = DEFAULT_DESIGN_ENV_IUB_FILE_NAME;
    }

    static {
        DESIGN_ENV_FILE_PATH = DEFAULT_DESIGN_ENV_FILE_PATH = GitHelper.getGitPath() + "rbs/sw/bsmss_1/bem/bemtest/bemtbcommon/regression/npc/";
        DESIGN_ENV_CABINET_FILE_NAME = DEFAULT_DESIGN_ENV_CABINET_FILE_NAME;
        DESIGN_ENV_SITE_FILE_NAME = DEFAULT_DESIGN_ENV_SITE_FILE_NAME;
        DESIGN_ENV_IUB_FILE_NAME = DEFAULT_DESIGN_ENV_IUB_FILE_NAME;
        TARGET_ENV_FILE_PATH = "c:\\Program Files\\Rbs\\Configuration\\Test\\";
        UNIX_ENV_FILE_PATH = "npcconf";
        cabinetInputFile = null;
        siteInputFile = null;
        iubInputFile = null;
        toBeConfiguredForNpc = false;
    }
}

