/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.util;

import java.util.Stack;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.util.PreconditionCheckTypes;
import se.ericsson.wcdma.rbs.bem.wizard.util.Preconditions;

public class PreconditionsCheck {
    private Preconditions currentPreconditions = null;
    private final StringBuffer resultBuf = new StringBuffer();
    private final Stack ctrlStack = new Stack();
    private BemMo baseMO = null;
    private BemMo[] baseMoChildren;
    private final Debug debug = new Debug();
    private static final int TRAVERSE_LEVEL = 10;
    private static final String MSG_IS_NOT_EXISTING = " is not existing.\n";
    private static final String MSG_IS_EXISTING = " is existing.\n";
    private static final String PROBABLE_CAUSE = "\nProbable cause:\n";
    private static final String CAUSE_BASIC_CV = "*\tBASIC_CV is not installed!";
    private static final String CAUSE_CABINET = "*\tCabinet Equipment Wizard has not been executed!";
    private static final String CAUSE_UNKNOWN = "*\tUnknown cause!";

    public PreconditionsCheck() {
        this.debug.enableDebug(false);
    }

    public Preconditions checkPreconditions(Preconditions preconditions) throws WizardException {
        this.currentPreconditions = preconditions;
        boolean bl = false;
        String string2 = null;
        try {
            if (this.currentPreconditions != null) {
                this.baseMO = new BemMoImpl(preconditions.getBaseLDN());
                this.resultBuf.append("\nResult of precondition check for " + preconditions.getOriginatingApplication() + ":\n");
                this.resultBuf.append("-------------------------------------------------\n");
                this.baseMoChildren = this.baseMO.getChildren(10, "", "");
                this.debug.printTrace("Retrived children to MO with LDN = " + preconditions.getBaseLDN());
                this.debug.printArray(this.baseMoChildren);
                for (String string2 : this.currentPreconditions.keySet()) {
                    Integer n = this.currentPreconditions.get(string2);
                    this.determineCheckType(string2, n);
                }
                if (this.ctrlStack.isEmpty()) {
                    this.resultBuf.append("Preconditions successfully evaluated! \n");
                    bl = true;
                } else {
                    this.determineProbableCause();
                }
            }
        }
        catch (NalCmException nalCmException) {
            bl = false;
            this.resultBuf.append("An error occured when checking precondtions for: " + string2 + "Detailed error description: " + nalCmException.getMessage() + "\n");
        }
        catch (WizardException wizardException) {
            String string3 = wizardException.getAdditionalInfo();
            StringBuffer stringBuffer = new StringBuffer();
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            stringBuffer.append("MO type: " + string2);
            string3 = stringBuffer.toString();
            wizardException.setAdditionalInfo(string3);
            throw wizardException;
        }
        finally {
            this.currentPreconditions.setPreconditionsFullfilled(bl);
            this.currentPreconditions.setResultMessage(this.resultBuf.toString());
            string2 = null;
        }
        return this.currentPreconditions;
    }

    private void determineCheckType(String string, Integer n) throws WizardException, NalCmException {
        this.debug.printTrace("Determines check type for MO Type = " + string);
        Stack<BemMo> stack = new Stack<BemMo>();
        try {
            if (this.baseMoChildren != null) {
                for (BemMo bemMo : this.baseMoChildren) {
                    String string2 = bemMo.getType();
                    if (!string2.equals(string)) continue;
                    stack.push(bemMo);
                }
            }
            if (n.equals(PreconditionCheckTypes.CHECK_IS_EXISTING)) {
                this.debug.printTrace("Check type = IS_EXISTING");
                this.checkIsExisting(stack, string);
            } else if (n.equals(PreconditionCheckTypes.CHECK_IS_NOT_EXISTING)) {
                this.debug.printTrace("Check type = IS_NOT_EXISTING");
                this.checkIsNotExisting(stack, string);
            } else if (n.equals(PreconditionCheckTypes.CHECK_SW_ALLOCATION_ROLES)) {
                this.debug.printTrace("Check type = CHECK_SW_ALLOCATION_ROLES");
            } else if (n.equals(PreconditionCheckTypes.CHECK_REPERTOIRES)) {
                this.debug.printTrace("Check type = CHECK_REPERTOIRES");
            } else if (n.equals(PreconditionCheckTypes.CHECK_PIU_TYPES)) {
                this.debug.printTrace("Check type = CHECK_PIU_TYPES");
            } else if (n.equals(PreconditionCheckTypes.CHECK_RBS_PRODUCT_NAME_OK)) {
                this.checkRbsProductName(stack, string);
            } else {
                this.debug.printTrace("Check type = UNKNOWN");
                this.resultBuf.append("Unknow check type = " + n + " for " + string + "\n");
                this.ctrlStack.push(string);
            }
        }
        catch (WizardException wizardException) {
            throw wizardException;
        }
        catch (Exception exception) {
            throw new WizardException("determineCheckType(String aMoType, Integer aCheckType)", null, null, null, exception);
        }
        finally {
            stack = null;
        }
    }

    private void checkIsExisting(Stack stack, String string) {
        if (stack.isEmpty()) {
            this.resultBuf.append(string + MSG_IS_NOT_EXISTING);
            this.ctrlStack.push(string);
        }
    }

    private void checkIsNotExisting(Stack stack, String string) throws WizardException {
        BemMo bemMo = null;
        try {
            while (!stack.isEmpty()) {
                bemMo = (BemMo)stack.pop();
                this.resultBuf.append(bemMo.getDN() + MSG_IS_EXISTING);
                this.ctrlStack.push(string);
            }
        }
        catch (Exception exception) {
            throw new WizardException("checkIsExisting(aMoStack, aMoType)", null, null, null, exception);
        }
        finally {
            bemMo = null;
        }
    }

    private void checkRbsProductName(Stack stack, String string) throws WizardException {
        BemMo bemMo = null;
        String string2 = "";
        try {
            while (!stack.isEmpty()) {
                bemMo = (BemMo)stack.pop();
                string2 = (String)bemMo.getAttribute("productName");
            }
            if (string2.equals("")) {
                this.resultBuf.append(string + CAUSE_CABINET);
                this.ctrlStack.push(string);
            }
        }
        catch (Exception exception) {
            throw new WizardException("checkRbsProductName(aMoStack, aMoType)", null, null, null, exception);
        }
    }

    private void determineProbableCause() throws WizardException {
        String string = null;
        this.resultBuf.append(PROBABLE_CAUSE);
        try {
            string = this.currentPreconditions.getOriginatingApplication();
            if (string.equals("Cabinet Equipment Wizard")) {
                this.resultBuf.append(CAUSE_BASIC_CV);
            } else if (string.equals("O&M Access Wizard")) {
                this.resultBuf.append(CAUSE_CABINET);
            } else if (string.equals("Site Equipment Wizard")) {
                this.resultBuf.append(CAUSE_CABINET);
            } else {
                this.resultBuf.append(CAUSE_UNKNOWN);
            }
        }
        catch (Exception exception) {
            throw new WizardException("determineProbableCause()", null, null, null, exception);
        }
        finally {
            string = null;
        }
    }

    static class Debug {
        private boolean isActive = false;

        Debug() {
        }

        void enableDebug(boolean bl) {
            this.isActive = bl;
        }

        void printTrace(String string) {
            if (this.isActive) {
                System.out.println(string);
            }
        }

        void printArray(Object[] objectArray) {
            if (objectArray != null && this.isActive) {
                for (Object object : objectArray) {
                    this.printTrace(object.toString());
                }
            }
        }
    }
}

