/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.control;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.control.GuiCheckAndShowWarning;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.model.CabinetFlexModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.view.IpView;

public class IpFlexController
extends BemWizardGuiController {
    private IpView view;
    private Rbs rbs;

    protected void init() {
        this.view = (IpView)this.getView();
        this.wizardHelp = WizardHelp.getTheInstance();
    }

    protected void beforeVisible() {
        this.rbs = CabinetFlexModel.getInstance().getRbs();
        try {
            IpAddressParameter ipAddressParameter = (IpAddressParameter)this.rbs.getCustomerParameterObject("ipAddress");
            IpAddressParameter ipAddressParameter2 = (IpAddressParameter)this.rbs.getCustomerParameterObject("subnetMask");
            IpAddressParameter ipAddressParameter3 = (IpAddressParameter)this.rbs.getCustomerParameterObject("defaultRouter");
            this.view.setIpAddress(ipAddressParameter);
            this.view.setSubnetMask(ipAddressParameter2);
            this.view.setDefaultRouter(ipAddressParameter3);
            this.view.updateGui();
            this.setWindowTitle();
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "beforeVisible()", null, "Setting up window for input", exception);
            System.out.println(wizardException.getMessage());
            super.displayError(wizardException);
            return;
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.view.setHeaderText(MessageFormat.format("Cabinet Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean next() {
        boolean bl = true;
        try {
            if (!GuiCheckAndShowWarning.checkIPAddressAndShowWarning(this.rbs, this)) {
                bl = false;
                return bl;
            }
        }
        catch (BemException bemException) {
            this.displayNextError(this.view, bemException);
            bl = false;
        }
        try {
            this.rbs.checkConsistency("IpOamCI");
        }
        catch (Exception exception) {
            this.displayNextError(this.view, exception);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        return true;
    }
}

