/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.control;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.PowerSupplyProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.model.CabinetFlexModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.view.PowerSupplyFlexView;

public class PowerSupplyFlexController
extends BemWizardGuiController {
    private PowerSupplyFlexView view;
    private Rbs rbs;

    protected void init() {
        this.view = (PowerSupplyFlexView)this.getView();
        this.wizardHelp = WizardHelp.getTheInstance();
    }

    protected void beforeVisible() {
        this.rbs = CabinetFlexModel.getInstance().getRbs();
        this.updateCustomerParameters();
        this.view.updateGui();
        this.setWindowTitle();
    }

    public void updateCustomerParameters() {
        try {
            CustomerParameterImpl customerParameterImpl;
            YesNoCustomerParameter yesNoCustomerParameter = null;
            yesNoCustomerParameter = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "configurePowerSupply");
            IntegerParameter integerParameter = null;
            integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "noOfPsu");
            PowerSupplyProvider powerSupplyProvider = (PowerSupplyProvider)((Object)this.rbs.getConfigItem("PowerSystemCI"));
            if (powerSupplyProvider != null) {
                if (powerSupplyProvider.isSupportSystemAvailable()) {
                    customerParameterImpl = null;
                    customerParameterImpl = (IntegerParameter)this.rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "noOfPdu");
                    this.view.setNoOfPdu((IntegerParameter)customerParameterImpl);
                    this.view.setSupportSystemAvailable(true);
                    TrueFalseCustomerParameter trueFalseCustomerParameter = (TrueFalseCustomerParameter)this.rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "multiplePowerSystem");
                    this.view.setMultiplePowerSystem(trueFalseCustomerParameter);
                    Enumeration enumeration = null;
                    enumeration = (Enumeration)this.rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "batteryType");
                    this.view.setBatteryType(enumeration);
                    IntegerParameter integerParameter2 = null;
                    integerParameter2 = (IntegerParameter)this.rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "noOfBfu");
                    this.view.setNoOfBfu(integerParameter2);
                } else {
                    customerParameterImpl = null;
                    customerParameterImpl = (IntegerParameter)this.rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "batteryCapacity");
                    this.view.setBatteryCapacity((IntegerParameter)customerParameterImpl);
                }
            }
            customerParameterImpl = null;
            customerParameterImpl = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "configureBatteryBackup");
            this.view.setConfigurePowerSupply(yesNoCustomerParameter);
            this.view.setNoOfPsu(integerParameter);
            this.view.setConfigureBattery((YesNoCustomerParameter)customerParameterImpl);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "beforeVisible()", null, "Setting up window for input", exception);
            System.out.println(wizardException.getMessage());
            super.displayError(wizardException);
            return;
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.view.setHeaderText(MessageFormat.format("Cabinet Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean next() {
        boolean bl = true;
        try {
            if (this.rbs.isConfigurationItemSupported("PowerSystemCI")) {
                this.rbs.checkConsistency("PowerSystemCI");
            }
        }
        catch (Exception exception) {
            this.displayNextError(this.view, exception);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        return true;
    }
}

