/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.precontrol;

import se.ericsson.wcdma.rbs.bem.common.mim.MimEthernetLink;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.model.CabinetFlexModel;

public class CheckPreconditionsPreController
implements SubInstaller {
    private final String description = "Handling import files";
    private Installer installer = null;
    private final String name = this.getClass().getName();
    private int totalReports = 10;
    private MoHandler moHandler;

    public CheckPreconditionsPreController(Installer installer) {
        this.installer = installer;
    }

    public int getTotalNoOfProgressReports() {
        return this.totalReports;
    }

    public boolean install() throws WizardException {
        this.installer.reportProgress(this.name, this.description);
        --this.totalReports;
        this.moHandler = new MoHandlerImpl();
        CabinetFlexModel cabinetFlexModel = CabinetFlexModel.getInstance();
        boolean bl = this.isWizardRun();
        cabinetFlexModel.setWizardRun(bl);
        while (this.totalReports > 0) {
            this.installer.reportProgress(this.name, this.description);
            --this.totalReports;
        }
        return true;
    }

    private boolean isWizardRun() throws WizardException {
        try {
            BemMo[] bemMoArray;
            boolean bl = false;
            BemMo bemMo = this.moHandler.getMo(BemLdn.LDN_IP);
            if (bemMo.isExisting() && (bemMoArray = this.moHandler.getChildren(bemMo, 1, MimEthernetLink.MOTYPENAME, "")) != null && bemMoArray.length > 0) {
                bl = true;
            }
            return bl;
        }
        catch (Exception exception) {
            throw new WizardException("Error in method isWizardRun", MimEthernetLink.MOTYPENAME, (Throwable)exception);
        }
    }

    public String getTheName() {
        return this.name;
    }

    public String getTheDescription() {
        return this.description;
    }
}

