/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterViewer;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;

public class IpView
extends BemWizardGuiView
implements CustomerParameterViewer {
    private IpAddressParameter ipAddressParameter;
    private IpAddressParameter subnetMaskParameter;
    private IpAddressParameter defaultRouterParameter;
    private CustomerParameterPanel ipAddressPanel;
    private CustomerParameterPanel subnetMaskPanel;
    private CustomerParameterPanel defaultRouterPanel;

    public void updateGui() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createIpPanel(), "North");
        this.addMainPanel(jPanel);
    }

    private JPanel createIpPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Ethernet link"));
        CustomerParameterTextField customerParameterTextField = null;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        customerParameterTextField = new CustomerParameterTextField(this.ipAddressParameter);
        customerParameterTextField.setColumns(16);
        this.ipAddressPanel = new CustomerParameterPanel("IP address:", customerParameterTextField, false);
        jPanel.add((Component)this.ipAddressPanel.getLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.ipAddressPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        customerParameterTextField = new CustomerParameterTextField(this.subnetMaskParameter);
        customerParameterTextField.setColumns(16);
        this.subnetMaskPanel = new CustomerParameterPanel("Subnet mask:", customerParameterTextField, false);
        jPanel.add((Component)this.subnetMaskPanel.getLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.subnetMaskPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        customerParameterTextField = new CustomerParameterTextField(this.defaultRouterParameter);
        customerParameterTextField.setColumns(16);
        this.defaultRouterPanel = new CustomerParameterPanel("Default router:", customerParameterTextField, false);
        jPanel.add((Component)this.defaultRouterPanel.getLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.defaultRouterPanel, gridBagConstraints);
        return jPanel;
    }

    public void setIpAddress(IpAddressParameter ipAddressParameter) {
        this.ipAddressParameter = ipAddressParameter;
    }

    public void setSubnetMask(IpAddressParameter ipAddressParameter) {
        this.subnetMaskParameter = ipAddressParameter;
    }

    public void setDefaultRouter(IpAddressParameter ipAddressParameter) {
        this.defaultRouterParameter = ipAddressParameter;
    }

    public String getGuiNameForCustomerParameter(String string) {
        if (this.ipAddressParameter.getName().equals(string)) {
            return this.ipAddressPanel.getLabel().getText();
        }
        if (this.subnetMaskParameter.getName().equals(string)) {
            return this.subnetMaskPanel.getLabel().getText();
        }
        if (this.defaultRouterParameter.getName().equals(string)) {
            return this.defaultRouterPanel.getLabel().getText();
        }
        return "";
    }

    public void setFocusOnCustomerParameterComponent(String string) {
        if (this.ipAddressParameter.getName().equals(string)) {
            this.ipAddressPanel.requestFocus();
        }
        if (this.subnetMaskParameter.getName().equals(string)) {
            this.subnetMaskPanel.requestFocus();
        }
        if (this.defaultRouterParameter.getName().equals(string)) {
            this.defaultRouterPanel.requestFocus();
        }
    }
}

