/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.control;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.util.InstallController;
import se.ericsson.wcdma.rbs.bem.wizard.view.NodeResultViewer;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.util.WizardHelp;

public class NodeResultController
extends BemWizardGuiController
implements ProgressReporter {
    private NodeResultViewer myView = null;
    private String currentProgressDescription = "Not started";
    private int currentProgressReported = 0;
    private int noProgressToReport = 0;
    private InstallController installController = null;

    protected void init() {
        this.myView = (NodeResultViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.setWindowTitle();
    }

    protected void afterVisible() {
        if (super.getPreviousControllerClass() == null) {
            super.setPreviousEnabled(false);
        }
        this.setNextEnabled(false);
        try {
            this.installController = this.createInstallController();
            this.noProgressToReport = this.installController.initiate();
            if (this.noProgressToReport == 0) {
                this.noProgressToReport = 1;
            }
            this.myView.setProgressMax(this.noProgressToReport);
            this.myView.setProgressMin(1);
            this.myView.setProgressCurrentValue(1);
            this.myView.setCurrentStatusText("Reading current configuration from the RBS");
            this.installController.start();
        }
        catch (Exception exception) {
            String string = exception.toString();
            this.myView.setResultText(string);
            this.installController = null;
        }
    }

    protected boolean checkSyntax() {
        return true;
    }

    protected boolean updateModel() {
        return true;
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Modify RBS Equipment Configuration page {0}({1})", string2, string3));
    }

    protected void stop() {
        if (this.installController != null) {
            this.installController.stopExecution();
        }
    }

    public void reportComplete(StringBuffer stringBuffer) {
        this.setNextEnabled(true);
        this.myView.setProgressCurrentValue(this.noProgressToReport);
        this.myView.setCurrentStatusText(" ");
        String string = "Current configuration successfully loaded from Radio Base Station!";
        if (stringBuffer != null) {
            string = string + "\n" + stringBuffer.toString();
        }
        this.myView.setResultText(string);
        this.installController = null;
    }

    public void reportError(BemException bemException) {
        ExceptionProperties exceptionProperties = bemException.getProperties();
        String string = exceptionProperties.getPopUpMessge();
        this.myView.setResultText(string);
    }

    public void reportProgress(String string, String string2) {
        this.reportProgress(string, string2, 1);
    }

    public void reportProgress(String string, String string2, int n) {
        this.currentProgressReported += n;
        this.currentProgressDescription = string2;
        if (this.currentProgressReported <= this.noProgressToReport) {
            this.myView.setProgressCurrentValue(this.currentProgressReported);
        }
        this.myView.setCurrentStatusText(string2);
    }

    public String getReportedProgress() {
        return this.currentProgressDescription;
    }

    public InstallController createInstallController() {
        Class[] classArray = this.wizardHelp.getAllPreControllerClasses();
        InstallController installController = new InstallController(this, classArray);
        return installController;
    }

    public String toString() {
        return this.currentProgressDescription;
    }
}

