/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AtmAndPtCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.EtbSlotParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.ExistOnNodeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.IpOverAtmLinkParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.PhysicalLineParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.ReqNoOfLinksParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.StandardParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TimeSlotsInFractionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.AtmPortProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.DynamicCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTableModel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.IpAtmPhysicalViewer;

public class IpAtmPhysicalController
extends BemWizardGuiController {
    public static final String LABEL_ETB_IN_SLOT = "ETB in slot:";
    public static final String LABEL_ETB_LINE = "ETB line:";
    public static final String LABEL_TERMINATION_TYPE = "Termination type:";
    public static final String LABEL_ETB_LINES_IMA = "ETB lines (IMA):";
    public static final String LABEL_REQ_NO_OF_LINKS = "Required number of links:";
    public static final String LABEL_SLOTS_IN_FRACTION = "Time slots in fraction:";
    public static final String ERROR_MESSAGE_IMA = "At least one ETB line must be selected in IMA configuration";
    public static final String ERROR_MESSAGE_REQ_NO_OF_LINKS = "Required number of links can not be larger than number of selected ETB lines";
    public static final String ERROR_MESSAGE_FRACTIONAL = "At least one Time Slot must be selected in a Fractional Configuration";
    static final String[] COLUMN_NAMES_FOR_IMA_LINES = new String[]{"ETB line", "Used"};
    static final String[] COLUMN_NAMES_FOR_SLOTS_IN_FRACTION = new String[]{"Time slot", "Active"};
    private static String NCONF_OAM_PAGE_HEADER = "O&M Access Configuration page {0}({1})";
    private CustomerParameterPanel[] slotsPanel = null;
    private CustomerParameterComboBox[] slotsCombo = null;
    private CustomerParameterPanel[] termTypesPanel = null;
    private CustomerParameterComboBox[] termTypesCombo = null;
    private CustomerParameterPanel[] linesPanel = null;
    private CustomerParameterComboBox[] linesCombo = null;
    private CustomerParameterTableModel[] imaLinesTableModel = null;
    private CustomerParameterPanel[] imaLinesPanel = null;
    private CustomerParameterTable[] imaLinesTable = null;
    private CustomerParameterPanel[] reqNoOfLinksPanel = null;
    private CustomerParameterTextField[] reqNoOfLinksComponent = null;
    private CustomerParameterTableModel[] timeSlotsFractionModel = null;
    private CustomerParameterPanel[] timeSlotsFractionPanel = null;
    private CustomerParameterTable[] timeSlotsFractionTable = null;
    private EtbSlotListener[] slotsComboListener = null;
    private TermTypeListener[] termTypesComboListener = null;
    private LineListener[] linesComboListener = null;
    private ImaTableModelListener[] imaLinesTableModelListener = null;
    private ReqNoOfLinkKeyListener[] reqNoOfLinksKeyListener = null;
    private IpAtmPhysicalViewer myView;
    private static final int DEFAULT = 0;
    private static final int REDUNDANT = 1;
    private static final int NO_OF_LINKS = 2;
    private final String[] IP_ATM_LINK;
    private WizardCIModel wizardCiModel;
    private DynamicCustomerParameterProvider dynamicCPProvider;
    private Rbs rbs;
    private AtmPortProvider atmPortProvider;
    private TerminationParameterList[] paramList;
    private EtbSlotParameter[] slotParameter;
    private PhysicalLineParameter[] lineParameter;
    private ReqNoOfLinksParameter[] reqNoOfLinksParameter;
    private TerminationTypeParameter[] termTypeParameter;
    private TimeSlotsInFractionParameter[] timeSlotsParameter;
    private StandardParameter[] standardParameter;
    private IpOverAtmLinkParameter[] ipOverAtmLinkParameter;
    private ExistOnNodeParameter[] existOnNodeParameter;
    private CustomerParameterPanel[][] atmLinkCPPanels;
    private boolean areGUIComponentsCreated;
    private boolean isListenerEnabled;
    private final boolean[] isIma;
    private final boolean[] isFractional;

    public IpAtmPhysicalController() {
        String[] stringArray = new String[2];
        stringArray[0] = AtmAndPtCI.getIpAtmPseudoPrefixByIndex(0);
        stringArray[1] = AtmAndPtCI.getIpAtmPseudoPrefixByIndex(1);
        this.IP_ATM_LINK = stringArray;
        this.dynamicCPProvider = null;
        this.rbs = null;
        this.atmPortProvider = null;
        this.paramList = null;
        this.slotParameter = null;
        this.lineParameter = null;
        this.reqNoOfLinksParameter = null;
        this.termTypeParameter = null;
        this.timeSlotsParameter = null;
        this.standardParameter = null;
        this.ipOverAtmLinkParameter = null;
        this.existOnNodeParameter = null;
        this.atmLinkCPPanels = null;
        this.areGUIComponentsCreated = false;
        this.isListenerEnabled = true;
        this.isIma = new boolean[2];
        this.isFractional = new boolean[2];
    }

    protected void init() {
        this.myView = (IpAtmPhysicalViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardCiModel = OamCIModel.getInstance();
        this.rbs = this.wizardCiModel.getRbs();
        this.dynamicCPProvider = (DynamicCustomerParameterProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
        this.atmPortProvider = (AtmPortProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
        this.setWindowTitle();
    }

    protected void beforeVisible() {
        super.setPreviousEnabled(false);
        super.setPreviousVisible(false);
    }

    protected void afterVisible() {
        if (this.areGUIComponentsCreated) {
            this.addListeners(0);
            this.addListeners(1);
            this.isListenerEnabled = true;
            int n = this.slotParameter[1].getAccessLevel();
            if (n == 0) {
                return;
            }
            this.slotParameter[1].getRestriction().setAccessLevel(3);
        } else {
            this.isListenerEnabled = false;
            try {
                this.createCPs();
                this.initiateGuiComponents();
                this.atmLinkCPPanels[0] = this.createGuiComponents(0);
                this.atmLinkCPPanels[1] = this.createGuiComponents(1);
                this.myView.setBemComponents(this.atmLinkCPPanels[0], 0);
                this.myView.setBemComponents(this.atmLinkCPPanels[1], 1);
                this.createListeners(0);
                this.createListeners(1);
                this.addListeners(0);
                this.addListeners(1);
                this.isListenerEnabled = true;
                int n = 0;
                while (true) {
                    if (n > true) break;
                    if (this.isCPForIpAtmLinkReadOnly(n)) {
                        this.setViewVisibilityFromCP(n);
                    } else {
                        this.initiateCustomerParameters(n);
                    }
                    ++n;
                }
                this.areGUIComponentsCreated = true;
            }
            catch (Exception exception) {
                WizardException wizardException = new WizardException(this.getClass().getName(), "afterVisible()", null, "Setting up window for input", exception);
                wizardException.setProperty("Problem, Low Level", "An error has occurred while reading from the model");
                super.displayError(wizardException);
            }
        }
    }

    protected boolean cancel() {
        this.removeListeners(0);
        this.removeListeners(1);
        this.isListenerEnabled = false;
        return super.cancel();
    }

    protected boolean previous() {
        this.removeListeners(0);
        this.removeListeners(1);
        this.isListenerEnabled = false;
        return true;
    }

    protected boolean next() {
        boolean bl = true;
        try {
            int n = 0;
            while (true) {
                if (n >= 2) break;
                if (!this.checkSyntax(n)) {
                    return false;
                }
                if (!this.isCPForIpAtmLinkReadOnly(n)) {
                    this.updateCP(n);
                }
                ++n;
            }
            ConfigurationItem configurationItem = this.rbs.getConfigItem("AtmAndPtCI");
            List list = this.paramList[0].getAllPseudos();
            list.addAll(this.paramList[1].getAllPseudos());
            configurationItem.checkConsistency(list);
        }
        catch (BemException bemException) {
            bl = false;
            this.displayError(bemException);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "next()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        if (bl) {
            this.removeListeners(0);
            this.removeListeners(1);
            this.isListenerEnabled = false;
        }
        return bl;
    }

    private void createCPs() throws BemException {
        this.paramList = new TerminationParameterList[2];
        this.slotParameter = new EtbSlotParameter[2];
        this.termTypeParameter = new TerminationTypeParameter[2];
        this.lineParameter = new PhysicalLineParameter[2];
        this.timeSlotsParameter = new TimeSlotsInFractionParameter[2];
        this.standardParameter = new StandardParameter[2];
        this.reqNoOfLinksParameter = new ReqNoOfLinksParameter[2];
        this.ipOverAtmLinkParameter = new IpOverAtmLinkParameter[2];
        this.existOnNodeParameter = new ExistOnNodeParameter[2];
        int n = 0;
        while (true) {
            if (n >= 2) break;
            List list = this.dynamicCPProvider.createCP(this.IP_ATM_LINK[n]);
            this.paramList[n] = (TerminationParameterList)list.get(0);
            this.slotParameter[n] = this.paramList[n].getSlotParameter();
            this.termTypeParameter[n] = this.paramList[n].getTerminationTypeParameter();
            this.lineParameter[n] = this.paramList[n].getLineParameter();
            this.timeSlotsParameter[n] = this.paramList[n].getTimeSlotsInFractionParameter();
            this.standardParameter[n] = this.paramList[n].getStandardParameter();
            this.reqNoOfLinksParameter[n] = this.paramList[n].getRequiredNumberOfLinksParameter();
            this.ipOverAtmLinkParameter[n] = this.paramList[n].getIpOverAtmLinkParameter();
            this.existOnNodeParameter[n] = this.paramList[n].getExistOnNodeParameter();
            ++n;
        }
    }

    private void initiateGuiComponents() {
        this.slotsPanel = new CustomerParameterPanel[2];
        this.slotsCombo = new CustomerParameterComboBox[2];
        this.termTypesPanel = new CustomerParameterPanel[2];
        this.termTypesCombo = new CustomerParameterComboBox[2];
        this.linesPanel = new CustomerParameterPanel[2];
        this.linesCombo = new CustomerParameterComboBox[2];
        this.imaLinesTableModel = new CustomerParameterTableModel[2];
        this.imaLinesPanel = new CustomerParameterPanel[2];
        this.imaLinesTable = new CustomerParameterTable[2];
        this.reqNoOfLinksPanel = new CustomerParameterPanel[2];
        this.reqNoOfLinksComponent = new CustomerParameterTextField[2];
        this.timeSlotsFractionModel = new CustomerParameterTableModel[2];
        this.timeSlotsFractionPanel = new CustomerParameterPanel[2];
        this.timeSlotsFractionTable = new CustomerParameterTable[2];
        this.slotsComboListener = new EtbSlotListener[2];
        this.termTypesComboListener = new TermTypeListener[2];
        this.linesComboListener = new LineListener[2];
        this.imaLinesTableModelListener = new ImaTableModelListener[2];
        this.reqNoOfLinksKeyListener = new ReqNoOfLinkKeyListener[2];
        this.atmLinkCPPanels = new CustomerParameterPanel[2][6];
    }

    private CustomerParameterPanel[] createGuiComponents(int n) {
        this.setEtbSlotParameter(this.slotParameter[n], n);
        this.setTerminationTypeParameter(this.termTypeParameter[n], n);
        this.setLineParameter(this.lineParameter[n], n);
        this.setLineParameterForIma(this.lineParameter[n], n);
        this.setTimeSlotsInFractionParameter(this.timeSlotsParameter[n], n);
        this.setReqNumberOfLinksParameter(this.reqNoOfLinksParameter[n], n);
        CustomerParameterPanel[] customerParameterPanelArray = new CustomerParameterPanel[]{this.slotsPanel[n], this.termTypesPanel[n], this.linesPanel[n], this.imaLinesPanel[n], this.reqNoOfLinksPanel[n], this.timeSlotsFractionPanel[n]};
        return customerParameterPanelArray;
    }

    private void setEtbSlotParameter(EtbSlotParameter etbSlotParameter, int n) {
        this.slotsCombo[n] = new CustomerParameterComboBox(etbSlotParameter);
        this.slotsPanel[n] = new CustomerParameterPanel(LABEL_ETB_IN_SLOT, this.slotsCombo[n], false);
    }

    private void setTerminationTypeParameter(TerminationTypeParameter terminationTypeParameter, int n) {
        this.termTypesCombo[n] = new CustomerParameterComboBox(terminationTypeParameter);
        this.termTypesPanel[n] = new CustomerParameterPanel(LABEL_TERMINATION_TYPE, this.termTypesCombo[n], false);
    }

    private void setLineParameter(PhysicalLineParameter physicalLineParameter, int n) {
        this.linesCombo[n] = new CustomerParameterComboBox(physicalLineParameter);
        this.linesPanel[n] = new CustomerParameterPanel(LABEL_ETB_LINE, this.linesCombo[n], false);
    }

    private void setLineParameterForIma(PhysicalLineParameter physicalLineParameter, int n) {
        int n2;
        if (this.imaLinesTableModel[n] != null) {
            this.imaLinesTableModel[n].deleteAllRows();
        }
        if ((n2 = physicalLineParameter.getAccessLevel()) == 0) {
            this.imaLinesTableModel[n] = new CustomerParameterTableModel(physicalLineParameter, COLUMN_NAMES_FOR_IMA_LINES, true);
        } else {
            this.imaLinesTableModel[n] = new CustomerParameterTableModel(physicalLineParameter, COLUMN_NAMES_FOR_IMA_LINES);
            this.imaLinesTableModel[n].setEditableColumn(0, false);
        }
        this.imaLinesTable[n] = new CustomerParameterTable(this.imaLinesTableModel[n]);
        int n3 = this.imaLinesTableModel[n].getRowCount();
        if (n3 >= 5) {
            this.imaLinesTable[n].setPreferredScrollableViewportSize(this.imaLinesTable[n].calculatePreferredScrollableViewportSize(5));
        } else {
            this.imaLinesTable[n].setPreferredScrollableViewportSize(this.imaLinesTable[n].calculatePreferredScrollableViewportSize(n3));
        }
        this.imaLinesTable[n].setRowSelectionAllowed(true);
        this.imaLinesTable[n].setSelectionMode(0);
        this.imaLinesPanel[n] = new CustomerParameterPanel(LABEL_ETB_LINES_IMA, this.imaLinesTable[n], false);
    }

    private void setReqNumberOfLinksParameter(IntegerParameter integerParameter, int n) {
        this.reqNoOfLinksComponent[n] = new CustomerParameterTextField(integerParameter);
        this.reqNoOfLinksComponent[n].setColumns(3);
        this.reqNoOfLinksPanel[n] = new CustomerParameterPanel(LABEL_REQ_NO_OF_LINKS, this.reqNoOfLinksComponent[n], false);
        this.reqNoOfLinksPanel[n].setLayout(new GridBagLayout());
    }

    private void setTimeSlotsInFractionParameter(TimeSlotsInFractionParameter timeSlotsInFractionParameter, int n) {
        int n2;
        if (this.timeSlotsFractionModel[n] != null) {
            this.timeSlotsFractionModel[n].deleteAllRows();
        }
        if ((n2 = this.timeSlotsParameter[n].getAccessLevel()) == 0) {
            this.timeSlotsFractionModel[n] = new CustomerParameterTableModel(timeSlotsInFractionParameter, COLUMN_NAMES_FOR_SLOTS_IN_FRACTION, true);
        } else {
            this.timeSlotsFractionModel[n] = new CustomerParameterTableModel(timeSlotsInFractionParameter, COLUMN_NAMES_FOR_SLOTS_IN_FRACTION);
            this.timeSlotsFractionModel[n].setEditableColumn(0, false);
        }
        this.timeSlotsFractionTable[n] = new CustomerParameterTable(this.timeSlotsFractionModel[n]);
        this.timeSlotsFractionTable[n].setPreferredScrollableViewportSize(this.timeSlotsFractionTable[n].calculatePreferredScrollableViewportSize(5));
        this.timeSlotsFractionTable[n].setRowSelectionAllowed(true);
        this.timeSlotsFractionTable[n].setSelectionMode(0);
        this.timeSlotsFractionPanel[n] = new CustomerParameterPanel(LABEL_SLOTS_IN_FRACTION, this.timeSlotsFractionTable[n], false);
    }

    private void setViewVisibilityFromCP(int n) throws BemException {
        String string = this.slotParameter[n].getValue();
        String string2 = this.termTypeParameter[n].getValue();
        this.setViewVisibility(n, string, string2);
    }

    private void setViewVisibilityInGui(int n) throws BemException {
        String string = (String)this.slotsCombo[n].getSelectedItem();
        String string2 = (String)this.termTypesCombo[n].getSelectedItem();
        this.setViewVisibility(n, string, string2);
    }

    private void setViewVisibility(int n, String string, String string2) throws BemException {
        if (string.equals("None")) {
            this.showTerminationTypeComponent(n, false);
            this.showEtbLineComponent(n, false);
            this.showImaEtbLinesComponent(n, false);
            this.showTimeSlotsComponent(n, false);
            return;
        }
        this.showTerminationTypeComponent(n, true);
        this.isIma[n] = this.atmPortProvider.isIma(string, string2);
        this.showEtbLineComponent(n, !this.isIma[n]);
        this.showImaEtbLinesComponent(n, this.isIma[n]);
        this.isFractional[n] = this.atmPortProvider.isFractional(string, string2);
        this.showTimeSlotsComponent(n, this.isFractional[n]);
    }

    private boolean isCPForIpAtmLinkReadOnly(int n) {
        int n2;
        int n3;
        boolean bl = true;
        int n4 = this.slotParameter[n].getAccessLevel();
        int n5 = n4 + (n3 = this.lineParameter[n].getAccessLevel()) + (n2 = this.termTypeParameter[n].getAccessLevel());
        if (n5 != 0) {
            bl = false;
        }
        return bl;
    }

    private void initiateCustomerParameters(int n) throws BemException {
        String[] stringArray;
        String string = (String)this.slotsCombo[n].getSelectedItem();
        if (string == null && (stringArray = this.atmPortProvider.getAvailableSlots()) != null && stringArray.length >= 1) {
            string = stringArray[0];
        }
        if (string != null) {
            int n2;
            if (DuwUtil.hasDuw()) {
                this.updateTerminatonTypeCpFromGui(n);
            }
            if ((n2 = this.slotParameter[n].getAccessLevel()) == 3) {
                String string2;
                this.slotParameter[n].setValue(string);
                String[] stringArray2 = null;
                stringArray2 = DuwUtil.hasDuw() ? this.atmPortProvider.getAllowedLinesMatchingDefaultOamAtmLink() : this.atmPortProvider.getAvailableLines(string);
                if (stringArray2 != null && stringArray2.length >= 1 && (n2 = this.lineParameter[n].getAccessLevel()) == 3 && (string2 = this.lineParameter[n].getValue()).equals("##UNDEFINED")) {
                    this.lineParameter[n].setValue(stringArray2[0]);
                }
            }
        }
        this.setViewVisibilityInGui(n);
    }

    private void updateTerminatonTypeCpFromGui(int n) {
        String string;
        int n2 = this.termTypeParameter[n].getAccessLevel();
        if (n2 == 3 && (string = (String)this.termTypesCombo[n].getSelectedItem()) != null) {
            this.termTypeParameter[n].setValue(string);
        }
    }

    private void createListeners(int n) {
        this.slotsComboListener[n] = new EtbSlotListener(n);
        this.termTypesComboListener[n] = new TermTypeListener(n);
        this.linesComboListener[n] = new LineListener(n);
        this.imaLinesTableModelListener[n] = new ImaTableModelListener(n);
        this.reqNoOfLinksKeyListener[n] = new ReqNoOfLinkKeyListener(n);
    }

    private void addListeners(int n) {
        this.slotsCombo[n].addActionListener(this.slotsComboListener[n]);
        this.termTypesCombo[n].addActionListener(this.termTypesComboListener[n]);
        this.linesCombo[n].addActionListener(this.linesComboListener[n]);
        this.imaLinesTableModel[n].addTableModelListener(this.imaLinesTableModelListener[n]);
        this.reqNoOfLinksComponent[n].addKeyListener(this.reqNoOfLinksKeyListener[n]);
    }

    private void removeListeners(int n) {
        this.slotsCombo[n].removeActionListener(this.slotsComboListener[n]);
        this.termTypesCombo[n].removeActionListener(this.termTypesComboListener[n]);
        this.linesCombo[n].removeActionListener(this.linesComboListener[n]);
        this.imaLinesTableModel[n].removeTableModelListener(this.imaLinesTableModelListener[n]);
        this.reqNoOfLinksComponent[n].removeKeyListener(this.reqNoOfLinksKeyListener[n]);
    }

    private void showEtbLineComponent(int n, boolean bl) {
        this.linesPanel[n].setVisible(bl);
        this.linesPanel[n].getLabel().setVisible(bl);
    }

    private void showTerminationTypeComponent(int n, boolean bl) {
        this.termTypesPanel[n].setVisible(bl);
        this.termTypesPanel[n].getLabel().setVisible(bl);
    }

    private void showImaEtbLinesComponent(int n, boolean bl) {
        this.imaLinesPanel[n].setVisible(bl);
        this.imaLinesPanel[n].getLabel().setVisible(bl);
        this.reqNoOfLinksPanel[n].setVisible(bl);
        this.reqNoOfLinksPanel[n].getLabel().setVisible(bl);
    }

    private void showTimeSlotsComponent(int n, boolean bl) {
        this.timeSlotsFractionPanel[n].setVisible(bl);
        this.timeSlotsFractionPanel[n].getLabel().setVisible(bl);
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = NCONF_OAM_PAGE_HEADER;
        String string3 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string4 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format(string2, string3, string4));
    }

    private boolean checkSyntax(int n) {
        boolean bl = true;
        try {
            String[] stringArray;
            String string = (String)this.slotsCombo[n].getSelectedItem();
            String string2 = (String)this.termTypesCombo[n].getSelectedItem();
            boolean bl2 = this.atmPortProvider.isIma(string, string2);
            boolean bl3 = this.atmPortProvider.isFractional(string, string2);
            if (bl2) {
                String[] stringArray2 = this.imaLinesTableModel[n].getSelectedItemsInRows();
                if (stringArray2 == null || stringArray2 != null && stringArray2.length < 1) {
                    JOptionPane.showMessageDialog(null, ERROR_MESSAGE_IMA, "", 0);
                } else {
                    int n2 = stringArray2.length;
                    String string3 = this.reqNoOfLinksParameter[n].getValue();
                    int n3 = Integer.parseInt(string3);
                    if (n3 > n2) {
                        bl = false;
                        JOptionPane.showMessageDialog(null, ERROR_MESSAGE_REQ_NO_OF_LINKS, "", 0);
                    }
                }
            } else if (bl3 && (stringArray = this.timeSlotsFractionModel[n].getSelectedItemsInRows()) != null && stringArray.length < 1) {
                bl = false;
                JOptionPane.showMessageDialog(null, ERROR_MESSAGE_FRACTIONAL, "", 0);
            }
        }
        catch (BemException bemException) {
            bl = false;
            JOptionPane.showMessageDialog(null, "Unknown Error", bemException.toString(), 0);
        }
        return bl;
    }

    private void updateCP(int n) throws BemException {
        this.isListenerEnabled = false;
        String string = (String)this.slotsCombo[n].getSelectedItem();
        if (string.equals("None")) {
            this.paramList[n].setAsIgnoredCP();
            return;
        }
        String string2 = (String)this.termTypesCombo[n].getSelectedItem();
        boolean bl = this.atmPortProvider.isIma(string, string2);
        boolean bl2 = this.atmPortProvider.isFractional(string, string2);
        if (bl) {
            String[] stringArray = this.imaLinesTableModel[n].getSelectedItemsInRows();
            this.lineParameter[n].setValue(stringArray);
            this.timeSlotsParameter[n].setValue("##UNDEFINED");
            this.timeSlotsParameter[n].getRestriction().setAccessLevel(1);
        } else if (bl2) {
            String[] stringArray = this.timeSlotsFractionModel[n].getSelectedItemsInRows();
            this.timeSlotsParameter[n].setValue(stringArray);
            this.reqNoOfLinksParameter[n].setValue("##UNDEFINED");
            this.reqNoOfLinksParameter[n].getRestriction().setAccessLevel(1);
        } else {
            this.reqNoOfLinksParameter[n].setValue("##UNDEFINED");
            this.reqNoOfLinksParameter[n].getRestriction().setAccessLevel(1);
            this.timeSlotsParameter[n].setValue("##UNDEFINED");
            this.timeSlotsParameter[n].getRestriction().setAccessLevel(1);
        }
        this.isListenerEnabled = true;
    }

    private class ReqNoOfLinkKeyListener
    extends KeyAdapter {
        private final int linkId;

        public ReqNoOfLinkKeyListener(int n) {
            this.linkId = n;
        }

        public void keyReleased(KeyEvent keyEvent) {
            String string;
            CustomerParameterTextField customerParameterTextField = (CustomerParameterTextField)keyEvent.getSource();
            if (IpAtmPhysicalController.this.isListenerEnabled && (string = customerParameterTextField.getText()) != null && !string.equals(IpAtmPhysicalController.this.reqNoOfLinksParameter[this.linkId].getValue())) {
                int n = IpAtmPhysicalController.this.reqNoOfLinksParameter[this.linkId].getAccessLevel();
                if (n != 0) {
                    IpAtmPhysicalController.this.reqNoOfLinksParameter[this.linkId].setValue(string);
                }
                try {
                    IpAtmPhysicalController.this.setViewVisibilityInGui(this.linkId);
                }
                catch (BemException bemException) {
                    JOptionPane.showMessageDialog(null, "Unknown Error", bemException.toString(), 0);
                }
            }
        }
    }

    private class ImaTableModelListener
    implements TableModelListener {
        private final int linkId;

        public ImaTableModelListener(int n) {
            this.linkId = n;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0) {
                if (!IpAtmPhysicalController.this.isIma[this.linkId]) {
                    return;
                }
                String[] stringArray = IpAtmPhysicalController.this.imaLinesTableModel[this.linkId].getSelectedItemsInRows();
                int n = stringArray.length;
                if (n > 0) {
                    int n2 = IpAtmPhysicalController.this.reqNoOfLinksParameter[this.linkId].getAccessLevel();
                    if (n2 != 0) {
                        IntegerRange integerRange = new IntegerRange(1, n);
                        IpAtmPhysicalController.this.reqNoOfLinksParameter[this.linkId].getRestriction().setRange(integerRange, true);
                    }
                    if ((n2 = IpAtmPhysicalController.this.lineParameter[this.linkId].getAccessLevel()) != 0) {
                        IpAtmPhysicalController.this.lineParameter[this.linkId].setValue(stringArray);
                    }
                }
                try {
                    IpAtmPhysicalController.this.setViewVisibilityInGui(this.linkId);
                }
                catch (BemException bemException) {
                    JOptionPane.showMessageDialog(null, "Unknown Error", bemException.toString(), 0);
                }
            }
        }
    }

    private class LineListener
    implements ActionListener {
        private final int linkId;

        public LineListener(int n) {
            this.linkId = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomerParameterComboBox customerParameterComboBox = (CustomerParameterComboBox)actionEvent.getSource();
            if (IpAtmPhysicalController.this.isListenerEnabled) {
                if (IpAtmPhysicalController.this.isIma[this.linkId]) {
                    return;
                }
                String string = (String)customerParameterComboBox.getSelectedItem();
                if (string != null && !string.equals("-")) {
                    int n;
                    if (!string.equals(IpAtmPhysicalController.this.lineParameter[this.linkId].getValue()) && (n = IpAtmPhysicalController.this.lineParameter[this.linkId].getAccessLevel()) != 0) {
                        IpAtmPhysicalController.this.lineParameter[this.linkId].setValue(string);
                    }
                    try {
                        IpAtmPhysicalController.this.setViewVisibilityInGui(this.linkId);
                    }
                    catch (BemException bemException) {
                        JOptionPane.showMessageDialog(null, "Unknown Error", bemException.toString(), 0);
                    }
                }
            }
        }
    }

    private class TermTypeListener
    implements ActionListener {
        private final int linkId;

        public TermTypeListener(int n) {
            this.linkId = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            CustomerParameterComboBox customerParameterComboBox = (CustomerParameterComboBox)actionEvent.getSource();
            if (IpAtmPhysicalController.this.isListenerEnabled && (string = (String)customerParameterComboBox.getSelectedItem()) != null && !string.equals("-")) {
                int n;
                try {
                    IpAtmPhysicalController.this.setViewVisibilityInGui(this.linkId);
                }
                catch (BemException bemException) {
                    JOptionPane.showMessageDialog(null, "Unknown Error", bemException.toString(), 0);
                }
                if (!string.equals(IpAtmPhysicalController.this.termTypeParameter[this.linkId].getValue()) && (n = IpAtmPhysicalController.this.termTypeParameter[this.linkId].getAccessLevel()) != 0) {
                    IpAtmPhysicalController.this.termTypeParameter[this.linkId].setValue(string);
                }
            }
        }
    }

    private class EtbSlotListener
    implements ActionListener {
        private final int linkId;

        public EtbSlotListener(int n) {
            this.linkId = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            CustomerParameterComboBox customerParameterComboBox = (CustomerParameterComboBox)actionEvent.getSource();
            if (IpAtmPhysicalController.this.isListenerEnabled && (string = (String)customerParameterComboBox.getSelectedItem()) != null && !string.equals("-")) {
                int n;
                if (!string.equals(IpAtmPhysicalController.this.slotParameter[this.linkId].getValue()) && (n = IpAtmPhysicalController.this.slotParameter[this.linkId].getAccessLevel()) != 0) {
                    IpAtmPhysicalController.this.slotParameter[this.linkId].setValue(string);
                }
                try {
                    IpAtmPhysicalController.this.setViewVisibilityInGui(this.linkId);
                }
                catch (BemException bemException) {
                    JOptionPane.showMessageDialog(null, "Unknown Error", bemException.toString(), 0);
                }
            }
        }
    }
}

