/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iprouting.IpRoutingCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.DynamicCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTableModel;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.AddStaticRouteDialogController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.AddStaticRouteDialogView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.RoutingViewer;

public class RoutingController
extends BemWizardGuiController {
    private static String NCONF_OAM_PAGE_HEADER = "O&M Access Configuration page {0}({1})";
    private static String NCONF_OAM_ROT_DELETE_ROUTE = "Are you sure that the selected route shall be deleted?";
    private RoutingViewer myView = null;
    private JButton addButton = null;
    private JButton deleteButton = null;
    private AddButtonActionListener addButtonActionListener = null;
    private DeleteButtonActionListener deleteButtonActionListener = null;
    private WizardCIModel oamCIModel;
    private Rbs rbs;
    private IpRoutingCI ipRoutingCI = null;
    private DynamicCustomerParameterProvider dynamicCustomerParameterProvider = null;

    protected void init() {
        this.myView = (RoutingViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.oamCIModel = OamCIModel.getInstance();
        this.rbs = this.oamCIModel.getRbs();
        this.ipRoutingCI = (IpRoutingCI)this.rbs.getConfigItem("IpRoutingCI");
        this.dynamicCustomerParameterProvider = this.ipRoutingCI;
        this.setWindowTitle();
    }

    protected void afterVisible() {
        try {
            this.addButton = this.myView.getAddButton();
            this.deleteButton = this.myView.getDeleteButton();
            String[] stringArray = new String[]{"Dest. IP Address", "Dest. Subnet Mask", "Next Hop IP Address", "Route Metric", "Redistribute"};
            Object[][] objectArray = this.getAttributeData();
            this.myView.setRoutingTableParameters(objectArray, stringArray);
            this.addButtonActionListener = new AddButtonActionListener();
            this.deleteButtonActionListener = new DeleteButtonActionListener();
            this.addButton.addActionListener(this.addButtonActionListener);
            this.deleteButton.addActionListener(this.deleteButtonActionListener);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("RoutingController", "afterVisible()", null, "Setting up window for input", exception);
            super.displayError(wizardException);
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = NCONF_OAM_PAGE_HEADER;
        String string3 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string4 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format(string2, string3, string4));
    }

    protected boolean previous() {
        this.removeActionListeners();
        return true;
    }

    protected boolean cancel() {
        this.removeActionListeners();
        return super.cancel();
    }

    protected boolean next() {
        boolean bl = true;
        try {
            this.rbs.checkConsistency("IpRoutingCI");
        }
        catch (Exception exception) {
            super.displayErrorMessage(exception.toString());
            bl = false;
        }
        if (bl) {
            this.removeActionListeners();
        }
        return bl;
    }

    private void removeActionListeners() {
        this.addButton.removeActionListener(this.addButtonActionListener);
        this.deleteButton.removeActionListener(this.deleteButtonActionListener);
    }

    public void addStaticRoute(ArrayList arrayList) {
        Vector vector = new Vector();
        for (int i = 1; i < 6; ++i) {
            vector.add(arrayList.get(i));
        }
        this.myView.addRow(vector);
    }

    public void cancelAddStaticRoute(List list) {
        String string = "";
        try {
            string = this.dynamicCustomerParameterProvider.removeCP(list);
        }
        catch (Exception exception) {
            string = "Remove error. Reason=" + exception.toString();
        }
        if (!string.equals("")) {
            this.displayErrorMessage(string);
        }
    }

    private Object[][] getAttributeData() throws BemException {
        Object[][] objectArray;
        ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>();
        ArrayList<CustomerParameter> arrayList2 = new ArrayList<CustomerParameter>();
        ArrayList<CustomerParameter> arrayList3 = new ArrayList<CustomerParameter>();
        ArrayList<CustomerParameter> arrayList4 = new ArrayList<CustomerParameter>();
        ArrayList<CustomerParameter> arrayList5 = new ArrayList<CustomerParameter>();
        int n = 0;
        while (true) {
            Integer n2 = ++n;
            objectArray = MessageFormat.format("R_{0}_", n2);
            if (!this.rbs.isParameterSupported((String)objectArray + "routeIpAddress")) break;
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject((String)objectArray + "routeIpAddress");
            if (customerParameter.getAccessLevel() == 1) continue;
            arrayList.add(customerParameter);
            customerParameter = this.rbs.getCustomerParameterObject((String)objectArray + "routeSubnetMask");
            arrayList2.add(customerParameter);
            customerParameter = this.rbs.getCustomerParameterObject((String)objectArray + "hopIpAddress");
            arrayList3.add(customerParameter);
            customerParameter = this.rbs.getCustomerParameterObject((String)objectArray + "routeMetric");
            arrayList4.add(customerParameter);
            customerParameter = this.rbs.getCustomerParameterObject((String)objectArray + "redistribute");
            arrayList5.add(customerParameter);
        }
        int n3 = arrayList.size();
        objectArray = new Object[n3][5];
        for (int i = 0; i < n3; ++i) {
            objectArray[i][0] = arrayList.get(i);
            objectArray[i][1] = arrayList2.get(i);
            objectArray[i][2] = arrayList3.get(i);
            objectArray[i][3] = arrayList4.get(i);
            objectArray[i][4] = arrayList5.get(i);
        }
        return objectArray;
    }

    IpRoutingCI getIpRoutingCI() {
        return this.ipRoutingCI;
    }

    class DeleteButtonActionListener
    implements ActionListener {
        DeleteButtonActionListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = RoutingController.this.displayConfirmDialog(NCONF_OAM_ROT_DELETE_ROUTE);
            if (!bl) return;
            CustomerParameterTable customerParameterTable = RoutingController.this.myView.getRoutingTable();
            int[] nArray = customerParameterTable.getSelectedRows();
            CustomerParameterTableModel customerParameterTableModel = RoutingController.this.myView.getRoutingTableModel();
            if (nArray == null || nArray.length <= 0) return;
            for (int i = nArray.length - 1; i >= 0; --i) {
                ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>();
                int n = nArray[i];
                CustomerParameter customerParameter = (CustomerParameter)customerParameterTableModel.getValueAt(n, 0);
                CustomerParameter customerParameter2 = (CustomerParameter)customerParameterTableModel.getValueAt(n, 1);
                CustomerParameter customerParameter3 = (CustomerParameter)customerParameterTableModel.getValueAt(n, 2);
                CustomerParameter customerParameter4 = (CustomerParameter)customerParameterTableModel.getValueAt(n, 3);
                CustomerParameter customerParameter5 = (CustomerParameter)customerParameterTableModel.getValueAt(n, 4);
                arrayList.add(customerParameter);
                arrayList.add(customerParameter2);
                arrayList.add(customerParameter3);
                arrayList.add(customerParameter4);
                arrayList.add(customerParameter5);
                RoutingController.this.myView.deleteRow(n);
                String string = "";
                try {
                    string = RoutingController.this.dynamicCustomerParameterProvider.removeCP(arrayList);
                }
                catch (Exception exception) {
                    string = "Remove error. Reason=" + exception.toString();
                }
                if (string.equals("")) continue;
                RoutingController.this.displayErrorMessage(string);
            }
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        AddButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RoutingController.this.startDialog(true, WizardLanguageHelp.getTranslation("NCONF_OAM_ADDSTATIC_WINDOW_TITLE"), null, AddStaticRouteDialogView.class, AddStaticRouteDialogController.class);
        }
    }
}

