/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ConfigurationGroupParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioIfTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.SectorOptionsView;

public class SectorOptionsController
extends BemWizardGuiController {
    private static final int MAX_NUMBER_OF_BASE_BANDS_POOLS = 2;
    private SectorOptionsView myView;
    private boolean isListenerEnabled;
    private Rbs rbs;
    private final List customerParameterNames = new ArrayList();
    private RadioIfTypeParameter[] radioIfTypeParameters;
    private ConfigurationGroupParameter configurationGroupParameter;
    private WizardCIModel siteCIModel;

    protected void init() {
        this.myView = (SectorOptionsView)this.getView();
        this.wizardHelp = WizardHelp.getTheInstance();
        this.siteCIModel = SiteCIModel.getInstance();
        this.rbs = this.siteCIModel.getRbs();
        this.isListenerEnabled = false;
        this.setWindowTitle();
    }

    protected void afterVisible() {
        Enumeration[] enumerationArray = null;
        String[] stringArray = null;
        YesNoCustomerParameter[] yesNoCustomerParameterArray = null;
        Enumeration[] enumerationArray2 = null;
        Enumeration[] enumerationArray3 = null;
        this.customerParameterNames.clear();
        try {
            this.myView.setRadioIfTypes(this.getRadioIfTypeParameters());
            int n = this.rbs.getMaxNumberOfSectors();
            enumerationArray = new Enumeration[n];
            stringArray = new String[n];
            yesNoCustomerParameterArray = new YesNoCustomerParameter[n];
            enumerationArray2 = new Enumeration[n];
            enumerationArray3 = new Enumeration[n];
            for (int i = 1; i <= n; ++i) {
                String string;
                String string2;
                String string3;
                String string4 = this.getRbbName(i);
                if (this.rbs.isParameterSupported(string4)) {
                    enumerationArray[i - 1] = (Enumeration)this.rbs.getCustomerParameterObject(string4);
                    stringArray[i - 1] = enumerationArray[i - 1].getLoadedValue();
                }
                if (this.rbs.isParameterSupported(string3 = this.getCreateSectorName(i))) {
                    yesNoCustomerParameterArray[i - 1] = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject(string3);
                }
                if (this.rbs.isParameterSupported(string2 = this.getPrimaryPortIdName(i))) {
                    enumerationArray2[i - 1] = (Enumeration)this.rbs.getCustomerParameterObject(string2);
                }
                if (!this.rbs.isParameterSupported(string = this.getSectorSequenceName(i))) continue;
                enumerationArray3[i - 1] = (Enumeration)this.rbs.getCustomerParameterObject(string);
            }
            String string = this.getConfigurationGroupName();
            if (this.rbs.isParameterSupported(string)) {
                this.configurationGroupParameter = (ConfigurationGroupParameter)this.rbs.getCustomerParameterObject(string);
            }
            this.myView.setChoiceOfRadioIfTypeSupported(this.rbs.isChoiceOfRadioIfTypeSupported());
            this.myView.setRadioBuildingBlocks(enumerationArray);
            this.myView.setLoadedRbbValues(stringArray);
            this.myView.setNumberOfSectors(n);
            this.myView.setCreateSector(yesNoCustomerParameterArray);
            this.myView.setPrimaryPortIdParameters(enumerationArray2);
            this.myView.setSectorSequenceParameters(enumerationArray3);
            this.myView.setConfigurationGroupParameter(this.configurationGroupParameter);
            this.myView.updateGui();
            this.myView.setConfigurationGroupListener(new ConfigurationGroupListener());
            this.isListenerEnabled = true;
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "afterVisible()", null, "Setting up window for input", exception);
            System.out.println(wizardException.getMessage());
            return;
        }
    }

    private RadioIfTypeParameter[] getRadioIfTypeParameters() throws Exception {
        this.radioIfTypeParameters = null;
        if (this.rbs.isChoiceOfRadioIfTypeSupported()) {
            for (int i = 2; i > 0; --i) {
                String string = String.valueOf(i) + "radioIfType";
                if (!this.rbs.isParameterSupported(string)) continue;
                if (this.radioIfTypeParameters == null) {
                    this.radioIfTypeParameters = new RadioIfTypeParameter[i];
                }
                this.radioIfTypeParameters[i - 1] = (RadioIfTypeParameter)this.rbs.getCustomerParameterObject(string);
                this.customerParameterNames.add(string);
            }
        }
        return this.radioIfTypeParameters;
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean next() {
        boolean bl = true;
        try {
            this.rbs.checkConsistency("CabinetBasicCI", this.customerParameterNames);
            this.rbs.checkConsistency("RadioEquipmentCI");
        }
        catch (Exception exception) {
            this.displayNextError(this.myView, exception);
            bl = false;
        }
        if (bl) {
            this.isListenerEnabled = false;
            this.myView.removeConfigurationGroupListener();
        }
        return bl;
    }

    protected boolean previous() {
        return true;
    }

    private String getRbbName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "radioBuildingBlock";
    }

    private String getCreateSectorName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "createSector";
    }

    private String getPrimaryPortIdName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "primaryPortId";
    }

    private String getSectorSequenceName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "sectorSequenceNumber";
    }

    private String getConfigurationGroupName() {
        return "configurationGroup";
    }

    public void updateConfigurationGroup(String string) throws BemException {
        if (string == null) {
            return;
        }
        try {
            this.myView.removeConfigurationGroupListener();
            this.myView.updateGui();
            this.myView.setConfigurationGroupListener(new ConfigurationGroupListener());
        }
        catch (Exception exception) {
            throw new BemException("Setting Configuration Group failed");
        }
    }

    private class ConfigurationGroupListener
    implements ActionListener {
        private ConfigurationGroupListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SectorOptionsController.this.isListenerEnabled) {
                CustomerParameterComboBox customerParameterComboBox = (CustomerParameterComboBox)actionEvent.getSource();
                try {
                    String string = (String)customerParameterComboBox.getSelectedItem();
                    if (string != null && !string.equals("-") && SectorOptionsController.this.configurationGroupParameter != null && !string.equals(SectorOptionsController.this.configurationGroupParameter.getValue())) {
                        SectorOptionsController.this.configurationGroupParameter.setValue(string);
                    }
                    SectorOptionsController.this.updateConfigurationGroup(SectorOptionsController.this.myView.getConfigurationGroup());
                    SectorOptionsController.this.setWindowTitle();
                }
                catch (Exception exception) {
                    SectorOptionsController.this.displayError(exception);
                }
                catch (Error error) {
                    SectorOptionsController.this.displayError(error);
                }
            }
        }
    }
}

