/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.InformativeText;
import se.ericsson.wcdma.rbs.bem.common.log.BemLogAndScriptUtil;
import se.ericsson.wcdma.rbs.bem.wizard.control.AbstractFlexFinishController;
import se.ericsson.wcdma.rbs.bem.wizard.control.GuiCheckAndShowWarning;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.view.ProgressDialogView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control.SitePostProgressDlgController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.FinishViewer;

public class SiteFinishController
extends AbstractFlexFinishController {
    private FinishViewer myView = null;
    private Rbs rbs = null;

    public SiteFinishController() {
        super(SiteCIModel.getInstance(), WizardHelp.getTheInstance());
    }

    protected void init() {
        this.myView = (FinishViewer)((Object)this.getView());
        super.setFlexModel(SiteCIModel.getInstance());
        super.init();
        this.rbs = SiteCIModel.getInstance().getRbs();
        super.init();
    }

    protected void afterVisible() {
        super.afterVisible();
        try {
            InformativeText informativeText = new InformativeText(this.rbs);
            String string = informativeText.getInformativeText();
            String string2 = "\n\tSite equipment configuration\n\t============================\n" + string;
            String string3 = SiteCIModel.getInstance().getTmfFiles();
            if (string3.length() > 0) {
                string2 = string2 + "\n\nTMF files" + string3 + "\n=======";
            }
            string2 = string2 + "\n\n\n\t==================================================================\n\tPressing <finish> downloads the configuration to the RBS. \n \tPressing <cancel> cancels the configuration. \n \tPressing <previous> makes it possible to change the configuration. ";
            this.myView.setSiteConfiguration(string2);
            if (this.rbs.isParameterSupported("carrierAllocationMode") && this.rbs.getCustomerParameter("carrierAllocationMode").equals("Flexible")) {
                super.setPreviousVisible(false);
            }
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("FinishController", "afterVisible()", null, "Getting changed customer parameters", exception);
            this.displayError(wizardException);
        }
    }

    protected void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean finish() {
        try {
            WizardCIModel wizardCIModel = super.getFlexModel();
            boolean bl = wizardCIModel.getUseWizard();
            boolean bl2 = wizardCIModel.getUseFileInput();
            if (bl2 && !bl && !GuiCheckAndShowWarning.checkDcVoltageAndShowWarning(this.rbs, this)) {
                return false;
            }
            super.finish();
            BemLogAndScriptUtil.getInstance().logStartConfigurationProcedure("SiteEquipment");
            this.startDialog(false, "NCONF_SITE_WIZARD_WINDOW_TITLE", null, ProgressDialogView.class, SitePostProgressDlgController.class);
            this.setCancelEnabled(false);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("FinishController", "finish()", null, "Performing finish action", exception);
            this.displayError(wizardException);
        }
        return false;
    }

    public String getWizardName() {
        return "Site";
    }
}

