/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceCommon;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control.AntennaCablesController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.AntennaCablesViewer;

public class AntennaCablesView
extends BemWizardGuiView
implements AntennaCablesViewer {
    private JPanel antennaCablesOverviewPanel = null;
    private JPanel antennaCablesMainPanel = null;
    private JPanel antennaCablesConfigPanel = null;
    private JTable antennaCablesOverviewTable = null;
    private JLabel sectorLabel;
    private JLabel sectorNumberLabel;
    private JLabel branchLabel;
    private JLabel branchNameLabel;
    private JLabel cpNameLabels;
    private JComponent cpValueFields;
    private static final String[] cpDescriptions = new String[]{"DL attenuation(0.1 dB):", "UL attenuation(0.1 dB):", "DL delay(0.1 ns):", "UL delay(0.1 ns):"};
    private AntennaCablesController controller = null;
    private int selectedRow = -1;
    private int selectedColumn = -1;
    private String bandType32 = "32";

    protected void init() {
        try {
            super.init();
            this.initiateMainPanel();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setController(AntennaCablesController antennaCablesController) {
        this.controller = antennaCablesController;
    }

    public void initiateMainPanel() {
        this.antennaCablesMainPanel = new JPanel();
        this.antennaCablesMainPanel.setLayout(new GridBagLayout());
        this.addMainPanel(this.antennaCablesMainPanel);
    }

    protected String getSubHeading() {
        return "NCONF_SITE_ANT_SUB_HEADING";
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public JTable setAntennaFeederCablesOverviewParameters(Object[][] objectArray, String[] stringArray) {
        if (this.antennaCablesOverviewTable == null) {
            this.antennaCablesOverviewTable = new JTable(objectArray, stringArray){

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.antennaCablesOverviewTable.putClientProperty("LANGUAGE_CONTROLLED", "NT");
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    this.setForeground(Color.BLACK);
                    if (n2 == 0) {
                        this.setHorizontalAlignment(0);
                    } else {
                        switch (AntennaCablesView.this.controller.getSectorAntennaState()[n2 - 1][n]) {
                            case 0: {
                                this.setHorizontalAlignment(0);
                                this.setText("*");
                                break;
                            }
                            case 2: {
                                this.setHorizontalAlignment(4);
                                String string = AntennaCablesView.this.controller.getActiveSectors()[n2 - 1] + "-" + ServiceCommon.BRANCH_NAMES[n];
                                this.setText(string);
                                break;
                            }
                            case 4: {
                                this.setHorizontalAlignment(2);
                                this.setText("Incorrect");
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 3: {
                                this.setHorizontalAlignment(0);
                                this.setText("-");
                                break;
                            }
                        }
                    }
                    return this;
                }
            };
            this.antennaCablesOverviewTable.setDefaultRenderer(Object.class, defaultTableCellRenderer);
            this.antennaCablesOverviewTable.setSelectionMode(0);
            this.antennaCablesOverviewTable.setCellSelectionEnabled(true);
            this.antennaCablesOverviewTable.setRowHeight(this.getFont().getSize() + 10);
            JScrollPane jScrollPane = new JScrollPane(this.antennaCablesOverviewTable);
            jScrollPane.setPreferredSize(new Dimension(630, 150));
            this.antennaCablesOverviewPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.antennaCablesOverviewTable.setModel(new DefaultTableModel(objectArray, stringArray));
        }
        this.antennaCablesMainPanel.add((Component)this.antennaCablesOverviewPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 10, 2, 10), 0, 0));
        return this.antennaCablesOverviewTable;
    }

    public void setListenerForAntennaFeederCablesOverviewTable(ListSelectionListener listSelectionListener) {
        this.antennaCablesOverviewTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.antennaCablesOverviewTable.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void updateSelectedCell() {
        this.selectedRow = this.antennaCablesOverviewTable.getSelectedRow();
        this.selectedColumn = this.antennaCablesOverviewTable.getSelectedColumn();
    }

    public void arrangeOverviewTable(int[] nArray) {
        int n = nArray.length;
        String[] stringArray = new String[n + 1];
        stringArray[0] = "Antenna branch";
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i] = "Sector " + nArray[i - 1];
        }
        Object[][] objectArray = new Object[ServiceCommon.BRANCH_NAMES.length][stringArray.length];
        for (int i = 0; i < ServiceCommon.BRANCH_NAMES.length; ++i) {
            objectArray[i][0] = ServiceCommon.BRANCH_NAMES[i];
        }
        if (this.antennaCablesOverviewPanel == null) {
            this.antennaCablesOverviewPanel = new JPanel();
            this.antennaCablesOverviewPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Antenna feeder cable Overview"));
            this.setAntennaFeederCablesOverviewParameters(objectArray, stringArray);
        } else {
            this.setAntennaFeederCablesOverviewParameters(objectArray, stringArray);
        }
    }

    public void arrangeAntennaCablesConfigTable() {
        if (this.antennaCablesConfigPanel != null) {
            this.antennaCablesMainPanel.remove(this.antennaCablesConfigPanel);
        }
        this.antennaCablesConfigPanel = new JPanel();
        this.antennaCablesConfigPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Antenna Feeder Cable Configuration"));
        this.antennaCablesConfigPanel.setLayout(new GridBagLayout());
        this.sectorLabel = new JLabel("Sector");
        String string = "-";
        if (this.selectedColumn >= 1 && this.selectedRow >= 0) {
            if (this.controller.getSectorAntennaState()[this.selectedColumn - 1][this.selectedRow] != 3) {
                string = String.valueOf(this.controller.getActiveSectors()[this.selectedColumn - 1]);
            }
        }
        this.sectorNumberLabel = new JLabel(string);
        this.branchLabel = new JLabel("Branch");
        String string2 = "-";
        if (this.selectedRow >= 0 && this.selectedColumn >= 1) {
            if (this.controller.getSectorAntennaState()[this.selectedColumn - 1][this.selectedRow] != 3) {
                string2 = ServiceCommon.BRANCH_NAMES[this.selectedRow];
            }
        }
        this.branchNameLabel = new JLabel(string2);
        this.antennaCablesConfigPanel.add((Component)this.sectorLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 17, new Insets(5, 10, 5, 10), 0, 0));
        this.antennaCablesConfigPanel.add((Component)this.sectorNumberLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(5, 10, 5, 10), 0, 0));
        this.antennaCablesConfigPanel.add((Component)this.branchLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 17, new Insets(5, 10, 5, 10), 0, 0));
        this.antennaCablesConfigPanel.add((Component)this.branchNameLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 12, 1, new Insets(5, 10, 5, 10), 0, 0));
        int n = this.controller.getSectorNumber(this.selectedColumn - 1);
        int n2 = this.selectedColumn - 1;
        String string3 = MessageFormat.format("S{0}_", n);
        for (int i = 0; i < cpDescriptions.length; ++i) {
            this.cpNameLabels = new JLabel(cpDescriptions[i]);
            if (this.selectedRow < 0 || this.selectedColumn < 1) {
                this.cpValueFields = new JLabel("-");
                this.cpValueFields.setPreferredSize(new Dimension(50, 20));
            } else if (this.controller.getSectorAntennaState()[this.selectedColumn - 1][this.selectedRow] != 3) {
                CustomerParameter customerParameter;
                String string4;
                String string5 = "0";
                if (this.controller.isSingleBand(n2)) {
                    string4 = this.controller.getSingleBandCp(n2);
                    customerParameter = this.controller.getCP(string4);
                    string5 = customerParameter.getValue();
                }
                if (AntennaCablesController.attrNames[i].startsWith("ul") && string5.equals(this.bandType32)) {
                    this.cpValueFields = new JLabel("-");
                } else {
                    string4 = string3 + AntennaCablesController.attrNames[i] + ServiceCommon.BRANCH_NAMES[this.selectedRow];
                    customerParameter = this.controller.getCP(string4);
                    if (AIRUtil.getInstance(SiteCIModel.getInstance().getRbs()).isAir4SectorAntenna(this.controller.getActiveSectors()[this.selectedColumn - 1], false)) {
                        if (AIRUtil.getInstance(SiteCIModel.getInstance().getRbs()).isRbb111AWithAir(n) && string2.equals(MimAntennaBranchDef.BRANCH_B)) {
                            this.cpValueFields = new CustomerParameterTextField(customerParameter);
                            customerParameter.addCustomerParameterListener(this.controller.getTextFieldListener());
                        } else {
                            this.cpValueFields = new JLabel(customerParameter.getValue());
                        }
                    } else {
                        this.cpValueFields = new CustomerParameterTextField(customerParameter);
                        customerParameter.addCustomerParameterListener(this.controller.getTextFieldListener());
                    }
                }
                this.cpValueFields.setPreferredSize(new Dimension(50, 20));
            } else {
                this.cpValueFields = new JLabel("-");
                this.cpValueFields.setPreferredSize(new Dimension(50, 20));
            }
            this.antennaCablesConfigPanel.add((Component)this.cpNameLabels, new GridBagConstraints(0, i + 2, 1, 1, 1.0, 1.0, 18, 17, new Insets(5, 10, 5, 10), 0, 0));
            this.antennaCablesConfigPanel.add((Component)this.cpValueFields, new GridBagConstraints(1, i + 2, 1, 1, 1.0, 1.0, 12, 1, new Insets(5, 10, 5, 10), 0, 0));
        }
        this.antennaCablesMainPanel.add((Component)this.antennaCablesConfigPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 18, new Insets(5, 10, 5, 10), 0, 0));
        this.antennaCablesMainPanel.repaint();
        this.antennaCablesMainPanel.validate();
    }

    public String getGuiNameForBranchCustomerParameter(String string) {
        String string2 = "";
        String string3 = " Branch ";
        int n = Integer.valueOf(string.substring(1, 2));
        String string4 = string.substring(string.length() - 1, string.length());
        string2 = this.antennaCablesOverviewTable.getColumnName(n) + string3 + string4;
        return string2;
    }

    public void editingStopped() {
        this.antennaCablesOverviewTable.editingStopped(new ChangeEvent(this));
    }
}

