/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ConfigurationGroupParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioIfTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterViewer;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;

public class SectorOptionsView
extends BemWizardGuiView
implements CustomerParameterViewer {
    private static final String[] MAIN_REMOTE_COLUMN_NAMES = new String[]{"Sector", "Radio Building Block", "Primary Port Id", "Sector Sequence"};
    private static final String[] MAIN_REMOTE_COLUMN_NAMES_RUIF = new String[]{"Sector", "Radio Building Block"};
    private static final int NO_OF_SECTORS_PER_BASE_BAND_POOL = 6;
    private static final int FIRST_SECTOR_IN_BB_POOL_2 = 7;
    private static final int MAIN_REMOTE_TABLE_COLUMNS = 4;
    private static final int MAIN_REMOTE_TABLE_COLUMNS_RUIF = 2;
    private YesNoCustomerParameter[] createSectorParameters;
    private Enumeration[] radioBuildingBlockParameters;
    private String[] loadedRbb;
    private Enumeration[] primaryPortIdParameters;
    private Enumeration[] sectorSequenceParameters;
    private ConfigurationGroupParameter configurationGroupParameter;
    private ActionListener configurationGroupListener;
    private CustomerParameterComboBox configurationGroupComboBox;
    private boolean choiceOfRadioIfTypeSupported = false;
    private RadioIfTypeParameter[] radioIfTypeParameters;
    private CustomerParameterTable mainRemoteSectorsTable;
    private int numberOfSectors;

    protected void init() {
        try {
            super.init();
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.updateGui();
    }

    public void setRadioBuildingBlocks(Enumeration[] enumerationArray) {
        this.radioBuildingBlockParameters = enumerationArray;
    }

    public void setLoadedRbbValues(String[] stringArray) {
        this.loadedRbb = stringArray;
    }

    public void setCreateSector(YesNoCustomerParameter[] yesNoCustomerParameterArray) {
        this.createSectorParameters = yesNoCustomerParameterArray;
    }

    public void setPrimaryPortIdParameters(Enumeration[] enumerationArray) {
        this.primaryPortIdParameters = enumerationArray;
    }

    public void setSectorSequenceParameters(Enumeration[] enumerationArray) {
        this.sectorSequenceParameters = enumerationArray;
    }

    public void setConfigurationGroupParameter(ConfigurationGroupParameter configurationGroupParameter) {
        this.configurationGroupParameter = configurationGroupParameter;
    }

    public String getConfigurationGroup() {
        if (this.configurationGroupComboBox == null) {
            return null;
        }
        return (String)this.configurationGroupComboBox.getSelectedItem();
    }

    public void setConfigurationGroupListener(ActionListener actionListener) {
        if (this.configurationGroupComboBox != null) {
            this.configurationGroupComboBox.removeActionListener(this.configurationGroupListener);
            this.configurationGroupListener = actionListener;
            this.configurationGroupComboBox.addActionListener(this.configurationGroupListener);
        }
    }

    public void removeConfigurationGroupListener() {
        if (this.configurationGroupListener != null && this.configurationGroupComboBox != null) {
            this.configurationGroupComboBox.removeActionListener(this.configurationGroupListener);
        }
    }

    public void setNumberOfSectors(int n) {
        this.numberOfSectors = n;
    }

    public void setChoiceOfRadioIfTypeSupported(boolean bl) {
        this.choiceOfRadioIfTypeSupported = bl;
    }

    public void setRadioIfTypes(RadioIfTypeParameter[] radioIfTypeParameterArray) {
        this.radioIfTypeParameters = radioIfTypeParameterArray;
    }

    public String getGuiNameForCustomerParameter(String string) {
        String string2 = null;
        if (this.mainRemoteSectorsTable != null && this.mainRemoteSectorsTable.isParameterInTable(string)) {
            string2 = this.mainRemoteSectorsTable.getRowAndColumnName(string);
        }
        return string2;
    }

    public void setFocusOnCustomerParameterComponent(String string) {
        if (this.mainRemoteSectorsTable != null && this.mainRemoteSectorsTable.isParameterInTable(string)) {
            this.mainRemoteSectorsTable.setFocusOnCell(string);
        }
    }

    public void updateGui() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        if (this.isMainRemoteSectors()) {
            jPanel.add((Component)this.createConfigurationGroupPanel(), gridBagConstraints);
        }
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        if (this.radioIfTypeParameters != null && this.radioIfTypeParameters.length > 1) {
            jPanel.add((Component)this.createMacroWithObifSectorOptionsPanel(), gridBagConstraints);
        } else {
            jPanel.add((Component)this.createMainRemoteSectorOptionsPanel(), gridBagConstraints);
        }
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        this.addMainPanel(jPanel);
    }

    private boolean isMainRemoteSectors() {
        boolean bl = false;
        if (!this.choiceOfRadioIfTypeSupported && this.createSectorParameters != null && this.createSectorParameters[0] != null) {
            bl = true;
        } else if (this.choiceOfRadioIfTypeSupported && this.radioIfTypeParameters != null && this.radioIfTypeParameters[0] != null && this.radioIfTypeParameters[0].getValue().equals("OBIF")) {
            bl = true;
        } else if (this.choiceOfRadioIfTypeSupported && this.radioIfTypeParameters != null && this.radioIfTypeParameters.length > 1 && this.radioIfTypeParameters[1] != null && this.radioIfTypeParameters[1].getValue().equals("OBIF")) {
            bl = true;
        }
        return bl;
    }

    private String[] getRowNames(int n) {
        String[] stringArray = new String[n];
        for (int i = 1; i <= n; ++i) {
            Integer n2 = i;
            stringArray[i - 1] = n2.toString();
        }
        return stringArray;
    }

    private String[] getRowNamesForObif(int n) {
        String[] stringArray = new String[6];
        for (int i = 0; i < 6; ++i) {
            Integer n2 = n + i;
            stringArray[i] = n2.toString();
        }
        return stringArray;
    }

    private JPanel createConfigurationGroupPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Configuration Group:   *");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints.gridx = 1;
        if (this.configurationGroupParameter != null) {
            this.configurationGroupComboBox = new CustomerParameterComboBox(this.configurationGroupParameter);
        }
        if (this.configurationGroupComboBox != null) {
            jPanel.add((Component)this.configurationGroupComboBox, gridBagConstraints);
        }
        return jPanel;
    }

    private JPanel createMainRemoteSectorOptionsPanel() {
        Object[][] objectArray;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Sector options"));
        if (this.radioIfTypeParameters != null && this.radioIfTypeParameters[0] != null && this.radioIfTypeParameters[0].getValue().equals("RUIF")) {
            objectArray = new Enumeration[this.numberOfSectors][2];
            for (int i = 0; i < this.radioBuildingBlockParameters.length && i < this.numberOfSectors; ++i) {
                objectArray[i][0] = this.radioBuildingBlockParameters[i];
            }
            this.mainRemoteSectorsTable = new CustomerParameterTable(objectArray, this.getRowNames(this.numberOfSectors), MAIN_REMOTE_COLUMN_NAMES_RUIF);
        } else {
            objectArray = new Enumeration[this.numberOfSectors][4];
            for (int i = 0; i < this.radioBuildingBlockParameters.length && i < this.numberOfSectors; ++i) {
                objectArray[i][0] = this.radioBuildingBlockParameters[i];
                objectArray[i][1] = this.primaryPortIdParameters[i];
                objectArray[i][2] = this.sectorSequenceParameters[i];
            }
            this.mainRemoteSectorsTable = new CustomerParameterTable(objectArray, this.getRowNames(this.numberOfSectors), MAIN_REMOTE_COLUMN_NAMES);
        }
        objectArray = new GridBagConstraints();
        objectArray.gridwidth = 2;
        objectArray.fill = 2;
        objectArray.weightx = 10.0;
        objectArray.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)new JScrollPane(this.mainRemoteSectorsTable), objectArray);
        return jPanel;
    }

    private JPanel createMacroWithObifSectorOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Sector options"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.radioIfTypeParameters != null) {
            for (RadioIfTypeParameter radioIfTypeParameter : this.radioIfTypeParameters) {
                int n;
                Object[][] objectArray;
                if (radioIfTypeParameter != null && radioIfTypeParameter.getValue().equals("RUIF")) {
                    objectArray = new Object[6][2];
                    for (n = 0; n < this.radioBuildingBlockParameters.length - 6 && n < this.numberOfSectors - 6; ++n) {
                        objectArray[n][0] = this.loadedRbb[n] == "" ? "-" : this.loadedRbb[n];
                    }
                    this.mainRemoteSectorsTable = new CustomerParameterTable(objectArray, this.getRowNames(6), MAIN_REMOTE_COLUMN_NAMES_RUIF);
                    gridBagConstraints.gridwidth = 2;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.weightx = 10.0;
                    gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                    gridBagConstraints.gridy = -1;
                    jPanel.add((Component)new JScrollPane(this.mainRemoteSectorsTable), gridBagConstraints);
                    continue;
                }
                objectArray = new Enumeration[6][4];
                for (n = 0; n < this.radioBuildingBlockParameters.length - 6 && n < this.numberOfSectors - 6; ++n) {
                    objectArray[n][0] = this.radioBuildingBlockParameters[n + 7 - 1];
                    objectArray[n][1] = this.primaryPortIdParameters[n + 7 - 1];
                    objectArray[n][2] = this.sectorSequenceParameters[n + 7 - 1];
                }
                this.mainRemoteSectorsTable = new CustomerParameterTable(objectArray, this.getRowNamesForObif(7), MAIN_REMOTE_COLUMN_NAMES);
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 10.0;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.gridy = -1;
                jPanel.add((Component)new JScrollPane(this.mainRemoteSectorsTable), gridBagConstraints);
            }
        }
        return jPanel;
    }

    public void editingStopped() {
    }
}

