/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.terminations;

import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import se.ericsson.cello.atm.aal2.AalCounterMode;
import se.ericsson.cello.atm.atm.AlarmReport;
import se.ericsson.cello.atm.atm.AtmInfoExtend;
import se.ericsson.cello.atm.atm.AtmNomPmBlkSize;
import se.ericsson.cello.atm.atm.VclTpMo;
import se.ericsson.cello.atm.atm.VclTpMoImpl;
import se.ericsson.cello.atm.terminations.Aal5TpVccTpMo;
import se.ericsson.cello.atm.terminations.fropxy.ActAal5CepCreateFroRsp;
import se.ericsson.cello.atm.terminations.fropxy.ActAal5CepDeleteFroRsp;
import se.ericsson.cello.atm.terminations.fropxy.ActAal5CepGetAttrRsp;
import se.ericsson.cello.atm.terminations.fropxy.ActAal5CepGetFrosForResourceRsp;
import se.ericsson.cello.atm.terminations.fropxy.ActAal5CepProxy;
import se.ericsson.cello.atm.terminations.fropxy.AnsPcCreateFroRsp;
import se.ericsson.cello.atm.terminations.fropxy.AnsPcDeleteFroRsp;
import se.ericsson.cello.atm.terminations.fropxy.AnsPcProxy;
import se.ericsson.cello.atm.terminations.fropxy.AnsPcSetAttrFroRsp;
import se.ericsson.cello.atm.terminations.fropxy.AnsPcType;
import se.ericsson.cello.equipment.Aal5ReservingPiu;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.ProcessorType;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ProcessorInfo;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.pmapp.GenericPmInterface;
import se.ericsson.cello.spu.SpmMo;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.transaction.Coordinator;

public class Aal5TpVccTpMoImpl
extends CelloMao
implements Aal5TpVccTpMo,
GenericPmInterface,
FroInfo,
ProcessorInfo,
Aal5ReservingPiu {
    private ActAal5CepProxy aal5CepProxy = null;
    private AnsPcProxy pcProxy = null;
    private FroProxy vcCepProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    private IntegerAttribute aal5CepFroId;
    private static TransactionalFroIdMap froIdTable = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
    private MoData data;
    private AtmInfoExtend atmInfoExtend = new AtmInfoExtend();
    private static final String AAL5_CEP_FRO_ID = "aal5CepFroId";
    private static final String PC_FRO_ID = "pcFroId";
    private static final String VCCEP_FRO_ID = "vcCepFroId";
    private static final int MO_DATA_REVISION_51 = 5100;
    private static final int MO_DATA_REVISION_LATEST = 5100;
    private static final boolean DEFAULT_COUNTER_ACTIVATION = false;
    private static final boolean AET_ATM_CONTCHECK_DISABLED = false;
    private static final int ALARM_REPORT_DEFAULT = 2;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, ActAal5CepProxy actAal5CepProxy, AnsPcProxy ansPcProxy, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Aal5TpVccTp", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TransportNetwork");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"Aal5TpVccTp", (int)6000);
        String[] stringArray = new String[]{"VclTp"};
        VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)MoAttributeValidator.checkAndGetReferenceAttribute2((String)"vclTpId", (AttrList)attrList, (boolean)true, (String[])stringArray, (String)"Aal5TpVccTp");
        String[] stringArray2 = new String[]{"PlugInUnit", "Spm", "PiuDevice"};
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute2((String)"processorId", (AttrList)attrList, (boolean)false, (String[])stringArray2, (String)"Aal5TpVccTp");
        int n = ProcessorType.ND.getValue();
        if (managedObject3 != null) {
            if (managedObject3.getType().equals("PlugInUnit")) {
                PlugInUnitMo plugInUnitMo = (PlugInUnitMo)managedObject3;
                n = ((PiuTypeMo)plugInUnitMo.getPiuType(coordinator)).getRole(coordinator);
            }
            if (managedObject3.getType().equals("Spm") || managedObject3.getType().equals("PiuDevice")) {
                n = ProcessorType.SP.getValue();
            }
        }
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"fromUserMaxSduSize", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)Integer.MAX_VALUE, (String)"Aal5TpVccTp");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"toUserMaxSduSize", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)Integer.MAX_VALUE, (String)"Aal5TpVccTp");
        int n4 = Aal5TpVccTpMoImpl.checkAndGetAlarmReport(attrList);
        int n5 = Aal5TpVccTpMoImpl.checkAndGetCounterMode(attrList);
        int n6 = Aal5TpVccTpMoImpl.checkAndGetNomPmBlkSize(attrList);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Aal5TpVccTp", (int)128, (int)0);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"continuityCheck", (AttrList)attrList, (boolean)false, (boolean)false, (String)"Aal5TpVccTp");
        boolean bl2 = MoAttributeValidator.checkAndGetBooleanAttribute((String)"counterActivation", (AttrList)attrList, (boolean)false, (boolean)false, (String)"Aal5TpVccTp");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Aal5TpVccTp");
        return new Aal5TpVccTpMoImpl(managedObject, vclTpMoImpl, managedObject3, n2, n3, string2, n4, bl, n5, n6, string, n, bl2, coordinator, initialMaoContext, actAal5CepProxy, ansPcProxy, froProxy, maoFroIndicationHandler);
    }

    private Aal5TpVccTpMoImpl(ManagedObject managedObject, VclTpMoImpl vclTpMoImpl, ManagedObject managedObject2, int n, int n2, String string, int n3, boolean bl, int n4, int n5, String string2, int n6, boolean bl2, Coordinator coordinator, InitialMaoContext initialMaoContext, ActAal5CepProxy actAal5CepProxy, AnsPcProxy ansPcProxy, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "Aal5TpVccTp", string2, coordinator, initialMaoContext);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.aal5CepProxy = actAal5CepProxy;
        this.pcProxy = ansPcProxy;
        this.vcCepProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        vclTpMoImpl.reserve(this, coordinator);
        int n7 = 0;
        if (managedObject2 != null) {
            n7 = managedObject2.getType().equals("PlugInUnit") ? ((PlugInUnitMo)managedObject2).getFroId(coordinator) : (managedObject2.getType().equals("PiuDevice") ? ((PiuDeviceMo)managedObject2).getFroId(coordinator) : ((SpmMo)managedObject2).getSpmInstanceId(coordinator));
        }
        int n8 = this.createVcCepFro(coordinator, vclTpMoImpl.getFroId(coordinator), n3, MaoFroTypeConverter.boolean2int((boolean)bl), n4, n5);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(VCCEP_FRO_ID, false, n8));
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n8);
        int n9 = this.createAal5CepFro(coordinator, n7, n6, n8, n, n2);
        this.aal5CepFroId = new IntegerAttribute(AAL5_CEP_FRO_ID, false, n9);
        this.data.registerPersistentAttr((Attribute)this.aal5CepFroId);
        int n10 = this.createPcFro(coordinator, vclTpMoImpl.getFroId(coordinator), n9);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(PC_FRO_ID, false, n10));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("reservedBy", true, null));
        this.data.registerPersistentAttr((Attribute)new BooleanAttribute("counterActivation", true, bl2));
        this.getMaoContext().getServiceRepository().addService((Object)this, Aal5ReservingPiu.class, coordinator);
        froIdTable.put(n9, (ManagedObject)this, coordinator);
        this.data.setRevision(5100);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public Aal5TpVccTpMoImpl(MoData moData, InitialMaoContext initialMaoContext, ActAal5CepProxy actAal5CepProxy, AnsPcProxy ansPcProxy, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.aal5CepProxy = actAal5CepProxy;
        this.pcProxy = ansPcProxy;
        this.vcCepProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(5100);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute(AAL5_CEP_FRO_ID);
        moDataRecoveryHelper.assertAttribute(PC_FRO_ID);
        moDataRecoveryHelper.assertAttribute(VCCEP_FRO_ID);
        moDataRecoveryHelper.assertAttribute("counterActivation");
        this.aal5CepFroId = (IntegerAttribute)this.data.getAttribute(AAL5_CEP_FRO_ID);
        this.getMaoContext().getServiceRepository().addService((Object)this, Aal5ReservingPiu.class, null);
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(VCCEP_FRO_ID)).getValue(null));
        froIdTable.put(this.aal5CepFroId.getValue(null), (ManagedObject)this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator) != null) {
            throw new MoReservedNotDeletableException("Aal5TpVccTp");
        }
        VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)this.getAttribute("vclTpId", coordinator);
        vclTpMoImpl.release(this, coordinator);
        this.deletePcFro(coordinator);
        this.deleteAal5CepFro(coordinator);
        this.deleteVcCepFro(coordinator);
        froIdTable.remove(this.aal5CepFroId.getValue(coordinator), coordinator);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getVcCepFroId(coordinator));
        this.getMaoContext().getServiceRepository().removeService((Object)this, Aal5ReservingPiu.class, coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public String getAal5TpVccTpId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("Aal5TpVccTpId", coordinator);
    }

    public ManagedObject getVclTpId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("vclTpId", coordinator);
    }

    public void setVclTpId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vclTpId", managedObject, coordinator);
    }

    public int getAlarmReport(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("alarmReport", coordinator);
    }

    public void setAlarmReport(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("alarmReport", new Integer(n), coordinator);
    }

    public boolean getContinuityCheck(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("continuityCheck", coordinator);
    }

    public void setContinuityCheck(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("continuityCheck", bl, coordinator);
    }

    public int getNomPmBlkSize(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("nomPmBlkSize", coordinator);
    }

    public void setNomPmBlkSize(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("nomPmBlkSize", new Integer(n), coordinator);
    }

    public int getCounterMode(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("counterMode", coordinator);
    }

    public void setCounterMode(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("counterMode", new Integer(n), coordinator);
    }

    public int getPmFwLostCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmFwLostCells", coordinator);
    }

    public int getPmFwMissinsCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmFwMissinsCells", coordinator);
    }

    public int getPmFwErrBlocks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmFwErrBlocks", coordinator);
    }

    public int getPmLostFpmCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmLostFpmCells", coordinator);
    }

    public int getPmBwLostCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmBwLostCells", coordinator);
    }

    public int getPmBwMissinsCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmBwMissinsCells", coordinator);
    }

    public int getPmBwErrBlocks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmBwErrBlocks", coordinator);
    }

    public int getPmLostBrCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmLostBrCells", coordinator);
    }

    public void setCounterActivation(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("counterActivation", bl, coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("currentPmRegister", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        ActAal5CepGetAttrRsp actAal5CepGetAttrRsp = null;
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("processorId")) {
                objectArray[i] = this.getProcessorId(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vclTpId")) {
                map = this.getVcCepGetCfm(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("vcCpFroId");
                objectArray[i] = VclTpMoImpl.lookupInstance(signedIntParameter.getValue(), coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference", "Aal5TpVccTp", "vclTpId");
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("reservedBy")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("Aal5TpVccTpId")) {
                objectArray[i] = this.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("atmInfo")) {
                objectArray[i] = this.atmInfoExtend.getAal5TpVccTpData(coordinator, this);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                actAal5CepGetAttrRsp = this.getFromAal5CepRes(actAal5CepGetAttrRsp, coordinator);
                objectArray[i] = new Integer(actAal5CepGetAttrRsp.getOperState());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("fromUserMaxSduSize")) {
                actAal5CepGetAttrRsp = this.getFromAal5CepRes(actAal5CepGetAttrRsp, coordinator);
                objectArray[i] = new Integer(actAal5CepGetAttrRsp.getMaxIngressSduSize());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("toUserMaxSduSize")) {
                actAal5CepGetAttrRsp = this.getFromAal5CepRes(actAal5CepGetAttrRsp, coordinator);
                objectArray[i] = new Integer(actAal5CepGetAttrRsp.getMaxEgressSduSize());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("counterMode")) {
                map = this.getVcCepGetCfm(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("counterMode");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("alarmReport")) {
                map = this.getVcCepGetCfm(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("alarmReport");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("continuityCheck")) {
                map = this.getVcCepGetCfm(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("continuityCheck");
                boolean bl = MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue());
                objectArray[i] = bl;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("nomPmBlkSize")) {
                map = this.getVcCepGetCfm(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("nomPmBlockSize");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("counterActivation")) {
                objectArray[i] = ((BooleanAttribute)this.data.getAttribute("counterActivation")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmBwErrBlocks")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmBwErrBlocks", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmBwLostCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmBwLostCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmBwMissinsCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmBwMissinsCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmFwErrBlocks")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmFwErrBlocks", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmFwLostCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmFwLostCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmFwMissinsCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmFwMissinsCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmLostBrCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmLostBrCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmLostFpmCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmLostFpmCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = super.getCurrentPmRegister(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Aal5TpVccTp");
        }
        return objectArray;
    }

    public ManagedObject getProcessorId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ActAal5CepGetAttrRsp actAal5CepGetAttrRsp = this.getAal5CepAttributes(coordinator);
        ManagedObject managedObject = null;
        int n = actAal5CepGetAttrRsp.getProcessorId();
        int n2 = actAal5CepGetAttrRsp.getProcessorType();
        MoIterator moIterator = null;
        if (n == 0) {
            return null;
        }
        if (n2 == ProcessorType.SP.getValue()) {
            moIterator = this.getMaoContext().getMoAccessor().lookupType("Spm");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    managedObject = moIterator.nextMo();
                    if (n != ((SpmMo)managedObject).getSpmInstanceId(coordinator)) continue;
                    return managedObject;
                }
            }
            if ((moIterator = this.getMaoContext().getMoAccessor().lookupType("PiuDevice")) != null) {
                while (moIterator.hasMoreElements()) {
                    managedObject = moIterator.nextMo();
                    if (n != ((PiuDeviceMo)managedObject).getFroId(coordinator)) continue;
                    return managedObject;
                }
            }
            throw new ConfigurationMismatchException("MO reference could not be found for the given froId: " + n, "Aal5TpVccTp");
        }
        if (n2 == ProcessorType.BP.getValue() || n2 == ProcessorType.MP.getValue()) {
            moIterator = this.getMaoContext().getMoAccessor().lookupType("PlugInUnit");
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    managedObject = (PlugInUnitMo)moIterator.nextMo();
                    if (n != ((PlugInUnitMo)managedObject).getResourceId(coordinator)) continue;
                    return managedObject;
                }
            }
            throw new ConfigurationMismatchException("MO reference could not be found for the given froId: " + n, "Aal5TpVccTp");
        }
        return null;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!(objectArray[i] instanceof String)) {
                    throw new WrongAttributeTypeException("userLabel", "Aal5TpVccTp");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"Aal5TpVccTp", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("alarmReport")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("alarmReport", "Aal5TpVccTp");
                }
                n = this.alarmReport_RangeCheck((Integer)objectArray[i]);
                arrayList.add(new SignedIntParameter("alarmReport", n));
                this.sendNotification("alarmReport", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("continuityCheck")) {
                if (!(objectArray[i] instanceof Boolean)) {
                    throw new WrongAttributeTypeException("continuityCheck", "Aal5TpVccTp");
                }
                bl = (Boolean)objectArray[i];
                arrayList.add(new SignedIntParameter("continuityCheck", MaoFroTypeConverter.boolean2int((boolean)bl)));
                this.sendNotification("continuityCheck", bl, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("counterMode")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("counterMode", "Aal5TpVccTp");
                }
                n = this.counterMode_RangeCheck((Integer)objectArray[i]);
                arrayList.add(new SignedIntParameter("counterMode", n));
                this.sendNotification("counterMode", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("nomPmBlkSize")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("nomPmBlkSize", "Aal5TpVccTp");
                }
                n = this.nomPmBlkSize_RangeCheck((Integer)objectArray[i]);
                arrayList.add(new SignedIntParameter("nomPmBlockSize", n));
                this.sendNotification("nomPmBlkSize", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vclTpId")) {
                if (objectArray[i] == null) {
                    throw new ValueOutOfRangeException("vclTpId", "Aal5TpVccTp");
                }
                if (!(objectArray[i] instanceof VclTpMo)) {
                    throw new WrongAttributeTypeException("vclTpId", "Aal5TpVccTp");
                }
                VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)objectArray[i];
                VclTpMoImpl vclTpMoImpl2 = (VclTpMoImpl)this.getAttribute("vclTpId", coordinator);
                vclTpMoImpl2.release(this, coordinator);
                vclTpMoImpl.reserve(this, coordinator);
                arrayList.add(new SignedIntParameter("vcCpFroId", vclTpMoImpl.getFroId(coordinator)));
                this.setPcFroAttr(coordinator, vclTpMoImpl.getFroId(coordinator));
                this.sendNotification("vclTpId", vclTpMoImpl, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("counterActivation")) {
                if (!(objectArray[i] instanceof Boolean)) {
                    throw new WrongAttributeTypeException("counterActivation", "Aal5TpVccTp");
                }
                bl = (Boolean)objectArray[i];
                if (((BooleanAttribute)this.data.getAttribute("counterActivation")).getValue(coordinator) != bl) {
                    super.setInstanceCounterActivation(bl, coordinator);
                }
                ((BooleanAttribute)this.data.getAttribute("counterActivation")).setValue(bl);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Aal5TpVccTp");
        }
        if (arrayList.size() > 0) {
            this.vcCepProxy.setAttributes(coordinator, this.getVcCepFroId(coordinator), arrayList);
        }
    }

    private void setPcFroAttr(Coordinator coordinator, int n) throws MoAccessException {
        AnsPcSetAttrFroRsp ansPcSetAttrFroRsp = this.pcProxy.sendSetAttrReq(coordinator.getTransactionID(), this.getPcFroId(coordinator), n);
        if (ansPcSetAttrFroRsp == null) {
            throw new FroNotAccessibleException("Aal5TpVccTp", "Pc");
        }
        if (ansPcSetAttrFroRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal5TpVccTp", "Pc", "SetAttrFroReq: " + this.pcProxy.getResultMsg(ansPcSetAttrFroRsp.getResult()), ansPcSetAttrFroRsp.getResult());
        }
    }

    private ActAal5CepGetAttrRsp getFromAal5CepRes(ActAal5CepGetAttrRsp actAal5CepGetAttrRsp, Coordinator coordinator) throws MoAccessException {
        ActAal5CepGetAttrRsp actAal5CepGetAttrRsp2 = actAal5CepGetAttrRsp;
        if (actAal5CepGetAttrRsp2 == null) {
            actAal5CepGetAttrRsp2 = this.getAal5CepAttributes(coordinator);
        }
        return actAal5CepGetAttrRsp2;
    }

    private Map getVcCepGetCfm(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            map = this.vcCepProxy.getAttributes(coordinator, this.getVcCepFroId(coordinator));
        }
        return map;
    }

    private int alarmReport_RangeCheck(int n) throws MoAccessException {
        if (!AlarmReport.inRange(n)) {
            throw new ValueOutOfRangeException("alarmReport", "Aal5TpVccTp");
        }
        return n;
    }

    private int counterMode_RangeCheck(int n) throws MoAccessException {
        if (!AalCounterMode.inRange(n)) {
            throw new ValueOutOfRangeException("counterMode", "Aal5TpVccTp");
        }
        return n;
    }

    private int nomPmBlkSize_RangeCheck(int n) throws MoAccessException {
        if (!AtmNomPmBlkSize.inRange(n)) {
            throw new ValueOutOfRangeException("nomPmBlkSize", "Aal5TpVccTp");
        }
        return n;
    }

    private void deleteAal5CepFro(Coordinator coordinator) throws MoAccessException {
        ActAal5CepDeleteFroRsp actAal5CepDeleteFroRsp = this.aal5CepProxy.sendDeleteFroReq(coordinator.getTransactionID(), this.getAal5CepFroId(coordinator));
        if (actAal5CepDeleteFroRsp == null) {
            throw new FroNotAccessibleException("Aal5TpVccTp", "Aal5Cep");
        }
        if (actAal5CepDeleteFroRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal5TpVccTp", "Aal5Cep", "DeleteFroReq: " + this.aal5CepProxy.getResultMsg(actAal5CepDeleteFroRsp.getResult()), actAal5CepDeleteFroRsp.getResult());
        }
    }

    private void deletePcFro(Coordinator coordinator) throws MoAccessException {
        AnsPcDeleteFroRsp ansPcDeleteFroRsp = this.pcProxy.sendDeleteFroReq(coordinator.getTransactionID(), this.getPcFroId(coordinator));
        if (ansPcDeleteFroRsp == null) {
            throw new FroNotAccessibleException("Aal5TpVccTp", "Pc");
        }
        if (ansPcDeleteFroRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal5TpVccTp", "Pc", "DeleteFroReq: " + this.pcProxy.getResultMsg(ansPcDeleteFroRsp.getResult()), ansPcDeleteFroRsp.getResult());
        }
    }

    private void deleteVcCepFro(Coordinator coordinator) throws MoAccessException {
        this.vcCepProxy.delete(coordinator, this.getVcCepFroId(coordinator), null);
    }

    private int createVcCepFro(Coordinator coordinator, int n, int n2, int n3, int n4, int n5) throws MoAccessException {
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter("vcCpFroId", n));
        arrayList.add(new SignedIntParameter("alarmReport", n2));
        arrayList.add(new SignedIntParameter("continuityCheck", n3));
        arrayList.add(new SignedIntParameter("counterMode", n4));
        arrayList.add(new SignedIntParameter("nomPmBlockSize", n5));
        FroData froData = this.vcCepProxy.create(coordinator, arrayList);
        return froData.getFroId();
    }

    private int createAal5CepFro(Coordinator coordinator, int n, int n2, int n3, int n4, int n5) throws MoAccessException {
        ActAal5CepCreateFroRsp actAal5CepCreateFroRsp = this.aal5CepProxy.sendCreateFroReq(coordinator.getTransactionID(), n, n2, n3, n5, n4);
        if (actAal5CepCreateFroRsp == null) {
            throw new FroNotAccessibleException("Aal5TpVccTp", "Aal5Cep");
        }
        if (actAal5CepCreateFroRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal5TpVccTp", "Aal5Cep", "CreateFroReq: " + this.aal5CepProxy.getResultMsg(actAal5CepCreateFroRsp.getResult()), actAal5CepCreateFroRsp.getResult());
        }
        return actAal5CepCreateFroRsp.getFroId();
    }

    private int createPcFro(Coordinator coordinator, int n, int n2) throws MoAccessException {
        AnsPcCreateFroRsp ansPcCreateFroRsp = this.pcProxy.sendCreateFroReq(coordinator.getTransactionID(), AnsPcType.aal5Type, n, n2);
        if (ansPcCreateFroRsp == null) {
            throw new FroNotAccessibleException("Aal5TpVccTp", "Pc");
        }
        if (ansPcCreateFroRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal5TpVccTp", "Pc", "CreateFroReq: " + this.pcProxy.getResultMsg(ansPcCreateFroRsp.getResult()), ansPcCreateFroRsp.getResult());
        }
        return ansPcCreateFroRsp.getFroId();
    }

    private ActAal5CepGetAttrRsp getAal5CepAttributes(Coordinator coordinator) throws MoAccessException {
        ActAal5CepGetAttrRsp actAal5CepGetAttrRsp = this.aal5CepProxy.sendGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.getAal5CepFroId(coordinator));
        if (actAal5CepGetAttrRsp == null) {
            throw new FroNotAccessibleException("Aal5TpVccTp", "Aal5Cep");
        }
        if (actAal5CepGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("Aal5TpVccTp", "Aal5Cep", "SetAttrReq: " + this.aal5CepProxy.getResultMsg(actAal5CepGetAttrRsp.getResult()), actAal5CepGetAttrRsp.getResult());
        }
        return actAal5CepGetAttrRsp;
    }

    public ManagedObject getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("reservedBy", coordinator);
    }

    public int getToUserMaxSduSize(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("toUserMaxSduSize", coordinator);
    }

    public int getFromUserMaxSduSize(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("fromUserMaxSduSize", coordinator);
    }

    private static int checkAndGetAlarmReport(AttrList attrList) throws MoAccessException {
        int n = 2;
        int n2 = attrList.indexOf("alarmReport");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("alarmReport", "Aal5TpVccTp");
        }
        n = (Integer)attrList.getValue(n2);
        if (!AlarmReport.inRange(n)) {
            throw new ValueOutOfRangeException("alarmReport", "Aal5TpVccTp");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetCounterMode(AttrList attrList) throws MoAccessException {
        int n = 6;
        int n2 = attrList.indexOf("counterMode");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("counterMode", "Aal5TpVccTp");
        }
        n = (Integer)attrList.getValue(n2);
        if (!AalCounterMode.inRange(n)) {
            throw new ValueOutOfRangeException("counterMode", "Aal5TpVccTp");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetNomPmBlkSize(AttrList attrList) throws MoAccessException {
        int n = 1024;
        int n2 = attrList.indexOf("nomPmBlkSize");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("nomPmBlkSize", "Aal5TpVccTp");
        }
        n = (Integer)attrList.getValue(n2);
        if (!AtmNomPmBlkSize.inRange(n)) {
            throw new ValueOutOfRangeException("nomPmBlkSize", "Aal5TpVccTp");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    public ManagedObject[] getReservingAal5CepFroIds(Coordinator coordinator, int n, int n2) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ActAal5CepGetFrosForResourceRsp actAal5CepGetFrosForResourceRsp = ActAal5CepProxy.instance().sendGetFrosForResource(n, n2);
        if (actAal5CepGetFrosForResourceRsp == null) {
            throw new FroNotAccessibleException("Aal5TpVccTp", "Aal5Cep");
        }
        int n3 = actAal5CepGetFrosForResourceRsp.getNoOfFros();
        int[] nArray = actAal5CepGetFrosForResourceRsp.getFroIdList();
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType("Aal5TpVccTp");
        Vector<Aal5TpVccTpMoImpl> vector = new Vector<Aal5TpVccTpMoImpl>();
        if (moIterator != null) {
            block0: while (moIterator.hasMoreElements()) {
                Aal5TpVccTpMoImpl aal5TpVccTpMoImpl = (Aal5TpVccTpMoImpl)moIterator.nextMo();
                for (int i = 0; i < n3; ++i) {
                    if (aal5TpVccTpMoImpl.getAal5CepFroId(coordinator) != nArray[i]) continue;
                    vector.add(aal5TpVccTpMoImpl);
                    continue block0;
                }
            }
        }
        return MaoFroTypeConverter.convertCollToMOArr(vector);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getPmFroId(String string, Coordinator coordinator) throws MoAccessException {
        return this.getVcCepFroId(coordinator);
    }

    public boolean hasCounterActivationAttribute() throws MoAccessException {
        return true;
    }

    public boolean getCounterActivation(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((BooleanAttribute)this.data.getAttribute("counterActivation")).getValue(coordinator);
    }

    private int getVcCepFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(VCCEP_FRO_ID)).getValue(coordinator);
    }

    public int getAal5CepFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.aal5CepFroId.getValue(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        return this.getAal5CepFroId(coordinator);
    }

    private int getPcFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(PC_FRO_ID)).getValue(coordinator);
    }

    public String getType() {
        return "Aal5TpVccTp";
    }

    public static Aal5TpVccTpMoImpl lookupInstance(int n, Coordinator coordinator) throws MoAccessException {
        return (Aal5TpVccTpMoImpl)froIdTable.get(n, coordinator);
    }
}

