/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.helpservice;

import java.util.logging.Level;
import javax.swing.JOptionPane;
import se.ericsson.cello.emt.helpservice.HelpServiceLog;
import se.ericsson.cello.emt.helpservice.view.Display;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.emt.utils.helpers.EmasUtilities;

public final class HtmlBrowser {
    String myPreferredBrowser = null;
    String myIconPath = "";

    public void setIconPath(String iconPath) {
        this.myIconPath = iconPath;
    }

    public void showURL(String path) {
        HelpServiceLog.logger().info("showURL: " + path);
        this.browseHtml(path);
    }

    public String getPreferredBrowser() {
        return this.myPreferredBrowser;
    }

    public void setPreferredBrowser(String preferredBrowser) {
        this.myPreferredBrowser = preferredBrowser;
    }

    void browseHtml(String htmlFile) {
        HelpServiceLog.logger().info("browseHTMLHelp htmlFil: " + htmlFile);
        if (System.getProperty("ALEX_TEST_MODE", "FALSE").equalsIgnoreCase("TRUE")) {
            HelpServiceLog.logger().finer("Test Mode: No command string set");
        } else {
            String cmdString = this.getCommandString();
            if (null == cmdString) {
                return;
            }
            try {
                HelpServiceLog.logger().finer("Executing " + cmdString + " " + htmlFile);
                Runtime.getRuntime().exec(cmdString + " " + htmlFile);
            }
            catch (Exception e) {
                HelpServiceLog.logger().log(Level.ALL, "Was not able to launch: " + htmlFile + e.getMessage());
                MessageDialogFactory.createMessageDialog("Display failure.", "It was not possible to launch a browser with the page " + htmlFile, e, this.myIconPath, false).setVisible(true);
                this.setPreferredBrowser(null);
            }
        }
    }

    String getCommandString() {
        String cmdString = null;
        if (EmasUtilities.runningOnWindows()) {
            cmdString = "cmd /c start";
        } else if (null == this.myPreferredBrowser) {
            cmdString = this.selectBrowser();
            if (null != cmdString) {
                this.setPreferredBrowser(cmdString);
            }
        } else {
            cmdString = this.getPreferredBrowser();
        }
        return cmdString;
    }

    String selectBrowser() {
        String retValue = JOptionPane.showInputDialog(Display.getInvisibleFrame(this.myIconPath), "Enter browser application for display:", "firefox");
        return retValue;
    }
}

