/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.logservices;

import java.util.Properties;
import se.ericsson.cello.emt.logservices.LogListenerHandler;
import se.ericsson.cello.emt.logservices.LogServices;
import se.ericsson.cello.emt.logservices.LogStatusListener;
import se.ericsson.cello.emt.logservices.view.LogServicesController;
import se.ericsson.cello.emt.logservices.view.LogServicesGUI;
import se.ericsson.emt.logservices.toolservice.Configuration;
import se.ericsson.emt.logservices.toolservice.ParameterHandler;
import se.ericsson.emt.logservices.toolservice.ToolServices;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.ReusableLaunchable;

public class LogServicesTool
implements ReusableLaunchable,
LogServices {
    LauncherInterface launcher;
    Launchable parent;
    LogServicesGUI gui;
    Configuration configuration;
    LogListenerHandler logListenerHdl = new LogListenerHandler();

    public void exit() {
        this.gui.setVisible(false);
        this.launcher.onExit((Launchable)this);
    }

    public boolean reconnect(String arg0, Properties arg1) {
        return true;
    }

    public void run(String hostname, Properties arguments, LauncherInterface launcher, Launchable parent) {
        this.launcher = launcher;
        this.parent = parent;
        this.configuration = new ParameterHandler(arguments);
        ToolServices toolServices = new ToolServices(this.configuration, launcher, hostname, (Launchable)this);
        LogServicesController controller = new LogServicesController(toolServices, (Launchable)this);
        this.gui = new LogServicesGUI(controller, this.logListenerHdl);
        this.gui.setVisible(true);
    }

    public void reuse(String hostname, Properties arguments, LauncherInterface launcher, Launchable parent) {
        String preSelectedLog = arguments.getProperty("LOG_NAME", null);
        this.gui.updateUI(preSelectedLog);
    }

    public String toString() {
        return this.configuration.getTitle();
    }

    public void registerListener(LogStatusListener logStatusListener) {
        this.logListenerHdl.addListener(logStatusListener);
    }

    public void deRegisterListener(LogStatusListener logStatusListener) {
        this.logListenerHdl.removeListener(logStatusListener);
    }
}

