/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.logservices.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.ericsson.cello.emt.logservices.LogListenerHandler;
import se.ericsson.cello.emt.logservices.view.LogServicesController;
import se.ericsson.cello.emt.utils.guihelper.MessageDialog;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;

public class LogServicesGUI
extends JFrame {
    static final String LOAD_SETTINGS_FROM_FILE = "Load log settings from file";
    static final String BROWSE = "Browse";
    static final String LOG_SETTINGS = "Log settings";
    static final String CHOOSE_FILE = "Choose file";
    static final String AVAILABLE_LOGS = "Available logs";
    static final String LOG_LEVEL = "Log level";
    static final String OUTPUT_SETTINGS = "Output settings";
    static final String SET = "Set";
    static final String CANCEL = "Cancel";
    static final String LOG_TO_FILE = "Log to file";
    static final String LOG_TO_CONSOLE = "Log to console";
    static final int HEIGHT = 445;
    static final int WIDTH = 400;
    static final int TEXTFIELD_NR_COLUMNS = 30;
    private static final long serialVersionUID = 1L;
    private final String[] levels = new String[]{"OFF", "SEVERE", "WARNING", "INFO", "CONFIG", "FINE", "FINER", "FINEST", "ALL"};
    private HashMap<String, JRadioButton> levelRadioButtons = new HashMap();
    private LogServicesController controller;
    private JPanel contentPane = null;
    private JPanel mainSettingsPanel = null;
    private JPanel loadSettingsFromFilePanel = null;
    private JPanel logSettingsPanel = null;
    private JTextField logSettingsFromFileField = null;
    private JButton browseForSettingsFileButton = null;
    private JPanel mainSettingsNorthPanel = null;
    private JPanel mainSettingsSouthPanel = null;
    private JRadioButton useSettingsFromFileRadioButton = null;
    private JRadioButton useManualSettingsRadioButton = null;
    private JScrollPane loggersPanel = null;
    private JPanel levelPanel = null;
    private JList availableLoggersList = null;
    private JPanel radioCheckBoxPanel = null;
    private JPanel outputSettingsPanel = null;
    private JPanel logToFileSettingsPanel = null;
    private JTextField logToFileTextField = null;
    private JButton logToFileBrowseButton = null;
    private JPanel jButtonPanel = null;
    private JButton setButton = null;
    private JButton jCancelButton = null;
    private JPanel logToConsoleSettingsPanel = null;
    private JCheckBox logToFileCheckBox = null;
    private JCheckBox logToConsoleCheckBox = null;
    private ButtonGroup buttonGroup = null;
    private JButton helpButton = null;
    private LogListenerHandler logListenerHdl;

    public LogServicesGUI(LogServicesController controller, LogListenerHandler logListenerHdl) {
        this.controller = controller;
        this.logListenerHdl = logListenerHdl;
        this.initialize();
    }

    private void initialize() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setSize(400, 445);
        this.setContentPane(this.getJContentPane());
        this.setTitle(this.controller.getTitle());
        this.setLocationRelativeTo(null);
        Image image = this.controller.getIconImage();
        if (image != null) {
            this.setIconImage(image);
        }
        this.logSettingsFromFileField.setName("tbLogSettingsFromFile");
        if (this.controller.getSettingsFilePath() != null) {
            this.logSettingsFromFileField.setText(this.controller.getSettingsFilePath());
        }
        if (this.controller.getLogFilePath() != null) {
            this.logToFileTextField.setText(this.controller.getLogFilePath());
            this.logToFileTextField.setEnabled(true);
            this.logToFileCheckBox.setSelected(true);
            this.logToFileBrowseButton.setEnabled(true);
        }
        this.logToConsoleCheckBox.setSelected(this.controller.getLogToConsole());
        this.logToFileCheckBox.setSelected(this.controller.getLogToFile());
        if (this.controller.getSelectedLog() != null) {
            this.availableLoggersList.setSelectedValue(this.controller.getSelectedLog(), true);
            String level = this.controller.getLevel((String)this.availableLoggersList.getSelectedValue());
            if (level != null) {
                this.levelRadioButtons.get(level).setSelected(true);
            } else {
                this.levelRadioButtons.get("OFF").setSelected(true);
            }
        }
        switch (this.controller.getInputSettings()) {
            case FILE: {
                this.disableManualSettingsComponents();
                this.enableSettingsFromFileComponents();
                break;
            }
            case MANUAL: {
                this.enableManualSettingsComponents();
                this.disableSettingsFromFileComponents();
                break;
            }
            default: {
                this.enableManualSettingsComponents();
                this.disableSettingsFromFileComponents();
            }
        }
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.contentPane.setLayout(new BorderLayout());
            this.contentPane.add((Component)this.getMainSettingsPanel(), "North");
            this.contentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.contentPane;
    }

    private JPanel getMainSettingsPanel() {
        if (this.mainSettingsPanel == null) {
            this.mainSettingsPanel = new JPanel();
            this.mainSettingsPanel.setLayout(new BorderLayout());
            this.mainSettingsPanel.add((Component)this.getMainSettingsNorthPanel(), "North");
            this.mainSettingsPanel.add((Component)this.getMainSettingsSouthPanel(), "Center");
        }
        return this.mainSettingsPanel;
    }

    private JPanel getLoadSettingsFromFilePanel() {
        if (this.loadSettingsFromFilePanel == null) {
            this.loadSettingsFromFilePanel = new JPanel();
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(3);
            this.loadSettingsFromFilePanel.setLayout(flowLayout);
            this.loadSettingsFromFilePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, LOAD_SETTINGS_FROM_FILE, 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
            this.loadSettingsFromFilePanel.setName(BROWSE);
            this.loadSettingsFromFilePanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.loadSettingsFromFilePanel.add((Component)this.getSettingsFileField(), null);
            this.loadSettingsFromFilePanel.add((Component)this.getBrowseForSettingsFileButton(), null);
        }
        return this.loadSettingsFromFilePanel;
    }

    private JPanel getLogSettingsPanel() {
        if (this.logSettingsPanel == null) {
            this.logSettingsPanel = new JPanel();
            this.logSettingsPanel.setLayout(new GridBagLayout());
            this.logSettingsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, LOG_SETTINGS, 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.logSettingsPanel.add((Component)this.getLoggersPanel(), c);
            c.fill = 1;
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 1.0;
            this.logSettingsPanel.add((Component)this.getLevelPanel(), c);
            c.fill = 1;
            c.gridwidth = 2;
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.logSettingsPanel.add((Component)this.getOutputSettingsPanel(), c);
        }
        return this.logSettingsPanel;
    }

    private JTextField getSettingsFileField() {
        if (this.logSettingsFromFileField == null) {
            this.logSettingsFromFileField = new JTextField();
            this.logSettingsFromFileField.setColumns(30);
            this.logSettingsFromFileField.setName("logSettingsFromFileField");
            this.logSettingsFromFileField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent ev) {
                    LogServicesGUI.this.controller.setSettingsFilePath(LogServicesGUI.this.logSettingsFromFileField.getText());
                }

                public void removeUpdate(DocumentEvent ev) {
                    LogServicesGUI.this.controller.setSettingsFilePath(LogServicesGUI.this.logSettingsFromFileField.getText());
                }

                public void changedUpdate(DocumentEvent ev) {
                    LogServicesGUI.this.controller.setSettingsFilePath(LogServicesGUI.this.logSettingsFromFileField.getText());
                }
            });
            this.logSettingsFromFileField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    LogServicesGUI.this.controller.setSettingsFilePath(LogServicesGUI.this.logSettingsFromFileField.getText());
                }
            });
        }
        return this.logSettingsFromFileField;
    }

    private JButton getBrowseForSettingsFileButton() {
        if (this.browseForSettingsFileButton == null) {
            this.browseForSettingsFileButton = new JButton();
            this.browseForSettingsFileButton.setText(BROWSE);
            this.browseForSettingsFileButton.setName("browseForSettingsFileButton");
            this.browseForSettingsFileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    String path = "";
                    path = LogServicesGUI.this.controller.getSettingsFilePath();
                    JFileChooser fileChooser = new JFileChooser(path);
                    fileChooser.showDialog(LogServicesGUI.this.contentPane, LogServicesGUI.CHOOSE_FILE);
                    File selectedFile = fileChooser.getSelectedFile();
                    if (selectedFile != null) {
                        LogServicesGUI.this.logSettingsFromFileField.setText(selectedFile.getAbsolutePath());
                    }
                    LogServicesGUI.this.controller.setSettingsFilePath(LogServicesGUI.this.logSettingsFromFileField.getText());
                }
            });
        }
        return this.browseForSettingsFileButton;
    }

    private JPanel getMainSettingsNorthPanel() {
        if (this.mainSettingsNorthPanel == null) {
            this.mainSettingsNorthPanel = new JPanel();
            this.mainSettingsNorthPanel.setLayout(new BoxLayout(this.getMainSettingsNorthPanel(), 0));
            this.mainSettingsNorthPanel.setName("northPanel");
            this.mainSettingsNorthPanel.add((Component)this.getUseSettingsFromFileRadioButton(), null);
            this.mainSettingsNorthPanel.add((Component)this.getLoadSettingsFromFilePanel(), null);
        }
        return this.mainSettingsNorthPanel;
    }

    private JPanel getMainSettingsSouthPanel() {
        if (this.mainSettingsSouthPanel == null) {
            this.mainSettingsSouthPanel = new JPanel();
            this.mainSettingsSouthPanel.setLayout(new BoxLayout(this.getMainSettingsSouthPanel(), 0));
            this.mainSettingsSouthPanel.setName("southPanel");
            this.mainSettingsSouthPanel.add((Component)this.getUseManualSettingsRadioButton(), null);
            this.mainSettingsSouthPanel.add((Component)this.getLogSettingsPanel(), null);
        }
        return this.mainSettingsSouthPanel;
    }

    private JRadioButton getUseSettingsFromFileRadioButton() {
        if (this.useSettingsFromFileRadioButton == null) {
            this.useSettingsFromFileRadioButton = new JRadioButton();
            this.useSettingsFromFileRadioButton.setName("useSettingsFromFileRadioButton");
            if (this.controller.getInputSettings() == LogServicesController.InputPreference.FILE) {
                this.useSettingsFromFileRadioButton.setSelected(true);
            } else {
                this.useSettingsFromFileRadioButton.setSelected(false);
            }
            this.useSettingsFromFileRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    LogServicesGUI.this.useManualSettingsRadioButton.setSelected(false);
                    LogServicesGUI.this.disableManualSettingsComponents();
                    LogServicesGUI.this.useSettingsFromFileRadioButton.setSelected(true);
                    LogServicesGUI.this.enableSettingsFromFileComponents();
                    LogServicesGUI.this.controller.setInputSettings(LogServicesController.InputPreference.FILE);
                }
            });
        }
        return this.useSettingsFromFileRadioButton;
    }

    private JRadioButton getUseManualSettingsRadioButton() {
        if (this.useManualSettingsRadioButton == null) {
            this.useManualSettingsRadioButton = new JRadioButton();
            this.useManualSettingsRadioButton.setName("useManualSettingsRadioButton");
            if (this.controller.getInputSettings() == LogServicesController.InputPreference.NOT_SELECTED || this.controller.getInputSettings() == LogServicesController.InputPreference.MANUAL) {
                this.useManualSettingsRadioButton.setSelected(true);
                this.disableSettingsFromFileComponents();
            } else {
                this.useManualSettingsRadioButton.setSelected(false);
                this.enableSettingsFromFileComponents();
            }
            this.useManualSettingsRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    LogServicesGUI.this.useSettingsFromFileRadioButton.setSelected(false);
                    LogServicesGUI.this.disableSettingsFromFileComponents();
                    LogServicesGUI.this.useManualSettingsRadioButton.setSelected(true);
                    LogServicesGUI.this.enableManualSettingsComponents();
                    LogServicesGUI.this.controller.setInputSettings(LogServicesController.InputPreference.MANUAL);
                }
            });
        }
        return this.useManualSettingsRadioButton;
    }

    private JScrollPane getLoggersPanel() {
        if (this.loggersPanel == null) {
            this.loggersPanel = new JScrollPane();
            ScrollPaneLayout layout = new ScrollPaneLayout();
            this.loggersPanel.setLayout(layout);
            this.loggersPanel.setViewportView(this.getAvailableLoggersList());
            this.loggersPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, AVAILABLE_LOGS, 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        }
        return this.loggersPanel;
    }

    private JPanel getLevelPanel() {
        if (this.levelPanel == null) {
            this.levelPanel = new JPanel();
            this.levelPanel.setLayout(new BorderLayout());
            this.levelPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, LOG_LEVEL, 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)), BorderFactory.createEmptyBorder(0, 0, 0, 0)), null));
            this.levelPanel.add((Component)this.getRadioCheckBoxPanel(), "Center");
        }
        return this.levelPanel;
    }

    private JList getAvailableLoggersList() {
        if (this.availableLoggersList == null) {
            this.availableLoggersList = new JList<Object>(this.controller.getLoggerNames().toArray());
            this.availableLoggersList.setName("availableLoggersList");
            this.availableLoggersList.setSelectionMode(0);
            this.availableLoggersList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    String level = null;
                    level = LogServicesGUI.this.controller.getLevel((String)LogServicesGUI.this.availableLoggersList.getSelectedValue());
                    LogServicesGUI.this.enableLevelRadioButtons();
                    if (level != null) {
                        ((JRadioButton)LogServicesGUI.this.levelRadioButtons.get(level)).setSelected(true);
                    } else {
                        ((JRadioButton)LogServicesGUI.this.levelRadioButtons.get("OFF")).setSelected(true);
                    }
                }
            });
        }
        return this.availableLoggersList;
    }

    private JPanel getRadioCheckBoxPanel() {
        if (this.radioCheckBoxPanel == null) {
            this.radioCheckBoxPanel = new JPanel();
            this.buttonGroup = new ButtonGroup();
            this.radioCheckBoxPanel.setLayout(new BoxLayout(this.getRadioCheckBoxPanel(), 1));
            for (int i = 0; i < this.levels.length; ++i) {
                final JRadioButton button = new JRadioButton(this.levels[i]);
                button.setName(this.levels[i]);
                this.levelRadioButtons.put(this.levels[i], button);
                this.buttonGroup.add(button);
                this.radioCheckBoxPanel.add(button);
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        LogServicesGUI.this.controller.applyLevel((String)LogServicesGUI.this.availableLoggersList.getSelectedValue(), button.getText());
                    }
                });
            }
        }
        return this.radioCheckBoxPanel;
    }

    private JPanel getOutputSettingsPanel() {
        if (this.outputSettingsPanel == null) {
            this.outputSettingsPanel = new JPanel();
            this.outputSettingsPanel.setLayout(new BoxLayout(this.getOutputSettingsPanel(), 1));
            this.outputSettingsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, OUTPUT_SETTINGS, 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)), BorderFactory.createEmptyBorder(0, 0, 0, 0)), null));
            this.outputSettingsPanel.add((Component)this.getLogToFileSettingsPanel(), null);
            this.outputSettingsPanel.add((Component)this.getLogToConsoleSettingsPanel(), null);
        }
        return this.outputSettingsPanel;
    }

    private JPanel getLogToFileSettingsPanel() {
        if (this.logToFileSettingsPanel == null) {
            this.logToFileSettingsPanel = new JPanel();
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(3);
            this.logToFileSettingsPanel.setLayout(flowLayout);
            this.logToFileSettingsPanel.add(this.getLogToFileCheckBox());
            this.logToFileSettingsPanel.add(this.getLogToFileTextField());
            this.logToFileSettingsPanel.add(this.getLogToFileBrowseButton());
        }
        return this.logToFileSettingsPanel;
    }

    private JTextField getLogToFileTextField() {
        if (this.logToFileTextField == null) {
            this.logToFileTextField = new JTextField();
            this.logToFileTextField.setName("logToFileTextField");
            this.logToFileTextField.setColumns(30);
            this.logToFileTextField.setEnabled(false);
            this.logToFileTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent ev) {
                    LogServicesGUI.this.controller.setLogFilePath(LogServicesGUI.this.logToFileTextField.getText());
                }

                public void removeUpdate(DocumentEvent ev) {
                    LogServicesGUI.this.controller.setLogFilePath(LogServicesGUI.this.logToFileTextField.getText());
                }

                public void changedUpdate(DocumentEvent ev) {
                    LogServicesGUI.this.controller.setLogFilePath(LogServicesGUI.this.logToFileTextField.getText());
                }
            });
        }
        return this.logToFileTextField;
    }

    private JButton getLogToFileBrowseButton() {
        if (this.logToFileBrowseButton == null) {
            this.logToFileBrowseButton = new JButton();
            this.logToFileBrowseButton.setName("logToFileBrowseButton");
            this.logToFileBrowseButton.setText(BROWSE);
            this.logToFileBrowseButton.setEnabled(false);
            this.logToFileBrowseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    JFileChooser fileChooser = new JFileChooser(System.getProperty("user.dir"));
                    fileChooser.setName("browseForLogFileChooser");
                    fileChooser.showDialog(LogServicesGUI.this.contentPane, LogServicesGUI.CHOOSE_FILE);
                    File selectedFile = fileChooser.getSelectedFile();
                    if (selectedFile != null) {
                        LogServicesGUI.this.logToFileTextField.setText(selectedFile.getAbsolutePath());
                    }
                }
            });
        }
        return this.logToFileBrowseButton;
    }

    private JPanel getButtonPanel() {
        if (this.jButtonPanel == null) {
            this.jButtonPanel = new JPanel();
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.jButtonPanel.setLayout(flowLayout);
            this.jButtonPanel.add((Component)this.getSetButton(), null);
            this.jButtonPanel.add((Component)this.getCancelButton(), null);
            this.jButtonPanel.add((Component)this.getHelpButton(), null);
        }
        return this.jButtonPanel;
    }

    private boolean updateController() {
        boolean traceEnabled = false;
        if (this.useManualSettingsRadioButton.isSelected()) {
            this.controller.set();
        } else if (!this.logSettingsFromFileField.getText().equalsIgnoreCase("")) {
            try {
                this.controller.readSettingsFromFile();
            }
            catch (FileNotFoundException e) {
                this.showError("It was not possible to set the logging properties from file. The file was not found.", e);
                return false;
            }
            catch (SecurityException e) {
                this.showError("It was not possible to set the logging properties from file. Reading from the specified file is not allowed. ", e);
                return false;
            }
            catch (IOException e) {
                this.showError("It was not possible to set the logging properties from file. Reading from the file failed. ", e);
                return false;
            }
            catch (IllegalArgumentException e) {
                this.showError("It was not possible to set the logging properties from file. ", e);
                return false;
            }
        }
        if (this.logToFileCheckBox.isSelected() || this.logToConsoleCheckBox.isSelected()) {
            traceEnabled = true;
        }
        this.logListenerHdl.notifyListeners(traceEnabled);
        return true;
    }

    void showError(final String msg, final Exception e) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    LogServicesGUI.this.showError(msg, e);
                }
            };
            SwingUtilities.invokeLater(runner);
            return;
        }
        MessageDialog msgDlg = MessageDialogFactory.createMessageDialog(msg, e, false, (JFrame)this);
        if (null != msgDlg) {
            msgDlg.setVisible(true);
        }
    }

    private JButton getSetButton() {
        if (this.setButton == null) {
            this.setButton = new JButton();
            this.setButton.setName("setButton");
            this.setButton.setText(SET);
            this.setButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    if (LogServicesGUI.this.updateController()) {
                        LogServicesGUI.this.controller.exit();
                    }
                }
            });
        }
        return this.setButton;
    }

    private JButton getCancelButton() {
        if (this.jCancelButton == null) {
            this.jCancelButton = new JButton();
            this.jCancelButton.setName("cancelButton");
            this.jCancelButton.setText(CANCEL);
            this.jCancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    LogServicesGUI.this.controller.exit();
                }
            });
        }
        return this.jCancelButton;
    }

    private JPanel getLogToConsoleSettingsPanel() {
        if (this.logToConsoleSettingsPanel == null) {
            this.logToConsoleSettingsPanel = new JPanel();
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(3);
            this.logToConsoleSettingsPanel.setLayout(flowLayout);
            this.logToConsoleSettingsPanel.add((Component)this.getLogToConsoleCheckBox(), null);
        }
        return this.logToConsoleSettingsPanel;
    }

    private JCheckBox getLogToFileCheckBox() {
        if (this.logToFileCheckBox == null) {
            this.logToFileCheckBox = new JCheckBox();
            this.logToFileCheckBox.setName("logToFileCheckBox");
            this.logToFileCheckBox.setText(LOG_TO_FILE);
            this.logToFileCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    LogServicesGUI.this.controller.setLogToFile(LogServicesGUI.this.logToFileCheckBox.isSelected());
                    if (LogServicesGUI.this.logToFileCheckBox.isSelected()) {
                        LogServicesGUI.this.logToFileTextField.setEnabled(true);
                        LogServicesGUI.this.logToFileBrowseButton.setEnabled(true);
                    } else {
                        LogServicesGUI.this.logToFileTextField.setEnabled(false);
                        LogServicesGUI.this.logToFileBrowseButton.setEnabled(false);
                    }
                }
            });
        }
        return this.logToFileCheckBox;
    }

    private JCheckBox getLogToConsoleCheckBox() {
        if (this.logToConsoleCheckBox == null) {
            this.logToConsoleCheckBox = new JCheckBox();
            this.logToConsoleCheckBox.setName("logToConsoleCheckBox");
            this.logToConsoleCheckBox.setText(LOG_TO_CONSOLE);
            this.logToConsoleCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    LogServicesGUI.this.controller.setLogToConsole(LogServicesGUI.this.logToConsoleCheckBox.isSelected());
                }
            });
        }
        return this.logToConsoleCheckBox;
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            super.processWindowEvent(e);
            this.controller.exit();
        } else {
            super.processWindowEvent(e);
        }
    }

    private void enableSettingsFromFileComponents() {
        this.browseForSettingsFileButton.setEnabled(true);
        this.logSettingsFromFileField.setEnabled(true);
    }

    private void disableSettingsFromFileComponents() {
        this.browseForSettingsFileButton.setEnabled(false);
        this.logSettingsFromFileField.setEnabled(false);
    }

    private void enableManualSettingsComponents() {
        this.logToConsoleCheckBox.setEnabled(true);
        this.logToFileCheckBox.setEnabled(true);
        this.logToFileTextField.setEnabled(true);
        this.logToFileBrowseButton.setEnabled(true);
        this.availableLoggersList.setEnabled(true);
        this.enableLevelRadioButtons();
    }

    private void disableManualSettingsComponents() {
        this.logToConsoleCheckBox.setEnabled(false);
        this.logToFileCheckBox.setEnabled(false);
        this.logToFileTextField.setEnabled(false);
        this.logToFileBrowseButton.setEnabled(false);
        this.availableLoggersList.setEnabled(false);
        this.disableLevelRadioButtons();
    }

    private void enableLevelRadioButtons() {
        Collection<JRadioButton> collection = this.levelRadioButtons.values();
        for (JRadioButton button : collection) {
            button.setEnabled(true);
        }
    }

    private void disableLevelRadioButtons() {
        Collection<JRadioButton> collection = this.levelRadioButtons.values();
        for (JRadioButton button : collection) {
            button.setEnabled(false);
        }
    }

    private JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton();
            this.helpButton.setText("Help");
            this.helpButton.setName("helpButton");
            this.helpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    LogServicesGUI.this.controller.showHelp();
                }
            });
        }
        return this.helpButton;
    }

    public void updateUI(String log) {
        if (log != null && this.controller.getSelectedLog() != null) {
            this.availableLoggersList.setSelectedValue(log, true);
            String level = this.controller.getLevel((String)this.availableLoggersList.getSelectedValue());
            if (level != null) {
                this.levelRadioButtons.get(level).setSelected(true);
            } else {
                this.levelRadioButtons.get("OFF").setSelected(true);
            }
        }
        this.bringToFront();
    }

    public void bringToFront() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.getState() == 1) {
                this.setState(0);
            }
            this.toFront();
            this.requestFocus();
        } else {
            Runnable runner = new Runnable(){

                public void run() {
                    LogServicesGUI.this.bringToFront();
                }
            };
            SwingUtilities.invokeLater(runner);
        }
    }
}

