/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.sshsftpservice.credential.impl;

import se.ericsson.cello.emt.sshsftpservice.credential.ifc.SlsCredentialsSupplier;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshLoginException;
import se.ericsson.security.login.LoginException;
import se.ericsson.security.login.LoginServices;
import se.ericsson.security.login.LoginServicesFactory;
import se.ericsson.security.login.creds.Credentials;
import se.ericsson.security.login.creds.CredentialsException;
import se.ericsson.security.utils.EmLogger;

public class SsuLoginContext
implements SlsCredentialsSupplier {
    private static final EmLogger LOG = EmLogger.SSH_SFTP_SERVICE;
    private static final String MSG = "Login failure via SSU";
    private static final String MSG3 = "Already logged in";
    private static final String MSG4 = "Login failure via SSU. Can not get credentials.";
    private static final String TITLE_LOGIN = "SSH/SFTP User Login";

    public Credentials getCredentials(String callingApplicationTitle) throws EmSshLoginException {
        LoginServices loginServices = LoginServicesFactory.getLoginServices();
        loginServices.setTitle(SsuLoginContext.constructTitle(callingApplicationTitle));
        try {
            loginServices.login();
        }
        catch (LoginException e) {
            if (e.getMessage().equals(MSG3)) {
                LOG.fine(MSG3, new Object[0]);
            }
            LOG.severe(MSG, new Object[0]);
            throw new EmSshLoginException(MSG, e);
        }
        Credentials creds = null;
        try {
            creds = loginServices.getCredentials();
        }
        catch (IllegalStateException e) {
            LOG.severe(MSG4, new Object[0]);
            throw new EmSshLoginException(MSG4, e);
        }
        catch (CredentialsException e) {
            LOG.severe(MSG4, new Object[0]);
            throw new EmSshLoginException(MSG4, e);
        }
        return creds;
    }

    private static String constructTitle(String callingApplicationTitle) {
        StringBuilder title = new StringBuilder();
        if (!"".equals(callingApplicationTitle)) {
            title.append(callingApplicationTitle);
            title.append(" - ");
        }
        title.append(TITLE_LOGIN);
        return title.toString();
    }
}

