/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.utils.guihelper;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import se.ericsson.cello.emt.utils.guihelper.AccumulativeRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwingWorker<T, V>
implements Future<T>,
Runnable {
    private static final int MAX_THREADS = 10;
    private volatile int progression;
    private volatile StateValue stateValue;
    private final FutureTask<T> futureTask;
    private final PropertyChangeSupport propertyChangeSup;
    private AccumulativeRunnable<V> doProcession;
    private AccumulativeRunnable<Integer> doNotifyProgreChange;
    private static final AccumulativeRunnable<Runnable> doSubmitAccumulate = new DoSubmitActionAccumulativeRunnable();
    private static ExecutorService executService = null;

    public SwingWorker() {
        Callable callA = new Callable<T>(){

            @Override
            public T call() throws Exception {
                SwingWorker.this.setStates(StateValue.STARTED);
                return SwingWorker.this.doInBackground();
            }
        };
        this.futureTask = new FutureTask<T>(callA){

            @Override
            protected void done() {
                SwingWorker.this.doneEventDispatchThread();
                SwingWorker.this.setStates(StateValue.DONE);
            }
        };
        this.stateValue = StateValue.PENDING;
        this.propertyChangeSup = new SwingWorkerFirePropertyChangeSupport(this);
        this.doProcession = null;
        this.doNotifyProgreChange = null;
    }

    protected abstract T doInBackground() throws Exception;

    @Override
    public final void run() {
        this.futureTask.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void publish(V ... chunk) {
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            if (this.doProcession == null) {
                this.doProcession = new AccumulativeRunnable<V>(){

                    @Override
                    public void run(List<V> arg) {
                        SwingWorker.this.process(arg);
                    }

                    @Override
                    protected void submit() {
                        doSubmitAccumulate.add(this);
                    }
                };
            }
        }
        this.doProcession.add(chunk);
    }

    protected void process(List<V> chunk) {
    }

    protected void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProgress(int progres) {
        if (progres < 0 || progres > 100) {
            throw new IllegalArgumentException("The value should be from 0 to 100");
        }
        if (this.progression == progres) {
            return;
        }
        int oldProgr = this.progression;
        this.progression = progres;
        if (!this.getPropertysChangeSupport().hasListeners("progress")) {
            return;
        }
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            if (this.doNotifyProgreChange == null) {
                this.doNotifyProgreChange = new AccumulativeRunnable<Integer>(){

                    @Override
                    public void run(List<Integer> arg) {
                        Integer object1 = arg.get(0);
                        Integer object2 = arg.get(arg.size() - 1);
                        SwingWorker.this.firePropertyChange("progress", object1, object2);
                    }

                    @Override
                    protected void submit() {
                        doSubmitAccumulate.add(this);
                    }
                };
            }
        }
        this.doNotifyProgreChange.add((Integer[])new Integer[]{oldProgr, progres});
    }

    public final int getProgress() {
        return this.progression;
    }

    public final void execute() {
        SwingWorker.getWorkersExecutService().execute(this);
    }

    @Override
    public final boolean cancel(boolean interruptIfRunning) {
        return this.futureTask.cancel(interruptIfRunning);
    }

    @Override
    public final boolean isCancelled() {
        return this.futureTask.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.futureTask.isDone();
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        return this.futureTask.get();
    }

    @Override
    public final T get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.futureTask.get(timeout, timeUnit);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangelistener) {
        this.getPropertysChangeSupport().addPropertyChangeListener(propertyChangelistener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangelistener) {
        this.getPropertysChangeSupport().removePropertyChangeListener(propertyChangelistener);
    }

    public final void firePropertyChange(String properName, Object oldValue, Object newValue) {
        this.getPropertysChangeSupport().firePropertyChange(properName, oldValue, newValue);
    }

    public final PropertyChangeSupport getPropertysChangeSupport() {
        return this.propertyChangeSup;
    }

    public final StateValue getStates() {
        StateValue sv = this.stateValue;
        if (this.isDone()) {
            sv = StateValue.DONE;
        }
        return sv;
    }

    private void setStates(StateValue stateVal) {
        StateValue oldValue = this.stateValue;
        this.stateValue = stateVal;
        this.firePropertyChange("state", (Object)oldValue, (Object)stateVal);
    }

    private void doneEventDispatchThread() {
        Runnable doFinish = new Runnable(){

            public void run() {
                SwingWorker.this.done();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doFinish.run();
        } else {
            doSubmitAccumulate.add((Runnable[])new Runnable[]{doFinish});
        }
    }

    private static synchronized ExecutorService getWorkersExecutService() {
        if (executService == null) {
            ThreadFactory threadFac = new ThreadFactory(){
                final AtomicInteger threadNum = new AtomicInteger(1);

                public Thread newThread(Runnable run) {
                    StringBuilder builderName = new StringBuilder("SwingWorker-pool-");
                    builderName.append(System.identityHashCode(this));
                    builderName.append("-thread-");
                    builderName.append(this.threadNum.getAndIncrement());
                    Thread th = new Thread(run, builderName.toString());
                    if (th.isDaemon()) {
                        th.setDaemon(false);
                    }
                    if (th.getPriority() != 5) {
                        th.setPriority(5);
                    }
                    return th;
                }
            };
            executService = new ThreadPoolExecutor(0, 10, 5L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFac){
                private final ReentrantLock pausesLock = new ReentrantLock();
                private final Condition unpauses = this.pausesLock.newCondition();
                private boolean isPauses = false;
                private final ReentrantLock executLock = new ReentrantLock();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(Runnable cmd) {
                    this.executLock.lock();
                    try {
                        this.pausesLock.lock();
                        try {
                            this.isPauses = true;
                            Object var3_2 = null;
                            this.pausesLock.unlock();
                        }
                        catch (Throwable throwable) {
                            Object var3_3 = null;
                            this.pausesLock.unlock();
                            throw throwable;
                        }
                        this.setCorePoolSize(10);
                        super.execute(cmd);
                        this.setCorePoolSize(0);
                        this.pausesLock.lock();
                        try {
                            this.isPauses = false;
                            this.unpauses.signalAll();
                            Object var5_5 = null;
                            this.pausesLock.unlock();
                        }
                        catch (Throwable throwable) {
                            Object var5_6 = null;
                            this.pausesLock.unlock();
                            throw throwable;
                        }
                        Object var7_8 = null;
                        this.executLock.unlock();
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        this.executLock.unlock();
                        throw throwable;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void afterExecute(Runnable run, Throwable th) {
                    super.afterExecute(run, th);
                    this.pausesLock.lock();
                    try {
                        try {
                            while (this.isPauses) {
                                this.unpauses.await();
                            }
                            Object var5_3 = null;
                            this.pausesLock.unlock();
                        }
                        catch (InterruptedException interruptedException) {
                            Object var5_4 = null;
                            this.pausesLock.unlock();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        this.pausesLock.unlock();
                        throw throwable;
                    }
                }
            };
        }
        return executService;
    }

    private class SwingWorkerFirePropertyChangeSupport
    extends PropertyChangeSupport {
        private static final long serialVersUID = 1L;

        SwingWorkerFirePropertyChangeSupport(Object sources) {
            super(sources);
        }

        public void firePropertyChange(final PropertyChangeEvent evts) {
            if (SwingUtilities.isEventDispatchThread()) {
                super.firePropertyChange(evts);
            } else {
                doSubmitAccumulate.add(new Runnable(){

                    public void run() {
                        SwingWorkerFirePropertyChangeSupport.this.firePropertyChange(evts);
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoSubmitActionAccumulativeRunnable
    extends AccumulativeRunnable<Runnable>
    implements ActionListener {
        private static final int DELAYTIME = 33;

        private DoSubmitActionAccumulativeRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void run(List<Runnable> arg) {
            int k = 0;
            try {
                for (Runnable runnable : arg) {
                    ++k;
                    runnable.run();
                }
                Object var6_5 = null;
                if (k >= arg.size()) return;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (k >= arg.size()) throw throwable;
                Runnable[] argsTails = new Runnable[arg.size() - k];
                for (int j = 0; j < argsTails.length; ++j) {
                    argsTails[j] = arg.get(k + j);
                }
                this.add(true, (T[])argsTails);
                throw throwable;
            }
            Runnable[] argsTails = new Runnable[arg.size() - k];
            for (int j = 0; j < argsTails.length; ++j) {
                argsTails[j] = arg.get(k + j);
            }
            {
            }
            this.add(true, (T[])argsTails);
        }

        @Override
        protected void submit() {
            Timer timers = new Timer(33, this);
            timers.setRepeats(false);
            timers.start();
        }

        @Override
        public void actionPerformed(ActionEvent events) {
            this.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StateValue {
        PENDING,
        STARTED,
        DONE;

    }
}

