/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment;

import java.text.StringCharacterIterator;
import se.ericsson.cello.equipment.BoardTypePositions;
import se.ericsson.cello.equipment.SubrackProdTypeBuildIF;
import se.ericsson.cello.equipment.SubrackProdTypeMo;
import se.ericsson.cello.equipment.SubrackProdTypeMoFactory;
import se.ericsson.cello.equipment.suaccess.SubrackProdTypeMoSU_Access;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProxySelectorEquInterface;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.SubrackProdTypeProxyInformation;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.SubrackProdTypeReadProxyInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.util.library.Lib;

public class SubrackProdTypeMoImpl
extends ManagedObjectBase
implements SubrackProdTypeMo,
SubrackProdTypeBuildIF,
SubrackProdTypeMoSU_Access {
    SubrackProdTypeProxyInformation mySubrackProdTypeProxyInformation = null;
    ProxySelectorEquInterface myProxySelectorInterface = null;
    String myProductNumberOpt = null;
    String myProductRevisionOpt = null;
    private static final String PRODUCT_NUMBER_OPT = "productNumberOpt";
    private static final String PRODUCT_REVISION_OPT = "productRevisionOpt";
    private MoData myData;
    private static String[] adminProductDataNames = new String[]{"productNumber", "productRevision", "productName", "productInfo", "productionDate"};
    static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1", "SU_2", "SU_3", "SU_4"};
    private static String[] structNames = new String[]{"cmxbPositionA", "cmxbPositionB", "scuPositionA", "scuPositionB", "tuPositionA", "tuPositionB"};
    private static final int MO_DATA_REVISION_7000 = 7000;
    private static final int MO_DATA_REVISION_14100 = 14100;
    private static final int MO_DATA_REVISION_LATEST = 14100;
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)SubrackProdTypeMoImpl.class, (int)70, (String)"create(ManagedObject aParent, AttrList anAttributes, String anIdentity, ManagedObject source, Coordinator aCoordinator)", (String)("aParent: " + managedObject + "\n\tanAttributes: " + Lib.toString((AttrList)attrList) + "\n\tanIdentity: " + string + "\n\taSource: " + managedObject2 + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        return SubrackProdTypeMoImpl.createMO(managedObject, attrList, string, true, coordinator);
    }

    public static synchronized ManagedObject createAtUpgrade(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)SubrackProdTypeMoImpl.class, (int)70, (String)"createAtUpgrade(ManagedObject aParent, AttrList anAttributes, String anIdentity, Coordinator aCoordinator)", (String)("aParent: " + managedObject + "\n\tanAttributes: " + Lib.toString((AttrList)attrList) + "\n\tanIdentity: " + string + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        return SubrackProdTypeMoImpl.createMO(managedObject, attrList, string, false, coordinator);
    }

    public static synchronized SubrackProdTypeMoSU_Access createAtUpgrade(ManagedObject managedObject, String string, String string2, String string3, String string4, int n, int n2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)SubrackProdTypeMoImpl.class, (int)70, (String)"createAtUpgrade(ManagedObject aParent, String anIdentity, String aProductNumber, String aProductRevision, String anUserLabel, int aTransmissionType, int aFanConfiguration, Coordinator aCoordinator)", (String)("aParent: " + managedObject + "\n\tanIdentity: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3 + "\n\tanUserLabel: " + string4 + "\n\taTransmissionType: " + n + "\n\taFanConfiguration: " + n2 + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"SubrackProdType", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Equipment");
        if (n == 5 && n2 != 5) {
            throw new ConfigurationMismatchException("Attribute fanConfiguration must be set to CAX_TWO value 5when attribute TransmissionType is set to ETHERNET_1G_10G_40G value 5", "SubrackProdType", "transmissionType");
        }
        if (n2 == 5 && n != 5) {
            throw new ConfigurationMismatchException("Attribute transmissionType must be set to ETHERNET_1G_10G_40G value 5 when attribute fanConfiguration is set to CAX_TWO value 5", "SubrackProdType", "fanConfiguration");
        }
        if (n == 4 && n2 != 4) {
            throw new ConfigurationMismatchException("Attribute fanConfiguration must be set to EGEM2_TWO value 4when attribute TransmissionType is set to ETHERNET_1G_10G value 4", "SubrackProdType", "fanConfiguration");
        }
        if (n2 == 4 && n != 4) {
            throw new ConfigurationMismatchException("Attribute transmissionType must be set to ETHERNET_1G_10G value 4 when attribute fanConfiguration is set to EGEM2_TWO value 4", "SubrackProdType", "TRANSMISSIONTYPE");
        }
        if (!string3.equals("*")) {
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string3);
            char c = stringCharacterIterator.first();
            if (!(c == 'R' | c == 'r' | c == 'P' | c == 'p')) {
                throw new ValueOutOfRangeException("productRevision", "SubrackProdType");
            }
            c = stringCharacterIterator.next();
            if (!Character.isDigit(c)) {
                throw new ValueOutOfRangeException("productRevision", "SubrackProdType");
            }
        }
        return new SubrackProdTypeMoImpl(managedObject, string, string2, string3, string4, coordinator);
    }

    private static ManagedObject createMO(ManagedObject managedObject, AttrList attrList, String string, boolean bl, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)SubrackProdTypeMoImpl.class, (int)70, (String)"create( ManagedObject aParent, AttrList anAttributes, String anIdentity, boolean anIsCheckOfExistingRevisionsNeeded, Coordinator aCoordinator)", (String)("aParent: " + managedObject + "\n\tanAttributes: " + Lib.toString((AttrList)attrList) + "\n\tanIdentity: " + string + "\n\tanIsCheckOfExistingRevisionsNeeded: " + bl + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"SubrackProdType", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Equipment");
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"maxPowerDissipation", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)100000, (String)"SubrackProdType");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"transmissionType", (AttrList)attrList, (boolean)true, (int)0, (int)1, (int)5, (String)"SubrackProdType");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"defNumberOfSlots", (AttrList)attrList, (boolean)true, (int)0, (int)1, (int)28, (String)"SubrackProdType");
        int n4 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"fanConfiguration", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)5, (String)"SubrackProdType");
        if (n2 == 5 && n4 != 5) {
            throw new ConfigurationMismatchException("Attribute fanConfiguration must be set to CAX_TWO value 5when attribute TransmissionType is set to ETHERNET_1G_10G_40G value 5", "SubrackProdType", "transmissionType");
        }
        if (n4 == 5 && n2 != 5) {
            throw new ConfigurationMismatchException("Attribute transmissionType must be set to ETHERNET_1G_10G_40G value 5 when attribute fanConfiguration is set to CAX_TWO value 5", "SubrackProdType", "fanConfiguration");
        }
        if (n2 == 4 && n4 != 4) {
            throw new ConfigurationMismatchException("Attribute fanConfiguration must be set to EGEM2_TWO value 4when attribute TransmissionType is set to ETHERNET_1G_10G value 4", "SubrackProdType", "fanConfiguration");
        }
        if (n4 == 4 && n2 != 4) {
            throw new ConfigurationMismatchException("Attribute transmissionType must be set to ETHERNET_1G_10G value 4 when attribute fanConfiguration is set to EGEM2_TWO value 4", "SubrackProdType", "TRANSMISSIONTYPE");
        }
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"SubrackProdType", (int)128, (int)0);
        BoardTypePositions boardTypePositions = new BoardTypePositions(attrList, n3);
        Struct struct = SubrackProdTypeMoImpl.checkAndGetProductData(attrList, bl);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"SubrackProdType");
        return new SubrackProdTypeMoImpl(managedObject, string, n, n2, n3, n4, boardTypePositions, struct, string2, coordinator);
    }

    private SubrackProdTypeMoImpl(ManagedObject managedObject, String string, int n, int n2, int n3, int n4, BoardTypePositions boardTypePositions, Struct struct, String string2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "SubrackProdType", string, coordinator);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"SubrackProdTypeMoImpl( ManagedObject parent, String identity, int maxPowerDissipation, int aTransmissionType, int defNumberOfSlots, int fanConfiguration, BoardTypePositions aBoardTypePositions, Struct productData, String userLabel, Coordinator context )", (String)("parent: " + managedObject + "\n\tidentity: " + string + "\n\tmaxPowerDissipation: " + n + "\n\taTransmissionType: " + n2 + "\n\tdefNumberOfSlots: " + n3 + "\n\tfanConfiguration: " + n4 + "\n\taBoardTypePositions: " + boardTypePositions + "\n\tproductData: " + Lib.toString((Struct)struct) + "\n\tuserLabel: " + string2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        StructAttribute structAttribute = new StructAttribute("SU_DOM_KEY", false);
        this.myData.registerPersistentAttr((Attribute)structAttribute);
        StringAttribute stringAttribute = new StringAttribute("userLabel", true, string2);
        this.myData.registerPersistentAttr((Attribute)stringAttribute);
        IntegerAttribute integerAttribute = new IntegerAttribute("maxPowerDissipation", false, n);
        this.myData.registerPersistentAttr((Attribute)integerAttribute);
        IntegerAttribute integerAttribute2 = new IntegerAttribute("transmissionType", false, n2);
        this.myData.registerPersistentAttr((Attribute)integerAttribute2);
        IntegerAttribute integerAttribute3 = new IntegerAttribute("defNumberOfSlots", false, n3);
        this.myData.registerPersistentAttr((Attribute)integerAttribute3);
        IntegerAttribute integerAttribute4 = new IntegerAttribute("fanConfiguration", false, n4);
        this.myData.registerPersistentAttr((Attribute)integerAttribute4);
        this.myData.registerPersistentAttr((Attribute)boardTypePositions.getAsStructAttribute());
        StructAttribute structAttribute2 = new StructAttribute("productData", false);
        StringAttribute stringAttribute2 = null;
        for (int i = 0; i < adminProductDataNames.length; ++i) {
            stringAttribute2 = new StringAttribute(adminProductDataNames[i], false, (String)struct.getValue(adminProductDataNames[i]));
            structAttribute2.addElement((Attribute)stringAttribute2);
            if (adminProductDataNames[i].equals("productNumber")) {
                this.myProductNumberOpt = Lib.optimize((String)stringAttribute2.getValue(coordinator));
                continue;
            }
            if (!adminProductDataNames[i].equals("productRevision")) continue;
            this.myProductRevisionOpt = Lib.optimize((String)stringAttribute2.getValue(coordinator));
        }
        this.myData.registerPersistentAttr((Attribute)structAttribute2);
        SequenceAttribute sequenceAttribute = new SequenceAttribute("reservedBy", false);
        sequenceAttribute.setValue(new Attribute[0]);
        this.myData.registerPersistentAttr((Attribute)sequenceAttribute);
        this.myData.setRevision(14100);
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private SubrackProdTypeMoImpl(ManagedObject managedObject, String string, String string2, String string3, String string4, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "SubrackProdType", string, coordinator);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"SubrackProdTypeMoImpl(ManagedObject aParent, String anIdentity, String aProductNumber, String aProductRevision, String anUserLabel, Coordinator aCoordinator)", (String)("parent: " + managedObject + "\n\tidentity: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3 + "\n\tanUserLabel: " + string4 + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        StructAttribute structAttribute = new StructAttribute("SU_DOM_KEY", false);
        StringAttribute stringAttribute = null;
        stringAttribute = new StringAttribute("productNumber", false, string2);
        structAttribute.addElement((Attribute)stringAttribute);
        stringAttribute = new StringAttribute("productRevision", false, string3);
        structAttribute.addElement((Attribute)stringAttribute);
        this.myData.registerPersistentAttr((Attribute)structAttribute);
        this.myProductNumberOpt = string2;
        this.myProductRevisionOpt = string3;
        StringAttribute stringAttribute2 = new StringAttribute("userLabel", true, string4);
        this.myData.registerPersistentAttr((Attribute)stringAttribute2);
        SequenceAttribute sequenceAttribute = new SequenceAttribute("reservedBy", false);
        sequenceAttribute.setValue(new Attribute[0]);
        this.myData.registerPersistentAttr((Attribute)sequenceAttribute);
        IntegerAttribute integerAttribute = new IntegerAttribute("maxPowerDissipation", false, 0);
        this.myData.registerPersistentAttr((Attribute)integerAttribute);
        IntegerAttribute integerAttribute2 = new IntegerAttribute("transmissionType", false, 0);
        this.myData.registerPersistentAttr((Attribute)integerAttribute2);
        IntegerAttribute integerAttribute3 = new IntegerAttribute("defNumberOfSlots", false, 0);
        this.myData.registerPersistentAttr((Attribute)integerAttribute3);
        IntegerAttribute integerAttribute4 = new IntegerAttribute("fanConfiguration", false, 0);
        this.myData.registerPersistentAttr((Attribute)integerAttribute4);
        StructAttribute structAttribute2 = new StructAttribute("boardPositions", false);
        this.myData.registerPersistentAttr((Attribute)structAttribute2);
        StructAttribute structAttribute3 = new StructAttribute("productData", false);
        this.myData.registerPersistentAttr((Attribute)structAttribute3);
        this.myData.setRevision(14100);
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public SubrackProdTypeMoImpl(MoData moData) throws MoAccessException {
        super(moData.getLocalDistinguishedName());
        this.myData = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.myData, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(14100);
        moDataRecoveryHelper.assertAttribute("boardPositions");
        moDataRecoveryHelper.assertAttribute("defNumberOfSlots");
        moDataRecoveryHelper.assertAttribute("transmissionType");
        moDataRecoveryHelper.assertAttribute("fanConfiguration");
        moDataRecoveryHelper.assertAttribute("maxPowerDissipation");
        moDataRecoveryHelper.assertAttribute("productData");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("SU_DOM_KEY");
        this.optimizeProductData();
    }

    public void activateSubrackrackProdTypeMo(String string, String string2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"activateSubrackrackProdTypeMo(String aProductNumber, String aRevision, Coordinator aCoordinator)", (String)("aProductNumber: " + string + "\n\taRevision: " + string2 + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        StructAttribute structAttribute = this.getSU_DOM_Key();
        if (structAttribute.isEmpty()) {
            StringAttribute stringAttribute = null;
            stringAttribute = new StringAttribute("productNumber", false, string);
            structAttribute.addElement((Attribute)stringAttribute);
            stringAttribute = new StringAttribute("productRevision", false, string2);
            structAttribute.addElement((Attribute)stringAttribute);
            ((IntegerAttribute)this.myData.getAttribute("maxPowerDissipation")).setValue(0);
            ((IntegerAttribute)this.myData.getAttribute("transmissionType")).setValue(0);
            ((IntegerAttribute)this.myData.getAttribute("defNumberOfSlots")).setValue(0);
            ((IntegerAttribute)this.myData.getAttribute("fanConfiguration")).setValue(0);
            StructAttribute structAttribute2 = (StructAttribute)this.myData.getAttribute("boardPositions");
            IntegerAttribute integerAttribute = (IntegerAttribute)structAttribute2.getElement("cmxbPositionA", coordinator);
            integerAttribute.setValue(0);
            integerAttribute = (IntegerAttribute)structAttribute2.getElement("cmxbPositionB", coordinator);
            integerAttribute.setValue(0);
            integerAttribute = (IntegerAttribute)structAttribute2.getElement("scuPositionA", coordinator);
            integerAttribute.setValue(0);
            integerAttribute = (IntegerAttribute)structAttribute2.getElement("scuPositionB", coordinator);
            integerAttribute.setValue(0);
            integerAttribute = (IntegerAttribute)structAttribute2.getElement("tuPositionA", coordinator);
            integerAttribute.setValue(0);
            integerAttribute = (IntegerAttribute)structAttribute2.getElement("tuPositionB", coordinator);
            integerAttribute.setValue(0);
            StructAttribute structAttribute3 = (StructAttribute)this.myData.getAttribute("productData");
            for (int i = 0; i < adminProductDataNames.length; ++i) {
                stringAttribute = (StringAttribute)structAttribute3.getElement(adminProductDataNames[i], coordinator);
                stringAttribute.setValue("");
            }
        }
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)this.myData.getAttribute("reservedBy");
        if (!sequenceAttribute.isEmpty()) {
            throw new MoReservedNotDeletableException("SubrackProdType");
        }
        super.delete(coordinator);
        this.myData.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"SubrackProdType", (MoData)this.myData, (SequenceAttribute)((SequenceAttribute)this.myData.getAttribute("reservedBy")));
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"SubrackProdType", (MoData)this.myData, (SequenceAttribute)((SequenceAttribute)this.myData.getAttribute("reservedBy")));
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            ManagedObject[] managedObjectArray;
            Object object;
            int n;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.myData.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("maxPowerDissipation")) {
                if (this.getSU_DOM_Key().isEmpty()) {
                    n = ((IntegerAttribute)this.myData.getAttribute("maxPowerDissipation")).getValue(coordinator);
                    objectArray[i] = new Integer(n);
                    continue;
                }
                objectArray[i] = this.getSubrackProdTypeReadProxyInterface().getMaxPowerDissipation((SubrackProdTypeMoSU_Access)this);
                if (objectArray[i] != null) continue;
                objectArray[i] = new Integer(0);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("defNumberOfSlots")) {
                if (this.getSU_DOM_Key().isEmpty()) {
                    n = ((IntegerAttribute)this.myData.getAttribute("defNumberOfSlots")).getValue(coordinator);
                    objectArray[i] = new Integer(n);
                    continue;
                }
                objectArray[i] = this.getSubrackProdTypeReadProxyInterface().getDefNumberOfSlots((SubrackProdTypeMoSU_Access)this);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("fanConfiguration")) {
                if (this.getSU_DOM_Key().isEmpty()) {
                    n = ((IntegerAttribute)this.myData.getAttribute("fanConfiguration")).getValue(coordinator);
                    objectArray[i] = new Integer(n);
                    continue;
                }
                objectArray[i] = this.getSubrackProdTypeReadProxyInterface().getFanConfigurationAsInteger((SubrackProdTypeMoSU_Access)this);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("transmissionType")) {
                if (this.getSU_DOM_Key().isEmpty()) {
                    n = ((IntegerAttribute)this.myData.getAttribute("transmissionType")).getValue(coordinator);
                    objectArray[i] = new Integer(n);
                    continue;
                }
                objectArray[i] = this.getSubrackProdTypeReadProxyInterface().getTransmissionTypeAsInteger((SubrackProdTypeMoSU_Access)this);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("SubrackProdTypeId")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("boardPositions")) {
                if (this.getSU_DOM_Key().isEmpty()) {
                    object = new BoardTypePositions((StructAttribute)this.myData.getAttribute("boardPositions"), coordinator);
                    objectArray[i] = ((BoardTypePositions)object).getAsStruct();
                    continue;
                }
                object = this.getSubrackProdTypeReadProxyInterface();
                managedObjectArray = object.getCmxbPositionA((SubrackProdTypeMoSU_Access)this);
                Integer n2 = object.getCmxbPositionB((SubrackProdTypeMoSU_Access)this);
                Integer n3 = object.getScuPositionA((SubrackProdTypeMoSU_Access)this);
                Integer n4 = object.getScuPositionB((SubrackProdTypeMoSU_Access)this);
                Integer n5 = object.getTuPositionA((SubrackProdTypeMoSU_Access)this);
                Integer n6 = object.getTuPositionB((SubrackProdTypeMoSU_Access)this);
                objectArray[i] = new StructImpl(structNames, new Object[]{managedObjectArray, n2, n3, n4, n5, n6});
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("productData")) {
                object = new Object[5];
                if (this.getSU_DOM_Key().isEmpty()) {
                    managedObjectArray = (StructAttribute)this.myData.getAttribute("productData");
                    StringAttribute stringAttribute = null;
                    for (int j = 0; j < adminProductDataNames.length; ++j) {
                        stringAttribute = (StringAttribute)managedObjectArray.getElement(adminProductDataNames[j], coordinator);
                        object[j] = stringAttribute.getValue(coordinator);
                    }
                } else {
                    managedObjectArray = this.getSubrackProdTypeReadProxyInterface().getProductData((SubrackProdTypeMoSU_Access)this);
                    object[0] = managedObjectArray.getNumberRaw();
                    object[1] = managedObjectArray.getRevisionRaw();
                    object[2] = managedObjectArray.getName();
                    object[3] = managedObjectArray.getInformation();
                    object[4] = managedObjectArray.getDate();
                    if (object[3] == null) {
                        object[3] = "";
                    }
                    if (object[4] == null) {
                        object[4] = "";
                    }
                }
                objectArray[i] = new StructImpl(adminProductDataNames, (Object[])object);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                object = ((SequenceAttribute)this.myData.getAttribute("reservedBy")).getValue(coordinator);
                managedObjectArray = new ManagedObject[((Object)object).length];
                for (int j = 0; j < ((Object)object).length; ++j) {
                    managedObjectArray[j] = ((ReferenceAttribute)object[j]).getValue(coordinator);
                }
                objectArray[i] = managedObjectArray;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(PRODUCT_NUMBER_OPT)) {
                objectArray[i] = this.getProductNumberOpt(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(PRODUCT_REVISION_OPT)) {
                objectArray[i] = this.getProductRevisionOpt(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "SubrackProdType");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? SubrackProdTypeMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "SubrackProdType");
                }
            } else {
                throw new NoSuchAttributeException(stringArray[i], "SubrackProdType");
            }
            MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"SubrackProdType", (int)128, (int)0);
            ((StringAttribute)this.myData.getAttribute("userLabel")).setValue((String)objectArray[i]);
        }
    }

    public void setAttributesForUpgrade(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAttributesForUpgrade(AttrList attributes, Coordinator c)", (String)(this.getClass() + ":" + this.getLocalDistinguishedName() + "\n\tc: " + Lib.toString((AttrList)attrList)));
        }
        if (this.getSU_DOM_Key().isEmpty()) {
            Integer n;
            int n2 = attrList.indexOf("fanConfiguration");
            if (n2 != -1) {
                n = (Integer)attrList.getValue(n2);
                ((IntegerAttribute)this.myData.getAttribute("fanConfiguration")).setValue(n);
            }
            if ((n2 = attrList.indexOf("transmissionType")) != -1) {
                n = (Integer)attrList.getValue(n2);
                ((IntegerAttribute)this.myData.getAttribute("transmissionType")).setValue(n);
            }
            if ((n2 = attrList.indexOf("defNumberOfSlots")) != -1) {
                n = (Integer)attrList.getValue(n2);
                ((IntegerAttribute)this.myData.getAttribute("defNumberOfSlots")).setValue(n);
            }
            if ((n2 = attrList.indexOf("maxPowerDissipation")) != -1) {
                n = (Integer)attrList.getValue(n2);
                ((IntegerAttribute)this.myData.getAttribute("maxPowerDissipation")).setValue(n);
            }
            if ((n2 = attrList.indexOf("boardPositions")) != -1) {
                Struct struct = (Struct)attrList.getValue(n2);
                StructAttribute structAttribute = (StructAttribute)this.myData.getAttribute("boardPositions");
                IntegerAttribute integerAttribute = (IntegerAttribute)structAttribute.getElement("cmxbPositionA", coordinator);
                integerAttribute.setValue(((Integer)struct.getValue("cmxbPositionA")).intValue());
                IntegerAttribute integerAttribute2 = (IntegerAttribute)structAttribute.getElement("cmxbPositionB", coordinator);
                integerAttribute2.setValue(((Integer)struct.getValue("cmxbPositionB")).intValue());
                IntegerAttribute integerAttribute3 = (IntegerAttribute)structAttribute.getElement("scuPositionA", coordinator);
                integerAttribute3.setValue(((Integer)struct.getValue("scuPositionA")).intValue());
                IntegerAttribute integerAttribute4 = (IntegerAttribute)structAttribute.getElement("scuPositionB", coordinator);
                integerAttribute4.setValue(((Integer)struct.getValue("scuPositionB")).intValue());
                IntegerAttribute integerAttribute5 = (IntegerAttribute)structAttribute.getElement("tuPositionA", coordinator);
                integerAttribute5.setValue(((Integer)struct.getValue("tuPositionA")).intValue());
                IntegerAttribute integerAttribute6 = (IntegerAttribute)structAttribute.getElement("tuPositionB", coordinator);
                integerAttribute6.setValue(((Integer)struct.getValue("tuPositionB")).intValue());
            }
        } else {
            UpgradeTrace.warning(this.getClass(), (String)"setAttributesForUpgrade(AttrList attributes, Coordinator c)", (String)"Not possible to update the SubrackProdTypeMo since SU DOM is used");
        }
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public Struct getProductData(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("productData", coordinator);
    }

    public int getMaxPowerDissipation(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("maxPowerDissipation", coordinator);
    }

    public StructAttribute getSU_DOM_Key() throws MoAccessException {
        return (StructAttribute)this.myData.getAttribute("SU_DOM_KEY");
    }

    public boolean getSU_DOM_Required(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSU_DOM_Required(Coordinator aCoordinator)");
        return !this.getSU_DOM_Key().isEmpty();
    }

    public int getDefNumberOfSlots(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("defNumberOfSlots", coordinator);
    }

    public int getFanConfiguration(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("fanConfiguration", coordinator);
    }

    public int getTransmissionType(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("transmissionType", coordinator);
    }

    public Struct getBoardPositions(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("boardPositions", coordinator);
    }

    public String getSubrackProdTypeld(Coordinator coordinator) throws MoAccessException {
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return super.getNamingAttributeValue();
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getType() {
        return "SubrackProdType";
    }

    public String getProductNumber(Coordinator coordinator) throws MoAccessException {
        return this.getMemberInProductData("productNumber", coordinator);
    }

    public String getProductRevision(Coordinator coordinator) throws MoAccessException {
        return this.getMemberInProductData("productRevision", coordinator);
    }

    public String getProductNumberOpt(Coordinator coordinator) throws MoAccessException {
        return this.myProductNumberOpt;
    }

    public String getProductRevisionOpt(Coordinator coordinator) throws MoAccessException {
        return this.myProductRevisionOpt;
    }

    public String getProductName(Coordinator coordinator) throws MoAccessException {
        return this.getMemberInProductData("productName", coordinator);
    }

    public String getProductDate(Coordinator coordinator) throws MoAccessException {
        return this.getMemberInProductData("productionDate", coordinator);
    }

    public String getProductInfo(Coordinator coordinator) throws MoAccessException {
        return this.getMemberInProductData("productInfo", coordinator);
    }

    public int getCmxbPositionA(Coordinator coordinator) throws MoAccessException {
        return this.getMemberInBoardPositions("cmxbPositionA", coordinator);
    }

    public int getCmxbPositionB(Coordinator coordinator) throws MoAccessException {
        return this.getMemberInBoardPositions("cmxbPositionB", coordinator);
    }

    public int getScuPositionA(Coordinator coordinator) throws MoAccessException {
        return this.getMemberInBoardPositions("scuPositionA", coordinator);
    }

    public int getScuPositionB(Coordinator coordinator) throws MoAccessException {
        return this.getMemberInBoardPositions("scuPositionB", coordinator);
    }

    public int getTubPositionA(Coordinator coordinator) throws MoAccessException {
        return this.getMemberInBoardPositions("tuPositionA", coordinator);
    }

    public int getTubPositionB(Coordinator coordinator) throws MoAccessException {
        return this.getMemberInBoardPositions("tuPositionB", coordinator);
    }

    private static Struct checkAndGetProductData(AttrList attrList, boolean bl) throws MoAccessException {
        Object[] objectArray;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        UpgradeTrace.debug((Class)SubrackProdTypeMoImpl.class, (int)70, (String)"checkAndGetProductData( AttrList attributes, boolean anIsCheckOfExistingRevisionsNeeded)", (String)("attributes: " + Lib.toString((AttrList)attrList) + "\n\tanIsCheckOfExistingRevisionsNeeded: " + bl));
        Struct struct = null;
        int n = attrList.indexOf("productData");
        if (n == -1) {
            throw new AttrMissingAtCreateException("productData", "SubrackProdType");
        }
        if (!(attrList.getValue(n) instanceof Struct)) {
            throw new WrongAttributeTypeException("productData", "SubrackProdType");
        }
        struct = (Struct)attrList.getValue(n);
        if (struct.size() > 5) {
            throw new NoSuchFieldException("Unknown field in struct");
        }
        SubrackProdTypeMoImpl.validateAdministrativeProductData(struct);
        try {
            string5 = (String)struct.getValue("productRevision");
            string4 = (String)struct.getValue("productNumber");
            string3 = (String)struct.getValue("productName");
            if (string5 == null || string4 == null || string3 == null) {
                throw new AttrMissingAtCreateException("productData", "SubrackProdType");
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AttrMissingAtCreateException("productData", "SubrackProdType");
        }
        try {
            string2 = (String)struct.getValue("productInfo");
            if (string2 == null) {
                string2 = "";
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            string2 = "";
        }
        try {
            string = (String)struct.getValue("productionDate");
            if (string == null) {
                string = "";
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            string = "";
        }
        if (!string5.equals("*")) {
            objectArray = new StringCharacterIterator(string5);
            char c = objectArray.first();
            if (!(c == 'R' | c == 'r' | c == 'P' | c == 'p')) {
                throw new ValueOutOfRangeException("productRevision", "SubrackProdType");
            }
            c = objectArray.next();
            if (!Character.isDigit(c)) {
                throw new ValueOutOfRangeException("productRevision", "SubrackProdType");
            }
        }
        if (bl) {
            SubrackProdTypeMoFactory.instance().verifyThatProductNumberAndRevisionIsAllowed(string4, string5);
        }
        objectArray = new String[]{string4, string5, string3, string2, string};
        struct = new StructImpl(adminProductDataNames, objectArray);
        attrList.removeElementAt(n);
        return struct;
    }

    private static void checkDateFormat(String string) throws ValueOutOfRangeException {
        if (string.length() == 0) {
            return;
        }
        if (string.length() != 5 && string.length() != 8) {
            throw new ValueOutOfRangeException("productionDate", "SubrackProdType");
        }
        if (string.length() == 8) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isDigit(c)) continue;
                throw new ValueOutOfRangeException("productionDate", "SubrackProdType");
            }
        } else {
            char c = string.charAt(2);
            if (c != 'w' && c != 'W') {
                throw new ValueOutOfRangeException("productionDate", "SubrackProdType");
            }
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (Character.isDigit(c2) || i == 2) continue;
                throw new ValueOutOfRangeException("productionDate", "SubrackProdType");
            }
        }
    }

    private static void validateAdministrativeProductData(Struct struct) throws MoAccessException {
        String[] stringArray = struct.getNames();
        String string = "";
        UpgradeTrace.debug((Class)SubrackProdTypeMoImpl.class, (int)70, (String)"validateAdministrativeProductData(Struct adminProductData))", (String)("names: " + Lib.toString((String[])stringArray)));
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("productInfo")) {
                    if (!struct.getValue("productInfo").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productInfo", "SubrackProdType");
                    }
                    string = (String)struct.getValue("productInfo");
                    MoAttributeValidator.checkStringWithLength((String)string, (String)"productInfo", (String)"SubrackProdType", (int)13, (int)0);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("productionDate")) {
                    if (!struct.getValue("productionDate").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productionDate", "SubrackProdType");
                    }
                    string = (String)struct.getValue("productionDate");
                    SubrackProdTypeMoImpl.checkDateFormat(string);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("productName")) {
                    if (!struct.getValue("productName").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productName", "SubrackProdType");
                    }
                    string = (String)struct.getValue("productName");
                    MoAttributeValidator.checkStringWithLength((String)string, (String)"productName", (String)"SubrackProdType", (int)12, (int)1);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("productNumber")) {
                    if (!struct.getValue("productNumber").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productNumber", "SubrackProdType");
                    }
                    string = (String)struct.getValue("productNumber");
                    MoAttributeValidator.checkStringWithLength((String)string, (String)"productNumber", (String)"SubrackProdType", (int)24, (int)1);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("productRevision")) {
                    if (!struct.getValue("productRevision").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productRevision", "SubrackProdType");
                    }
                    string = (String)struct.getValue("productRevision");
                    MoAttributeValidator.checkStringWithLength((String)string, (String)"productRevision", (String)"SubrackProdType", (int)7, (int)1);
                    continue;
                }
                throw new NoSuchFieldException("SubrackProdType. Unknown field in administrativeProductData " + stringArray[i]);
            }
        }
    }

    private String getMemberInProductData(String string, Coordinator coordinator) throws MoAccessException {
        Struct struct = (Struct)this.getAttribute("productData", coordinator);
        return (String)struct.getValue(string);
    }

    private int getMemberInBoardPositions(String string, Coordinator coordinator) throws MoAccessException {
        Struct struct = (Struct)this.getAttribute("boardPositions", coordinator);
        return (Integer)struct.getValue(string);
    }

    public boolean matchSubrackProdTypeMo(String string, String string2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"matchSubrackProdTypeMo(String prodNo, String prodRev, Coordinator c)", (String)("prodNo: " + string + "\n\tprodRev: " + string2 + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.myData.handleTransaction(coordinator, MoData.READ_ACCESS);
        return SubrackProdTypeMoImpl.pidcompare(this.getProductRevision(coordinator), string2) && SubrackProdTypeMoImpl.pidcompare(this.getProductNumber(coordinator), string);
    }

    private void optimizeProductData() throws MoAccessException {
        if (this.getSU_DOM_Key().isEmpty()) {
            this.myProductNumberOpt = this.getProductNumber(null);
            this.myProductNumberOpt = Lib.optimize((String)this.myProductNumberOpt);
            this.myProductRevisionOpt = this.getProductRevision(null);
            this.myProductRevisionOpt = Lib.optimize((String)this.myProductRevisionOpt);
            if (UpgradeTrace.valid(this.getClass(), (int)72)) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"optimizeProductData()", (String)("Initial configured i.e. not accessible from SU DOM: myProductNumberOpt: " + this.myProductNumberOpt + " myProductRevisionOpt: " + this.myProductRevisionOpt));
            }
        } else {
            this.myProductNumberOpt = this.getSU_DOM_KeyProductNumber();
            this.myProductRevisionOpt = this.getSU_DOM_KeyProductRevision();
            if (UpgradeTrace.valid(this.getClass(), (int)72)) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"optimizeProductData()", (String)("SubrackProdType Mo is accessible via SU DOM: myProductNumberOpt: " + this.myProductNumberOpt + " myProductRevisionOpt: " + this.myProductRevisionOpt));
            }
        }
    }

    private static boolean pidcompare(String string, String string2) {
        return string == null ? SubrackProdTypeMoImpl.removeWhiteSpace(string2) == null : (string2 == null ? SubrackProdTypeMoImpl.removeWhiteSpace(string) == null : SubrackProdTypeMoImpl.removeWhiteSpace(string).equalsIgnoreCase(SubrackProdTypeMoImpl.removeWhiteSpace(string2)));
    }

    private static String removeWhiteSpace(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (Character.isSpaceChar(string.charAt(i))) continue;
            stringBuffer.append(string.charAt(i));
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    private String getSU_DOM_KeyProductNumber() throws MoAccessException {
        StringAttribute stringAttribute = (StringAttribute)this.getSU_DOM_Key().getElement("productNumber", null);
        return stringAttribute.getValue(null);
    }

    private String getSU_DOM_KeyProductRevision() throws MoAccessException {
        StringAttribute stringAttribute = (StringAttribute)this.getSU_DOM_Key().getElement("productRevision", null);
        return stringAttribute.getValue(null);
    }

    private SubrackProdTypeReadProxyInterface getSubrackProdTypeReadProxyInterface() throws MoAccessException {
        try {
            return this.getSubrackProdTypeProxyInformation().getSubrackProdTypeReadProxyInterface();
        }
        catch (Throwable throwable) {
            String string = "\n\tSU_DOM_KeyProductNumber: " + this.getSU_DOM_KeyProductNumber() + "\n\tSU_DOM_KeyProductRevision: " + this.getSU_DOM_KeyProductRevision();
            if (throwable instanceof NullPointerException) {
                SubrackProdTypeProxyInformation subrackProdTypeProxyInformation = this.getSubrackProdTypeProxyInformation();
                string = string + "\n\tgetSubrackProdTypeProxyInformation( ) returns " + subrackProdTypeProxyInformation;
                if (subrackProdTypeProxyInformation != null) {
                    SubrackProdTypeReadProxyInterface subrackProdTypeReadProxyInterface = subrackProdTypeProxyInformation.getSubrackProdTypeReadProxyInterface();
                    string = string + "\n\tgetSubrackProdTypeProxyInformation( ).getSubrackProdTypeReadProxyInterface( ) returns " + subrackProdTypeReadProxyInterface;
                }
            }
            UpgradeTrace.error(this.getClass(), (String)"getSubrackProdTypeReadProxyInterface( )", (String)("Throwable caught," + string), (Throwable)throwable);
            throw new SoftwareErrorException(throwable);
        }
    }

    private SubrackProdTypeProxyInformation getSubrackProdTypeProxyInformation() throws MoAccessException {
        this.mySubrackProdTypeProxyInformation = this.getProxySelectorInterface().getSubrackProdTypeReadProxyInterface(this.getSU_DOM_KeyProductNumber(), this.getSU_DOM_KeyProductRevision(), this.mySubrackProdTypeProxyInformation);
        return this.mySubrackProdTypeProxyInformation;
    }

    private ProxySelectorEquInterface getProxySelectorInterface() {
        if (this.myProxySelectorInterface == null) {
            this.myProxySelectorInterface = (ProxySelectorEquInterface)ServiceLocatorFacade.getRepository().getService(ProxySelectorEquInterface.class);
        }
        return this.myProxySelectorInterface;
    }
}

