/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.equipment.fropxy;

import enea.ose.io.SignalOutputStream;
import enea.ose.system.UnlinkedSignal;
import java.io.IOException;
import se.ericsson.cello.equipment.SubrackProdTypeBuildIF;
import se.ericsson.cello.moframework.MoAccessException;

public class OsaSr2CreateReq
extends UnlinkedSignal {
    public static final int SIGNO = 68402;
    private long txId;
    private int srSwitchModuleNo;
    private String productNo;
    private String productRevision;
    private String productName;
    private String productDate;
    private String serialNo;
    private int numberOfSlots;
    private int maxPowerDissipation;
    private int transmissionType;
    private int fanConfiguration;
    private int nrOfDenibDevices;
    private int cmxbPositionA;
    private int cmxbPositionB;
    private int scuPositionA;
    private int scuPositionB;
    private int tuPositionA;
    private int tuPositionB;
    private int NUMBER_BOARD_TYPE_POSITIONS = 6;
    private int CELLO_SR_TUB_POSITION_A = 1;
    private int CELLO_SR_TUB_POSITION_B = 2;
    private int CELLO_SR_SCU_POSITION_A = 3;
    private int CELLO_SR_SCU_POSITION_B = 4;
    private int CELLO_SR_CMXB_POSITION_A = 5;
    private int CELLO_SR_CMXB_POSITION_B = 6;

    public int getSignalNumber() {
        return 68402;
    }

    public OsaSr2CreateReq(long l, int n, SubrackProdTypeBuildIF subrackProdTypeBuildIF, int n2) throws MoAccessException {
        super(68402);
        this.txId = l;
        this.srSwitchModuleNo = n;
        this.productNo = subrackProdTypeBuildIF.getProductNumber(null);
        this.productRevision = subrackProdTypeBuildIF.getProductRevision(null);
        this.productName = subrackProdTypeBuildIF.getProductName(null);
        this.productDate = subrackProdTypeBuildIF.getProductDate(null);
        this.serialNo = subrackProdTypeBuildIF.getProductInfo(null);
        this.numberOfSlots = subrackProdTypeBuildIF.getDefNumberOfSlots(null);
        this.maxPowerDissipation = subrackProdTypeBuildIF.getMaxPowerDissipation(null);
        this.transmissionType = subrackProdTypeBuildIF.getTransmissionType(null);
        this.fanConfiguration = subrackProdTypeBuildIF.getFanConfiguration(null);
        this.cmxbPositionA = subrackProdTypeBuildIF.getCmxbPositionA(null);
        this.cmxbPositionB = subrackProdTypeBuildIF.getCmxbPositionB(null);
        this.scuPositionA = subrackProdTypeBuildIF.getScuPositionA(null);
        this.scuPositionB = subrackProdTypeBuildIF.getScuPositionB(null);
        this.tuPositionA = subrackProdTypeBuildIF.getTubPositionA(null);
        this.tuPositionB = subrackProdTypeBuildIF.getTubPositionB(null);
        this.nrOfDenibDevices = n2;
    }

    public void initReceive() {
    }

    public void initSend() {
        SignalOutputStream signalOutputStream = this.getSignalOutputStream();
        try {
            signalOutputStream.writeU32(this.txId);
            signalOutputStream.writeU16(this.srSwitchModuleNo);
            signalOutputStream.writeString(this.productNo);
            signalOutputStream.writeU8Array(new int[25 - this.productNo.length() - 1]);
            signalOutputStream.writeString(this.productRevision);
            signalOutputStream.writeU8Array(new int[8 - this.productRevision.length() - 1]);
            signalOutputStream.writeString(this.productName);
            signalOutputStream.writeU8Array(new int[13 - this.productName.length() - 1]);
            signalOutputStream.writeString(this.productDate);
            signalOutputStream.writeU8Array(new int[9 - this.productDate.length() - 1]);
            signalOutputStream.writeString(this.serialNo);
            signalOutputStream.writeU8Array(new int[14 - this.serialNo.length() - 1]);
            signalOutputStream.writeU32((long)this.numberOfSlots);
            signalOutputStream.writeU32((long)this.maxPowerDissipation);
            signalOutputStream.writeU32((long)this.transmissionType);
            signalOutputStream.writeU32((long)this.fanConfiguration);
            signalOutputStream.writeU32((long)this.nrOfDenibDevices);
            signalOutputStream.writeU32((long)this.NUMBER_BOARD_TYPE_POSITIONS);
            signalOutputStream.writeU32((long)this.CELLO_SR_TUB_POSITION_A);
            signalOutputStream.writeU32((long)this.tuPositionA);
            signalOutputStream.writeU32((long)this.CELLO_SR_TUB_POSITION_B);
            signalOutputStream.writeU32((long)this.tuPositionB);
            signalOutputStream.writeU32((long)this.CELLO_SR_SCU_POSITION_A);
            signalOutputStream.writeU32((long)this.scuPositionA);
            signalOutputStream.writeU32((long)this.CELLO_SR_SCU_POSITION_B);
            signalOutputStream.writeU32((long)this.scuPositionB);
            signalOutputStream.writeU32((long)this.CELLO_SR_CMXB_POSITION_A);
            signalOutputStream.writeU32((long)this.cmxbPositionA);
            signalOutputStream.writeU32((long)this.CELLO_SR_CMXB_POSITION_B);
            signalOutputStream.writeU32((long)this.cmxbPositionB);
            signalOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

