/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.managedelement.DataCollectionGenerationMoFactory;
import se.ericsson.cello.managedelement.FroAlarmMappings;
import se.ericsson.cello.managedelement.GeneratedAlarmDefinitions;
import se.ericsson.cello.managedelement.ManagedElementDataMoFactory;
import se.ericsson.cello.managedelement.ManagedElementDataMoImpl;
import se.ericsson.cello.managedelement.ManagedElementMoFactory;
import se.ericsson.cello.managedelement.ManagedElementMoImpl;
import se.ericsson.cello.managedelement.NtpServerMoFactory;
import se.ericsson.cello.managedelement.PmServiceMoFactory;
import se.ericsson.cello.managedelement.PmServiceMoImpl;
import se.ericsson.cello.managedelement.SystemFunctionsMoFactory;
import se.ericsson.cello.managedelement.SystemFunctionsMoImpl;
import se.ericsson.cello.managedelement.TimeSettingMoFactory;
import se.ericsson.cello.managedelement.TransportNetworkMoFactory;
import se.ericsson.cello.managedelement.TransportNetworkMoImpl;
import se.ericsson.cello.managedelement.WebServerMoFactory;
import se.ericsson.cello.managedelement.WebServerMoImpl;
import se.ericsson.cello.managedelement.cello_dcgproxy_mi;
import se.ericsson.cello.managedelement.cello_timesetting_mi;
import se.ericsson.cello.managedelement.fropxy.OsaHttpsProxy;
import se.ericsson.cello.managedelement.fropxy.OsaMeMgmntProxy;
import se.ericsson.cello.managedelement.osa_me_managedelement_mi;
import se.ericsson.cello.managedelement.osa_ntp_fro_server_mi;
import se.ericsson.cello.managedelement.osa_ntp_managedelementdata_mi;
import se.ericsson.cello.mao.MaRevisionWriter;
import se.ericsson.cello.mao.RecoverDynamicReservations;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.proxy.FroMaoGenericProxy;
import se.ericsson.cello.maofro.proxy.FroMaoHandlerRegistry;
import se.ericsson.cello.maofro.proxy.FroMaoHandlerRegistryImpl;
import se.ericsson.cello.maofro.proxy.FroMaoRequestQueue;
import se.ericsson.cello.maofro.proxy.FroMaoRequestRouter;
import se.ericsson.cello.maofro.proxy.FroMaoRequestThread;
import se.ericsson.cello.maofro.proxy.FroProxyFactoryImpl;
import se.ericsson.cello.maofro.proxy.SignalSender;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.MoppletExtended;
import se.ericsson.cello.pmapp.fropxy.PmSignalDistributor;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.cello.support.sigutil.PortManager;

public class ManagedElementMgr
implements MoppletExtended,
Runnable {
    public Collection proxies = new Vector();
    private FroMaoRequestQueue froMaoQueue = null;
    private DataCollectionGenerationMoFactory dcgFactory = null;
    private static final String TEST_MGR_CLASS_NAME = "se.ericsson.cello.test.TestMgr";
    private static final String INSTANCE = "instance";
    private static final String INIT = "init";
    private static final String START = "start";
    private static final String CMA_RECOVERY_THREAD_NAME = "cma_recoverDynamicReservationsThread";
    private TimeSettingMoFactory tsFactory = null;

    public void init() {
        MessageLog.info(this.getClass(), (String)"Latest version ManagedElementMgr: PA2 ");
        this.setupFroMaoService();
        FroProxy froProxy = null;
        froProxy = FroProxyFactoryImpl.getProxy((Class)osa_me_managedelement_mi.class, (String)"ManagedElement");
        ManagedElementMoFactory.instance();
        this.proxies.add(froProxy);
        froProxy = FroProxyFactoryImpl.getProxy((Class)osa_ntp_managedelementdata_mi.class, (String)"ManagedElementData");
        ManagedElementDataMoFactory.instance().registerFactory();
        this.proxies.add(froProxy);
        ManagedElementMoImpl.instance();
        ManagedElementDataMoImpl.instance();
        SystemFunctionsMoFactory.instance();
        froProxy = FroProxyFactoryImpl.getProxy((Class)cello_timesetting_mi.class, (String)"TimeSetting");
        this.tsFactory = new TimeSettingMoFactory(froProxy);
        this.tsFactory.registerFactory();
        this.proxies.add(froProxy);
        SystemFunctionsMoImpl.instance();
        PmServiceMoFactory.instance();
        PmServiceMoImpl.instance();
        WebServerMoFactory.instance().registerFactory();
        WebServerMoImpl.instance();
        TransportNetworkMoFactory.instance().registerFactory();
        TransportNetworkMoImpl.instance();
        froProxy = FroProxyFactoryImpl.getProxy((Class)osa_ntp_fro_server_mi.class, (String)"NtpServer");
        NtpServerMoFactory ntpServerMoFactory = new NtpServerMoFactory(froProxy);
        ntpServerMoFactory.registerFactory();
        this.proxies.add(froProxy);
        if (System.getProperty("is.using.nat", "false").equalsIgnoreCase("false")) {
            froProxy = FroProxyFactoryImpl.getProxy((Class)cello_dcgproxy_mi.class, (String)"DataCollectionGeneration");
            this.dcgFactory = new DataCollectionGenerationMoFactory(froProxy);
            this.dcgFactory.registerFactory();
            this.proxies.add(froProxy);
        }
        this.callMethod(TEST_MGR_CLASS_NAME, INIT);
        GeneratedAlarmDefinitions.init(AlarmManager.getDefinitionRepository());
        FroAlarmMappings.initiate();
    }

    public void start() {
        MaRevisionWriter.writeRevision((Object)this);
        this.createRootMo();
        ManagedElementDataMoImpl.instance().registerData();
        SystemFunctionsMoImpl.instance().registerData();
        this.tsFactory.getMo();
        WebServerMoImpl.instance().registerData();
        TransportNetworkMoImpl.instance().registerData();
        PmServiceMoImpl.instance().registerData();
        if (System.getProperty("is.using.nat", "false").equalsIgnoreCase("false")) {
            this.dcgFactory.getMo();
        }
        OsaMeMgmntProxy.instance().subscribeService();
        OsaMeMgmntProxy.instance().sendOmsInitializedToFro();
        OsaHttpsProxy.instance().subscribeService();
        ManagedElementMoImpl.instance().registerInPMS();
        Iterator iterator = this.proxies.iterator();
        while (iterator.hasNext()) {
            ((FroProxy)iterator.next()).subscribeService();
        }
        this.callMethod(TEST_MGR_CLASS_NAME, START);
    }

    public void finish() {
        this.recoverDynamicReservations();
        this.subscribeForIpAddressChangeAndWriteSLSFile();
        PmSignalDistributor.startListeningPmIndication();
        this.startFroMaoService();
    }

    private void recoverDynamicReservations() {
        try {
            Thread thread = new Thread((Runnable)this, CMA_RECOVERY_THREAD_NAME);
            thread.start();
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"recoverDynamicReservations()", (String)"Recovery of DynamicReservations failed, throwable caught. ", (Throwable)throwable);
        }
    }

    private void subscribeForIpAddressChangeAndWriteSLSFile() {
        ManagedElementDataMoImpl.instance().subscribeForNodeIpAddressChange();
        File file = new File("/c");
        try {
            ManagedElementDataMoImpl.instance().writeSlsAddressCfgFile(file, ManagedElementDataMoImpl.instance().getLogonServerAddress(null));
        }
        catch (MoAccessException moAccessException) {
            moAccessException.printStackTrace();
        }
    }

    public void run() {
        MoRepository.instance().select(MibMgr.instance().getMib().getRootMo(), -1, (MoFilter)new RecoverDynamicReservations());
    }

    void createRootMo() {
        MessageLog.info(this.getClass(), (String)"createRootMo()");
        ManagedElementMoImpl.instance().start();
    }

    private void setupFroMaoService() {
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        FroMaoHandlerRegistryImpl froMaoHandlerRegistryImpl = new FroMaoHandlerRegistryImpl();
        serviceRepository.addService((Object)froMaoHandlerRegistryImpl, FroMaoHandlerRegistry.class, null);
        FroMaoRequestRouter froMaoRequestRouter = new FroMaoRequestRouter((FroMaoHandlerRegistry)froMaoHandlerRegistryImpl, new SignalSender());
        this.froMaoQueue = new FroMaoRequestQueue(300, froMaoRequestRouter);
        new FroMaoGenericProxy(PortManager.instance(), this.froMaoQueue);
    }

    private void startFroMaoService() {
        new Thread((Runnable)new FroMaoRequestThread(this.froMaoQueue)).start();
    }

    private void callMethod(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getDeclaredMethod(INSTANCE, null);
            Object object = method.invoke(null, null);
            Method method2 = clazz.getDeclaredMethod(string2, null);
            method2.invoke(object, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Throwable throwable) {
            MessageLog.traceError(this.getClass(), (String)("callMethod() failed: className=" + string + ", methodName=" + string2), (Throwable)throwable);
        }
    }
}

