/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomAssociationEnd;
import se.ericsson.cello.mimparser.MomChild;
import se.ericsson.cello.mimparser.MomSupported;
import se.ericsson.cello.mimparser.model.MomBiDirectionalAssociationImpl;
import se.ericsson.cello.mimparser.model.MomClassImpl;
import se.ericsson.cello.mimparser.model.MomContainmentImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipImpl;
import se.ericsson.cello.mimparser.model.MomSoftLinkImpl;
import se.ericsson.cello.mimparser.model.MomSupportImpl;
import se.ericsson.cello.mimparser.model.MomUniDirectionalAssociationImpl;

public class RelationshipResolver {
    private List relationships = new ArrayList(0);
    private List softLinks = new ArrayList(0);
    private List supports = new ArrayList(0);
    private List biDirectionalAssociations = new ArrayList(0);
    private List uniDirectionalAssociations = new ArrayList(0);
    private List containments = new ArrayList(0);

    RelationshipResolver() {
    }

    void addRelationship(MomRelationshipImpl momRelationshipImpl) {
        this.relationships.add(momRelationshipImpl);
    }

    void addSoftLink(MomSoftLinkImpl momSoftLinkImpl) {
        this.softLinks.add(momSoftLinkImpl);
    }

    void addSupport(MomSupportImpl momSupportImpl) {
        this.supports.add(momSupportImpl);
    }

    void addBiDirectionalAssociation(MomBiDirectionalAssociationImpl momBiDirectionalAssociationImpl) {
        this.biDirectionalAssociations.add(momBiDirectionalAssociationImpl);
    }

    void addUniDirectionalAssociation(MomUniDirectionalAssociationImpl momUniDirectionalAssociationImpl) {
        this.uniDirectionalAssociations.add(momUniDirectionalAssociationImpl);
    }

    void addContainment(MomContainmentImpl momContainmentImpl) {
        this.containments.add(momContainmentImpl);
    }

    void resolve(MimModel mimModel) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.relationships.size();
        for (n5 = 0; n5 < n6; ++n5) {
            MomRelationshipImpl momRelationshipImpl = (MomRelationshipImpl)this.relationships.get(n5);
            this.resolveFromTo(momRelationshipImpl, mimModel);
        }
        n5 = this.softLinks.size();
        for (n4 = 0; n4 < n5; ++n4) {
            MomSoftLinkImpl momSoftLinkImpl = (MomSoftLinkImpl)this.softLinks.get(n4);
            this.resolveSoftLinks(momSoftLinkImpl, mimModel);
        }
        n4 = this.supports.size();
        for (n3 = 0; n3 < n4; ++n3) {
            MomSupportImpl momSupportImpl = (MomSupportImpl)this.supports.get(n3);
            this.resolveSupports(momSupportImpl, mimModel);
        }
        n3 = this.biDirectionalAssociations.size();
        for (n2 = 0; n2 < n3; ++n2) {
            MomBiDirectionalAssociationImpl momBiDirectionalAssociationImpl = (MomBiDirectionalAssociationImpl)this.biDirectionalAssociations.get(n2);
            this.resolveBiDirectionalAssociation(momBiDirectionalAssociationImpl, mimModel);
        }
        n2 = this.uniDirectionalAssociations.size();
        for (n = 0; n < n2; ++n) {
            MomUniDirectionalAssociationImpl momUniDirectionalAssociationImpl = (MomUniDirectionalAssociationImpl)this.uniDirectionalAssociations.get(n);
            this.resolveUniDirectionalAssociation(momUniDirectionalAssociationImpl, mimModel);
        }
        n = this.containments.size();
        for (int i = 0; i < n; ++i) {
            MomContainmentImpl momContainmentImpl = (MomContainmentImpl)this.containments.get(i);
            this.resolveContainments(momContainmentImpl, mimModel);
        }
    }

    private void resolveFromTo(MomRelationshipImpl momRelationshipImpl, MimModel mimModel) {
        String string = momRelationshipImpl.getFromElementName();
        String string2 = momRelationshipImpl.getToElementName();
        if (string != null && string2 != null) {
            MomClassImpl momClassImpl = (MomClassImpl)mimModel.getClass(string);
            MomClassImpl momClassImpl2 = (MomClassImpl)mimModel.getClass(string2);
            if (momClassImpl == null || momClassImpl2 == null) {
                String string3 = "Can not resolve From/To relation for relationship=" + momRelationshipImpl.getName() + ". from Object name=" + string + " to Object name=" + string2 + " method=RelationshipResolver.resolveParentChild()";
                throw new RuntimeException(string3);
            }
            momRelationshipImpl.setFrom(momClassImpl);
            momRelationshipImpl.setTo(momClassImpl2);
            momClassImpl2.addParent(momClassImpl, momRelationshipImpl);
            momClassImpl2.addRelationship(momRelationshipImpl);
            momClassImpl.addChild(momClassImpl2, momRelationshipImpl);
            momClassImpl.addRelationship(momRelationshipImpl);
        }
    }

    private void resolveSoftLinks(MomSoftLinkImpl momSoftLinkImpl, MimModel mimModel) {
        String string = momSoftLinkImpl.getParent().getHasClass().getName();
        MomClassImpl momClassImpl = (MomClassImpl)mimModel.getClass(string);
        Iterator iterator = momSoftLinkImpl.getChildren();
        while (iterator.hasNext()) {
            MomChild momChild = (MomChild)iterator.next();
            String string2 = momChild.getHasClass().getName();
            MomClassImpl momClassImpl2 = (MomClassImpl)mimModel.getClass(string2);
            momClassImpl2.addSoftLinkParent(momClassImpl);
            momClassImpl.addSoftLinkChild(momClassImpl2);
        }
    }

    private void resolveSupports(MomSupportImpl momSupportImpl, MimModel mimModel) {
        String string = momSupportImpl.getSupporter().getHasClass().getName();
        MomClassImpl momClassImpl = (MomClassImpl)mimModel.getClass(string);
        Iterator iterator = momSupportImpl.getSupported();
        while (iterator.hasNext()) {
            MomSupported momSupported = (MomSupported)iterator.next();
            String string2 = momSupported.getHasClass().getName();
            MomClassImpl momClassImpl2 = (MomClassImpl)mimModel.getClass(string2);
            momClassImpl2.addSupporter(momClassImpl);
            momClassImpl.addSupported(momClassImpl2);
        }
    }

    private void resolveBiDirectionalAssociation(MomBiDirectionalAssociationImpl momBiDirectionalAssociationImpl, MimModel mimModel) {
        MomAssociationEnd momAssociationEnd = momBiDirectionalAssociationImpl.getAssociationEndFrom();
        String string = momBiDirectionalAssociationImpl.getAssociationEndFrom().getHasClass().getName();
        MomClassImpl momClassImpl = (MomClassImpl)mimModel.getClass(string);
        Iterator iterator = momBiDirectionalAssociationImpl.getAssociationEndsTo();
        while (iterator.hasNext()) {
            MomAssociationEnd momAssociationEnd2 = (MomAssociationEnd)iterator.next();
            String string2 = momAssociationEnd2.getHasClass().getName();
            MomClassImpl momClassImpl2 = (MomClassImpl)mimModel.getClass(string2);
            momClassImpl2.addDirectionalAssociationFrom(momAssociationEnd);
            momClassImpl.addDirectionalAssociationTo(momAssociationEnd2);
        }
    }

    private void resolveUniDirectionalAssociation(MomUniDirectionalAssociationImpl momUniDirectionalAssociationImpl, MimModel mimModel) {
        String string = momUniDirectionalAssociationImpl.getHasClass().getName();
        MomClassImpl momClassImpl = (MomClassImpl)mimModel.getClass(string);
        Iterator iterator = momUniDirectionalAssociationImpl.getAssociationEndsTo();
        while (iterator.hasNext()) {
            momClassImpl.addDirectionalAssociationTo((MomAssociationEnd)iterator.next());
        }
    }

    private void resolveContainments(MomContainmentImpl momContainmentImpl, MimModel mimModel) {
        String string = momContainmentImpl.getParent().getHasClass().getName();
        MomClassImpl momClassImpl = (MomClassImpl)mimModel.getClass(string);
        Iterator iterator = momContainmentImpl.getChildren();
        while (iterator.hasNext()) {
            MomChild momChild = (MomChild)iterator.next();
            String string2 = momChild.getHasClass().getName();
            MomClassImpl momClassImpl2 = (MomClassImpl)mimModel.getClass(string2);
            momClassImpl2.addContaimentParent(momClassImpl);
            momClassImpl.addContainmentChild(momClassImpl2);
        }
    }
}

